#define McsPluginInitResult int
#define MCS_PLUGIN_INIT_OK 1

#define SHM_STRING_LENGTH 32

typedef struct McsManager{
    int shm;
    char shm_name[64];   
}McsManager;

typedef struct McsPlugin{
   McsManager *manager;
   gchar *plugin_name;
   gchar *caption;
   void * (*run_dialog)(struct McsPlugin *mp);
   GdkPixbuf *icon;
   int shm;
   void *m;
}McsPlugin;

typedef struct mcs_data_t{
	gchar *v_string;
} mcs_data_t;

typedef struct McsSetting{
   mcs_data_t data;
}McsSetting;

typedef struct mcs_shm_data_t{
	char name[SHM_STRING_LENGTH];
	char value[SHM_STRING_LENGTH];
}mcs_shm_data_t;

typedef struct mcs_shm_t{
	int serial;
	mcs_shm_data_t data[XFFM_OPTIONS];
}mcs_shm_t;
		
	

static
void mcs_manager_notify(McsManager *, const gchar *);

static      
void mcs_manager_set_string(McsManager *, const gchar *, const gchar *, const gchar *);

#define MCS_PLUGIN_CHECK_INIT 


