/*
 * Copyright (c) 2006 Edscott Wilson Garcia <edscott@xfce.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 */

static  McsPlugin *mp=NULL;
#define SETTINGS_TIMERVAL 500
static int shm_settings_serial=0;
static int settings_timer=0;
static
gint settings_monitor(gpointer data){
	mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	if (shm_settings_serial < 0) return FALSE;
	if (shm_settings_serial != mcs_shm_p->serial) {
		int i;
		TRACE("shm_settings_serial != mcs_shm_p->serial(%d!=%d)",
				shm_settings_serial, mcs_shm_p->serial);
		shm_settings_serial = mcs_shm_p->serial;
		for (i=0; i<XFFM_OPTIONS; i++) {
	   	    if (mcs_shm_p->data[i].value) {
			    g_free(xffm_options[i].value);
			    xffm_options[i].value = g_strdup(mcs_shm_p->data[i].value);
		  	    xffm_setenv(xffm_options[i].name,xffm_options[i].value,TRUE);
		    } else {
		  	    xffm_setenv(xffm_options[i].name,NULL,TRUE);
		    }
		}
	}
	else {
		/*TRACE("shm_settings_serial OK");*/
	}
	return TRUE;
}


static int mcs_shm_fileread(void){
    static gchar *rcfile=NULL;
    
    if (!rcfile){
	rcfile=g_build_filename(MCS_SHM_PLUGIN_FILE,NULL);
    }
    
    if (g_file_test(rcfile,G_FILE_TEST_EXISTS)){
	FILE *f;
	TRACE("reading %s",rcfile);
	f=fopen(rcfile,"r");
	if (f) {
		    fread(mp->m,sizeof(mcs_shm_t),1,f);
		    fclose(f);
	}
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
	return 1;
    }
    return 0;
}

static int mcs_shm_filewrite(void){
	FILE *f;
    static gchar *rcfile=NULL;
    
    if (!rcfile){
	rcfile=g_build_filename(MCS_SHM_PLUGIN_FILE,NULL);
    }
	TRACE("writing %s",rcfile);
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
	f=fopen(rcfile,"w");
	if (f) {
		mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
		mcs_shm_p->serial++;
		    fwrite(mp->m,sizeof(mcs_shm_t),1,f);
		    fclose(f);
		    return 1;
	}
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
    return 0;
}

static void mcs_shm_bringforth(void){
	int i,j;
	mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	TRACE("mcs_shm_bringforth");
	for (i=0; i<XFFM_OPTIONS; i++){
		g_free(xffm_options[i].value);
		xffm_options[i].value=g_strdup("");
	}
	for (i=0; i<XFFM_OPTIONS; i++) for(j=0;j< XFFM_OPTIONS;j++){
		if (xffm_options[i].name && mcs_shm_p->data[j].name){
			if (strcmp(xffm_options[i].name, mcs_shm_p->data[j].name))
				continue;
			g_free(xffm_options[i].value);
			xffm_options[i].value = g_strdup(mcs_shm_p->data[j].value);
			break;
		}
	}
}
#if 0
static void mcs_shm_sendback(void){
	int i;
	mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	TRACE("mcs_shm_sendback");
	for (i=0; i<XFFM_OPTIONS; i++){
	   memset(mcs_shm_p->data[i].name,0,SHM_STRING_LENGTH);
	   memset(mcs_shm_p->data[i].value,0,SHM_STRING_LENGTH);
	   strncpy(mcs_shm_p->data[i].name,xffm_options[i].name,SHM_STRING_LENGTH);
	   if (xffm_options[i].value)
	     strncpy(mcs_shm_p->data[i].value,xffm_options[i].value,SHM_STRING_LENGTH);
	}
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
}
#endif
static void mcs_shm_init(void){
	int i;
	mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	TRACE("mcs_shm_init");
	for (i=0; i<XFFM_OPTIONS; i++){
	   memset(mcs_shm_p->data[i].name,0,SHM_STRING_LENGTH);
	   memset(mcs_shm_p->data[i].value,0,SHM_STRING_LENGTH);
	   strncpy(mcs_shm_p->data[i].name,xffm_options[i].name,SHM_STRING_LENGTH);
	   if (xffm_options[i].value)
	     strncpy(mcs_shm_p->data[i].value,xffm_options[i].value,SHM_STRING_LENGTH);
	}
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
}


G_MODULE_EXPORT
void *mcs_shm_start(void){
    if (!mp){
	    int i;
	gchar *shm_settings_file=g_strdup_printf("/%d-xffmsettings",(int)getuid());
	TRACE("starting instance of mcs-shm");
	mp=(McsPlugin *)malloc(sizeof(McsPlugin));
	memset(mp,0,sizeof(McsPlugin));
	mp->manager = (McsManager *)malloc(sizeof(McsManager));
	memset(mp->manager,0,sizeof(McsManager));
	mcs_manager = mp->manager;
	mp->plugin_name = g_strdup(CHANNEL);
	mp->caption = g_strdup(_("File manager"));
	mp->run_dialog = run_xffm_settings_dialog;
	mp->icon = gdk_pixbuf_new_from_xpm_data((const char **)xffm_icon_xpm);
	mp->shm=shm_open(shm_settings_file, O_RDWR, 0700);
	if (mp->shm < 0) {
	    mcs_shm_t *mcs_shm_p;
	    mp->shm=shm_open(shm_settings_file, O_CREAT | O_RDWR, 0700);
	    if (mp->shm < 0) {
		free(mp->manager);
		free(mp);
		mp=NULL;
		return NULL;
	    }
    	    ftruncate(mp->shm,sizeof(mcs_shm_t));
	    
	    mp->m = mmap(0, sizeof(mcs_shm_t), PROT_READ | PROT_WRITE , MAP_SHARED, mp->shm, 0);
	    memset(mp->m,0,sizeof(mcs_shm_t));
	    mcs_shm_p = (mcs_shm_t *)mp->m;

	    mcs_shm_p->serial=1;
	    if (mcs_shm_fileread()){
		    mcs_shm_bringforth();
	    }
	    else {
		    mcs_shm_init();
	    }
	    
    	    msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
	} else {
	    TRACE("using preexisting shm block");
	    mp->m = mmap(0, sizeof(mcs_shm_t), PROT_READ | PROT_WRITE , MAP_SHARED, mp->shm, 0);
	    mcs_shm_bringforth();
	}
	
	
    	/* read environment...*/
	for (i=0; i<XFFM_OPTIONS; i++){
		if (getenv(xffm_options[i].name)){
		    g_free(xffm_options[i].value);
		    xffm_options[i].value = g_strdup(getenv(xffm_options[i].name));
		}
		else {
	    	    mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
		    if (mcs_shm_p->data[i].value) {
		        g_free(xffm_options[i].value);
			xffm_options[i].value = g_strdup(mcs_shm_p->data[i].value);
		  	xffm_setenv(xffm_options[i].name,xffm_options[i].value,TRUE);
		    } else {
		  	    xffm_setenv(xffm_options[i].name,NULL,TRUE);
		    }
		}
	}
	
    }
    if (mp) {
	    mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	    shm_settings_serial=mcs_shm_p->serial;
	    TRACE("mcs_shm_p->serial=%d",mcs_shm_p->serial);
	    settings_timer = g_timeout_add (SETTINGS_TIMERVAL,settings_monitor, NULL);
    }
    return mp;
}

G_MODULE_EXPORT
void *mcs_shm_stop(void){
	TRACE("stopping instance of mcs-shm");
    if(mp) {
	munmap(mp->m,sizeof(mcs_shm_t));
    }
    shm_settings_serial = -1;
    return GINT_TO_POINTER(1);
}


G_MODULE_EXPORT
void *module_init(void){
    mcs_shm_start();
    return (void *)mp;
}

#if 0    
static
gboolean mcs_manager_save_channel_to_file(McsManager *mcs_m, const gchar *channel, const gchar *rcfile)
{
	TRACE("mcs_manager_save_channel_to_file");
    /* here we dump the shmblock to a file */
	mcs_shm_sendback();
	mcs_shm_filewrite();
    return TRUE;
}
#endif

static      
void mcs_manager_set_string(McsManager *mcs_m, const gchar *setting_name, const gchar *channel, const gchar *setting_value)
{
	mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	int i;
	g_message("mcs_manager_set_string");
		
	for (i=0; i<XFFM_OPTIONS; i++) {
	 if (strcmp(setting_name, mcs_shm_p->data[i].name)==0){
	   memset(mcs_shm_p->data[i].value,0,SHM_STRING_LENGTH);
	   if (setting_value){
	     g_message("%s -> %s",setting_name,setting_value);
	     strncpy(mcs_shm_p->data[i].value,setting_value,SHM_STRING_LENGTH);
	     g_free(xffm_options[i].value);
	     xffm_options[i].value = g_strdup(setting_value);
	   }
	 }
	}
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);
    /* here we update the shmblock */
    return;
}


static
void mcs_manager_notify(McsManager *mcs_m, const gchar *channel)
{
    /* here we ++ the shmblock serial (or something), this should be
     * monitored by other instances so that changes are ACK.*/
	TRACE("mcs_manager_notify");
	mcs_shm_t *mcs_shm_p = (mcs_shm_t *)mp->m;
	mcs_shm_p->serial++;
    	msync(mp->m, sizeof(mcs_shm_t), MS_SYNC);	
	mcs_shm_filewrite();
    return;
}


