/*  xffm4
 *
 *  Copyright (C) 2003 olivier fourdan <xfce@users.sourceforge.net>
 *  Copyright (C) 2003-2006 edscott wilson garcia <edscott@xfce.org>
 *  Copyright (C) 2002 Jasper Huijsmans <huysmans@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "primary.h"


enum {
	XFFM_DEFAULT_UNLINK,		/* 1 */
	XFFM_USE_SUDO,			/* 3 */
	TERMCMD,			/* 4 */
	EDITORCMD,			/* 4 */
	DESKTOP_DIR,			/* 5 */
	DESKTOP_COLOR,			/* 5 */
	DESKTOP_BACKGROUND_IMAGE,	/* 6 */
	USE_DESKTOP_MENU,		/* 7 */
	USE_DESKTOP_MENU_ICONS,		/* 8 */
	DISABLE_DESKTOP,		/* 9 */
	SMB_USER,			/* 10*/
	XFFM_SINGLE_CLICK_NAVIGATION,	/* 11*/
	XFFM_DRAG_DOES_COPY,		/* 12*/
	XFFM_FORCE_DIAGNOSTICS,		/* 13*/
	XFFM_DISABLE_DIAGNOSTICS,	/* 14*/
	XFFM_DISABLE_MONITOR,		/* 15*/
	XFFM_DISABLE_TEXTCOLORS,	/* 16*/
	XFFM_DISABLE_CELL_EDIT,		/* 17*/
	XFFM_DISABLE_TIPS,		/* 18*/
	XFFM_ICON_THEME,		/* 19*/
	
	XFFM_MAX_PREVIEW_SIZE,		/* 20*/
	XFFM_DIAGNOSTICS_FONT_SIZE,	/* 21*/
     XFFM_OPTIONS
};

typedef struct
{
  gchar   *name;
  gchar   *value;
}
Options;

static Options xffm_options[XFFM_OPTIONS]={
    /* radio button */
	{ "XFFM_DEFAULT_UNLINK",     	NULL },/*1*/
    /* check buttons */	
	{ "XFFM_USE_SUDO",	     	NULL },/*3*/
    /* envars */
	{ "TERMCMD",                 	NULL },/*4 */
	{ "EDITORCMD",                 	NULL },/*4 */
	{ "DESKTOP_DIR",             	NULL },/*5 */
	{ "DESKTOP_COLOR",             	NULL },/*5 */
	{ "DESKTOP_BACKGROUND_IMAGE",  	NULL },/*6 */
	{ "USE_DESKTOP_MENU",          	NULL },/*7 */
	{ "USE_DESKTOP_MENU_ICONS",    	NULL },/*8 */
	{ "DISABLE_DESKTOP",    	NULL },/*9 */
	{ "SMB_USER",                	NULL },/*10*/
    /* these should be checkbuttons too */
	{ "XFFM_SINGLE_CLICK_NAVIGATION",NULL },/*11*/
	{ "XFFM_DRAG_DOES_COPY",	NULL },/*12*/
    /* these two should be grouped as a radio */
	{ "XFFM_FORCE_DIAGNOSTICS",	NULL },/*13*/
	{ "XFFM_DISABLE_DIAGNOSTICS",	NULL },/*14*/
    /* more check button */
	{ "XFFM_DISABLE_MONITOR",	NULL },/*15*/
	{ "XFFM_DISABLE_TEXTCOLORS",	NULL },/*16*/
	{ "XFFM_DISABLE_CELL_EDIT",	NULL },/*17*/
	{ "XFFM_DISABLE_TIPS",       	NULL },/*18*/
    /* this one should be a spinbutton */
	{ "XFFM_MAX_PREVIEW_SIZE",   	NULL },/*19*/ 
	{ "XFFM_ICON_THEME",   		NULL },/*20*/ 
	{ "XFFM_DIAGNOSTICS_FONT_SIZE", NULL },/*20*/ 
};



 #include <sys/types.h>
 #include <sys/mman.h>
 #include <fcntl.h> 
 #include "mcs-shm-manager.h"
#define MCS_SHM_PLUGIN_FILE g_get_home_dir(),".config","xffm","mcs.shm"

#include "constants.h"
#include "types.h"


#ifndef XFFM_MCS_PLUGIN
#define XFFM_MCS_PLUGIN
#endif

#define CHANNEL  "xffm"

#define BORDER 6
#define SKIP BORDER


static GSList *remove_group=NULL;
GtkWidget *radio_cancel,*radio_waste,*radio_unlink;
GtkWidget *hide_book,*hide_local,*hide_network,
    *hide_find,*hide_trash,*hide_fstab,
    *hide_recent,*hide_frequent,
    *use_sudo;


typedef struct
{
  gchar   *variable;
  gchar   *value;
  gboolean editable;
}
Item;

enum
{
  COLUMN_VARIABLE,
  COLUMN_VALUE,
  COLUMN_EDITABLE,
  NUM_COLUMNS
};

static GtkWidget *dialog = NULL;
#include "xffm_icon.xpm"

/********************************************************/
static McsManager *mcs_manager = NULL;

void *run_xffm_settings_dialog(McsPlugin *);


 #include "mcs-xfcecompat.i"
 #include "mcs-shm-manager.i"
LIBXFFM_MODULE

static void set_option_buttons(void){
	int i;
    for (i = 0; i < XFFM_OPTIONS; i++)
    {
	switch (i) {
		case XFFM_DEFAULT_UNLINK:
			if (strcmp(xffm_options[i].value,"waste")==0) gtk_toggle_button_set_active ((GtkToggleButton *)radio_waste,TRUE);
			else if (strcmp(xffm_options[i].value,"unlink")==0) gtk_toggle_button_set_active ((GtkToggleButton *)radio_unlink,TRUE);
			else gtk_toggle_button_set_active ((GtkToggleButton *)radio_cancel,TRUE);
			break;
		case XFFM_USE_SUDO:
			if (strlen(xffm_options[i].value)) gtk_toggle_button_set_active ((GtkToggleButton *)use_sudo,TRUE);
			break;
	}
    }
}


/* the dialog ******************************************/
static void add_spacer(GtkBox * box)
{
    GtkWidget *eventbox = gtk_alignment_new(0,0,0,0);

    gtk_widget_set_size_request(eventbox, SKIP, SKIP);
    gtk_widget_show(eventbox);
    gtk_box_pack_start(box, eventbox, FALSE, TRUE, 0);
}

static gboolean environment_changed(GtkCellRendererText *cell,
	     const gchar         *path_string,
	     const gchar         *new_text,
	     gpointer             data)
{             
    GtkTreeModel *model = (GtkTreeModel *)data;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter iter;

    gint *column;

    column = g_object_get_data (G_OBJECT (cell), "column");

    gtk_tree_model_get_iter (model, &iter, path);

    if (GPOINTER_TO_INT (column) == COLUMN_VALUE) {
    
	gint i;
	gchar *old_text;

        gtk_tree_model_get (model, &iter, column, &old_text, -1);
	g_free (old_text);
	old_text=NULL;
	i = gtk_tree_path_get_indices (path)[0] + TERMCMD;
        if (xffm_options[i].value)
        {
            g_free(xffm_options[i].value);
            xffm_options[i].value = NULL;
        }
	if (new_text && strlen(new_text)) {
		xffm_options[i].value = g_strdup (new_text);
	} else {
		xffm_options[i].value = g_strdup("");
	}
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, column,
                            xffm_options[i].value, -1);
        mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        /*write_options();*/
    }
    gtk_tree_path_free (path);
    
    return FALSE;
}

/* the dialog */
static void dialog_delete(GtkWidget *dialog)
{
    gtk_widget_destroy(dialog);
    dialog = NULL;
}

void remove_toggled(GtkToggleButton *togglebutton, gpointer user_data){
	gchar *new_text = NULL;
	if(gtk_toggle_button_get_active((GtkToggleButton *)radio_cancel)) {
		new_text=g_strdup("cancel");
	} 
	else if(gtk_toggle_button_get_active((GtkToggleButton *)radio_waste)) {
		new_text=g_strdup("waste");
	}
	else if(gtk_toggle_button_get_active((GtkToggleButton *)radio_unlink)) {
		new_text=g_strdup("unlink");
	}
        if (xffm_options[XFFM_DEFAULT_UNLINK].value)
        {
            g_free(xffm_options[XFFM_DEFAULT_UNLINK].value);
        }
	xffm_options[XFFM_DEFAULT_UNLINK].value = new_text;
        mcs_manager_set_string(mcs_manager, xffm_options[XFFM_DEFAULT_UNLINK].name, CHANNEL, xffm_options[XFFM_DEFAULT_UNLINK].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        /*write_options();*/

}

void option_toggled(GtkToggleButton *togglebutton, gpointer user_data){
	int i = (int)((long) user_data);
	if (xffm_options[i].value)
        {
            g_free(xffm_options[i].value);
        }
	if (gtk_toggle_button_get_active(togglebutton)){
	       	xffm_options[XFFM_DEFAULT_UNLINK].value = g_strdup("yes");
	}
	else {
		xffm_options[XFFM_DEFAULT_UNLINK].value = g_strdup("");
	}
        mcs_manager_set_string(mcs_manager, xffm_options[i].name, CHANNEL, xffm_options[i].value);
        mcs_manager_notify(mcs_manager, CHANNEL);
        /*write_options();*/

}



G_MODULE_EXPORT
void *
    run_xffm_settings_dialog(McsPlugin *mp)
{
    GtkWidget *header, *vbox,*frame, *hbox, *sw;
    int i;
    GtkListStore *model;
    GtkTreeIter iter;
    GtkCellRenderer *renderer;
    GtkWidget *treeview; 

    /* plugin: */
    /*xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");*/

    dialog = gtk_dialog_new_with_buttons(_("File manager"),
                                    	 NULL, GTK_DIALOG_NO_SEPARATOR, 
					 GTK_STOCK_CLOSE, GTK_RESPONSE_OK,
					 NULL);

    g_signal_connect(dialog, "response", G_CALLBACK(dialog_delete), NULL);
    g_signal_connect(dialog, "delete_event", G_CALLBACK(dialog_delete), NULL);
    g_signal_connect(dialog, "destroy", G_CALLBACK(dialog_delete), NULL);
    
    /* pretty header */
    vbox = GTK_DIALOG(dialog)->vbox;
    header = xfce_create_header(mp->icon, _("Xffm Settings"));
    gtk_box_pack_start(GTK_BOX(vbox), header, FALSE, TRUE, 0);
    
    add_spacer(GTK_BOX(vbox));

    frame = xfce_framebox_new (_("Default remove action:"), TRUE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

    hbox = gtk_hbox_new (FALSE, 6);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), hbox);
    
    radio_cancel = gtk_radio_button_new_with_label (NULL,_("Cancel"));
    remove_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_cancel));
    gtk_box_pack_start ((GtkBox *)hbox,radio_cancel,FALSE,FALSE,0);
    radio_waste = gtk_radio_button_new_with_label (remove_group,_("Wastebasket"));
    remove_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_waste));
    gtk_box_pack_start ((GtkBox *)hbox,radio_waste,FALSE,FALSE,0);
    radio_unlink = gtk_radio_button_new_with_label (remove_group,_("Unlink"));
    remove_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_unlink));
    gtk_box_pack_start ((GtkBox *)hbox,radio_unlink,FALSE,FALSE,0);

    gtk_widget_show_all (hbox);

    add_spacer(GTK_BOX(vbox));

    frame = xfce_framebox_new (_("Other useful options:"), TRUE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new (FALSE, 6);
    gtk_widget_show (vbox);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), vbox);
    
    use_sudo = gtk_check_button_new_with_label (_("Mount with sudo"));
    gtk_box_pack_start ((GtkBox *)vbox,use_sudo,FALSE,FALSE,0);

    set_option_buttons();
    
    g_signal_connect(radio_cancel, "toggled", G_CALLBACK(remove_toggled), NULL);
    g_signal_connect(radio_waste, "toggled", G_CALLBACK(remove_toggled), NULL);
    g_signal_connect(radio_unlink, "toggled", G_CALLBACK(remove_toggled), NULL);


    g_signal_connect(use_sudo, "toggled", G_CALLBACK(option_toggled), (gpointer)((long)(XFFM_USE_SUDO)));

    gtk_widget_show_all(vbox);

    {
      gchar *g;
      g=g_find_program_in_path("sudo");
      if (g){
	g_free(g);
      } else {
	  gtk_widget_hide(use_sudo);
      }
    }
    
    vbox = GTK_DIALOG(dialog)->vbox;
    
    add_spacer(GTK_BOX(vbox));

    frame = xfce_framebox_new (_("Environment variables:"), FALSE);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
    
    sw = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
					 GTK_SHADOW_ETCHED_IN);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    gtk_widget_show(sw);
    xfce_framebox_add (XFCE_FRAMEBOX (frame), sw);

    
    model = gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING,
			      G_TYPE_BOOLEAN);
    for (i=TERMCMD; i < XFFM_OPTIONS; i++) {
        gtk_list_store_append (model, &iter);
        gtk_list_store_set (model, &iter,
			  COLUMN_VARIABLE,
			  g_strdup (xffm_options[i].name),
			  COLUMN_VALUE,
			  g_strdup (xffm_options[i].value),
			  COLUMN_EDITABLE,
			  TRUE,
			  -1);
    }
    treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(model));
    g_object_unref (G_OBJECT (model));
    gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
    gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)),
				 GTK_SELECTION_SINGLE);
    /* variable column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited",
		      G_CALLBACK (environment_changed), model);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_VARIABLE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					         -1, _("Variable"), renderer,
					         "text", COLUMN_VARIABLE,
					         NULL);
    /* value column */
    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect (G_OBJECT (renderer), "edited",
		      G_CALLBACK (environment_changed), model);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_VALUE);

    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					         -1, _("Value"), renderer,
					         "text", COLUMN_VALUE,
					         "editable", COLUMN_EDITABLE,
					         NULL);

    gtk_widget_set_size_request(treeview, 350, 200);
    gtk_widget_show(treeview);
    gtk_container_add (GTK_CONTAINER (sw), treeview);

    //xfce_gtk_window_center_on_monitor_with_pointer (GTK_WINDOW (dialog));
    gtk_widget_show(dialog);
    return (void *) (dialog);
}


