/**********************************************************************/
/* Copywrite Edscott Wilson Garcia 2005 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

/*********************************************************************/
/***************desk_population_t functions **************************/
static
void 
destroy_desk_population_p(  desk_view_t *desk_view_p,
			    desk_population_t *desk_population_p){
    if (!desk_population_p) return;
    /*if (!g_file_test(desk_population_p->en->path,G_FILE_TEST_EXISTS)){
	clean_rectangle(desk_view_p, desk_population_p->x,desk_population_p->y,desk_population_p->w,desk_population_p->h);
    }*/
    destroy_entry(desk_population_p->en);
    if (desk_population_p->pixbuf) g_object_unref(desk_population_p->pixbuf);
    desk_population_p->pixbuf=NULL;
    if (desk_population_p->saturated) g_object_unref(desk_population_p->saturated);
    desk_population_p->saturated=NULL;
    if (desk_population_p->selected_pixbuf) g_object_unref(desk_population_p->selected_pixbuf);
    desk_population_p->selected_pixbuf=NULL;
    g_free(desk_population_p);   
}


static 
gint 
population_compare (	gconstpointer a, gconstpointer b)
{
    desk_population_t *p_a = (desk_population_t *)a;
    desk_population_t *p_b = (desk_population_t *)b;
    if (!a || !b) return 0; 
    return (p_a->serial - p_b->serial);
}
/***************deskview_t + desk_population_t functions ***************/

static 
void 
update_population_list(	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p)
{
    desk_population_p->serial = desk_view_p->serial++;
    desk_view_p->population_list = g_list_sort (desk_view_p->population_list,population_compare); 
}

static 
void
set_population_offset(	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p,
			gdouble x, 
			gdouble y)
{
    desk_view_p->offset_x = x - desk_population_p->x;
    desk_view_p->offset_y = y - desk_population_p->y;
}

static 
void
unselect_all_population
(	desk_view_t *desk_view_p)
{
    GList *tmp;
    int o_x=desk_view_p->offset_x, o_y=desk_view_p->offset_y;
    desk_view_p->offset_x=desk_view_p->offset_y=0;
    
    for (tmp=g_list_last(desk_view_p->population_list); tmp; tmp=tmp->prev){
	desk_population_t *desk_population_p = (desk_population_t *)tmp->data;
	if (!desk_population_p) continue;
	if (desk_view_p->doing_drag_p && desk_view_p->doing_drag_p == desk_population_p)
	    continue;
	if (desk_population_p->selected){
	    gdouble x=desk_population_p->x,y=desk_population_p->y;
	    desk_population_p->selected=FALSE;
	    redraw_text(desk_view_p,desk_population_p,TEXT_COLOR);
	    redraw_pixbuf(desk_view_p,desk_population_p, x, y);
	}
    }
    desk_view_p->offset_x=o_x, desk_view_p->offset_y=o_y;
    return;
}


static 
desk_population_t *
find_in_population(	desk_view_t *desk_view_p,
			gdouble x, 
			gdouble y)
{
    GList *tmp;
    for (tmp=g_list_last(desk_view_p->population_list); tmp; tmp=tmp->prev){
	desk_population_t *desk_population_p = (desk_population_t *)tmp->data;
	if (!desk_population_p) continue;
	if (x >= desk_population_p->x && x < desk_population_p->x + desk_population_p->w &&
	    y >= desk_population_p->y && y < desk_population_p->y + desk_population_p->h){
	    return desk_population_p;
	}
	TRACE("x=%d y=%d w=%d h=%d is not it",
		desk_population_p->x,desk_population_p->y,desk_population_p->w,desk_population_p->h);
    }
    return NULL;
}


 static 
desk_population_t *
create_desk_population_t(	desk_view_t *desk_view_p,
			record_entry_t *en,
			int x, 
			int y)
{
    GdkPixbuf *pixbuf;
    desk_population_t *desk_population_p;
    
    desk_population_p =(desk_population_t *)malloc(sizeof(desk_population_t));
    memset(desk_population_p,0,sizeof(desk_population_t));
    
    pixbuf = get_icon (&(desk_view_p->widgets), en,desk_view_p->en);
;
    desk_population_p->en=en;
    desk_population_p->x=x;
    desk_population_p->y=y;
    desk_population_p->w=gdk_pixbuf_get_width((const GdkPixbuf *)pixbuf);
    desk_population_p->h=gdk_pixbuf_get_height((const GdkPixbuf *)pixbuf);
    
    desk_population_p->serial = desk_view_p->serial++;
    desk_population_p->pixbuf = pixbuf;
    desk_population_p->selected = FALSE;

    desk_view_p->population_list = g_list_append (desk_view_p->population_list,(gpointer)desk_population_p);
    return desk_population_p;
}


