/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
static void
graphics_apply_window_size(icon_view_t *icon_view_p, int w, int h);

static void
graphics_set_rows_columns(icon_view_t *icon_view_p, int width);

static void graphics_fix_tip_bug(icon_view_t *icon_view_p)
{
	int x,y;
	int p_x, p_y;
	gint root_w,root_h;
	gint tipW,tipH;

	if (!icon_view_p || !icon_view_p->tips ||! icon_view_p->tips->tip_window||! icon_view_p->tips->tip_window->window) return;
	
	gdk_window_get_geometry  (gdk_get_default_root_window(),
				    NULL,NULL,&root_w,&root_h,NULL);        
	gtk_window_get_position (GTK_WINDOW(icon_view_p->widgets.window),&p_x,&p_y);
	gtk_window_get_position (GTK_WINDOW(icon_view_p->tips->tip_window),&x,&y);
	TRACE("tip window= 0x%x; parent= 0x%x", 
		(unsigned) icon_view_p->tips->tip_window,
		(unsigned) icon_view_p->widgets.window);
	TRACE("tip window position=%d,%d; parent= %d,%d", x,y,p_x,p_y);
	gdk_window_get_position (icon_view_p->widgets.window->window,&p_x,&p_y);

	gdk_window_get_geometry  (icon_view_p->tips->tip_window->window,
				    NULL,NULL,&tipW,&tipH,NULL); 
	if (p_y - tipH > 0) {
	    p_y -= tipH;
	}
	else if (p_y  + icon_view_p->widgets.window->allocation.height < root_h + 20){
	    p_y  += icon_view_p->widgets.window->allocation.height;
	}
        gdk_window_move (icon_view_p->tips->tip_window->window,x,p_y);
	gdk_window_show(icon_view_p->tips->tip_window->window);


}

static void
graphics_set_default_tooltip(icon_view_t *icon_view_p, record_entry_t *en)
{
    gtk_tooltips_set_tip (GTK_TOOLTIPS (icon_view_p->tips), 
		icon_view_p->paper,NULL,"");
}

typedef struct tip_timer_t{
    icon_view_t *icon_view_p;
    int tip_timer;
}tip_timer_t;

static 
int
graphics_set_entry_tip(gpointer data)
{
    const gchar *tip=NULL;
    tip_timer_t *tip_timer_p = data;
    icon_view_t *icon_view_p;
    record_entry_t *en;
    TRACE("gtk_tooltips_enable");
    if (!data) return FALSE;
    icon_view_p = tip_timer_p->icon_view_p;
    if (tip_timer_p->tip_timer != icon_view_p->tip_timer) {
	TRACE("graphics_set_entry_tip: wrong timeout condition");
	g_free(data);
	return FALSE;
    }
    if (!icon_view_p  || !icon_view_p->tip_timer) {
	TRACE("graphics_set_entry_tip: no timer should be active condition");
	g_free(data);
	return FALSE;
    }
    if (icon_view_p->saturated_p) {
        en = icon_view_p->saturated_p->en;
	/* XXX remving comment allows tip on selected item, but produces
	 * scores of wrong timeout condition and buggy tip */
    /*} else if (icon_view_p->selected_p) {
        en = icon_view_p->selected_p->en;*/
    } else {
	TRACE("graphics_set_entry_tip: no timer should be active condition (!icon_view_p->saturated_p && !icon_view_p->selected_p)");
	g_free(data);
	return FALSE;
    }
    

    if (icon_view_p->module_name) {
	tip=function_natural("plugins",icon_view_p->module_name,en,"entry_tip");
    }
    else if (en && en->module) {
	tip=function_natural("plugins",en->module,en,"plugin_info");
    }
    if (!tip && en && en->path && strlen(en->path)) {
	tip=path_info(en);
    }
    if (!tip || !strlen(tip)) {
	/*graphics_set_default_tooltip(icon_view_p, NULL);*/
	/*graphics_set_default_tooltip(icon_view_p, en);*/
	goto over;
    }
    TRACE("gtk_tooltips_set_tip (%s)",tip);

    gtk_tooltips_set_tip (GTK_TOOLTIPS (icon_view_p->tips), 
		icon_view_p->paper,tip,"");
    if (icon_view_p->tips && icon_view_p->tips->tips_data_list){
	    icon_view_p->tips->active_tips_data = icon_view_p->tips->tips_data_list->data;
    }
    /* twice to get around a gtk bug upon initial entering
       of the main window (where the tooltip is assigned */
    gtk_tooltips_set_tip (GTK_TOOLTIPS (icon_view_p->tips), 
		icon_view_p->paper,tip,"");
    gtk_tooltips_force_window (icon_view_p->tips);
   
    /* now, work around gtk bug for the tooltip placement: */
    graphics_fix_tip_bug(icon_view_p);
over:
    icon_view_p->tip_timer=0;
    g_free(data);
    return FALSE;
}


static void
graphics_unset_entry_tip(icon_view_t *icon_view_p)
{

    /*graphics_set_default_tooltip(icon_view_p,NULL);*/
    /*graphics_fix_tip_bug(icon_view_p);*/
    if (icon_view_p && icon_view_p->tips && icon_view_p->tips->tip_window && icon_view_p->tips->tip_window->window) {
	gdk_window_hide(icon_view_p->tips->tip_window->window);
    }
}




static int iconview_is_mapped(icon_view_t *icon_view_pp){
    GList *tmp;
    int offset=0;
    if (!icon_view_pp) {
	TRACE(" mapped: !icon_view_pp");
	return offset;
    }
	
    for (tmp=iconview_list; tmp; tmp=tmp->next){
	icon_view_t *icon_view_p=(icon_view_t *)tmp->data;
	if (icon_view_pp==tmp->data) continue;
        if (!icon_view_pp->en){
	    if (!tmp->data) {
		TRACE(" mapped: !tmp->data");
		offset++;
		continue;
	    }
	    return FALSE;
	}
        if (!icon_view_pp->en->path){
	    if (icon_view_p->en && !icon_view_p->en->path) {
		TRACE(" mapped: !icon_view_p->en->path");
		offset++;
		continue;
	    }
	    continue;
	}

	if (icon_view_p->en && icon_view_p->en->path && strcmp(icon_view_pp->en->path,icon_view_p->en->path)==0) {
	    TRACE(" mapped: %s",icon_view_p->en->path);
	    offset++;
	    continue;
	}
    }
    return offset;
}

static
iconview_preferences_t *
get_iconview_preferences(const gchar *path){
    DBHashTable *preferences;
    const gchar *key;
    GString *gs;
    static iconview_preferences_t iconview_preferences;
    gchar *f=g_build_filename(xdg_cache_dir(),GRIDVIEW_PREFERENCES_DBH_FILE,NULL);

    if (path) key=path;
    else key="ROOT_ICONVIEW";
    TRACE("looking for preferences with key=%s",key);
    
    preferences = DBH_open(f);
    g_free(f);
    
    if(!preferences){
	TRACE("no preferences file");
	return NULL;
    }
        
    gs = g_string_new(key);	
    sprintf((char *)DBH_KEY(preferences), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    
    
    if(!DBH_load(preferences)) {
	TRACE("no preferences record for %s (%s)", key, (char *)DBH_KEY(preferences));
	DBH_close(preferences);
	return NULL;
    }
    memcpy(&iconview_preferences, DBH_DATA(preferences), sizeof(iconview_preferences_t));
    TRACE("got preferences with key=%s  (preferences=0x%x, sort_column%d)\n",
	    key,iconview_preferences.preferences,
	    iconview_preferences.sortcolumn);
    DBH_close(preferences);
    return &iconview_preferences;
}

static
iconview_geometry_t *
get_iconview_geometry_p(icon_view_t *icon_view_p){
    DBHashTable *geometry;
    const gchar *key;
    GString *gs;
    static iconview_geometry_t iconview_geometry;
    gchar *f;
    gboolean no_record=FALSE;

    if (!icon_view_p) return NULL;
    if (icon_view_p->en && icon_view_p->en->path && strlen(icon_view_p->en->path)) key=icon_view_p->en->path;
    else key="ROOT_ICONVIEW";

again:
    f=g_build_filename(xdg_cache_dir(),GRIDVIEW_GEOMETRY_DBH_FILE,NULL);
    
    TRACE("looking for geometry with key=%s",key);
    
    geometry = DBH_open(f);
    g_free(f);
    
    if(!geometry){
	TRACE("no geometry file");
	return NULL;
    }
        
    gs = g_string_new(key);	
    sprintf((char *)DBH_KEY(geometry), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    
    
    if(!DBH_load(geometry)) {
	TRACE("no geometry record for %s (%s)", key, (char *)DBH_KEY(geometry));
	DBH_close(geometry);
	
	if (strcmp(key,"ROOT_ICONVIEW")==0) return NULL;
	else {
	    key="ROOT_ICONVIEW";
	    no_record=TRUE;
	    goto again;
	}
    }
    memcpy(&iconview_geometry, DBH_DATA(geometry), sizeof(iconview_geometry_t));
    /* no placement for non records...*/
    if (no_record){
	iconview_geometry.x = iconview_geometry.y = -1;
    }
    TRACE("got geometry with key=%s  (%lf,position=%d,%d, size=%d,%d)\n",
	    key,iconview_geometry.scrollX,
	    iconview_geometry.x,iconview_geometry.y,
	    iconview_geometry.w,iconview_geometry.h);
    DBH_close(geometry);
    return &iconview_geometry;
}

static
void 
save_iconview_geometry_p(icon_view_t *icon_view_p){
    iconview_geometry_t iconview_geometry;
    DBHashTable *geometry;
    GString *gs;
    gchar *f;
    const gchar *key;
    if (!icon_view_p) return;

    if (!icon_view_p->en || !icon_view_p->en->path) key="ROOT_ICONVIEW";
    else key=icon_view_p->en->path;
    
    f=g_build_filename(xdg_cache_dir(),GRIDVIEW_GEOMETRY_DBH_FILE,NULL);
    
    geometry = DBH_open(f);
    if (!geometry) geometry = DBH_create(f, 11);

    g_free(f);
    if (!geometry) {
	g_warning("cannot create geometry file");
	return;
    }
    
    gs = g_string_new(key);	
    sprintf((char *)DBH_KEY(geometry), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);

    iconview_geometry.w=icon_view_p->widgets.window->allocation.width;
    iconview_geometry.h=icon_view_p->widgets.window->allocation.height;
    
    //iconview_geometry.w=icon_view_p->paperX;
    //iconview_geometry.h=icon_view_p->paperY;

    
    iconview_geometry.scrollX=gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
    TRACE("saving ajustment at %lf (%s)",iconview_geometry.scrollX, key);
    gtk_window_get_position ((GtkWindow *)icon_view_p->widgets.window,&(iconview_geometry.x),&(iconview_geometry.y));
    /*iconview_geometry.preferences=icon_view_p->preferences;*/
	    
    TRACE("saving windowposition %d,%d size %d,%d",
	    iconview_geometry.x,iconview_geometry.y,
	    iconview_geometry.w,iconview_geometry.h);
 


    memcpy(DBH_DATA(geometry),&iconview_geometry,  sizeof(iconview_geometry_t));
    DBH_set_recordsize(geometry, sizeof(iconview_geometry_t));
    
    if (!DBH_update(geometry))	{
	g_warning("!DBH_update(geometry)");
    }
    DBH_close(geometry);
    TRACE("saved geometry with key=%s (%lf,%d,%d)\n",
	    key,
	    iconview_geometry.scrollX,
	    iconview_geometry.w,
	    iconview_geometry.h);
    return;
}

static 
void
restore_iconview_size (icon_view_t *icon_view_p){
    double a=0.0;
    /*record_entry_t *en=icon_view_p->en;*/
    iconview_geometry_t *iconview_geometry_p;
    iconview_geometry_p=get_iconview_geometry_p(icon_view_p);
    /* figure out the x,y landing position before the resize to
     * avoid race conditions and the inability of gtk to sync
     * easily with X server */
    TRACE("restore_iconview_size now");
    CLUE(show_clues(icon_view_p,"beginning....");)
    if (iconview_geometry_p) {
	
	gint x,y;
	gint root_w,root_h;
			
	graphics_apply_window_size(icon_view_p, iconview_geometry_p->w, iconview_geometry_p->h);
	
	if (iconview_geometry_p->w && iconview_geometry_p->h) {
	    int w=iconview_geometry_p->w;
	    int h=iconview_geometry_p->h;
	    int current_mouseX=icon_view_p->current_mouseX; /* snapshot */
	    int current_mouseY=icon_view_p->current_mouseY; /* snapshot */
	    GdkWindow *win=gtk_widget_get_parent_window(icon_view_p->widgets.status);

	    TRACE("autoresize for %s (%d,%d)",((icon_view_p->en && icon_view_p->en->path)?icon_view_p->en->path:"null"),w,h);

	    gtk_window_get_position((GtkWindow *)icon_view_p->widgets.window,&x,&y);
	    gdk_window_get_geometry  (gdk_get_default_root_window(),
				    NULL,NULL,&root_w,&root_h,NULL);
	    TRACE("********************WM suggests: x=%d y=%d",x,y);
	    TRACE("Bottom corners on resize: x=%d, y=%d (w=%d;%d, h=%d;%d)",
		    iconview_geometry_p->w+x,iconview_geometry_p->h+y,
		    iconview_geometry_p->w,root_w,
		    iconview_geometry_p->h,root_h);
	    TRACE("mouse position: x=%d, y=%d",current_mouseX,current_mouseY);
	   
#define X_OFFSET 5
#define Y_OFFSET 25
	    /* check if bottom corner is off the virtual screen */
	    if (w+x <= root_w && h+y <= root_h){
		/* it is */
		TRACE("bottom corner is within the virtual screen");
		TRACE("restoring size to %d,%d at %d,%d",w, h, x,y);
		gdk_window_move_resize (win,
			((x<X_OFFSET)?X_OFFSET:x),
			((y<Y_OFFSET)?Y_OFFSET:y), w,h);
		/*graphics_apply_window_size(icon_view_p, w, h);*/
	    } else {
		TRACE("bottom corner is off virtual screen");			
		/* check if saved position contains mouse position 
		 * (this is to ascertain saved position is visible)*/
		if (!current_mouseX && !current_mouseY) {
		    TRACE("No initial mouse position");
		} else {
		    int suggestX, suggestY;
		    TRACE("Mouse position detected");
		    suggestX=(current_mouseX+x) - w/2;
		    suggestY=(current_mouseY+y) - h/2;
		    if (suggestX < X_OFFSET) suggestX=X_OFFSET;
		    if (suggestY < Y_OFFSET) suggestY=Y_OFFSET;
		    TRACE("Suggested geometry: x=%d, y=%d, w=%d, h=%d",
			    suggestX,
			    suggestY,
			    w,h);
		    if (suggestX+w <= root_w && suggestY+h <= root_h)
		    /*if (current_mouseX >= iconview_geometry_p->x - 10 &&
			current_mouseX <= iconview_geometry_p->x + w &&
			current_mouseY >= iconview_geometry_p->y - 10 &&
			current_mouseY >= iconview_geometry_p->y + h)*/
		    {
			int offset =  iconview_is_mapped(icon_view_p);
			/* it is, should be ok to reset size and position */
			TRACE("cool. Y offset is %d*%d",offset,Y_OFFSET);
			x=iconview_geometry_p->x,y=iconview_geometry_p->y;
			gdk_window_move_resize (win, suggestX, suggestY+(offset*25), w,h);
			/*graphics_apply_window_size(icon_view_p, w, h);*/
 		    } 
		    else {
			TRACE("beyond mouse area of interest!");
		    }
		}
	    } 
	    

	    while (gtk_events_pending()) gtk_main_iteration();
	    gdk_flush();
	    CLUE(TRACE("paper size=(%d,%d), allocation=(%d,%d)",
	    icon_view_p->paperX,
	    icon_view_p->paperY,
	    icon_view_p->paper->allocation.width,
	    icon_view_p->paper->allocation.height);)

	    TRACE("resize to %d,%d",iconview_geometry_p->w,iconview_geometry_p->h);
#if 0
	    /* this is already set */
	TRACE("before; icon_view_p->text_height=%d",icon_view_p->text_height);
	    graphics_set_rows_columns(icon_view_p, iconview_geometry_p->w);
	TRACE("after; icon_view_p->text_height=%d",icon_view_p->text_height);
#endif
	    
	    if (iconview_geometry_p->scrollX < icon_view_p->paper->allocation.height)
	    {
		a=iconview_geometry_p->scrollX;
	    }
	    TRACE("scrolled_window->upper: %lf->%lf (icon_view_p->grid_rows=%d, icon_view_p->text_height=%d)",
		    (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window))->upper,
		    (double)icon_view_p->grid_rows*CELLHEIGHT,
		    icon_view_p->grid_rows,icon_view_p->text_height);
	    (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window))->upper=(double)icon_view_p->grid_rows*CELLHEIGHT;
	    if (a<icon_view_p->grid_rows*CELLHEIGHT && 
		    icon_view_p->paper->allocation.height > 
		    icon_view_p->widgets.window->allocation.height ) {
		TRACE("setting scroll position to %lf",a);
		gtk_adjustment_set_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window),a);
	    } else {
		gtk_adjustment_set_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window),0.0);
	    }
	    gtk_adjustment_changed (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
	    
	    TRACE("set adjustment to %lf",a); 

	}
    } else {
	TRACE("no iconview_geometry_p");
    }
    CLUE(show_clues(icon_view_p,"end....");)
}

static 
int
select_population_rectangle(icon_view_t *icon_view_p,
			    GdkRectangle *rect)
{
    int result=0;
    int row,column;
    int bottom_row=rect->y/CELLHEIGHT;
    int bottom_column=rect->x/CELLWIDTH;
    int top_row=(rect->y+rect->height)/CELLHEIGHT;
    int top_column=(rect->x+rect->width)/CELLWIDTH;

    int low_X=rect->x, low_Y=rect->y; 
    int	high_X=rect->x+rect->width, high_Y=rect->y+rect->height;

    TRACE("CELLHEIGHT=%d,CELLWIDTH=%d,rect=(%d,%d,%d,%d)",
	    CELLHEIGHT,CELLWIDTH,low_X,low_Y,high_X,high_Y);
    if (!rect->width || !rect->height) return result;

    /* first find the affected grid elements. we
     * later can figure out if the icon is actually
     * selected. */
    if (!icon_view_p->population_pp) return result;
    
    for (row=bottom_row; row <= top_row; row++) {
	for (column=bottom_column; column <= top_column; column++){
	    population_t *population_p;
	    int element=row*icon_view_p->grid_columns+column;
	    if (element >= icon_view_p->max_elements) continue;
	    if (column >= icon_view_p->grid_columns)  continue;
	    population_p = *(icon_view_p->population_pp+element);
	    if (!population_p) continue;
	    TRACE("select_population_rectangle: row, column ok (%d,%d)",row,column);
	    /* update row, column to consider posible window resizes 
	     * that may have occured. */
	    population_p->row=row;
	    population_p->column=column;
	    /* figure out if the icon is actually in the selection box */
	    {
		int low_x = column*CELLWIDTH + CELLWSPACING;
		int high_x = column*CELLWIDTH + CELLWSPACING 
		    + population_p->pixbufW;
		int low_y = row*CELLHEIGHT;
		int high_y = row*CELLHEIGHT + population_p->pixbufH;
		if (low_X - high_x < -1 && low_x - high_X < -1 &&
		    low_Y - high_y < -1 && low_y - high_Y < -1){
		    TRACE("select_population_rectangle: found in selection box: %s",
			    population_p->en->path);
		    select_pixbuf(icon_view_p,population_p);

		    result++;
		}
			
	    }
	    
	}
    }
    return result;
}

static
void
draw_window(icon_view_t *icon_view_p, int x, int y, gboolean draw){
    static GdkGC *toggleGC=NULL;
    if (icon_view_p->down_X == -1 && icon_view_p->down_Y == -1) return;

    if (!toggleGC){
	GdkColor pen_color={7,65535,30000,65535}; 
	toggleGC = gdk_gc_new (icon_view_p->paper->window);
	gdk_gc_set_colormap (toggleGC,icon_view_p->cmap);
	gdk_colormap_alloc_color(icon_view_p->cmap,&pen_color,TRUE,TRUE);
	gdk_gc_set_foreground (toggleGC, &pen_color);	
	gdk_gc_set_function (toggleGC, GDK_XOR);
    }
    if (icon_view_p->old_X == -1 && icon_view_p->old_Y== -1) {
	    icon_view_p->old_X=icon_view_p->down_X;
	    icon_view_p->old_Y=icon_view_p->down_Y;
    } else {
	    int lowX,highX,lowY,highY;
	    lowX=(icon_view_p->old_X>icon_view_p->down_X)?
		icon_view_p->down_X:icon_view_p->old_X;
	    lowY=(icon_view_p->old_Y>icon_view_p->down_Y)?
		icon_view_p->down_Y:icon_view_p->old_Y;
	    highX=(icon_view_p->old_X<icon_view_p->down_X)?
		icon_view_p->down_X:icon_view_p->old_X;
	    highY=(icon_view_p->old_Y<icon_view_p->down_Y)?
		icon_view_p->down_Y:icon_view_p->old_Y;
	    /* clean old rectangle */
	    /* draw new rectangle */
	    gdk_draw_rectangle (icon_view_p->paper->window, 
			toggleGC, FALSE, 
			lowX,lowY,
			highX-lowX,highY-lowY);
	    if (!draw) return;
	    /* draw new rectangle */
	    icon_view_p->old_X=x;
	    icon_view_p->old_Y=y;
	    lowX=(icon_view_p->old_X>icon_view_p->down_X)?
		icon_view_p->down_X:icon_view_p->old_X;
	    lowY=(icon_view_p->old_Y>icon_view_p->down_Y)?
		icon_view_p->down_Y:icon_view_p->old_Y;
	    highX=(icon_view_p->old_X<icon_view_p->down_X)?
		icon_view_p->down_X:icon_view_p->old_X;
	    highY=(icon_view_p->old_Y<icon_view_p->down_Y)?
		icon_view_p->down_Y:icon_view_p->old_Y;
	    gdk_draw_rectangle (icon_view_p->paper->window, 
			toggleGC, FALSE, 
			lowX,lowY,
			highX-lowX,highY-lowY);
	    
    }

}

static 
int
select_population_area(	icon_view_t *icon_view_p)
{
    GdkRectangle rect;
    int lowX=(icon_view_p->old_X>icon_view_p->down_X)?
	icon_view_p->down_X:icon_view_p->old_X;
    int lowY=(icon_view_p->old_Y>icon_view_p->down_Y)?
	icon_view_p->down_Y:icon_view_p->old_Y;
    int highX=(icon_view_p->old_X<icon_view_p->down_X)?
	icon_view_p->down_X:icon_view_p->old_X;
    int highY=(icon_view_p->old_Y<icon_view_p->down_Y)?
	icon_view_p->down_Y:icon_view_p->old_Y;
    rect.x = lowX;
    rect.y = lowY;
    rect.width = highX - lowX;
    rect.height = highY - lowY;
    return select_population_rectangle(icon_view_p,&rect);
}

static
void set_session_command (icon_view_t *icon_view_p, int argc, char **argv){
    int j, rargc=0;
    static char **rstart=NULL;
    TRACE("set_restart_command argc=%d",argc);
    
    if (!argc) return;
    for (rargc=0; argv[rargc]; rargc++);
    TRACE("rargc=%d",rargc);
    g_free(rstart); 
    rstart = (char **)malloc((rargc+1)*sizeof(char *));
    memset (rstart,0,(rargc+1)*sizeof(char *));
    for(j=0;j<rargc;j++){
	rstart[j]=g_strdup(argv[j]);
	TRACE("arg[%d]=%s",j,rstart[j]);
    }
    rstart[rargc]=NULL;
    smc_set_properties(rargc, rstart, SmRestartIfRunning);
      return;
}


static 
void
set_iconview_restart(icon_view_t *icon_view_p)
{
	int argc=0;
	/*int argc=1+2*g_list_length(iconview_list);*/
	const gchar *argv[5];
	argv[0]="xffm-iconview";

	if (icon_view_p->module_name && function_void("plugins",icon_view_p->module_name,"exec_name")){
		argv[argc++]=function_void("plugins",icon_view_p->module_name,"exec_name");
	} else {
		argc++;
	}  
	if (icon_view_p->en && icon_view_p->en->path){
		argv[argc++]=icon_view_p->en->path;
	} else {
		argv[argc++]=NULL;
	}
	
	argv[argc++]=NULL;
	set_session_command (icon_view_p,argc,argv);
}


static
void
set_iconview_title(	icon_view_t *icon_view_p)
{
    record_entry_t *en=icon_view_p->en;
    const gchar *path;

    if (en && en->path && strlen(en->path)){
	path=en->path;
    } else {
	path=OUR_HOST_NAME(&(icon_view_p->widgets));
    }
    if (icon_view_p->module_name){
      if (icon_view_p->module_name && function_natural("plugins",icon_view_p->module_name,icon_view_p->en,"window_title")){
	  path=function_natural("plugins",icon_view_p->module_name,icon_view_p->en,"window_title");
      }
      else if (function_void("plugins",icon_view_p->module_name,"exec_name")) {
	  path=function_void("plugins",icon_view_p->module_name,"exec_name");
      }
    }
    /*if (icon_view_p->module_name && function_void("plugins",icon_view_p->module_name,"exec_name")) path=function_void("plugins",icon_view_p->module_name,"exec_name");*/
    set_icon_name(icon_view_p->widgets.window,path);
    set_application_icon(&(icon_view_p->widgets),en);
    
    /* session management */
    set_iconview_restart(icon_view_p);
    
    
    return;
}
#if 0
static 
void
graphics_expose_labels(	icon_view_t *icon_view_p,
			int bottom_row,
			int bottom_column,
			int top_row,
			int top_column){
    int row,column;
    TRACE("expose for grid elements %d,%d -> %d,%d",
	    bottom_row,bottom_column,top_row,top_column);
    if (!icon_view_p) return;
    for (column=bottom_column; column<=top_column; column++){
	for (row=bottom_row; row<=top_row; row++){
	    
	    int element=row*icon_view_p->grid_columns+column;
	    population_t *population_p;
	    if (icon_view_p->population_pp)
		population_p=icon_view_p->population_pp[element];
	    else
		population_p=NULL;
	    TRACE("exposing element %d,%d",row,column);
	    select_pen(icon_view_p,BACKGROUND_COLOR);
	    /* if element is out of bounds, skip it */
	    if (element >= icon_view_p->max_elements) return;
	    /* if element is repeated as first column of next row, skip it */
	    if (element == (row+1)*icon_view_p->grid_columns) return;
	        
	    if ( population_p ){
		int text_color=TEXT_COLOR;
		/* contents */

		if (population_p->en && population_p->en->path && !g_utf8_validate (population_p->en->path,-1,NULL)) 
		    text_color=INVALID_UTF8_TEXT_COLOR;
		TRACE("drawing element %d,%d (0x%x)",row,column,
			(unsigned)population_p);
		
		if (population_p==icon_view_p->label_p)text_color=SATURATE_LABEL_COLOR;
		
		if (population_p->selected) text_color=SELECT_TEXT_COLOR;
		else if (population_p==icon_view_p->saturated_p)
		    text_color=SATURATE_TEXT_COLOR;
		select_pen(icon_view_p,text_color);
		if (population_p->layout) 
		    gdk_draw_layout(icon_view_p->paper->window,
		    icon_view_p->penGC, 
		    column*CELLWIDTH + (CELLWIDTH-population_p->logical_rect.width)/2,
		    row*CELLHEIGHT+TEXTSPACING+population_p->pixbufH,
		    population_p->layout);
		if (population_p->layout2) 
		    gdk_draw_layout(icon_view_p->paper->window,
		    icon_view_p->penGC, 
		    column*CELLWIDTH + (CELLWIDTH-population_p->logical_rect2.width)/2,
		    row*CELLHEIGHT+TEXTSPACING+population_p->pixbufH+population_p->logical_rect2.height,
		    population_p->layout2);

	    }
	}
    }
}
#endif
static 
void
graphics_expose_item(	icon_view_t *icon_view_p,
			int row,
			int column){
	    int element=row*icon_view_p->grid_columns+column;
	    population_t *population_p;
	    if (icon_view_p->population_pp)
		population_p=icon_view_p->population_pp[element];
	    else
		population_p=NULL;
	    TRACE("exposing element %d,%d",row,column);
	    select_pen(icon_view_p,BACKGROUND_COLOR);
	    gdk_draw_rectangle (icon_view_p->paper->window, 
			icon_view_p->penGC, TRUE, 
			column*CELLWIDTH,row*CELLHEIGHT,
			CELLWIDTH,CELLHEIGHT);
	    /* if element is out of bounds, skip it */
	    if (element >= icon_view_p->max_elements) return;
	    /* if element is repeated as first column of next row, skip it */
	    if (element == (row+1)*icon_view_p->grid_columns) return;
	        
	    if ( population_p ){
		int text_color=TEXT_COLOR;
		/* contents */

		if (population_p->en && population_p->en->path && !g_utf8_validate (population_p->en->path,-1,NULL)) 
		    text_color=INVALID_UTF8_TEXT_COLOR;
		TRACE("drawing element %d,%d (0x%x)",row,column,
			(unsigned)population_p);
		
		if (population_p==icon_view_p->label_p)text_color=SATURATE_LABEL_COLOR;
	        if (population_p->pixbuf) {
		    gdk_draw_pixbuf (icon_view_p->paper->window,
		    icon_view_p->penGC,
		    population_p->pixbuf,
		    0,0,
		    column*CELLWIDTH+CELLWSPACING,
		    row*CELLHEIGHT,
		    population_p->pixbufW,
		    population_p->pixbufH,
                    GDK_RGB_DITHER_NONE,0,0);
		}
		
		if (population_p->selected) text_color=SELECT_TEXT_COLOR;
		else if (population_p==icon_view_p->saturated_p)
		    text_color=SATURATE_TEXT_COLOR;
		select_pen(icon_view_p,text_color);
		if (population_p->layout) 
		    gdk_draw_layout(icon_view_p->paper->window,
		    icon_view_p->penGC, 
		    column*CELLWIDTH + (CELLWIDTH-population_p->logical_rect.width)/2,
		    row*CELLHEIGHT+TEXTSPACING+population_p->pixbufH,
		    population_p->layout);
		if (population_p->layout2) 
		    gdk_draw_layout(icon_view_p->paper->window,
		    icon_view_p->penGC, 
		    column*CELLWIDTH + (CELLWIDTH-population_p->logical_rect2.width)/2,
		    row*CELLHEIGHT+TEXTSPACING+population_p->pixbufH+population_p->logical_rect2.height,
		    population_p->layout2);

	    }
}

/**
 * graphics_expose:
 *
 *    redraws a range of grid elements.
 *    
 *    To redraw by x,y coordinates, use
 *    gtk_widget_draw_queue_area(). This will in turn come
 *    back to this function with the correct grid range parameters.
 *    
 *    **/

static 
void
graphics_expose(	icon_view_t *icon_view_p,
			int bottom_row,
			int bottom_column,
			int top_row,
			int top_column)
{
    int row,column;
    TRACE("expose for grid elements %d,%d -> %d,%d",
	    bottom_row,bottom_column,top_row,top_column);
    if (!icon_view_p) return;
    for (column=bottom_column; column<=top_column; column++){
	for (row=bottom_row; row<=top_row; row++){
	    graphics_expose_item(icon_view_p,row,column);
	}
    }
}

static 
void
graphics_set_rows_columns(icon_view_t *icon_view_p, int width){
    icon_view_p->grid_columns = width / CELLWIDTH;
    icon_view_p->grid_rows = icon_view_p->grid_area / icon_view_p->grid_columns;
    if (icon_view_p->grid_rows * icon_view_p->grid_columns < icon_view_p->max_elements) 
     {
	TRACE("++++adding an extra row...%d*%d < %d",
		icon_view_p->grid_rows,icon_view_p->grid_columns,
		icon_view_p->max_elements);
	icon_view_p->grid_rows++;
    }
}


static 
void
graphics_expose_all(	icon_view_t *icon_view_p){
    GdkRectangle rect;
    rect.x=rect.y=0;
    rect.width=icon_view_p->widgets.window->allocation.width;
    rect.height=icon_view_p->widgets.window->allocation.height;
    gdk_window_invalidate_rect(icon_view_p->widgets.window->window,&rect,TRUE);  
    TRACE("exposeall for grid");
}



/**
 * graphics_on_size:
 *
 * figures out the number of columns and rows in the paper
 * from resize event data *
 * **/

static
gboolean    
graphics_on_size (	icon_view_t *icon_view_p, 
			int width, 
			int height)
{
    int w,h;
    GtkAdjustment *adjustment;
    TRACE("graphics_on_size: area ...%d x %d = %d\n",width,height,width*height);
    if (!icon_view_p || !icon_view_p->paper) {
	g_warning("!icon_view_p || !icon_view_p->paper");
	return TRUE;
    }
    if (!CELLWIDTH) {
	TRACE("!CELLWIDTH");
	return TRUE;
    }
    
    w=icon_view_p->paper->allocation.width;
    h=icon_view_p->paper->allocation.height;  
    TRACE("graphics_on_size: paper area...%d\n",w*h);
    TRACE("graphics_on_size: w=%d, windowW=%d\n",w,icon_view_p->widgets.window->allocation.width);
    graphics_set_rows_columns(icon_view_p, width);
    
    TRACE("graphics_on_size: rows and columns: %d,%d",icon_view_p->grid_rows,icon_view_p->grid_columns);
    
    adjustment=gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window);
    TRACE("graphics_on_size: adjustment upper=%lf, adjustment pagesize=%lf", adjustment->upper,adjustment->page_size);
    adjustment->upper=icon_view_p->grid_rows*CELLHEIGHT;

    CLUE(show_clues(icon_view_p,"graphics_on_size....");)

    /* XXX this lies: */
    TRACE("hscroll is visible=%d",GTK_WIDGET_VISIBLE(icon_view_p->scrolled_window->hscrollbar));
    /*{
	    record_entry_t *en=copy_entry(icon_view_p->en);

	    reload_iconview(icon_view_p,en,FALSE);
    }*/
	    
    return TRUE;
}

static 
void
graphics_apply_window_size(icon_view_t *icon_view_p, int w, int h){
    gdk_flush();
    gdk_display_sync  (gdk_display_get_default ());
    graphics_on_size (icon_view_p,  w,h);
    TRACE("gdk_window_resize(paperX,Y=%d,%d) grid_rows=%d, grid_cols=%d (%s)",
      icon_view_p->paperX,icon_view_p->paperY,
      icon_view_p->grid_rows,icon_view_p->grid_columns,
      ((icon_view_p->en && icon_view_p->en->path)?icon_view_p->en->path:"null")
	    );
    gtk_widget_set_size_request(icon_view_p->paper,icon_view_p->paperX,	icon_view_p->paperY);
    TRACE("scroll position=%d",gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window)));
    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();
    gdk_display_sync  (gdk_display_get_default ());

}

/**
 * select_pixbuf:
 *
 * Selects the icon which belongs to the parameter @population_p
 * in the iconview window @icon_view_p
 *
 * **/

static 
void 
select_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p)
{
    if (!population_p) {
	TRACE("!population_p");
	return;
    }
    if (!population_p->en) return;
    
    if (IS_DUMMY_TYPE(population_p->en->type)) return;
    /* this might not be convenient: */
#if 10
    if (icon_view_p->module_name) {
	/* ask the module whether the element is selectable 
	 * (by default they will not be)*/
	if (!function_natural("plugins",icon_view_p->module_name,
		    population_p->en,"is_selectable")) 
	{
	    return;
	}
    }
#endif
    if (IS_ROOT_TYPE(population_p->en->type) && population_p->en->module)
    {
	/*if (!population_p->en->module) return;*/
	if (!function_natural("plugins",population_p->en->module,
		    population_p->en,"get_dnd_path")) return;
    }
    

    if (!population_p->selected_pixbuf && population_p->normal_pixbuf){
	population_p->selected_pixbuf = gdk_pixbuf_copy (population_p->normal_pixbuf);
	gdk_pixbuf_saturate_and_pixelate(population_p->selected_pixbuf,population_p->selected_pixbuf,-8.0,TRUE); 
    }
    population_p->pixbuf = population_p->selected_pixbuf;
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);	
    if (!population_p->selected) icon_view_p->selection_count++;
    population_p->selected=TRUE;
    if (!g_list_find(icon_view_p->selection_list,population_p->en))
	icon_view_p->selection_list = g_list_append(icon_view_p->selection_list,population_p->en);
    icon_view_p->selected_p=population_p;
    
}

static 
void 
unselect_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p)
{
    if (!population_p) {
	g_warning("!population_p");
	return;
    }   
    population_p->pixbuf = population_p->normal_pixbuf;
    
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, 
		population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);	
    if (population_p->selected) icon_view_p->selection_count--;
    population_p->selected=FALSE;
    if (icon_view_p->selection_list){
	icon_view_p->selection_list = g_list_remove(icon_view_p->selection_list,population_p->en);
	if (!g_list_length(icon_view_p->selection_list)){
	    g_list_free(icon_view_p->selection_list);
	    icon_view_p->selection_list=NULL;
	}
    }
}

static 
void 
unselect_all_pixbuf(	icon_view_t *icon_view_p)
{
    GList *tmp;
    for (tmp=icon_view_p->population_list; tmp; tmp=tmp->next){
	population_t *population_p = (population_t *)tmp->data;
	if (!population_p) continue;
	if (population_p == icon_view_p->doing_drag_p) continue;
	if (population_p->selected){
	    unselect_pixbuf(icon_view_p,population_p);
	}
    }
    if (icon_view_p->selection_list) g_list_free(icon_view_p->selection_list);
    icon_view_p->selection_list=NULL;
}
   

static 
void 
saturate_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p)
{
    if (!population_p) {
	g_warning("!population_p");
	return;
    }
    if (population_p->normal_pixbuf) {
	if (icon_view_p->dnd_pixmap) {
	    g_object_unref(icon_view_p->dnd_pixmap);
	    if (icon_view_p->dnd_mask) g_object_unref(icon_view_p->dnd_mask);
	    icon_view_p->dnd_pixmap=NULL;
	    icon_view_p->dnd_mask=NULL;
	    TRACE("unref dnd_pixmap (now null)");
	}
	TRACE("setting dnd_pixmap");
	gdk_pixbuf_render_pixmap_and_mask(population_p->normal_pixbuf,&(icon_view_p->dnd_pixmap),&(icon_view_p->dnd_mask),1);
    }
   
    if (population_p->selected) return;
    if (getenv("XFFM_DISABLE_TIPS") && strlen(getenv("XFFM_DISABLE_TIPS"))) {
	/* tips disabled condition */
	TRACE("tips disabled by environment variable");
    }
    else {
	tip_timer_t *tip_timer_p = (tip_timer_t *)malloc(sizeof(tip_timer_t));
	memset(tip_timer_p, 0, sizeof(tip_timer_t));
	tip_timer_p->icon_view_p = icon_view_p;
	tip_timer_p->tip_timer = icon_view_p->tip_timer =
	    g_timeout_add (500,graphics_set_entry_tip, tip_timer_p);
    }	
    if (!population_p->saturated_pixbuf && population_p->normal_pixbuf){
	population_p->saturated_pixbuf = gdk_pixbuf_copy (population_p->normal_pixbuf);
	gdk_pixbuf_saturate_and_pixelate(population_p->saturated_pixbuf,population_p->saturated_pixbuf,38.0,TRUE);
    }
    population_p->pixbuf = population_p->saturated_pixbuf;
    icon_view_p->saturated_p=population_p;
    TRACE("saturate row, column=(%d,%d)",population_p->row,population_p->column);
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
}

static 
void 
unsaturate_pixbuf(	icon_view_t *icon_view_p)
{
    if (icon_view_p->tip_timer) {
	
    }
    if (!icon_view_p->saturated_p) {
	TRACE("!icon_view_p->saturated_p");
	return;
    }  
    if (icon_view_p->saturated_p->en && g_list_find(icon_view_p->selection_list,icon_view_p->saturated_p->en)){
	icon_view_p->saturated_p=NULL;
	TRACE("population is selected...");
	return;
    }
    icon_view_p->saturated_p->pixbuf = icon_view_p->saturated_p->normal_pixbuf;
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		icon_view_p->saturated_p->column*CELLWIDTH, 
		icon_view_p->saturated_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);	
    icon_view_p->saturated_p=NULL;
    graphics_unset_entry_tip(icon_view_p);
}


static 
void 
graphics_saturation_event(	icon_view_t *icon_view_p,
				population_t *population_p,
				double x,
				double y)
{
    if (!icon_view_p) return;
    if (!population_p && icon_view_p->saturated_p){
	TRACE("unsaturating");
	unsaturate_pixbuf(icon_view_p);
	return;
    }
    TRACE("graphics_saturation_event");
    if (icon_view_p->doing_drag_p && x>0 && y>0){
	gdouble h=(x - icon_view_p->mouseX)*(x - icon_view_p->mouseX)+(y - icon_view_p->mouseY)*(y - icon_view_p->mouseY);
	TRACE("h=%f",h);
	/* reverse 1:2 to change behaviour from control to no-control */
	if (h >= 4) enter_drag_state(icon_view_p);
#if 0
	/* if not valid drop target, return */
	if (icon_view_p->module_name){
	    if (!function_natural("plugins",icon_view_p->module_name,population_p->en,"valid_drop_site")) return;
	} else { /* local */
	    if (!IS_DIR(population_p->en->type)) return;
	}
#endif
    }
    /*if (!population_p || population_p->selected) {*/
    if (!population_p) {
	graphics_unset_entry_tip(icon_view_p);
	return;
    }
    if (population_p && !icon_view_p->saturated_p){
	TRACE("saturating");
	saturate_pixbuf(icon_view_p,population_p);
    }
    TRACE("graphics_saturation_event done");
}
static 
void 
graphics_label_event(	icon_view_t *icon_view_p,
				population_t *population_p)
{
    if (!icon_view_p) return;
    if (!population_p && icon_view_p->label_p){
	TRACE("unsaturating label");
	gtk_widget_queue_draw_area (icon_view_p->paper, 
		icon_view_p->label_p->column*CELLWIDTH, 
		icon_view_p->label_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);	
	icon_view_p->label_p=NULL;
	return;
    }
    if (!population_p || population_p->selected) return;
   
    if (population_p && !icon_view_p->label_p && population_p->en && !IS_ROOT_TYPE(population_p->en->type) && !IS_DUMMY_TYPE(population_p->en->type)){
	if (icon_view_p->module_name){
	    TRACE("FIXME: ask module");
	} else if (IS_PATH(population_p->en->type)) {
	    TRACE("saturating label");
	    icon_view_p->label_p=population_p;
	    gtk_widget_queue_draw_area (icon_view_p->paper, 
		icon_view_p->label_p->column*CELLWIDTH, 
		icon_view_p->label_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);	
	}
    }
}


static
void 
select_pen(		icon_view_t *icon_view_p,
			int p)
{
  static GdkColor pen_color[]={
      {0,65535,65535,65535}, 	/*white*/
      {1,0,0,0}, 		/*black*/
      {2,45000,0,0}, 		/*red*/
      {3,0,30000,0}, 		/*green*/
      {4,0,0,65535}, 		/*blue*/
      {5,28000,28000,0}, 	/*brown*/
      {6,65535,0,65535}, 	/*magenta*/
  };
  if (p < 0 ||  p > 6) {
      g_warning("pen %d out of range.",p);
      return;
  }
	    
  if (!icon_view_p->cmap) {
    int i;
      
    icon_view_p->cmap = gdk_drawable_get_colormap (icon_view_p->paper->window);
    for (i=0; i<7; i++){
	if (!gdk_colormap_alloc_color(icon_view_p->cmap,pen_color+i,TRUE,TRUE)) 
	    g_error ("couldn't allocate color");
    }

    icon_view_p->penGC = gdk_gc_new (icon_view_p->paper->window);
    gdk_gc_set_colormap (icon_view_p->penGC,icon_view_p->cmap);
  }
  gdk_gc_set_foreground (icon_view_p->penGC, pen_color+p);	
}

static
int
get_max_layout_width(icon_view_t *icon_view_p,xfdir_t *xfdir_p, int vport_width){
    int i; 
    int max_width=CELLHEIGHT;
    PangoLayout *layout=NULL;
    if (!xfdir_p || !xfdir_p->pathc) {
	return max_width;
    }
    for (i=0; i<xfdir_p->pathc; i++) {
	PangoRectangle logical_rect;
	const gchar *label=my_utf_string(xfdir_p->gl[i].pathv);
	layout = gtk_widget_create_pango_layout(icon_view_p->paper, label);
	pango_layout_get_pixel_extents(layout, NULL, &(logical_rect));
	g_object_unref(layout);
	if ((logical_rect.width/2+2*TEXTSPACING + 1) > max_width) {
	    TRACE("max width for %s",label);
	    /* this is to fit at least 3 columns. anything less is not
	     * an iconview but a listview */
	    if (logical_rect.width/2+2*TEXTSPACING + 1 < vport_width/3)
	    {
		max_width = (logical_rect.width/2+2*TEXTSPACING + 1);
	    } else {
		max_width = vport_width/3;
	    }
	}
    }
    return max_width;
}

static
void
graphics_mk_layouts(icon_view_t *icon_view_p,gchar *tag,PangoLayout **layout,PangoLayout **layout2 ){
    int i;
    gchar *optimal_chars=" .-_";
    static gchar *optimal_set[4]={NULL,NULL,NULL,NULL};
    PangoRectangle logical_rect;
    gchar *tag_copy=NULL,*the_tag=NULL;
    
    if (!layout || !layout2) return;
    /* cleanup first */
    if (*layout) g_object_unref(*layout);
    if (*layout2) g_object_unref(*layout2);
    *layout=*layout2=NULL;
    
    if (!tag || !strlen(tag)) return;
    if (!optimal_set[0]) {
	for (i=0; i<strlen(optimal_chars); i++){
	    gchar c[2]={0,0};
	    c[0]=optimal_chars[i];
	    optimal_set[i]=g_strdup(my_utf_string(c));
	}
    }

    /* new method... */
    /* get width of string */
    the_tag=g_strdup(my_utf_string(tag));
    *layout = gtk_widget_create_pango_layout(icon_view_p->paper, the_tag);
    pango_layout_get_pixel_extents(*layout, NULL, &(logical_rect));
    if (logical_rect.width+1 <= CELLWIDTH - 2*TEXTSPACING){
	/* if it fits, were all done */
	TRACE("no cut necessary for %s",tag);
	g_free(the_tag);
	return;
    }
    /* shucks, it doesn't fit. Let's work with a copy of the tag */
    tag_copy=g_strdup(the_tag);
    while (strlen(tag_copy)>1 && logical_rect.width+1 > CELLWIDTH - 2*TEXTSPACING)
    {
	gchar *rear;
	int length=strlen(tag_copy);
	gchar *p=tag_copy+length-1;
	rear=g_utf8_find_prev_char(tag_copy,p);	
	length=strlen (rear);
	memset(rear,0,length);
	g_object_unref(*layout);
	*layout = gtk_widget_create_pango_layout(icon_view_p->paper, tag_copy);
	pango_layout_get_pixel_extents(*layout, NULL, &(logical_rect));	
    }
    TRACE("\"%s\" cut to \"%s\"",the_tag,tag_copy);
    /* Now the first part fits, but the split may not be optimum
     * we must now look for one in " .-_" to do the split, but the
     * character search must be done in utf */
    /* is the cut optimal?*/
     {
	int cut_location=strlen(tag_copy);
	gchar *optimal_ch=NULL;
	gchar *p=the_tag+(cut_location-1);
	gchar *optimal_cut_p=NULL;
	p=g_utf8_find_prev_char(the_tag,p);/* previous validated location */
	p=g_utf8_find_next_char(p,NULL);/* validated location */
	
	for (i=0; i<strlen(optimal_chars); i++){
	    if (strncmp(p,optimal_set[i],strlen(optimal_set[i]))==0){
		optimal_ch=optimal_set[i];
		optimal_cut_p=p;
		TRACE("optimal cut found for %s",tag);
		break;
	    }
	}
	if (optimal_cut_p) goto go_on;
	
	
	for (i=0; i<strlen(optimal_chars); i++){
	    gchar *g=g_utf8_strrchr (tag_copy,-1, g_utf8_get_char (optimal_set[i]));
	    if (g) {
		int diff=strlen(tag_copy)-strlen(g);
		g=the_tag+diff+1;
		*layout2 = gtk_widget_create_pango_layout(icon_view_p->paper, g);
		pango_layout_get_pixel_extents(*layout2, NULL, &(logical_rect));
		if (logical_rect.width+1 <= CELLWIDTH - 2*TEXTSPACING) {
		    TRACE("might improve cut for %s",tag);
		    g_object_unref(*layout);  
		    memset(tag_copy+diff+1,0,strlen(tag_copy+diff+1));
		    *layout = gtk_widget_create_pango_layout(icon_view_p->paper, tag_copy);
		    
		    goto done;
		} else {
		    TRACE("NOT improveable: %s (could look for another cut char)",tag);
		    g_object_unref(*layout2);  
		}
		break;		
	    }
	}
     }
#if 0
     /* so its not improvable. then strcat a "~" to show the cut, unless
      * next line starts with a space */
     {gchar *p=the_tag+(strlen(tag_copy));
     if (strncmp(p,optimal_set[0],strlen(optimal_set[0])))
     
     {
	 gchar *tag_copy2;
	 g_object_unref(*layout);  
	 tag_copy2 = g_strconcat(tag_copy,my_utf_string("~"),NULL);
	 *layout = gtk_widget_create_pango_layout(icon_view_p->paper, tag_copy2);
	 g_free(tag_copy2);
     } }    
#endif
    
    /* So we don't have an optimal split. Let's construct the rest.*/
go_on:
    if (strlen(tag_copy) && strlen(the_tag) > strlen(tag_copy)){
	gchar *p=the_tag+(strlen(tag_copy));
	/* XXX should do this for all spaces, not just the first  */
	if (strncmp(p,optimal_set[0],strlen(optimal_set[0]))==0) p=g_utf8_find_next_char (p,NULL);
	
	*layout2 = gtk_widget_create_pango_layout(icon_view_p->paper, p);
	/* final question, does it fit? */
	pango_layout_get_pixel_extents(*layout2, NULL, &(logical_rect));
	while (logical_rect.width+1 > CELLWIDTH - 2*TEXTSPACING) {
	    gchar *g;
	    TRACE("second line does not fit (%s)",p);
	    g_object_unref(*layout2);  
	    p=g_utf8_find_next_char (p,NULL);
	    g=g_strconcat("~",p,NULL);
	    *layout2 = gtk_widget_create_pango_layout(icon_view_p->paper, my_utf_string(g));
	    pango_layout_get_pixel_extents(*layout2, NULL, &(logical_rect));
	    g_free(g);
	}	
	
#if 0
	/*FIXED_COLUMN_WIDTH*/
/* this is not the dtfile default */
	pango_layout_get_pixel_extents(*layout2, NULL, &(logical_rect));
	while (strlen(p)>1 && logical_rect.width+1 > CELLWIDTH - 2*TEXTSPACING)
	{
	    gchar *alt_tag=NULL;
	    if (g_utf8_find_next_char (p,NULL) && 
		    p != g_utf8_find_next_char (p,NULL))
	    {
		p=g_utf8_find_next_char (p,NULL);
	    } else { p++;}
	    alt_tag=g_strconcat(my_utf_string("~"),p,NULL);
	    g_object_unref(*layout2);
	    *layout2 = gtk_widget_create_pango_layout(icon_view_p->paper,alt_tag);
	    pango_layout_get_pixel_extents(*layout2, NULL, &(logical_rect));
	    g_free(alt_tag);
	}
#endif
    }
    /* finally we free our copies of the tag */
done:
    g_free(tag_copy);
    g_free(the_tag);
    return;
}

static
void
graphics_mk_logical_rect(PangoLayout *layout, PangoRectangle *logical_rect)
{
    if (layout){
	pango_layout_get_pixel_extents(layout, NULL, logical_rect);
	/* ++ because zero is actually unity, not nonexistance */
	logical_rect->width++;
	logical_rect->height++;
    }
}

void 
static
graphics_layout(	icon_view_t *icon_view_p,
			population_t *population_p,
			gchar *actual_tag)
{
    if (!icon_view_p || !population_p){
	g_warning("!icon_view_p || !population_p");
	return;
    }
    graphics_mk_layouts(icon_view_p,actual_tag,
	    &(population_p->layout),&(population_p->layout2));
    graphics_mk_logical_rect(population_p->layout,
	    &(population_p->logical_rect));
    graphics_mk_logical_rect(population_p->layout2,
	    &(population_p->logical_rect2));
    return;
}

static
population_t **
graphics_mk_grid_elements(int grid_elements){
    population_t **population_pp;
    /* we use (grid_elements+1) to use a NULL pointer as an
     * end of list marker */
    TRACE("grid_elements=%d (elements)",grid_elements);
    population_pp=
	(population_t **)malloc((grid_elements+1)*sizeof(population_t *));
    memset((void *)(population_pp),0,(grid_elements+1)*sizeof(population_t *));
    return population_pp;
}

G_MODULE_EXPORT
gboolean 
graphics_destroy_event	(icon_view_t *icon_view_p)
{
    GList *tmp;
    for (tmp=icon_view_p->go_list; tmp; tmp=tmp->next) {
	destroy_entry((record_entry_t *)(tmp->data));
    }
    g_list_free(icon_view_p->go_list);
    destroy_population(icon_view_p);
    /*if (icon_view_p->pixmap) g_object_unref(icon_view_p->pixmap);*/
    destroy_entry(icon_view_p->en);
    g_free(icon_view_p->population_pp);
    icon_view_p->population_pp=NULL;
    widgets_p_list=g_list_remove (widgets_p_list,&(icon_view_p->widgets));
    iconview_list=g_list_remove (iconview_list,icon_view_p);
    gtk_widget_destroy(icon_view_p->widgets.window);
    
    gtk_object_sink(GTK_OBJECT(icon_view_p->tips));
    
    g_free(icon_view_p);
    
    if (!iconview_list) {
	TRACE("No more iconviews on screen.");
	gtk_main_quit();
    }
    else {
	set_iconview_restart((icon_view_t *)iconview_list->data);
    }
    return TRUE;
}


