/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
/*typedef struct callback_data_t {
    icon_view_t *icon_view_p;
    population_t *population_p;
    int caso;
}callback_data_t;*/



static
void
entry_activate(		GtkEntry *entry,
			icon_view_t *icon_view_p, 
			int caso)
{
    gchar *actual_tag;
    const gchar *tag;
    gchar *b;
    int result=FALSE;
    population_t *population_p;

    

    gtk_widget_hide(GTK_WIDGET(icon_view_p->rename));
    
    population_p=g_object_get_data(G_OBJECT(icon_view_p->rename),"population_p");
    // FIXME: should check whether population_p is still a valid pointer,
    //        or else garantee that invalid pointers will not be used...
   
    TRACE("entry_activate");
    
    if (!population_p || !population_p->en || !population_p->en->path) {
ATOMIC_OFF
	return;
    }
    actual_tag=gtk_editable_get_chars ((GtkEditable *)entry,0,-1);
    tag=my_utf2local_string(actual_tag);
    g_free(actual_tag);
    actual_tag=g_strdup(tag);
    b=g_path_get_basename(population_p->en->path);
    
    if (strcmp(b,actual_tag)==0 && caso==0){
       result=xffm_touch(&(icon_view_p->widgets),population_p->en->path);
       TRACE("touching file %s...",population_p->en->path);
    }
    else {
        gchar *d=g_path_get_dirname(population_p->en->path);
	gchar *p=g_build_filename(d,actual_tag,NULL);
	g_free(d);
	switch (caso) {
	    case 0:
	        result=xffm_rename(&(icon_view_p->widgets), p,population_p->en->path);
		if (result) {
		 gchar *q=p; 
		 p=population_p->en->path; 
		 population_p->en->path=q;
	    	}
		TRACE("renaming %s to %s",population_p->en->path,p);
		
		break;
	    case 1:
	        result=xffm_duplicate(&(icon_view_p->widgets), p,population_p->en->path);
		if (result) {
		 record_entry_t *en;
		 gchar *q=p; 
		 p=population_p->en->path; 
		 population_p->en->path=q;
		 en=copy_entry(icon_view_p->en);
		 reload_iconview(icon_view_p,en,TRUE);
	    	}
		TRACE("duplication %s to %s",population_p->en->path,p);
		break;
	    case 2:
	        result=xffm_symlink(&(icon_view_p->widgets),  p,population_p->en->path);
		TRACE("symlinking %s to %s",population_p->en->path,p);
		if (result) {
		 record_entry_t *en;
		 gchar *q=p; 
		 p=population_p->en->path; 
		 population_p->en->path=q;
		 en=copy_entry(icon_view_p->en);
		 reload_iconview(icon_view_p,en,TRUE);
	    	}
		break;
	}
	g_free(p);
    }

    g_free(b);
    g_free(actual_tag);
    done_with_rename((gpointer)icon_view_p);
    if (result) {
	gchar *m=g_strdup_printf(_("cp/mv complete"));
	print_status(&(icon_view_p->widgets),"xffm/info",m,NULL);
	g_free(m);
    }
    else {
	gchar *m=g_strdup_printf(_("cp/mv %s"),strerror(EIO));
	print_status(&(icon_view_p->widgets),"xffm/error",m,NULL);
	g_free(m);
    }
}
    

static
void
entry_activate_rename(GtkEntry *entry, gpointer data){
    entry_activate(entry,(icon_view_t *)data,0); 
}
static
void
entry_activate_duplicate(GtkEntry *entry, gpointer data){
    entry_activate(entry,(icon_view_t *)data,1); 
}
static
void
entry_activate_symlink(GtkEntry *entry, gpointer data){
    entry_activate(entry,(icon_view_t *)data,2); 
}

static void
done_with_rename (gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    gchar *actual_tag=NULL;
    population_t *population_p;
    
    
    TRACE("done_with_rename");
    if (!icon_view_p->rename) {
	TRACE("!icon_view_p->rename");
	return;
    }
    population_p=g_object_get_data(G_OBJECT(icon_view_p->rename),"population_p");
    
    TRACE("gtk_widget_destroy(GTK_WIDGET(icon_view_p->rename));");
    gtk_widget_destroy(GTK_WIDGET(icon_view_p->rename));
    icon_view_p->rename=NULL;
    print_status(&(icon_view_p->widgets),NULL," ",NULL);
   

    actual_tag=g_path_get_basename(population_p->en->path);   
    if (actual_tag && strcmp(actual_tag,"..Wastebasket")==0){
	g_free(actual_tag);
	actual_tag = g_strdup(_("Wastebasket"));
    }	    

    TRACE("xxxx actual tag=%s",actual_tag);
    graphics_layout(icon_view_p,population_p,actual_tag);
    g_free(actual_tag); 
    
    gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, 
		population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
ATOMIC_OFF
    TRACE("redlight off");
}



static void
destroy_dialog (GtkWidget * widget, gpointer data)
{
    done_with_rename(data);
}



static gint on_key_press(GtkWidget * entry, GdkEventKey * event, gpointer data)
{
 icon_view_t *icon_view_p = (icon_view_t *)data;
 if (event->keyval == GDK_Escape) {
    done_with_rename(data);
    print_status(&(icon_view_p->widgets),NULL,_("Omitting"),NULL);
    return TRUE;
 }
 return FALSE;
}

static 
gboolean 
grab_focus (		GtkWidget *widget, 
			GdkEventCrossing *event, 
			gpointer data)
{
   //icon_view_t *icon_view_p = (icon_view_t *)data;   
    XSetInputFocus(GDK_DISPLAY(),
	  GDK_WINDOW_XID(gtk_widget_get_parent_window(widget)),
	  RevertToParent,CurrentTime);
    return TRUE;
}

/* exported only within library */ 
void
mk_text_entry(icon_view_t *icon_view_p, population_t *population_p, int caso){
  GtkWidget *entry;
  GtkWidget *hbox;

    /* avoid race condition with monitor...*/
    ATOMIC_CHECK return;
ATOMIC_ON
    TRACE("redlight on");
    
    icon_view_p->selected_p = population_p;
  
  
  /* caso=0, rename; caso=1, duplicate; caso=2, symlink */
  
  if (population_p->layout){ 
    g_object_unref(population_p->layout);
    population_p->layout=NULL;
  }
  if (population_p->layout2){ 
    g_object_unref(population_p->layout2);
    population_p->layout2=NULL;
  }
  gtk_widget_queue_draw_area (icon_view_p->paper, 
	population_p->column*CELLWIDTH, 
	population_p->row*CELLHEIGHT,
	CELLWIDTH,CELLHEIGHT);
		    
  entry=gtk_entry_new ();
  hbox = gtk_hbox_new (FALSE, 0);
  /*icon_view_p->rename = gtk_window_new (GTK_WINDOW_TOPLEVEL);*/
  icon_view_p->rename = gtk_window_new (GTK_WINDOW_POPUP);
  /*gtk_window_set_position (GTK_WINDOW (icon_view_p->rename), GTK_WIN_POS_MOUSE);*/
  
  {
#define DECORATION_H 10
    gint x,y; 
    double sh = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window));
    int X = CELLWIDTH * population_p->column;
    int Y= CELLHEIGHT * population_p->row + ICON_SIZE + TEXTSPACING  ;
    gtk_window_get_position((GtkWindow *)icon_view_p->widgets.window,&x,&y);
    TRACE("sh=%lf, Y=%d, y=%d\n",sh,Y,y);
    gtk_window_move((GtkWindow *)icon_view_p->rename,X+x,Y+y-sh+DECORATION_H);
  }

  
  gtk_window_set_resizable (GTK_WINDOW (icon_view_p->rename), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (icon_view_p->rename), 0);
  gtk_window_set_modal (GTK_WINDOW (icon_view_p->rename), FALSE);
  {
    gchar *g=NULL,*b=g_path_get_basename(population_p->en->path);
    g_object_set_data(G_OBJECT(icon_view_p->rename),"population_p",population_p);
    if (caso == 0) {
	g=g_strdup(b);
	print_status(&(icon_view_p->widgets),"xffm/warning",_("Rename")," ",b,NULL);
	g_signal_connect (G_OBJECT (entry), "activate", 
  		  GTK_SIGNAL_FUNC (entry_activate_rename), icon_view_p);
    }
    else if (caso == 1) {
	gchar *dir=g_path_get_dirname(population_p->en->path);
	g=g_strdup(xffm_new_name(dir, b));
	g_free(dir);
	print_status(&(icon_view_p->widgets),"xffm/warning",_("Duplicate")," ",b,NULL);
	g_signal_connect (G_OBJECT (entry), "activate", 
  		  GTK_SIGNAL_FUNC (entry_activate_duplicate), icon_view_p);
    }
    else if (caso == 2){
	g=g_strconcat(b,"-lnk",NULL);
	print_status(&(icon_view_p->widgets),"xffm/warning",_("Symlink")," ",b,NULL);
	g_signal_connect (G_OBJECT (entry), "activate", 
  		  GTK_SIGNAL_FUNC (entry_activate_symlink), icon_view_p);
    }
    
    gtk_entry_set_text ((GtkEntry *)entry,my_utf_string(g));
    g_free(b);
    g_free(g);
  }
  gtk_editable_set_editable ((GtkEditable *) entry, TRUE);
  gtk_editable_select_region((GtkEditable *) entry,0,-1);

  gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
  gtk_container_add (GTK_CONTAINER(icon_view_p->rename), hbox);

  
  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, FALSE, 0);
		  
  g_signal_connect (G_OBJECT (icon_view_p->rename), "destroy-event", 
  		  GTK_SIGNAL_FUNC (destroy_dialog), icon_view_p);
  g_signal_connect(G_OBJECT(icon_view_p->rename), "key_press_event", 
		    G_CALLBACK(on_key_press), icon_view_p);
  g_signal_connect (G_OBJECT (icon_view_p->rename), "delete-event", 
  		  GTK_SIGNAL_FUNC (destroy_dialog), icon_view_p);
  g_signal_connect (G_OBJECT (entry),"enter-notify-event",
		  GTK_SIGNAL_FUNC (grab_focus),icon_view_p);
 
  gtk_widget_show_all (icon_view_p->rename);
  /* this sucks: gtk_widget_grab_focus (icon_view_p->rename);*/
  XSetInputFocus(GDK_DISPLAY(),
	  GDK_WINDOW_XID(gtk_widget_get_parent_window(entry)),
	  RevertToParent,CurrentTime);
  gtk_window_set_transient_for (
		    GTK_WINDOW (icon_view_p->rename), 
		    GTK_WINDOW (icon_view_p->widgets.window));
  
  
  return;
}




static 
void
process_double_click(icon_view_t *icon_view_p,population_t *population_p, gboolean control){
    icon_view_t *icon_view_target=icon_view_p;
    if (!icon_view_p || !population_p) return;
    cursor_wait(icon_view_p->widgets.window);

    if (population_p->en) TRACE("submodule_name=%s",population_p->en->module);
    if (population_p->en && population_p->en->exec) {
	xffm_on_run_path(&(icon_view_p->widgets), population_p->en->exec,
		    NULL, 
		    population_p->en->terminal,
		    FALSE, FALSE);
	cursor_reset(icon_view_p->widgets.window);
	return;
    }
    if (population_p->en && !population_p->en->module && 
	!g_file_test(population_p->en->path,G_FILE_TEST_IS_DIR)) 
    {
	record_entry_t *en=population_p->en;
	if (g_file_test(en->path,G_FILE_TEST_EXISTS)){
	    record_entry_t *en=population_p->en;
	    cursor_reset(icon_view_p->widgets.window);
	    if(IS_EXE(en->type) )
	    {	/* run it (if not registered)*/
		const gchar *prg = MIME_command (en->path);
		if (prg) gridview_open_with(&(icon_view_p->widgets),en);
		else {
    			/*  assume in_term to be safe */
    			SET_IN_TERM(en->subtype);
			xffm_double_click_run(&(icon_view_p->widgets),en);
		}
		if (en->path) RECENT_add2history(&(icon_view_p->widgets),en->path);
	    } else {      /* open with */
		gridview_open_with(&(icon_view_p->widgets),en);
		if (en->path) RECENT_add2history(&(icon_view_p->widgets),en->path);
	    }
	    return;
	}

        g_warning("nothing programed here with double click");
	cursor_reset(icon_view_p->widgets.window);
        return;
    } else {
	record_entry_t *en=copy_entry(population_p->en);
	const gchar *submodule_name=NULL;
	if (population_p->en) submodule_name=population_p->en->module;

   
	
	/* does the module have something else in mind for the
	double click on the particular entry ? */
	if (icon_view_p->module_name){
	    TRACE("looking for alternate module double click here");
	    if (function_rational("plugins",icon_view_p->module_name,en,&(icon_view_p->widgets),"double_click"))
	    {
		cursor_reset(icon_view_p->widgets.window);
		return;
	    }
	    TRACE("no alternate found, going for default...");
	}
	
	if (!control) {
	    TRACE("create_iconview ");	    
	    icon_view_target=create_iconview(en);	    
	    cursor_wait(icon_view_target->widgets.window);
	    cursor_reset(icon_view_p->widgets.window); 
	} else push_iconview_go_history(icon_view_p); 
    
	icon_view_target->preferences = icon_view_p->preferences;
	icon_view_target->sortcolumn = icon_view_p->sortcolumn;

	icon_view_target->module_name=submodule_name;
	TRACE("RELOADING HERE... module_name=%s",icon_view_target->module_name);
 	if (reload_iconview(icon_view_target, en, TRUE)){ 
	    if (en && en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)) gui_save_to_go_history(en->path);
	    cursor_reset(icon_view_target->widgets.window);
	}
    }
    return;    
}
  
static 
gint
my_strcmp(gconstpointer a, gconstpointer b){
    return (strcmp((char *)a, (char *)b));
}



static
int 
load_xfdir_icons(	icon_view_t *icon_view_p,
			xfdir_t *xfdir_p,
			GSList *reselect_list,
			record_entry_t *parent_en)
{
    population_t *population_p;
    unsigned int smallcount = 0;
    int last_element=0;
    int j,up=0;
    /*const gchar *submodule_name=function_void("plugins",
					   icon_view_p->module_name,
					   "submodule_name");*/

    /* add entry for each population_t */
    DBG("Loading... load_xfdir_icons()");
    if (xfdir_p) TRACE("pathc=%d",xfdir_p->pathc);
    
    /* previous value is freed in init_iconview() call: */
    icon_view_p->population_pp=
	graphics_mk_grid_elements(icon_view_p->grid_rows*icon_view_p->grid_columns);

    /* with a clean population_pp, this expose no longer 
     * clears the paper on screen :
     *
     * gtk_widget_queue_draw(icon_view_p->paper);
     *
     * */
   
    population_p=add_up_element(icon_view_p,parent_en);
    if (population_p) {
        icon_view_p->population_pp[up]=population_p;
        up++;
    }
    else {
	TRACE("no parent for %s",icon_view_p->module_name);
    }
	
    
    TRACE("xfdir_p->pathc=%d",xfdir_p->pathc);
    if (xfdir_p) {
      for(j=0; j < xfdir_p->pathc; j++)
      {
	
	if (j+up >= icon_view_p->max_elements){
	    g_warning("j+up >= icon_view_p->max_elements");
	    continue;
	}
	if (!xfdir_p->gl[j].pathv || !xfdir_p->gl[j].en){
	    g_warning("!xfdir->gl[j].pathv || !xfdir->gl[j].en");
	    continue;
	}
	if (icon_view_p->population_pp) {
	    population_p=create_population_t(icon_view_p,xfdir_p->gl[j].en, j+up, NULL, xfdir_p->gl[j].pathv);
	    TRACE("%d. created %s",j+1,xfdir_p->gl[j].pathv);
	}
	else {
	    TRACE("Load borked");
	    return 0;
	}
	xfdir_p->gl[j].en->module = icon_view_p->submodule_name;
	if (icon_view_p->population_pp) icon_view_p->population_pp[j+up]=population_p;
	else return 0;
	TRACE("new population_p(%d,%d)=0x%x",population_p->row,population_p->column,(unsigned)population_p);
	
	gtk_widget_queue_draw_area (icon_view_p->paper, 
		population_p->column*CELLWIDTH, population_p->row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
	
	if (population_p->en && population_p->en->path) {
	    if (g_slist_find_custom(reselect_list,population_p->en->path,my_strcmp)){
		TRACE("reselecting %s",population_p->en->path);
		select_pixbuf(icon_view_p,population_p);
	    }
	}
	if(xfdir_p->pathc >= 512 && smallcount++ & (1 << 7))
	{
	    set_progress_full(&(icon_view_p->widgets),j, xfdir_p->pathc);
	    smallcount = 1;
	    while(gtk_events_pending()) gtk_main_iteration();
	    /*/Xprocess_pending_gtk();*/
	}
      }
      DBG("xfdir_p->pathc=%d",xfdir_p->pathc);
      /* we add 1 to get past last element, including up element
       * which is not tabulated in pathc...*/
      last_element=xfdir_p->pathc;	     
      if(xfdir_p->pathc >= 512) 
	  set_progress_full(&(icon_view_p->widgets),j, xfdir_p->pathc);
      TRACE("memory in population structures=%ld",(long)sizeof(population_t)*xfdir_p->pathc);
    } 
    for (j=last_element+1; j<icon_view_p->grid_area; j++) {
	/*clear remaining gridspots */  
	int row,column;
	row = j / icon_view_p->grid_columns;

	column = j - (row * icon_view_p->grid_columns);
	TRACE("*clear remaining gridspot=%d,%d. J=%d, max=%d, rows=%d, cols=%d, area=%d",
		row,column,j,icon_view_p->max_elements,
		icon_view_p->grid_rows,icon_view_p->grid_columns,
		icon_view_p->grid_area);
	if (row <= icon_view_p->grid_rows && 
		column <= icon_view_p->grid_columns)
	{
	    gtk_widget_queue_draw_area (icon_view_p->paper, 
		column*CELLWIDTH, row*CELLHEIGHT,
		CELLWIDTH,CELLHEIGHT);
	}
    }
    
    
    
    return 1;
}


static
void
init_grid(icon_view_t *icon_view_p, int pathc, xfdir_t *xfdir_p){
    int width;

    if (xfdir_p) pathc=xfdir_p->pathc;
    icon_view_p->max_elements=pathc;
    if (has_up_element(icon_view_p)) icon_view_p->max_elements++;
    
    iconview_geometry_t *iconview_geometry_p=
	    get_iconview_geometry_p(icon_view_p);

    if (!icon_view_p->widgets.window){
	g_warning("init_grid: icon_view_p->widgets.window==NULL");
	icon_view_p->grid_columns=MINIMUM_ICON_COLUMNS;
    } else {
	if (iconview_geometry_p) width=iconview_geometry_p->w;
	else width=icon_view_p->widgets.window->allocation.width;
	/* what is the viewport width? 
	 * viewport = ((GtkBin *)scrolled_window)->child 
	 * the same, minus the scrollbar, if any (bout 20)*/
#ifdef DEBUG
	GtkWidget *viewport=((GtkBin *)icon_view_p->scrolled_window)->child;
	DBG("window width=%d, geometry width=%d, viewport width=%d",
		icon_view_p->widgets.window->allocation.width,
		iconview_geometry_p->w,
		viewport->allocation.width);
#endif
        CELLWIDTH=get_max_layout_width(icon_view_p,xfdir_p,width );
	icon_view_p->grid_columns=width/CELLWIDTH;
    }
    
    icon_view_p->grid_rows = (icon_view_p->max_elements)/icon_view_p->grid_columns;
    DBG("init_grid: rows=%d columns=%d",icon_view_p->grid_rows, icon_view_p->grid_columns);
    if (icon_view_p->grid_rows * icon_view_p->grid_columns < icon_view_p->max_elements) {
	DBG("%d * %d < %d, adding extra row...pathc=%d",icon_view_p->grid_rows, icon_view_p->grid_columns, icon_view_p->max_elements,pathc);
	icon_view_p->grid_rows++;
    }

    icon_view_p->grid_area=icon_view_p->grid_rows*icon_view_p->grid_columns;

    
    icon_view_p->paperX = icon_view_p->grid_columns * CELLWIDTH;
    icon_view_p->paperY = icon_view_p->grid_rows * CELLHEIGHT;
    TRACE("init_grid: paperX=%d, paperY=%d",icon_view_p->paperX,icon_view_p->paperY);
 
    TRACE("paperX=%d columns=%d",icon_view_p->paperX,icon_view_p->grid_columns);
    TRACE("paperY=%d (%d rows)",icon_view_p->paperY,icon_view_p->grid_rows);   
    TRACE("area= %d cells)",icon_view_p->grid_area);   

}

static
void
init_icon_view(icon_view_t *icon_view_p, record_entry_t *en){
    icon_view_p->en=en;
    icon_view_p->down_X=-1,icon_view_p->down_Y=-1;
    icon_view_p->old_X=-1,icon_view_p->old_Y=-1;
    icon_view_p->selection_count=0;   
    if (icon_view_p->population_list) g_list_free(icon_view_p->population_list);
    icon_view_p->population_list=NULL;
    if (icon_view_p->selection_list) g_list_free(icon_view_p->selection_list);
    icon_view_p->selection_list=NULL;
    icon_view_p->mouseX=0;
    icon_view_p->mouseY=0;
    icon_view_p->tip_timer=0;
    icon_view_p->rename=NULL;
    icon_view_p->label_p=NULL;
    icon_view_p->doing_drag_p=NULL;
    icon_view_p->saturated_p=NULL;
    icon_view_p->selected_p=NULL;
    g_free(icon_view_p->population_pp);
    icon_view_p->population_pp=NULL; 
}

static 
xfdir_t *
local_xfdir(		icon_view_t *icon_view_p,
			record_entry_t *en)
{
    static xfdir_t xfdir;
    if (!en || !en->path){
	g_warning("en==NULL");
	return NULL;
    }
    if (!g_file_test(en->path,G_FILE_TEST_IS_DIR)) return NULL;
		/* XXX parameter 3 is gchar with regexp for
		 * filter. Not used in iconview at the present time. */
    if (!en->st) {
	en->st=(struct stat *)malloc(sizeof(struct stat));
	stat(en->path,en->st);
    }
#ifdef DO_THE_STATUS_LOADING_THING
    print_status(&(icon_view_p->widgets),"xffm/info",_("Loading..."),NULL);
#endif
    get_xfdir_local(&xfdir, en, NULL);
    return &xfdir;
}

    

