#define TIMERVAL 1000
#define MAX_LOAD_TIME 2

static
gint gridview_monitor(gpointer data)
{
   static gboolean said=FALSE;
   GList *tmp;
   int retval;
   TRACE("gridview_monitor");
    if(!xffm_details->timer)
    {
	xffm_details->timer = g_timeout_add (TIMERVAL,gridview_monitor, NULL);
	return TRUE;
    }
    if(getenv("XFFM_DISABLE_MONITOR") && strlen(getenv("XFFM_DISABLE_MONITOR"))) 
    {
	return TRUE;
    }
    waitpid(-1,&retval,WNOHANG);
    ATOMIC_CHECK return TRUE;
    
    for (tmp=iconview_list;tmp;tmp=tmp->next){
	struct stat st;
	icon_view_t *icon_view_p=(icon_view_t *)tmp->data;
	record_entry_t *new_en;
	widgets_t *widgets_p=&(icon_view_p->widgets);
	/* button down? */
	if (icon_view_p->down_X != -1 && icon_view_p->down_Y != -1) continue;
	/* popup active? */
	if (icon_view_p->popup_active) {
	    /*if (!said)*/
	    {
		print_status(widgets_p,"xffm/warning",_("Monitor disabled: click window to reenable"),NULL);		
		said=TRUE;
	    } 
	    continue;
	}
	if (said) {  
	    print_status(widgets_p,"xffm/info",_("Monitor reenabled"),NULL);	
	    said=FALSE;
	}
 	
	if (!icon_view_p || !icon_view_p->en) continue;
	/* entry tip on? */
	if (icon_view_p->tips->tip_window && GTK_WIDGET_VISIBLE(icon_view_p->tips->tip_window)){
	    TRACE("tip window is visible, skipping monitor");
	    continue;
	}
	
	if (icon_view_p->en->module) {
	    if (!function_natural("plugins",icon_view_p->en->module,(void *) icon_view_p->en,"module_monitor")) continue;
	    TRACE("updating %s",icon_view_p->en->module);
	} else {
	  if (!icon_view_p->en->path || !icon_view_p->en->st) continue;
	  if (!g_file_test(icon_view_p->en->path,G_FILE_TEST_EXISTS)) continue;
	  if (!update_check(icon_view_p->en)) {
	      /* we don't update until directory stops changing 
	       * (this is determined in update_check()*/
	    if (IS_CHANGED(icon_view_p->en->type)) print_status(&(icon_view_p->widgets),"xffm/info",_("Directory is modified"),NULL);
	    continue;
	  }
	}
	new_en=copy_entry(icon_view_p->en);
	if (!reload_iconview(icon_view_p,new_en,FALSE)){
	    destroy_entry(new_en);
	} else {
	    if (icon_view_p->en && icon_view_p->en->st) {
		if (icon_view_p->en->path) stat(icon_view_p->en->path,icon_view_p->en->st);
		else memcpy(icon_view_p->en->st,&st,sizeof(struct stat));
	    }
	}
    }
    return TRUE;
}
