/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
/*
This is a private header file for internal use
of gridview library. Do not include this in any
 file which does not belong to the gridview
 library... You have been warned...*/

#ifndef GRIDVIEW_H
#define GRIDVIEW_H

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <pwd.h>

#include <ctype.h>
#include <glob.h>
#include <memory.h>
#include <signal.h>
#include <dirent.h>

#include <X11/Xlib.h>
#ifdef HAVE_LIBSM
#include <X11/SM/SMlib.h>
#endif

#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gmodule.h>
#include <dbh.h>

#include "types.h"
#include "constants.h"

#include "primary.h"
#include "gui.h"
#include "actions_lib.h"


#include "gridview_macros.h"
#include "gridview_types.h"
#include "gridview_lib.h"
#include "gridview_input.h"
#include "gridview_popup.h"

void 
save_iconview_preferences(icon_view_t *icon_view_p);

gboolean 
graphics_destroy_event	(icon_view_t *icon_view_p);

#endif


