#ifndef GRIDVIEW_TYPES_H
#define GRIDVIEW_TYPES_H


typedef struct population_t {
    int row;
    int column;
    record_entry_t *en;
    int pixbufW;
    int pixbufH;
    GdkPixbuf *pixbuf;
    GdkPixbuf *normal_pixbuf;
    GdkPixbuf *saturated_pixbuf;
    GdkPixbuf *selected_pixbuf;
    gboolean selected;
    PangoLayout *layout;
    PangoRectangle logical_rect;
    PangoLayout *layout2;
    PangoRectangle logical_rect2;
} population_t;

typedef struct icon_view_t {
    widgets_t widgets;
    int grid_rows;
    int grid_columns;
    int grid_area;
    int max_elements;
    int selection_count;
    int preferences;
    int text_height;
    int column_width;
    gint paperX;
    gint paperY;
    gdouble mouseX;
    gdouble mouseY;
    int current_mouseX;
    int current_mouseY;
    int old_X;
    int old_Y;
    int down_X;
    int down_Y;
    int drag_button;
    population_t **population_pp;
    population_t *doing_drag_p;
    population_t *saturated_p;
    population_t *label_p;
    population_t *selected_p;
    GdkColormap *cmap;
    GdkGC *penGC;  
    record_entry_t *en;
    GList *population_list;
    GList *selection_list;
    GList *go_list;
    GtkWidget *paper;
    GtkWidget *rename;
    GtkWidget *popup;
    GtkTooltips *tips;
    int tip_timer;
    double vpane_ratio;
    GdkEventDND drag_event;
    GtkScrolledWindow *scrolled_window;
    int hot_x;
    int hot_y;
    gboolean dragstate;
    const gchar *module_name;
    const gchar *submodule_name;
    int sortcolumn;
    gboolean stop;
    gboolean popup_active;
    GdkPixmap *dnd_pixmap;
    GdkBitmap *dnd_mask;
    gboolean atomic;
} icon_view_t;


typedef struct iconview_geometry_t {
    gdouble scrollX;
    int x;
    int y;
    int w;
    int h;
} iconview_geometry_t;
typedef struct iconview_preferences_t {
    int preferences;
    int sortcolumn;
} iconview_preferences_t;
    

#endif

