/*
 * Copyright (C) 2003-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define SPLIT_VIEW
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#define __TREEVIEW_C__

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <dirent.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "gui.h"
#include "treeview.h"
#include "actions_lib.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define LOCAL_OVERRIDE_MASK (SHOW_MM|SHOW_TB1|SHOW_TB2|SHOW_F|SHOW_TITLES)

#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
SessionClient *session_client;
#endif

extern gboolean enable_pane_resize;


static
GtkTreeStore *
create_treestore(void)
{
    column_info_t column_info[] = {
	{EMPTY_COLUMN, G_TYPE_STRING},
	{ENTRY_COLUMN, G_TYPE_POINTER},
	{STYLE_COLUMN, PANGO_TYPE_STYLE},
	{FONT_COLUMN, PANGO_TYPE_FONT_DESCRIPTION},
	{SFONT_COLUMN, PANGO_TYPE_FONT_DESCRIPTION},
	{EDITABLE_COLUMN, G_TYPE_BOOLEAN},
	{COLOUR_COLUMN, GDK_TYPE_COLOR},
	{WEIGHT_COLUMN, G_TYPE_INT},

	{PIXBUF_COLUMN, GDK_TYPE_PIXBUF},
	{NAME_COLUMN, G_TYPE_STRING},
	{SIZE_COLUMN, G_TYPE_STRING},
	{DATE_COLUMN, G_TYPE_STRING},
	{OWNER_COLUMN, G_TYPE_STRING},
	{GROUP_COLUMN, G_TYPE_STRING},
	{MODE_COLUMN, G_TYPE_STRING}
    };
    return (gtk_tree_store_new(TREE_COLUMNS, 
		column_info[EMPTY_COLUMN].type, 
		column_info[ENTRY_COLUMN].type, 
		column_info[STYLE_COLUMN].type, 
		column_info[FONT_COLUMN].type, 
		column_info[SFONT_COLUMN].type, 
		column_info[EDITABLE_COLUMN].type, 
		column_info[COLOUR_COLUMN].type, 
		column_info[WEIGHT_COLUMN].type, 

		column_info[PIXBUF_COLUMN].type, 
		column_info[NAME_COLUMN].type, 
		column_info[SIZE_COLUMN].type, 
		column_info[DATE_COLUMN].type, 
		column_info[OWNER_COLUMN].type, 
		column_info[GROUP_COLUMN].type, 
		column_info[MODE_COLUMN].type));
}
static
void titles_off(GtkTreeViewColumn * column, gpointer data)
{
    quick_hide((GtkButton *) xffm_details->arbol->widgets.window, (gpointer) ((long)(SHOW_TITLES)));
}

static
void set_session_command (GtkWidget *widget, int argc, char **argv){
#ifdef HAVE_LIBXFCEGUI4
    int j;
    static gchar **rstart=NULL;
    gchar **saved_rstart=rstart;
	TRACE("set_restart_command argc=%d",argc);
    if (!argc) return;
     
    rstart = (gchar **)malloc((argc+1)*sizeof(gchar *));
    for(j=0;j<argc;j++){
	rstart[j]=g_strdup(argv[j]);
	TRACE("new_rstart %d: %s",j,rstart[j]);
    }
    rstart[argc]=NULL;
    if (session_client) session_client->restart_command=rstart;
    g_free(saved_rstart);

#endif
      return;
}

G_MODULE_EXPORT
void set_treeview_title (GtkWidget *widget, gchar *path)
{
    gchar *argv[3];
    set_icon_name(widget,path);

    argv[0]=xffm_details->argv[0];
    argv[1]=path;
    argv[2]=NULL;
    set_session_command (widget,2,argv);
    set_restart_command(widget,2,argv);
}

G_MODULE_EXPORT
void menu_detach(void)
{
    /*printf ("dbg:menu_detach()\n"); */
}

static
gboolean    on_name_size (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    int which = (int)((long)user_data);
    if (!enable_pane_resize) return FALSE;
    /*printf("TRACE %d is changing...%d\n",which,widget->allocation.width);*/
    xffm_details->arbol->treestuff[which].name_size=widget->allocation.width;
    return TRUE;
}

static
gboolean    on_size (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    static int pane_pos;
    
    GtkWidget *hpaned;

    if (!enable_pane_resize) {
	TRACE("pane resize not enabled\n");
	return FALSE;
    }
    hpaned = lookup_widget(xffm_details->arbol->widgets.window,"hpaned1");
    TRACE("TRACE:pane width=%d\n",hpaned->allocation.width);
    pane_pos=gtk_paned_get_position((GtkPaned *)hpaned);
    if (xffm_details->arbol->geometryX == xffm_details->arbol->widgets.window->allocation.width &&
	xffm_details->arbol->geometryY == xffm_details->arbol->widgets.window->allocation.height &&
	xffm_details->arbol->hpane != gtk_paned_get_position((GtkPaned *)hpaned)
	){
        xffm_details->arbol->hpane = gtk_paned_get_position((GtkPaned *)hpaned);
	xffm_details->arbol->hpane_ratio = (double)xffm_details->arbol->hpane / (double)hpaned->allocation.width;
	set_widget_initial_state();
	turn_on();
	TRACE("pane size is changing... new ratio=%lf (%d/%d)\n",
		xffm_details->arbol->hpane_ratio,xffm_details->arbol->hpane,hpaned->allocation.width);
    } else if (xffm_details->arbol->geometryX != xffm_details->arbol->widgets.window->allocation.width ||
	    xffm_details->arbol->geometryY != xffm_details->arbol->widgets.window->allocation.height ||
	    (xffm_details->arbol->hpane_ratio >= 0 && xffm_details->arbol->hpane != xffm_details->arbol->hpane_ratio * hpaned->allocation.width))
    {
	if (xffm_details->arbol->geometryX != xffm_details->arbol->widgets.window->allocation.width ||
	    xffm_details->arbol->hpane != xffm_details->arbol->hpane_ratio * hpaned->allocation.width)
	{
	    int pane_pos = xffm_details->arbol->hpane_ratio * hpaned->allocation.width;
	    /* keep pane ratio constant*/
	    TRACE("arbol->geometryX is changing... ratio=%lf, setting pane pos to %d\n",
		xffm_details->arbol->hpane_ratio,pane_pos);
	    gtk_paned_set_position(GTK_PANED(hpaned), pane_pos);
	    xffm_details->arbol->hpane = gtk_paned_get_position((GtkPaned *)hpaned);
	} else {
	    xffm_details->arbol->geometryY = xffm_details->arbol->widgets.window->allocation.height;
	    TRACE("arbol->geometryY change... not interesting.\n");
	    return TRUE;
	}
	xffm_details->arbol->geometryX = xffm_details->arbol->widgets.window->allocation.width;
	xffm_details->arbol->geometryY = xffm_details->arbol->widgets.window->allocation.height;	    
    } else {
	TRACE("size allocation event for main window...\n");
	return TRUE;
    }
    write_xffm_config(); 
    return TRUE;
}



static gboolean null_motion(GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    return FALSE;
}

G_MODULE_EXPORT
void create_module_root_element(GtkTreeView * treeview, GtkTreeIter *iterator,
		const gchar *module_name)
{
    record_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    
    const gchar *icon_id=NULL;
    const gchar *submodule_name=NULL;
    const gchar *label=NULL;
    
    if (!module_name) return;
 
 
    
      if (!function_void("plugins",module_name,"is_root_module")) {
	g_warning("%s is not root module",module_name);
	return;
      }
      module_name=function_void("plugins",module_name,"module_name");
      icon_id=function_natural("plugins",module_name,NULL,"module_icon_id");
      label=function_natural("plugins",module_name,NULL,"module_label");
      submodule_name=function_void("plugins",module_name,"module_name");
      
      en=mk_entry(0);
      {
	  gchar *g=(gchar *)function_natural("plugins",module_name,NULL,"module_label");
	  if (!g) g=g_strdup("FIXME");
	  en->path = g_strdup(g);
	  en->tag = g_strdup(g);
      }
    
    if (!icon_id || !label) {
	g_warning("(!icon_id || !label)");
	return;
    }   
    SET_ROOT_TYPE(en->type);
    en->module=module_name;
    
    
	
    if (xffm_details->preferences & IMAGE_PREVIEW) 	SET_SHOWS_IMAGES(en->type);
    if (xffm_details->preferences & SHOW_DOT) SET_SHOWS_HIDDEN(en->type);
	
    gtk_tree_store_append((GtkTreeStore *) treemodel, iterator, NULL);


    /* FIXME: should be "basic" function:*/
	TRACE("setting name to %s",label);
	gtk_tree_store_set((GtkTreeStore *) treemodel, iterator, 
			ENTRY_COLUMN, en, 
			NAME_COLUMN, (my_utf_string(label)), 
			MODE_COLUMN, (""), 
			DATE_COLUMN, (""), 
			GROUP_COLUMN, (""), 
			OWNER_COLUMN, (""), 
			SIZE_COLUMN, (""), 
	-1);
	
    /*FIXME hack to be removed, one by one*/
    TRACE("module name=%s",module_name);
    if (strcmp(module_name,"xffm_samba")==0) SET_NETWORK_TYPE(en->type);
    else if (strcmp(module_name,"xffm_fstab")==0) SET_FSTAB_TYPE(en->type);
    else if (strcmp(module_name,"xffm_trash")==0) SET_TRASH_TYPE(en->type);
	
	/* end hack */
    
    if (icon_id) {
	/*TRACE("icon_id=%s, size=%d",icon_id,xffm_details->icon_size);*/
	    GdkPixbuf *Icon = icon_tell(&(xffm_details->arbol->widgets), MEDIUM, icon_id);
	    update_iconcolumn_for_row(treemodel, iterator,Icon);	
    } else set_icon(treemodel, iterator);
	
	
    insert_dummy_row(treemodel, iterator,NULL,en,NULL,NULL);
}

G_MODULE_EXPORT
void create_root_element(GtkTreeView * treeview, GtkTreeIter *iterator,
		const gchar *which,const gchar *home){
    record_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    
	const gchar *name;
    	gchar *tag;
    if (which && strcmp(which,"xffm_find")){
	create_module_root_element(treeview, iterator,which);
	return;
    }
    if (which && strcmp(which,"xffm_find")==0)
    {
	en=mk_entry(0);
	SET_FIND_TYPE(en->type);
	name = _("Find");
	en->path=g_strdup(name);
    } else {
	if (!home) home=g_get_home_dir();
        if (!home) home="/";
	if((en = stat_entry((char *)home, 0)) == NULL) {
	    g_warning("cannot stat home dir: %s",home);
	    return;
	}
	SET_LOCAL_TYPE(en->type);
	if (xffm_details->preferences & IMAGE_PREVIEW) SET_SHOWS_IMAGES(en->type);
	if (xffm_details->preferences & SHOW_DOT) SET_SHOWS_HIDDEN(en->type);
	name = FILENAME(en);
    }

    SET_ROOT_TYPE(en->type);
    if (en->tag) {
	g_free(en->tag);
	en->tag = NULL;
    }
    tag = g_strdup("");
	
    gtk_tree_store_append((GtkTreeStore *) treemodel, iterator, NULL);
    TRACE("TRACE: root name is %s (%s)\n",name,en->path);
    en->count = -1;
    if (g_utf8_validate (en->path,-1,NULL)) set_row_colours(treemodel, iterator, NULL,DIR_COLOR);
    else  set_row_colours(treemodel, iterator, NULL,INVALID_UTF8_COLOR);
	    
    /* icon size set by config-file */
    TRACE("setting name to %s",name);
    gtk_tree_store_set((GtkTreeStore *) treemodel, iterator, 
			ENTRY_COLUMN, en, 
			NAME_COLUMN, (my_valid_utf_pathstring(name)), 
			MODE_COLUMN, (""), 
			DATE_COLUMN, (""), 
			GROUP_COLUMN, (""), 
			OWNER_COLUMN, (""), 
			SIZE_COLUMN, (""), 
	-1);
    set_icon(treemodel, iterator);
    if (!which) insert_dummy_row(treemodel, iterator,NULL,en,NULL,NULL);
    update_row(treemodel, iterator, NULL, en);
    g_free(tag);tag=NULL;
}




static void add_roots(GtkTreeView * treeview, char *home){
    GtkTreeIter iter;
    GSList *list,*plugin_list;
    plugin_list = find_root_plugins();

    TRACE("treeviews 0x%x == 0x%x",
	    (unsigned)(treeview),(unsigned)(xffm_details->arbol->treestuff[0].treeview));
    /* hidden treeview will have all found modules 
     * (except for xffm-find...)*/
    //if (treeview!=xffm_details->arbol->treestuff[0].treeview || !xffm_details->argv[1])
    if (treeview!=xffm_details->arbol->treestuff[0].treeview)
    {
	DBG("treeview full gui");
	TRACE("1. creating root element for %s",home);
	create_root_element(treeview,&iter,NULL,home);
	if (!strstr(xffm_details->argv[0],"xffm-find")){
	  for(list=plugin_list; list; list=list->next){
	    TRACE("---- %s",(char *)list->data);
	    create_module_root_element(treeview,&iter, list->data);
	}}
	return;
    }
#if DEBUG
      for(list=plugin_list; list; list=list->next){
	  DBG("checking for plugin-> %s",(char *)list->data);
      }
#endif
      
    if (xffm_details->argv[1]) {
	gboolean found=FALSE;
	if (xffm_details->argv[2]) {
	    for(list=plugin_list; list; list=list->next){
	    if (strcmp((char *)list->data,xffm_details->argv[2])==0) {
		create_module_root_element(treeview,&iter, list->data);
		found=TRUE;
	    }	
	    }
	    if (!found){
		const gchar *parent_module=xffm_details->argv[2];
		do {
		    parent_module=function_natural("plugins",parent_module,NULL,"parent_module_name");
		    if (parent_module && function_void("plugins",parent_module,"is_root_module")) {
			create_module_root_element(treeview,&iter, parent_module);
			break;
		    }
		} while (parent_module);
	    }
	    if (!found) {
		gchar *p=g_strdup_printf(_("Cannot find module %s nor parent module"),xffm_details->argv[2]);
		xffm_confirm(NULL,p,NULL,NULL);
		exit(0);
	    }
	}   
	else if (!strstr(xffm_details->argv[0],"xffm-find")) {
	    TRACE("3. creating root element for %s",xffm_details->argv[1]);
	    create_root_element(treeview,&iter,NULL,xffm_details->argv[1]);
	}
    }
    else { /* no arguments */
	TRACE("2. creating root element for %s",home);
	create_root_element(treeview,&iter,NULL,home);	  
    }
    return;
}


/***********  treeview ******************/
typedef struct menu_checks_t
{
    unsigned flag;
    char *name;
}
menu_checks_t;



static void insert_arrows(GtkTreeViewColumn *column, gboolean showup, gboolean showdown){
    GtkWidget *w = column->button;
    GtkWidget *box = gtk_bin_get_child(GTK_BIN(w));
    GtkWidget *arrow;
    arrow=gtk_arrow_new (GTK_ARROW_DOWN,GTK_SHADOW_NONE);
    g_object_set_data(G_OBJECT(column), "down", (gpointer) arrow);
    gtk_box_pack_start (GTK_BOX (box), arrow, FALSE, FALSE, 0);
    if (showdown) gtk_widget_show(arrow);
    arrow=gtk_arrow_new (GTK_ARROW_UP,GTK_SHADOW_NONE);
    g_object_set_data(G_OBJECT(column), "up", (gpointer) arrow);
    gtk_box_pack_start (GTK_BOX (box), arrow, FALSE, FALSE, 0);
    if (showup) gtk_widget_show(arrow);
}

static void insert_column_icon(GtkTreeViewColumn *column, const gchar *name){
  GdkPixbuf *src=NULL;
  GtkWidget *w = column->button;
  GtkWidget *box = gtk_bin_get_child(GTK_BIN(w));
  if (!name || !strlen(name)) return;
  src=ICON_create_pixbuf(name);
  if (src){
    GdkPixbuf *tgt = gdk_pixbuf_scale_simple(src, 18,18, GDK_INTERP_BILINEAR);
    GtkWidget *image = gtk_image_new_from_pixbuf (tgt);
    g_object_unref(src);
    g_object_unref(tgt);
    if (image) {
      GList *t,*tmp;
      gtk_widget_show(image);
      t=gtk_container_get_children(GTK_CONTAINER(box));
      for (tmp=t;tmp;tmp=tmp->next) {
	  GtkWidget *v=(GtkWidget *)tmp->data;
	  gtk_box_set_child_packing (GTK_BOX (box), v,FALSE,FALSE,0,GTK_PACK_START);
      }
      g_list_free(t);
      gtk_box_pack_start (GTK_BOX (box), image, FALSE, FALSE, 0);
      /*  gtk_box_reorder_child (GTK_BOX (box),image,0);*/
    }
  }
}


/* this is a flag to turn off sorting until all row of a node have
 * been added, so that a single sort is performed. This speeds things up.
 * Currently the value is set an unset in callbacks.c
 * */
G_MODULE_EXPORT
gboolean no_sorting=FALSE;
G_MODULE_EXPORT
gint IterCompareFunc(GtkTreeModel *treemodel, GtkTreeIter *a,GtkTreeIter *b, gpointer user_data){
    int caso=(int)((long)user_data);
    record_entry_t *en_a;
    record_entry_t *en_b;
    gtk_tree_model_get(treemodel, a, ENTRY_COLUMN, &en_a, -1);
    gtk_tree_model_get(treemodel, b, ENTRY_COLUMN, &en_b, -1);
    
    /*gboolean subsort = (gboolean)((long)user_data);*/

    if (no_sorting) return 0;
    return (entry_compare(caso,en_a,en_b));
}


static GtkTreeView *create_treeview(char *path,gint tree_id)
{
    int i;
    GtkCellRenderer *cell;
    gchar *d_path=NULL;
    GtkTreeViewColumn *column;
    GtkTreeModel *treemodel;
    GtkTreeView *treeview;
    GtkTreeSortable *sortable;
    GtkTreeSelection *selection;
    treestuff_t *treestuff = (xffm_details->arbol->treestuff)+tree_id;
    
    if(path && g_file_test(path,G_FILE_TEST_IS_DIR)) d_path=g_strdup(path);     

    /* create treemodel: */
    treemodel = treestuff->treemodel = GTK_TREE_MODEL(create_treestore());
    /* get treesortable */
    sortable = treestuff->sortable = GTK_TREE_SORTABLE((GtkTreeStore *)treestuff->treemodel);
    /* create treeview */
    treeview = treestuff->treeview = GTK_TREE_VIEW(gtk_tree_view_new_with_model(treestuff->treemodel));
    /* get selection */
    selection = treestuff->selection = GTK_TREE_SELECTION(gtk_tree_view_get_selection(treestuff->treeview));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

    g_timeout_add_full(0, 2000, (GtkFunction) set_treeview_colours, treeview, NULL);

    /* empty margin column. Do not remove */
    column = gtk_tree_view_column_new();
    cell = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, "text", EMPTY_COLUMN,  NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect ((gpointer) (column->button), "button_press_event", G_CALLBACK (column_button_press_event), (gpointer)((long)tree_id));
    g_signal_connect(G_OBJECT(column), "clicked", G_CALLBACK(titles_off), NULL);
    
    {
	  GtkWidget *arrow=gtk_arrow_new (GTK_ARROW_DOWN,GTK_SHADOW_NONE);
	  GtkWidget *w=column->button;
    	  GtkWidget *box = gtk_bin_get_child(GTK_BIN(w));
	  GtkTooltips *tooltips=(GtkTooltips *)lookup_widget(xffm_details->arbol->widgets.window,"tooltips");

	  gtk_box_pack_start (GTK_BOX (box), arrow, TRUE, TRUE, 0);
	  gtk_widget_show(arrow);
	  gtk_widget_set_size_request (w, 13, 0);
	  GTK_WIDGET_UNSET_FLAGS (w, GTK_CAN_FOCUS);
	  gtk_tooltips_set_tip (tooltips, w, _("Hide"), NULL);
    }
    
    /* XXX autosize columns must be set until after rendering window...
     * (gtk 2.2.4 bug) so they are set at main.c ...*/
    /* expander column.  */
    column = 
	xffm_details->arbol->treestuff[tree_id].column[PIXBUF_COLUMN] = gtk_tree_view_column_new();
    cell = gtk_cell_renderer_pixbuf_new();

    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "pixbuf", PIXBUF_COLUMN, 
		    "pixbuf_expander_closed", PIXBUF_COLUMN, 
		    "pixbuf_expander_open", PIXBUF_COLUMN, 
		    NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect(column, "clicked", G_CALLBACK(on_treeview_column_click),(gpointer)((long)tree_id));
    /*g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)(treeview));*/
    g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID)));
    

    gtk_tree_view_set_expander_column(treeview, column);
    
    /* create the label column */
    column = 
	xffm_details->arbol->treestuff[tree_id].column[NAME_COLUMN] = gtk_tree_view_column_new();
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);


    cell = gtk_cell_renderer_text_new();
    /*g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); */
    g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_rename), (gpointer)treeview);
    
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "style", STYLE_COLUMN, 
		    "font-desc", FONT_COLUMN, 
		    "text", NAME_COLUMN,
		    "editable", EDITABLE_COLUMN, 
		    "foreground-gdk", COLOUR_COLUMN,
		    /*"weight", WEIGHT_COLUMN,*/
		    NULL);

    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);

    if (xffm_details->preferences & TEXT_HEADERS) {
	const gchar *label=NULL;
	if (tree_id==0 && xffm_details->argv[2]){
	    label=(const gchar *)function_void("plugins",xffm_details->argv[2],"name_column_title");
	}
	if (!label) label=_("Name");
	gtk_tree_view_column_set_title(column, my_utf_string(label));
    }
    else insert_column_icon(column,"xffm/c-name");
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect ((gpointer) (column->button), "button_press_event", G_CALLBACK (column_button_press_event), (gpointer)((long)tree_id));
    g_signal_connect(column, "clicked", G_CALLBACK(on_treeview_column_click),(gpointer)((long)tree_id));
    g_signal_connect(G_OBJECT (column), "clicked", G_CALLBACK(on_column_click), (gpointer)(treeview));
    g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(NAME_COLUMN)));
    insert_arrows(column,FALSE,FALSE);


    for(i = SIZE_COLUMN; i < TREE_COLUMNS; i++)
    {
	const gchar *iname=NULL;
	const gchar *module_column_label="xxxx";
	cell = gtk_cell_renderer_text_new();
	g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
	column = 
	    gtk_tree_view_column_new();
	gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_GROW_ONLY);
	gtk_tree_view_column_set_resizable(column, TRUE);
	/* seems like a gtk bug while reordering (sometimes):
	 * Gtk-CRITICAL **: file gtktreeview.c: line 8647 (gtk_tree_view_move_column_after): assertion `base_el != NULL' failed */
	/*gtk_tree_view_column_set_reorderable(column, TRUE);*/

	gtk_tree_view_column_pack_start(column, cell, FALSE);
        g_signal_connect(column, "clicked", G_CALLBACK(on_treeview_column_click),(gpointer)((long)tree_id));
	switch (i)
	{
	    case SIZE_COLUMN:
		/*texto = _("Size");*/
		module_column_label="size_column_title";
		iname = (xffm_details->preferences & TEXT_HEADERS)?_("Size"):"xffm/c-size";
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview );
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(SIZE_COLUMN)));
		xffm_details->arbol->treestuff[tree_id].column[SIZE_COLUMN] = column;
		break;
	    case DATE_COLUMN:
		module_column_label="date_column_title";
		iname = (xffm_details->preferences & TEXT_HEADERS)?_("Date"):"xffm/c-time";
		/*texto = _("Date");*/
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click), (gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(DATE_COLUMN)));
		xffm_details->arbol->treestuff[tree_id].column[DATE_COLUMN] = column;
		break;
	    case OWNER_COLUMN:
		module_column_label="owner_column_title";
		iname = (xffm_details->preferences & TEXT_HEADERS)?_("Owner"):"xffm/c-uid";
		/*texto = _("Owner");*/
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(OWNER_COLUMN)));
		xffm_details->arbol->treestuff[tree_id].column[OWNER_COLUMN] = column;
		g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); 
		g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_chown), (gpointer)treeview);	
		break;
	    case GROUP_COLUMN:
		module_column_label="group_column_title";
		iname = (xffm_details->preferences & TEXT_HEADERS)?_("Group"):"xffm/c-gid";
		/*texto = _("Group");*/
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(GROUP_COLUMN)));
		xffm_details->arbol->treestuff[tree_id].column[GROUP_COLUMN] = column;
		g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); 
		g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_chgrp), (gpointer)treeview);	
		break;
	    case MODE_COLUMN:
		module_column_label="mode_column_title";
		iname = (xffm_details->preferences & TEXT_HEADERS)?_("Mode"):"xffm/c-mode";
		/*texto = _("Mode");*/
		xffm_details->arbol->treestuff[tree_id].column[MODE_COLUMN] = column;
		g_signal_connect(column, "clicked", G_CALLBACK(on_column_click),(gpointer)treeview);
		g_object_set_data(G_OBJECT(column), "column_id", (gpointer) ((long)(MODE_COLUMN)));
		g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); 
		g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (easy_remode), (gpointer)treeview);	
		break;
	    default:
		module_column_label="xxxx";
		iname = NULL;
	}
	
	if (i!=SIZE_COLUMN && i!=DATE_COLUMN) {
	   gtk_tree_view_column_set_attributes(column, cell,  
			"font-desc", SFONT_COLUMN, 
		        "foreground-gdk", COLOUR_COLUMN,
			"text", i, 
			"editable", EDITABLE_COLUMN, 
			NULL);
	} else {
	   gtk_tree_view_column_set_attributes(column, cell,  
			"font-desc", SFONT_COLUMN, 
		        "foreground-gdk", COLOUR_COLUMN,
			"text", i, 
			NULL);	    
	}
	
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
	gtk_tree_view_column_set_clickable(column, i);
	g_signal_connect ((gpointer) (column->button), "button_press_event", G_CALLBACK (column_button_press_event), (gpointer)((long)tree_id));
	if (iname){
	  if (xffm_details->preferences & TEXT_HEADERS) {
	    const gchar *label=NULL;
	    if (tree_id==0  && xffm_details->argv[2]){
		label=(const gchar *)function_void("plugins",xffm_details->argv[2],module_column_label);
	    }
	    if (!label) label=iname;
	    gtk_tree_view_column_set_title(column, my_utf_string(label));
	  }
	  else insert_column_icon(column,iname);
	}
	insert_arrows(column,FALSE,FALSE);
	gtk_tree_sortable_set_sort_func(sortable,i,IterCompareFunc,(gpointer)((long)i),NULL);

    }
    gtk_tree_sortable_set_sort_func(sortable,NAME_COLUMN,IterCompareFunc,(gpointer)((long)NAME_COLUMN),NULL);
    gtk_tree_sortable_set_default_sort_func(sortable,IterCompareFunc,(gpointer)((long)GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID),NULL);
    /* we change this to GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID just before
     * entering gtk_main() to force a sort in main.c */
    gtk_tree_sortable_set_sort_column_id (sortable,NAME_COLUMN,GTK_SORT_ASCENDING);
    
    gtk_widget_show(GTK_WIDGET(treeview));
        
    /* this is good for current names defined in treeview_gui.c */
    {
	gchar *g;
	g=g_strdup_printf("treeview_scroll%d",tree_id);
	gtk_container_add(GTK_CONTAINER(lookup_widget(xffm_details->arbol->widgets.window,g)), GTK_WIDGET(treeview));
	g_free(g);
    }

    g_signal_connect_object(treeview, "row-expanded", G_CALLBACK(open_dir), treeview, 0);
    g_signal_connect_object(treeview, "row-collapsed", G_CALLBACK(close_dir), treeview, 0);


    /*g_signal_connect(treeview, "motion-notify-event", G_CALLBACK(on_mouse_move), treeview);*/
    g_signal_connect(treeview, "button-press-event", G_CALLBACK(treeclick), treeview);
/* g_signal_connect works better than g_signal_connect_object, sometimes */
    g_signal_connect_object(treeview, "button-release-event", 
		    G_CALLBACK(button_releaseF), treeview, G_CONNECT_AFTER);

    TRACE("************dpath is %s\n",d_path);
    add_roots(treeview, d_path);
    g_signal_connect(treeview, "key-press-event", G_CALLBACK(treeview_key), NULL);    
    g_free(d_path);
    return treeview;
}


G_MODULE_EXPORT
GtkTreeView *init_xffm_treeviews(void)
{
    int i;
    gchar *startup=NULL;
    GtkTreeView *treeview;
    TRACE("TRACE:xffm_details->argv[0]=%s\n",xffm_details->argv[0]);

    if((strstr(xffm_details->argv[0],"xffm") || strstr(xffm_details->argv[0],"xffm-treeview") || strstr(xffm_details->argv[0],"xffm-find")) ) startup = startup_path(xffm_details->argv[1]);

     TRACE("startup is %s, tmp=%s\n",((startup)?startup:"NULL"),g_get_tmp_dir());


    for (i=0;i<TREECOUNT;i++) {
      treestuff_t *treestuff = (xffm_details->arbol->treestuff)+i;	
      treestuff->gogo = (golist *) malloc(sizeof(golist));
      if (!treestuff->gogo) assert_not_reached();
      treestuff->gogo->next = treestuff->gogo->previous = NULL;
      if (startup && strlen(startup)) treestuff->gogo->path = g_strdup(startup);
      else treestuff->gogo->path = g_strdup(g_get_home_dir());

      treeview = treestuff->treeview = create_treeview(startup,i);
      /*printf("TRACE: treeview is 0x%x\n",treeview);*/
      treeview_setup_drag_signal(treestuff->treeview);
      apply_view(treestuff->treeview);
      g_signal_connect ((gpointer) treestuff->treeview, 
	      "size-allocate", G_CALLBACK (on_size), NULL);
      g_signal_connect ((gpointer) (treestuff->column[NAME_COLUMN]->button),
	      "size-allocate", G_CALLBACK (on_name_size), 
	      (gpointer)((long)i));
    }
    g_free(startup);startup=NULL;

   {
	GtkWidget *menu;
	menu = lookup_widget(xffm_details->arbol->widgets.window,"item22_menu");
	gtk_menu_detach((GtkMenu *) menu);
	gtk_menu_attach_to_widget(GTK_MENU(menu), (GtkWidget *) treeview, 
			(GtkMenuDetachFunc) menu_detach);
    }
    
    

    gtk_combo_set_case_sensitive(GTK_COMBO(lookup_widget(xffm_details->arbol->widgets.window,"input_combo")), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO(lookup_widget(xffm_details->arbol->widgets.window,"filter_combo")), TRUE);
    xffm_details->arbol->loading = FALSE;

    {				/* status should not accept drops nor input */
	GtkWidget *w;

	w = lookup_widget(xffm_details->arbol->widgets.window,"status");
	g_signal_connect(G_OBJECT(w), "drag_motion", G_CALLBACK(null_motion), NULL);
	gtk_text_view_set_editable((GtkTextView *) w, FALSE);
    }

    {
	char *shows[]={
	    "show_tb1",
	    "show_f",
	    "show_titles",
	    NULL};
	char *hides[]={
	    "hide_tb1",
	    "hide_f",
	    NULL};
	char **wnames[]={shows,hides};
	int i,j;
	for (j=0;j<2;j++) for (i=0;wnames[j][i];i++){
	  GtkWidget *arrow;
	  GtkWidget *w=lookup_widget(xffm_details->arbol->widgets.window,wnames[j][i]);
    	  GtkWidget *l = gtk_bin_get_child(GTK_BIN(w));
	  if (j) arrow=gtk_arrow_new (GTK_ARROW_DOWN,GTK_SHADOW_NONE);
	  else arrow=gtk_arrow_new (GTK_ARROW_RIGHT,GTK_SHADOW_NONE);
	  /* remove empty labels */
	  if (l) gtk_container_remove((GtkContainer *)w, l);
	  gtk_container_add ((GtkContainer *)w,arrow);
	  gtk_widget_show(arrow);
	} 
    }

    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"show_tb1")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB1));
    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"hide_tb1")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB1));


   g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"show_f")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_F));
    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"hide_f")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_F));

    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"show_titles")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TITLES));

    {
  	GdkPixbuf *xffm_icon_pixbuf;
	const gchar *icon_id="xffm-treeview";
	if (strstr(xffm_details->argv[0],"xffm-find"))  icon_id="xffm/stock_search";

  	xffm_icon_pixbuf = icon_tell (&(xffm_details->arbol->widgets),REAL_BIG,icon_id);
  	/*xffm_icon_pixbuf = ICON_create_pixbuf ("bluefing");*/
  	if (xffm_icon_pixbuf)
    	{
      		gtk_window_set_icon (GTK_WINDOW (xffm_details->arbol->widgets.window), 
				xffm_icon_pixbuf);
      		g_object_unref (G_OBJECT(xffm_icon_pixbuf));
   	}
	else g_warning("cannot create application icon");
    }


    gtk_widget_grab_focus((GtkWidget *) (xffm_details->arbol->treestuff[get_active_tree_id()].treeview));
    
    gui_set_filter_combo(&(xffm_details->arbol->widgets));

    gtk_window_set_default_size(GTK_WINDOW(xffm_details->arbol->widgets.window), xffm_details->arbol->geometryX, xffm_details->arbol->geometryY);

    /* gtk_window_set_default_size() *must* come before gtk_widget_realize() */
    gtk_widget_realize(xffm_details->arbol->widgets.window);

   
   /* local_monitor will monitor all treeviews...*/ 
      local_monitor(FALSE);

    
    recreate_icons(treeview);
   return treeview;

}

G_MODULE_EXPORT
void config_treeview(void)
{
	int i;
	xffm_details->arbol = (arbol_t *) malloc(sizeof(arbol_t));
	memset(xffm_details->arbol,0,sizeof(arbol_t));
	xffm_details->arbol->widgets.input = OTHER_INPUT;
	/*FIXME object functions to be removed or put in widgets_t*/
	xffm_details->arbol->get_active_tree_id= get_active_tree_id;
	xffm_details->arbol->get_module_root=get_module_root;
	xffm_details->arbol->hide_branch_activate=hide_branch_activate;
	xffm_details->arbol->prune_row=prune_row;
	xffm_details->arbol->add_row=add_row;
	xffm_details->arbol->add_contents_row=add_contents_row;
	xffm_details->arbol->remove_row=remove_row;
	xffm_details->arbol->erase_dummy_row=erase_dummy_row;
	xffm_details->arbol->insert_dummy_row=insert_dummy_row;
	xffm_details->arbol->reset_dummy_row=reset_dummy_row;
	xffm_details->arbol->set_load_wait=set_load_wait;
	xffm_details->arbol->unset_load_wait=unset_load_wait;
	xffm_details->arbol->find_module_root=find_module_root;
	xffm_details->arbol->update_icon=update_icon;
	xffm_details->arbol->set_icon=set_icon;
	xffm_details->arbol->local_monitor=local_monitor;
	xffm_details->arbol->get_selectpath_iter=get_selectpath_iter;
	for (i=0; i<TREECOUNT; i++){
	    xffm_details->arbol->treestuff[i].name_size=100;
	}
    /* read user configuration or set to default (loads treeview library)*/    
    get_xffm_config(); 
}    

