
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"

#include "primary.h"
#include "gui.h"
#include "treeview.h"
#include "actions_lib.h"

G_MODULE_EXPORT
int 
treeview_get_entry_from_reference (	GtkTreeView * treeview, 
				GtkTreeRowReference * reference, 
				GtkTreeIter * iter, 
				record_entry_t ** en_p)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath = gtk_tree_row_reference_get_path(reference);
    if(!treepath || !treemodel)	return FALSE;
    if(!gtk_tree_model_get_iter(treemodel, iter, treepath))
	return FALSE;
    gtk_tree_path_free(treepath);
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, en_p, -1);
    return TRUE;
}

GtkWidget*
create_xffm (void)
{
  GtkWidget *xffm;
  AtkObject *atko;

  
  GtkWidget *vbox1;
  GtkWidget *hbox27;
  GtkWidget *menubar2;
  GtkWidget *main_menu2_menu;
  GtkWidget *eventbox4;
  GtkWidget *filter_box;
  GtkWidget *button201;
  GtkWidget *hide_f;
  GtkWidget *label11;
  GtkWidget *filter_combo;
  GtkWidget *filter_entry;
  GtkWidget *vbox2;
  GtkWidget *hbox28;
  GtkWidget *eventbox1;
  GtkWidget *pane1;
  GtkWidget *pane10;
  GtkWidget *pane0;
  GtkWidget *show_tb1;
  GtkWidget *show_f;
  GtkWidget *show_titles;
  GtkWidget *eventbox2;
  GtkWidget *box_tb1;
  GtkWidget *hide_tb1;
  GtkWidget *toolbar_xftree;
  GtkWidget *eventbox3;
  GtkWidget *hbox6;
  GtkWidget *eventbox_sidebar;
  GtkWidget *vpaned1;
  GtkWidget *hpaned1;
  GtkWidget *treeview_scroll1;
  GtkWidget *vbox3;
  GtkWidget *treeview_scroll0;
  GtkWidget *scrolledwindow5;
  GtkWidget *diagnostics;
  GtkWidget *hbox1;
  GtkWidget *progressbar1;
  GtkWidget *status;
  GtkAccelGroup *accel_group;


  accel_group = gtk_accel_group_new ();

  xffm = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  xffm_details->arbol->widgets.window=xffm;
  xffm_details->arbol->widgets.tooltips = gtk_tooltips_new ();
  gtk_window_set_default_size (GTK_WINDOW (xffm), -1, 600);

  g_signal_connect(G_OBJECT(xffm), "key-press-event", 
	    G_CALLBACK(treewindow_keyevent), NULL);


  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (xffm), vbox1);

  hbox27 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox27);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox27, FALSE, TRUE, 0);

  menubar2 = gtk_menu_bar_new ();
  gtk_widget_show (menubar2);
  gtk_box_pack_start (GTK_BOX (hbox27), menubar2, FALSE, FALSE, 0);
  GLADE_HOOKUP_OBJECT (xffm, menubar2, "menubar2");

  main_menu2_menu=treeview_mk_main_menu(menubar2,accel_group);
  treeview_mk_popup_menu(NULL,accel_group,NULL);
  
  eventbox4 = gtk_event_box_new ();
  gtk_widget_show (eventbox4);
  gtk_box_pack_start (GTK_BOX (hbox27), eventbox4, TRUE, TRUE, 0);

  filter_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (filter_box);
  gtk_container_add (GTK_CONTAINER (eventbox4), filter_box);

  button201 = gtk_button_new ();
  gtk_widget_show (button201);
  gtk_box_pack_end (GTK_BOX (filter_box), button201, FALSE, FALSE, 0);
  GTK_WIDGET_UNSET_FLAGS (button201, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, button201, _("Refresh selected directory with filter options"), NULL);
  gtk_button_set_relief (GTK_BUTTON (button201), GTK_RELIEF_NONE);



  hide_f = gtk_button_new_with_mnemonic ("");
  gtk_widget_show (hide_f);
  gtk_box_pack_start (GTK_BOX (filter_box), hide_f, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hide_f, 13, 0);
  GTK_WIDGET_UNSET_FLAGS (hide_f, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, hide_f, _("Hide"), NULL);

  label11 = gtk_label_new (_("Filter"));
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (filter_box), label11, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (label11), 5, 0);

  filter_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (filter_combo)->popwin),
                     "GladeParentKey", filter_combo);
  gtk_widget_show (filter_combo);
  gtk_box_pack_start (GTK_BOX (filter_box), filter_combo, TRUE, TRUE, 0);
  gtk_combo_set_case_sensitive (GTK_COMBO (filter_combo), TRUE);

  filter_entry = GTK_COMBO (filter_combo)->entry;
  gtk_widget_show (filter_entry);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, filter_entry, _("To display files which pass the filter (stars and regexps will be processed)"), NULL);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox27), vbox2, TRUE, TRUE, 0);

  hbox28 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox28);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox28, TRUE, TRUE, 0);

  eventbox1 = gtk_event_box_new ();
  gtk_widget_show (eventbox1);
  gtk_box_pack_start (GTK_BOX (hbox28), eventbox1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (eventbox1, -1, 13);

  pane1 = gtk_button_new ();
  gtk_widget_show (pane1);
  gtk_box_pack_start (GTK_BOX (hbox28), pane1, FALSE, FALSE, 0);
  GTK_WIDGET_UNSET_FLAGS (pane1, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, pane1, _("Show left pane"), NULL);


  pane10 = gtk_button_new ();
  gtk_widget_show (pane10);
  gtk_box_pack_start (GTK_BOX (hbox28), pane10, FALSE, FALSE, 0);
  GTK_WIDGET_UNSET_FLAGS (pane10, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, pane10, _("Show both panes"), NULL);


  pane0 = gtk_button_new ();
  gtk_widget_show (pane0);
  gtk_box_pack_start (GTK_BOX (hbox28), pane0, FALSE, FALSE, 0);
  GTK_WIDGET_UNSET_FLAGS (pane0, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, pane0, _("Show right pane"), NULL);


  show_tb1 = gtk_button_new_with_mnemonic ("");
  gtk_widget_show (show_tb1);
  gtk_box_pack_start (GTK_BOX (hbox28), show_tb1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (show_tb1, 13, 26);
  GTK_WIDGET_UNSET_FLAGS (show_tb1, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, show_tb1, _("Show toolbar"), NULL);

  show_f = gtk_button_new_with_mnemonic ("");
  gtk_widget_show (show_f);
  gtk_box_pack_start (GTK_BOX (hbox28), show_f, FALSE, FALSE, 0);
  gtk_widget_set_size_request (show_f, 13, 26);
  GTK_WIDGET_UNSET_FLAGS (show_f, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, show_f, _("Show filter"), NULL);

  show_titles = gtk_button_new_with_mnemonic ("");
  gtk_widget_show (show_titles);
  gtk_box_pack_start (GTK_BOX (hbox28), show_titles, FALSE, FALSE, 0);
  gtk_widget_set_size_request (show_titles, 13, 26);
  GTK_WIDGET_UNSET_FLAGS (show_titles, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, show_titles, _("Show titles"), NULL);

  eventbox2 = gtk_event_box_new ();
  gtk_widget_show (eventbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), eventbox2, FALSE, FALSE, 0);

  box_tb1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box_tb1);
  gtk_container_add (GTK_CONTAINER (eventbox2), box_tb1);

  hide_tb1 = gtk_button_new_with_mnemonic ("");
  gtk_widget_show (hide_tb1);
  gtk_box_pack_start (GTK_BOX (box_tb1), hide_tb1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (hide_tb1, 13, 0);
  GTK_WIDGET_UNSET_FLAGS (hide_tb1, GTK_CAN_FOCUS);
  gtk_tooltips_set_tip (xffm_details->arbol->widgets.tooltips, hide_tb1, _("Hide"), NULL);

  toolbar_xftree = gtk_toolbar_new ();
  gtk_widget_show (toolbar_xftree);
  gtk_box_pack_start (GTK_BOX (box_tb1), toolbar_xftree, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_xftree), GTK_TOOLBAR_ICONS);

  eventbox3 = gtk_event_box_new ();
  gtk_widget_show (eventbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), eventbox3, FALSE, TRUE, 0);

  gui_mk_input_box(&(xffm_details->arbol->widgets),vbox1,NULL);
  g_signal_connect ((gpointer) lookup_widget(xffm,"input_ok"), 
	    "clicked",G_CALLBACK (treeview_input_ok), NULL);


  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox6, TRUE, TRUE, 0);

  eventbox_sidebar = gtk_event_box_new ();
  gtk_widget_show (eventbox_sidebar);
  gtk_box_pack_start (GTK_BOX (hbox6), eventbox_sidebar, FALSE, FALSE, 0);

  vpaned1 = gtk_vpaned_new ();
  gtk_widget_show (vpaned1);
  gtk_box_pack_start (GTK_BOX (hbox6), vpaned1, TRUE, TRUE, 0);
  gtk_paned_set_position (GTK_PANED (vpaned1), 1000);

  hpaned1 = gtk_hpaned_new ();
  gtk_widget_show (hpaned1);
  gtk_paned_pack1 (GTK_PANED (vpaned1), hpaned1, TRUE, TRUE);
  gtk_paned_set_position (GTK_PANED (hpaned1), 1);

  treeview_scroll1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (treeview_scroll1);
  gtk_paned_pack1 (GTK_PANED (hpaned1), treeview_scroll1, FALSE, TRUE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (treeview_scroll1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (treeview_scroll1), GTK_SHADOW_IN);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_paned_pack2 (GTK_PANED (hpaned1), vbox3, TRUE, TRUE);

  treeview_scroll0 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (treeview_scroll0);
  gtk_box_pack_start (GTK_BOX (vbox3), treeview_scroll0, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (treeview_scroll0), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (treeview_scroll0), GTK_SHADOW_IN);

  scrolledwindow5 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow5);
  gtk_paned_pack2 (GTK_PANED (vpaned1), scrolledwindow5, TRUE, TRUE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  diagnostics = gtk_text_view_new ();
  gtk_widget_show (diagnostics);
  gtk_container_add (GTK_CONTAINER (scrolledwindow5), diagnostics);
  gtk_container_set_border_width (GTK_CONTAINER (diagnostics), 2);
  GTK_WIDGET_UNSET_FLAGS (diagnostics, GTK_CAN_FOCUS);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (diagnostics), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (diagnostics), FALSE);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

  progressbar1 = gtk_progress_bar_new ();
  /*gtk_widget_show (progressbar1);*/
  gtk_box_pack_start (GTK_BOX (hbox1), progressbar1, FALSE, FALSE, 0);

  status = gtk_text_view_new ();
  gtk_widget_show (status);
  gtk_box_pack_start (GTK_BOX (hbox1), status, TRUE, TRUE, 3);
  GTK_WIDGET_UNSET_FLAGS (status, GTK_CAN_FOCUS);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (status), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (status), FALSE);


  xffm_details->arbol->widgets.button_space = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (xffm_details->arbol->widgets.button_space);
  gtk_box_pack_start (GTK_BOX (hbox1), xffm_details->arbol->widgets.button_space, FALSE, FALSE, 0);

  xffm_details->arbol->widgets.stop_button = mk_little_button(
	    &(xffm_details->arbol->widgets),
	    "xffm/stock_stop",
	    (void *) on_stop,
	    (void *) (&(xffm_details->arbol->widgets)),
	    _("Stop the current operation"));
  gtk_box_pack_end (GTK_BOX (xffm_details->arbol->widgets.button_space), xffm_details->arbol->widgets.stop_button, FALSE, FALSE, 0);
  
  xffm_details->arbol->widgets.clear_button = mk_little_button(
	    &(xffm_details->arbol->widgets),
	    "xffm/stock_clear",
	    (void *) on_clear_text_window,
	    (void *) (&(xffm_details->arbol->widgets)),
	    _("Clear text window"));


  gtk_box_pack_end (GTK_BOX (xffm_details->arbol->widgets.button_space), xffm_details->arbol->widgets.clear_button, FALSE, FALSE, 0);
  gtk_widget_show (xffm_details->arbol->widgets.clear_button);


/* images: */
  gui_mk_pixmap_menu(&(xffm_details->arbol->widgets), "xffm/stock_apply",button201,BUTTON_PIXMAP);
  gui_mk_pixmap_menu(&(xffm_details->arbol->widgets), "xffm/stock_goto-last",pane1,BUTTON_PIXMAP);
  gui_mk_pixmap_menu(&(xffm_details->arbol->widgets), "xffm/stock_reset",pane10,BUTTON_PIXMAP);
  gui_mk_pixmap_menu(&(xffm_details->arbol->widgets), "xffm/stock_goto-first",pane0,BUTTON_PIXMAP);


  
  g_signal_connect ((gpointer) hbox27, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) eventbox4, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) button201, "clicked",
                    G_CALLBACK (treeview_on_refresh),
                    NULL);
  g_signal_connect ((gpointer) hide_f, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) eventbox1, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) pane1, "clicked",
                    G_CALLBACK (on_pane1_clicked),
                    NULL);
  g_signal_connect ((gpointer) pane1, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) pane10, "clicked",
                    G_CALLBACK (on_pane10_clicked),
                    NULL);
  g_signal_connect ((gpointer) pane10, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) pane0, "clicked",
                    G_CALLBACK (on_pane0_clicked),
                    NULL);
  g_signal_connect ((gpointer) pane0, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) show_tb1, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) show_f, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) show_titles, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) eventbox2, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) box_tb1, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) hide_tb1, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) eventbox3, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) eventbox_sidebar, "button_press_event",
                    G_CALLBACK (popup_button_press_event),
                    NULL);

  atko = gtk_widget_get_accessible (xffm);
  atk_object_set_name (atko, "xffm");


  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (xffm, xffm, "xffm");

  GLADE_HOOKUP_OBJECT (xffm, eventbox4, "eventbox4");
  GLADE_HOOKUP_OBJECT (xffm, filter_box, "filter_box");
  GLADE_HOOKUP_OBJECT (xffm, button201, "button201");
  GLADE_HOOKUP_OBJECT (xffm, hide_f, "hide_f");
  GLADE_HOOKUP_OBJECT (xffm, label11, "label11");
  GLADE_HOOKUP_OBJECT (xffm, filter_combo, "filter_combo");
  GLADE_HOOKUP_OBJECT (xffm, filter_entry, "filter_entry");
  GLADE_HOOKUP_OBJECT (xffm, vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (xffm, hbox27, "hbox27");
  GLADE_HOOKUP_OBJECT (xffm, hbox28, "hbox28");
  GLADE_HOOKUP_OBJECT (xffm, eventbox1, "eventbox1");
  GLADE_HOOKUP_OBJECT (xffm, pane1, "pane1");
  GLADE_HOOKUP_OBJECT (xffm, pane10, "pane10");
  GLADE_HOOKUP_OBJECT (xffm, pane0, "pane0");
  GLADE_HOOKUP_OBJECT (xffm, show_tb1, "show_tb1");
  GLADE_HOOKUP_OBJECT (xffm, show_f, "show_f");
  GLADE_HOOKUP_OBJECT (xffm, show_titles, "show_titles");
  GLADE_HOOKUP_OBJECT (xffm, eventbox2, "eventbox2");
  GLADE_HOOKUP_OBJECT (xffm, box_tb1, "box_tb1");
  GLADE_HOOKUP_OBJECT (xffm, hide_tb1, "hide_tb1");
  GLADE_HOOKUP_OBJECT (xffm, toolbar_xftree, "toolbar_xftree");
  GLADE_HOOKUP_OBJECT (xffm, eventbox3, "eventbox3");
  GLADE_HOOKUP_OBJECT (xffm, hbox6, "hbox6");
  GLADE_HOOKUP_OBJECT (xffm, eventbox_sidebar, "eventbox_sidebar");
  GLADE_HOOKUP_OBJECT (xffm, vpaned1, "vpaned1");
  GLADE_HOOKUP_OBJECT (xffm, hpaned1, "hpaned1");
  GLADE_HOOKUP_OBJECT (xffm, treeview_scroll1, "treeview_scroll1");
  GLADE_HOOKUP_OBJECT (xffm, vbox3, "vbox3");
  GLADE_HOOKUP_OBJECT (xffm, treeview_scroll0, "treeview_scroll0");
  GLADE_HOOKUP_OBJECT (xffm, scrolledwindow5, "scrolledwindow5");
  GLADE_HOOKUP_OBJECT (xffm, diagnostics, "diagnostics");
  GLADE_HOOKUP_OBJECT (xffm, progressbar1, "progressbar1");
  GLADE_HOOKUP_OBJECT (xffm, status, "status");
  GLADE_HOOKUP_OBJECT_NO_REF (xffm, xffm_details->arbol->widgets.tooltips, "tooltips");

  gtk_window_add_accel_group (GTK_WINDOW (xffm), accel_group);

  return xffm;
}

