
/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"
#include "treeview.h"


#include "treeview_preferences.i"

static gboolean disable_column_action=FALSE;
G_MODULE_EXPORT

extern gboolean light_background;
typedef struct change_size_t {
	GtkTreeView *treeview;
	int size;
}change_size_t;

static
void on_selective_toggle(GtkTreeView *treeview,int flag)
{
    GtkTreeIter iter;
    record_entry_t *en;
    
    if (!is_toggle_enabled()) return;
    if(!get_selectpath_iter(&iter, &en)) return;
    switch (flag)
    {
	default:
	    g_warning("0x%x is not individual toggle",flag);
	    break;
	case SHOW_DOT:
	    TOGGLE_SHOWS_HIDDEN(en->type);
	    break;
	case IMAGE_PREVIEW:
	    TOGGLE_SHOWS_IMAGES(en->type);
	    break;
    }
    treeview_refresh(&(xffm_details->arbol->widgets));
    
}


G_MODULE_EXPORT
void apply_view(GtkTreeView * treeview)
{
    treestuff_t *treestuff=get_treestuff(treeview);
    gtk_tree_view_column_set_visible(treestuff->column[SIZE_COLUMN], 
		    treestuff->preferences & SHOW_SIZE);
    gtk_tree_view_column_set_visible(treestuff->column[DATE_COLUMN], 
		    treestuff->preferences & SHOW_DATE);
    gtk_tree_view_column_set_visible(treestuff->column[OWNER_COLUMN], 
		    treestuff->preferences & SHOW_UID);
    gtk_tree_view_column_set_visible(treestuff->column[GROUP_COLUMN], 
		    treestuff->preferences & SHOW_GID);
    gtk_tree_view_column_set_visible(treestuff->column[MODE_COLUMN], 
		    treestuff->preferences & SHOW_MODE);

    disable_column_action=FALSE;

}



G_MODULE_EXPORT
void apply_preferences(GtkTreeView * treeview, int preferences)
{
    xffm_details->preferences = preferences;
}

G_MODULE_EXPORT
void quick_hide(GtkButton * button, gpointer user_data)
{
    unsigned l = (unsigned)((long)user_data);
    if (strstr(xffm_details->argv[0],"xffm-find")) return;
    xffm_details->preferences ^= l;
    hide_bars();
}

static gboolean set_dot(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) {
	SET_SHOWS_HIDDEN(en->type);
    }
   return FALSE;
}
static gboolean unset_dot(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) {
	UNSET_SHOWS_HIDDEN(en->type);
    }
    return FALSE;
}
static gboolean set_preview(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) {
	SET_SHOWS_IMAGES(en->type);
    }
   return FALSE;
}
static gboolean unset_preview(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) {
	UNSET_SHOWS_IMAGES(en->type);
    }
    return FALSE;
}

static gboolean switch_easy_edit(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data){
    gboolean c=FALSE;
    record_entry_t *en;
    
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return FALSE;

    if (getenv("XFFM_DISABLE_CELL_EDIT") && strlen(getenv("XFFM_DISABLE_CELL_EDIT")));
    else {
        c=IS_PATH(en->type);
        if (en && en->path && strchr(en->path,G_DIR_SEPARATOR) && 
	   strcmp( strrchr(en->path,G_DIR_SEPARATOR)+1,"..Wastebasket")==0)
		c=FALSE;

    }
    gtk_tree_store_set((GtkTreeStore *) treemodel, iter,EDITABLE_COLUMN,c, -1);
    /*printf("TRACE:%s set to %d\n",en->path,c);*/
    return FALSE;
}

G_MODULE_EXPORT
void set_column_menu(gint tree_id){
    int flag=xffm_details->arbol->treestuff[tree_id].preferences;
    disable_column_action=TRUE;

    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(lookup_widget(xffm_details->arbol->widgets.window,"size5")), flag & SHOW_SIZE);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(lookup_widget(xffm_details->arbol->widgets.window,"date5")), flag & SHOW_DATE);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(lookup_widget(xffm_details->arbol->widgets.window,"uid5")), flag & SHOW_UID);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(lookup_widget(xffm_details->arbol->widgets.window,"gid5")), flag & SHOW_GID);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(lookup_widget(xffm_details->arbol->widgets.window,"mode5")), flag & SHOW_MODE);
    disable_column_action=FALSE;
}

/* only for treeview */

G_MODULE_EXPORT
void toggle_preference(GtkMenuItem * menuitem, gpointer user_data)
{
    int i;
    gboolean warned=FALSE;
    gint tree_id;
    GtkTreeView *treeview;
    GtkTreeModel *treemodel;
    unsigned flag = (unsigned)((long)user_data);

    if (!xffm_details->arbol->widgets.window){
	g_warning("treeview only");
    }
    
    tree_id = get_active_tree_id();
    treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
  
    if (flag & (SHOW_SIZE|SHOW_DATE|SHOW_UID|SHOW_GID|SHOW_MODE))
	tree_id = get_relative_tree_id();
    
    
    if (disable_column_action){
	TRACE("TRACE: disable_column_action=TRUE\n");
       	return;
    }
	TRACE("TRACE: toggle_preference...\n");
    if (flag & INDIVIDUAL_TOGGLE) {
	flag ^= INDIVIDUAL_TOGGLE;

	TRACE("individual toggle");
	xffm_details->arbol->treestuff[tree_id].preferences ^= flag;
	if (flag & SHOW_COLUMNS){
	  apply_view(xffm_details->arbol->treestuff[tree_id].treeview);
	}
	if (flag & (SHOW_DOT | IMAGE_PREVIEW)){
	    on_selective_toggle(xffm_details->arbol->treestuff[tree_id].treeview,flag);
	}
	write_xffm_config (); 
	return;
    }

    /* preferences for all treeviews: */
    xffm_details->preferences ^= flag;
    TRACE(" xffm_details->preferences & SHOW_DOT =%d",xffm_details->preferences & SHOW_DOT);
    for (i=0;i<TREECOUNT;i++) {
      treemodel = xffm_details->arbol->treestuff[i].treemodel;
      treeview = xffm_details->arbol->treestuff[i].treeview;
       
      if (flag & SHOW_DOT){
	gtk_tree_model_foreach(treemodel, 
			((xffm_details->preferences & SHOW_DOT) ?
		        set_dot:unset_dot), treeview);
      }   
      if (flag & IMAGE_PREVIEW){
	gtk_tree_model_foreach(treemodel, 
			((xffm_details->preferences & IMAGE_PREVIEW) ?
		        set_preview:unset_preview), treeview);
      }   
    
      if(flag & (IMAGE_PREVIEW | SHOW_DOT ))
      {
	gtk_tree_selection_unselect_all(gtk_tree_view_get_selection(treeview));
	treeview_refresh(&(xffm_details->arbol->widgets));
      }
      if (!warned && flag & (TEXT_HEADERS|ENABLE_RESIZE_FONTS)){
	warned=TRUE;
	print_diagnostics(&(xffm_details->arbol->widgets),"xffm/warning",_("Restart application for changes to take effect"),"\n",NULL);
      } 
      if (getenv("XFFM_DISABLE_CELL_EDIT") && strlen(getenv("XFFM_DISABLE_CELL_EDIT")))
	  gtk_tree_model_foreach(treemodel, switch_easy_edit, treeview);
    }

    /* XXX  why this? Couldn't light_background be static at basic_colours.c? 
     * 	Of course. FIXME (someday): use deskview model for light/dark
     * 	background.*/
    if (getenv("XFFM_DISABLE_TEXTCOLORS") && strlen(getenv("XFFM_DISABLE_TEXTCOLORS"))) ;
    else light_background = !light_background;
    
    write_xffm_config (); 

}

G_MODULE_EXPORT
void
tb_toggleview                          (GtkButton       *button,
                                        gpointer         user_data)
{
    g_warning("tb_toggleview function is not enabled (options.c)");
}

G_MODULE_EXPORT
void sb_toggleview (GtkWidget *w){
  tb_toggleview ((GtkButton *)w,NULL);
}


G_MODULE_EXPORT
gboolean set_icon_theme(gchar *theme,gboolean restart){
    return TRUE;
}

G_MODULE_EXPORT
void toggle_theme(GtkMenuItem * menuitem, gpointer user_data)
{
}
