/*  settings.c
 *  
 *  Copyright (C) 2003 Edscott Wilson Garcia (edscott@users.sourceforge.net)
 *  Copyright (C) 2002 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *
 *   modified for xffm by Edscott Wilson Garcia
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/stat.h>

#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>


#include <libxml/parser.h>
#include <libxml/tree.h>


#include "constants.h"
#include "primary.h"

#include "treeview.h"
#include "treeview_preferences.i"

#define CONFIG_VERSION  "0.8.10"

#define GEOMETRY_X 600
#define GEOMETRY_Y 500
/* although this works to set an alternate width for xfetc,
 * the size of the toolbar will in the end determine the minimum width 
 * of the window... */
#define HPANE_POS 125
#define ALT_HPANE_POS 0
#define DEFAULT_XFFM_THEME "Rodent"
#define FALLBACK_XFFM_THEME "hicolor"
#define XFFM_ICON_SIZE 2


static gboolean write_config_active=FALSE;
G_MODULE_EXPORT
void enable_write_config(void){
    write_config_active=TRUE;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
  Reading xml
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
static xmlDocPtr xmlconfig = NULL;


G_MODULE_EXPORT
void get_config(char *rcfile)
{
    xmlChar *value;
    xmlNodePtr node;
    int i;
    TRACE("TRACE: now reading rcfile...\n");

    xffm_details->preferences = DEFAULT_PREFERENCES;
    xffm_details->arbol->hpane = ((strstr(xffm_details->argv[0],"xffm"))? HPANE_POS:ALT_HPANE_POS);
    xffm_details->arbol->geometryX = GEOMETRY_X;
    xffm_details->arbol->geometryY = GEOMETRY_Y;
    xffm_details->arbol->smart_hash = NULL;
    xffm_details->arbol->loading=FALSE;
    xffm_details->arbol->widgets.stop=FALSE;
    xffm_details->arbol->selectionOK=0;
    xffm_details->arbol->widgets.input=OTHER_INPUT;
    xffm_details->arbol->hpane_ratio=-1.0;
/*    xffm_details->icon_size=1;*/
    xffm_details->arbol->sidebar=g_strdup("single_selection_button");
    /*xffm_details->theme = g_build_filename(PACKAGE_DATA_DIR,"icons",FALLBACK_XFFM_THEME,NULL);*/
    for (i=0;i<TREECOUNT;i++){
	switch (i) {
	    case RIGHT_TREEVIEW:
	    {
		xffm_details->arbol->treestuff[i].preferences = (INDIVIDUAL_TOGGLE|SHOW_SIZE|SHOW_DATE|SHOW_GID|SHOW_UID|SHOW_MODE|DETAILED_VIEW);
		break;
	    }
	    default:
		xffm_details->arbol->treestuff[i].preferences = (INDIVIDUAL_TOGGLE|SHOW_SIZE|SHOW_DATE|SHOW_GID|SHOW_UID|SHOW_MODE|DETAILED_VIEW);
		/*xffm_details->arbol->treestuff[i].preferences = (INDIVIDUAL_TOGGLE|DEFAULT_VIEW);*/
	}
    }


    /* global xmlDocPtr */
    if (!g_file_test(rcfile,G_FILE_TEST_EXISTS)) return;
    if(!xmlconfig){
       xmlKeepBlanksDefault(0);
       xmlconfig = xmlParseFile(rcfile);
       if (!xmlconfig) {
	       goto new_xffm_config;
       }
    }

    node = xmlDocGetRootElement(xmlconfig);
    if(!node){
        goto new_xffm_config;
    }

    if(!xmlStrEqual(node->name, (const xmlChar *)xffm_details->argv[0]))
    {
new_xffm_config:
	xmlFreeDoc(xmlconfig);
	xmlconfig=NULL;
	write_xffm_config();
	return;
    }
    
    
    for(node = node->children; node; node = node->next){
	if(xmlStrEqual(node->name, (const xmlChar *)"CONFIG_VERSION")){
	    xmlChar *e=xmlNodeListGetString(xmlconfig, node->children, 1);
	    if (strcmp((const char*)e,CONFIG_VERSION)==0)
	    {
	        g_free(e);
	        break;
	    } else {
	        g_free(e);
	        goto new_xffm_config;
	    }
	}

    }
    node = xmlDocGetRootElement(xmlconfig);

    /* Now parse the xml tree */
    for(node = node->children; node; node = node->next)
    {
	for(i = 0; i<TREECOUNT; i++) {
	  gchar *g=g_strdup_printf("treeview_%d",i);
	  if(xmlStrEqual(node->name, (const xmlChar *)g)){
	    value = xmlGetProp(node, (const xmlChar *)"preferences");
	    if (value) 	    {
		xffm_details->arbol->treestuff[i].preferences = atoi((const char *)value);
		g_free(value);value=NULL;
	    }  else xffm_details->arbol->treestuff[i].preferences = 0;  
	    value = xmlGetProp(node, (const xmlChar *)"name_size");
	    if (value) 	    {
		xffm_details->arbol->treestuff[i].name_size = atoi((const char *)value);
		g_free(value);value=NULL;
	    }  else xffm_details->arbol->treestuff[i].name_size = 100;  
	  }
	  g_free(g);
	}
	if(xmlStrEqual(node->name, (const xmlChar *)"options"))
	{	    
	    value = xmlGetProp(node, (const xmlChar *)"preferences");
	    if (value) 	    {
		xffm_details->preferences = atoi((const char *)value);
		g_free(value);value=NULL;
	    }  else xffm_details->preferences = DEFAULT_PREFERENCES;

	    
#if 0
	    value = xmlGetProp(node, (const xmlChar *)"theme");
	    if(value) {
		g_free(xffm_details->theme);    
		xffm_details->theme = (char*)value;
	    }
#endif
	    
	    value = xmlGetProp(node, (const xmlChar *)"sidebar");
	    if(value) {
		g_free(xffm_details->arbol->sidebar);    
		xffm_details->arbol->sidebar = (char*)value;
	    }
	}

	if(xmlStrEqual(node->name, (const xmlChar *)"geometry"))
	{
	    value = xmlGetProp(node, (const xmlChar *)"width");
	    if (value) xffm_details->arbol->geometryX =  atoi((const char *)value);
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"height");
	    if (value) xffm_details->arbol->geometryY =  atoi((const char *)value);
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"hpane");
	    if (value) {
		    
		xffm_details->arbol->hpane = atoi((const char *)value);
		TRACE("pane is read=%d\n",xffm_details->arbol->hpane);
	    }
	    g_free(value);value=NULL;
	    
	    /*xffm_details->arbol->hpane_ratio = (double)xffm_details->arbol->hpane / (double)xffm_details->arbol->geometryX;*/
	}
	if(xmlStrEqual(node->name, (const xmlChar *)"smart_button")){
	    const xmlChar *name = xmlGetProp(node, (const xmlChar *)"name");
	    if (name){
		int v;
		value = xmlGetProp(node, (const xmlChar *)"value");
		v=atoi((const char *)value);
		TRACE("TRACE:loading hash value %s=%s\n",(const char *)name,(const char *)value);
		if (xffm_details->arbol->smart_hash == NULL){
		    xffm_details->arbol->smart_hash = 
			g_hash_table_new( g_str_hash, g_str_equal);
		}
		g_hash_table_insert(xffm_details->arbol->smart_hash,(gpointer)name,(gpointer)((long)v));
		g_free(value);
	    }
	}
	

    }
    xmlFreeDoc(xmlconfig);
    xmlconfig = NULL;
}

G_MODULE_EXPORT
void get_xffm_config(){
    gchar *rcfile;
    gchar *fname=g_strconcat(xffm_details->argv[0],"rc.xml",NULL);
    
    rcfile=g_build_filename(xdg_config_dir(),XFFM_RC_FILE,fname,NULL);
    g_free(fname);
   get_config(rcfile);
   g_free(rcfile);
}

G_MODULE_EXPORT
void get_local_xffm_config(){
    get_xffm_config();
}

static void  save_sb(gpointer key, gpointer value,gpointer user_data){
    xmlNodePtr root,node;
    gchar *v=g_strdup_printf("%d",(int)((long)value));
    root = (xmlNodePtr)user_data;
    TRACE("TRACE:saving hash value %s\n ",(char *)key);
    node = xmlNewTextChild(root, NULL,(const xmlChar *)"smart_button", NULL);
    xmlSetProp(node, (const xmlChar *)"name",(const xmlChar *)key);
    xmlSetProp(node, (const xmlChar *)"value",(const xmlChar *)v);
    g_free(v);
}

static
void xffm_write_xml(xmlNodePtr root)
{
    xmlNodePtr node;
    xmlNodePtr child;
    char value[32];
    int i;
    
    node = xmlNewTextChild(root, NULL, (const xmlChar *)"CONFIG_VERSION",(const xmlChar *)CONFIG_VERSION);
    
    for(i = 0; i<TREECOUNT; i++) {
	gchar *g=g_strdup_printf("treeview_%d",i);
	node = xmlNewTextChild(root, NULL, (const xmlChar *)g, NULL);
	g_free(g);
	/*snprintf(value, 32, "%d", xffm_details->icon_size);
	xmlSetProp(node, "icon_size", value);*/
	snprintf(value, 32, "%d", xffm_details->arbol->treestuff[i].preferences);
	xmlSetProp(node, (const xmlChar *)"preferences", (const xmlChar *)value);
	snprintf(value, 32, "%d", xffm_details->arbol->treestuff[i].name_size);
	xmlSetProp(node, (const xmlChar *)"name_size", (const xmlChar *)value);
    }
    
    node = xmlNewTextChild(root, NULL, (const xmlChar *)"options", NULL);
    /*xmlSetProp(node, (const xmlChar *)"theme", xffm_details->theme);*/
 
    snprintf(value, 32, "%d", xffm_details->preferences);
    xmlSetProp(node, (const xmlChar *)"preferences", (const xmlChar *)value);

    xmlSetProp(node, (const xmlChar *)"sidebar", (const xmlChar *)xffm_details->arbol->sidebar);

    if (xffm_details->arbol->widgets.window) {
	GtkWidget *window=xffm_details->arbol->widgets.window;
	GtkWidget *hpaned= NULL;
	if (xffm_details->arbol->widgets.window){
	    hpaned= lookup_widget(xffm_details->arbol->widgets.window,"hpaned1");
	    TRACE("1 hpane is %d\n",xffm_details->arbol->hpane);
	}
	xffm_details->arbol->geometryX = window->allocation.width;
	xffm_details->arbol->geometryY = window->allocation.height;
	if (hpaned && GTK_IS_PANED (hpaned)) 
	    xffm_details->arbol->hpane = gtk_paned_get_position((GtkPaned *)hpaned);
	else
	    xffm_details->arbol->hpane = 0;
	    

	child = xmlNewTextChild(root, NULL, (const xmlChar *)"geometry", NULL);
	snprintf(value, 32, "%d", xffm_details->arbol->geometryX);
	xmlSetProp(child, (const xmlChar *)"width", (const xmlChar *)value);

	snprintf(value, 32, "%d", xffm_details->arbol->geometryY);
	xmlSetProp(child, (const xmlChar *)"height", (const xmlChar *)value);
	
        TRACE("2 hpane is %d\n",xffm_details->arbol->hpane);
	snprintf(value, 32, "%d",xffm_details->arbol->hpane);
	xmlSetProp(child, (const xmlChar *)"hpane", (const xmlChar *)value);

    }   
    
    if (xffm_details->arbol->smart_hash)
	g_hash_table_foreach(xffm_details->arbol->smart_hash,save_sb,(gpointer)root);
}

static
void write_config(char *rcfile)
{
    char *dir;
    xmlNodePtr root;
    if (!write_config_active) {
	TRACE("write_config is not active at this point");
	return;
    }

    if(!g_file_test(rcfile, G_FILE_TEST_EXISTS))
    {
	dir = g_path_get_dirname(rcfile);

	if(!g_file_test(dir, G_FILE_TEST_IS_DIR))
	    mkdir(dir, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);

	g_free(dir);dir=NULL;
    }

    xmlconfig = xmlNewDoc((const xmlChar *)"1.0");
    xmlconfig->children = xmlNewDocRawNode(xmlconfig, NULL, (const xmlChar *)xffm_details->argv[0], NULL);

    root = (xmlNodePtr) xmlconfig->children;
    xmlDocSetRootElement(xmlconfig, root);

    xffm_write_xml(root);

    xmlSaveFormatFile(rcfile, xmlconfig, 1);

    xmlFreeDoc(xmlconfig);
    xmlconfig = NULL;
}

G_MODULE_EXPORT
void write_xffm_config(void)
{
    gchar *rcfile;
    gchar *fname=g_strconcat(xffm_details->argv[0],"rc.xml",NULL);
    
    rcfile=g_build_filename(xdg_config_dir(),XFFM_RC_FILE,fname,NULL);
    g_free(fname);
    write_config(rcfile);
    chmod(rcfile,0644);
    g_free(rcfile);
}

/***   callbackS   ***/
