/*
 * Copyright (C) 2004 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>

#include <pwd.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif





#include "constants.h"
#include "types.h"
#include "primary.h"
#include "gui.h"
#include "treeview.h"
#include "actions_lib.h"


#include "treeview_popup-callbacks.i"
#include "treeview_popup.i"


/*FIXME: dnd to normal buttons not enabled, but everything is in place for it to work */

/* if the location of xfce4-panel icons changes, this line must change to
 * reflect that */
/*#define CURRENT_PANEL_ICONS PACKAGE_DATA_DIR,"xfce4","icons",panel_theme,"48x48","emblems"*/
#define CURRENT_PANEL_ICONS PACKAGE_DATA_DIR,"icons","hicolor","48x48","stock","generic"

/* if something is broken in icon detemination: */
#define DEFAULT_PANEL_ICON "xffm/unknown"
 
extern void sb_diff(GtkWidget *w); /* missing xfdiff.h file */
extern void sb_zoom_in(GtkWidget *w); /* missing zoom.h file */
extern void sb_zoom_out(GtkWidget *w); /* missing zoom.h file */
extern void tb_properties(GtkWidget *w); /* missing properties.h file */

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

/* FIXME: remove support for drag and drop, not used really...  */
static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/plain", 0, TARGET_PLAIN},
    {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))


static guint open_timer=0;
static  GtkTooltips *tooltips=NULL;
static char *smart_button_cmd=NULL;
static char *smart_button_arg=NULL; /* used for dnd only */

static 
GdkPixbuf *
plain_icon(const gchar *iconname){
    g_warning("Cannot find icon %s in icon factory",iconname);
    return NULL;
}

static gboolean false_click=FALSE;
static gint open_menu(gpointer user_data){
   smart_t *smart = (smart_t *)user_data;
   open_timer=0;
   false_click=TRUE;
   gtk_button_released ((GtkButton *)smart->button);
   gtk_menu_popup(GTK_MENU(smart->menu), NULL, NULL, NULL, NULL, 1, gtk_get_current_event_time());
   return FALSE;
}

static void open_menu1 (GtkButton * button, gpointer  user_data)
{
   /*printf("TRACE: pressed\n");*/
   false_click=FALSE;
   open_timer=g_timeout_add_full(0, 150, (GtkFunction) open_menu, user_data, NULL);

}

static void close_menu1 (GtkButton * button, gpointer  user_data)
{
   smart_t *smart = (smart_t *)user_data;
   /*printf("TRACE: clicked\n");*/
   if (open_timer)g_source_remove(open_timer);
   open_timer=0;
   smart_button_cmd = smart->cmd;
   if (smart->callback && !false_click) (*(smart->callback))(smart->widget);
   
}

static void change_button (GtkMenuItem * menuitem, gpointer  user_data)
{
    smart_button_t *smart_button=(smart_button_t *)user_data;
    smart_t *smart = (smart_t *)(smart_button->smartp);
    GtkWidget *box;
    
    if (smart->type == SMART_COLUMN_BUTTON) { 
	box = gtk_bin_get_child(GTK_BIN(smart->button));
	
    }
    else if (smart->type == SMART_TOOLBAR_BUTTON) { 
	box =(GtkWidget *)(smart->button);
    } else assert_not_reached();
    gtk_container_remove(GTK_CONTAINER (box),smart->image);
    gtk_container_add (GTK_CONTAINER (box), smart_button->altimage);
    
    smart->image=smart_button->altimage;
    smart->callback = smart_button->callback;
    if (smart->cmd){
	g_free(smart->cmd);
	smart->cmd=NULL;
    }
    if (smart_button->cmd) smart->cmd = g_strdup(smart_button->cmd);
    smart_button_cmd = smart->cmd; /* used by panel buttons */
    {
      gchar *g;
      if (smart_button->tooltip) g=g_strdup(_(smart_button->tooltip));
      else 
      g=g_strdup(_("Press and hold for popup"));
      gtk_tooltips_set_tip (tooltips, smart->button, g, NULL);
      g_free(g);
    }
    TRACE("TRACE:hashing value %s=%d\n ",smart->name,smart_button->id);
    if (smart_button->id) {
	g_hash_table_insert(xffm_details->arbol->smart_hash,
	    (gpointer)(smart->name),
	    (gpointer)((long)smart_button->id));
    } else {
	g_hash_table_remove(xffm_details->arbol->smart_hash,(gpointer)(smart->name));
    }
    write_xffm_config();
}

static void set_menu (GtkMenuItem * menuitem, gpointer  user_data){
    smart_button_t *smart_button=(smart_button_t *)user_data;
    smart_t *smart = (smart_t *)(smart_button->smartp);
    /*printf("smart button is %s\n",smart_button->tooltip);*/
    if (!menuitem) change_button(menuitem,user_data);
    else if (smart_button->callback){
	smart_button_cmd = smart_button->cmd;
       	(*(smart_button->callback))(smart->widget);
    }
    gtk_menu_popdown (GTK_MENU(smart->menu));	
}
static void exec_menu (GtkMenuItem * menuitem, gpointer  user_data){
    smart_button_t *smart_button=(smart_button_t *)user_data;
    smart_t *smart = (smart_t *)(smart_button->smartp);
    /*printf("activate menu\n");*/
    change_button(menuitem,user_data);
    if (smart->callback) (*(smart->callback))(smart->widget);
}

typedef void ((*smart_f))(GtkWidget *);
static void button_action (GtkButton * button, gpointer  user_data)
{
    /*printf("button_action\n");*/
    gchar *cmd=g_object_get_data(G_OBJECT(button),"cmd");
    if (cmd && strlen(cmd)) {
	smart_button_cmd=cmd;
    } else  smart_button_cmd=NULL;
    smart_button_arg=NULL; /* used for dnd only */
    if (user_data){
	void ((*func))(GtkWidget *);
        func = (smart_f)user_data;
	(*func)((GtkWidget *)button);
    }
    else {
	printf("TRACE: button callback is NULL\n");
    }
}



static gboolean  menu_release_callback (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("release at coordinates %f,%f\n", event->x, event->y);*/
    /* ctrl-click1: exec and do not change top drawer */
    /* click1: exec and change top drawer */
    if (event->state & GDK_CONTROL_MASK && event->button == 1) {
	/*set_menu ((gpointer)((long) 1), user_data);
	return TRUE;*/
	set_menu (NULL, user_data);
	return FALSE;
    }
    if( event->button == 1) return FALSE;
    /* click2 or click3: change top drawer */
    set_menu (NULL, user_data);
    return TRUE;
}

G_MODULE_EXPORT
gboolean  normal_button_press_event (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    GtkWidget *sidebar=gtk_bin_get_child(GTK_BIN(lookup_widget(xffm_details->arbol->widgets.window,"eventbox_sidebar")));
   if( event->button != 3) return FALSE;
   if (sidebar) {
       if (GTK_WIDGET_VISIBLE(sidebar)){
	   g_free(xffm_details->arbol->sidebar);
	   xffm_details->arbol->sidebar=g_strdup("");
	   gtk_widget_hide(sidebar);
	   write_xffm_config();
       }
       else do_main_popup("main_menu2_menu",event->time);
   } else do_main_popup("main_menu2_menu",event->time);

   return TRUE;
}


static  void normal_buttons(GtkWidget *toolbar,smart_button_init_t *button_info){
  int i;
  GdkPixbuf *pixbuf;
  GtkWidget *button,*image;
  
  if (!tooltips) tooltips = gtk_tooltips_new ();
  for (i=0; button_info[i].image; i++){
    if (strcmp(button_info[i].image,"-")==0){
	gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
	continue;
    }
    if (strncmp(button_info[i].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(&(xffm_details->arbol->widgets),button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(xffm_details->arbol->widgets.window, button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
    } else {
	pixbuf = icon_tell(&(xffm_details->arbol->widgets),GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[i].image);
    }
    if (!pixbuf) pixbuf=plain_icon(button_info[i].image);
    if (pixbuf) {
      image = gtk_image_new_from_pixbuf (pixbuf);
      g_object_unref(pixbuf);
    } else image=NULL;

    button = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "",
                                _(button_info[i].tooltip), NULL,
                                image, NULL, NULL);

    gtk_widget_show (button);
    if (button_info[i].cmd && strlen(button_info[i].cmd)) 
	g_object_set_data(G_OBJECT(button),"cmd",button_info[i].cmd);
    g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (button_action), (gpointer)button_info[i].callback);
    g_signal_connect ((gpointer) button, "button_press_event", G_CALLBACK (normal_button_press_event), toolbar);

    if (button_info[i].name) GLADE_HOOKUP_OBJECT(xffm_details->arbol->widgets.window,button,button_info[i].name);
  }
}


G_MODULE_EXPORT
gboolean tb_drag_motion(GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    GdkDragAction action = GDK_ACTION_COPY;
    /*printf("TRACE:  tb_drag_motion \n"); */
    /* Insert code to get our default action here. */

    if(dc->actions == GDK_ACTION_MOVE) gdk_drag_status(dc, GDK_ACTION_MOVE, t);
    else if(dc->actions == GDK_ACTION_COPY) gdk_drag_status(dc, GDK_ACTION_COPY, t);
    else if(dc->actions == GDK_ACTION_LINK) gdk_drag_status(dc, GDK_ACTION_LINK, t);
    else if(dc->actions & action) gdk_drag_status(dc, action, t);
    else gdk_drag_status(dc, 0, t);
    return (TRUE);
}

static void create_sidebar(smart_t *smart, gboolean save){
  GtkWidget *sidebar,*eventbox_sidebar;
  smart_t *old_smart;
  eventbox_sidebar=lookup_widget(xffm_details->arbol->widgets.window,"eventbox_sidebar");
  sidebar = gtk_bin_get_child(GTK_BIN(eventbox_sidebar));

  if (!smart->button_info) {
      return;
  }

  old_smart = (smart_t *)g_object_get_data(G_OBJECT(eventbox_sidebar),"smart_id");
  if (sidebar && old_smart && smart==old_smart) {
     g_free(xffm_details->arbol->sidebar);
     if (GTK_WIDGET_VISIBLE(sidebar)){
	 xffm_details->arbol->sidebar=g_strdup("");
	 gtk_widget_hide(sidebar);
     }
     else {
	 xffm_details->arbol->sidebar=g_strdup(smart->name);
	 gtk_widget_show(sidebar);
     }
     if (save) write_xffm_config();
     return;
  }
      
  
  if (sidebar)
    gtk_container_remove(GTK_CONTAINER (eventbox_sidebar),sidebar);
  
  sidebar = gtk_toolbar_new ();
  g_object_set_data(G_OBJECT(eventbox_sidebar),"smart_id",smart);
  
  gtk_toolbar_set_style (GTK_TOOLBAR (sidebar), GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_orientation (GTK_TOOLBAR (sidebar), GTK_ORIENTATION_VERTICAL);
  normal_buttons(sidebar,smart->button_info);
  gtk_container_add (GTK_CONTAINER (eventbox_sidebar), sidebar);
  
  g_free(xffm_details->arbol->sidebar);
  if (smart->name) xffm_details->arbol->sidebar=g_strdup(smart->name);
  else xffm_details->arbol->sidebar=g_strdup("");
  
  gtk_widget_show (sidebar);  
  if (save) {
     write_xffm_config();
     turn_on();
  }
}

static gboolean  button_press_callback (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("Event box clicked at coordinates %f,%f\n", event->x, event->y);*/
   if( event->button == 1) return FALSE;
   if (!((smart_t *)user_data)->button_info) {
       open_menu(user_data);
       return TRUE;
   }
   create_sidebar((smart_t *)user_data,TRUE);

    return TRUE;
}

G_MODULE_EXPORT
smart_t *
mk_smart_button(	smart_button_init_t *button_info,
			gchar *name,
			GtkWidget **button_p)
{
  int i,id;
  GdkPixbuf *pixbuf;
  smart_t *smart;  
  GtkWidget *button;
  int lastused=0;
  gpointer lu;
  if (xffm_details->arbol->smart_hash == NULL){
	xffm_details->arbol->smart_hash = 
	    g_hash_table_new( g_str_hash, g_str_equal);
  }
  if ((lu = g_hash_table_lookup(xffm_details->arbol->smart_hash, name)) != NULL){
      lastused = (int)((long)lu);
  }
#ifdef DEBUG
  else {
    TRACE("TRACE:new hash value %s=0\n ",name);
  } 
#endif
  
  
  smart = (smart_t *)malloc(sizeof(smart_t));
  if (!smart) assert_not_reached();
  
  
  if (button_p) {
      smart->button_info = NULL;
      smart->type = SMART_COLUMN_BUTTON;
  }
  else {
      smart->button_info = (gpointer)button_info;
      smart->type = SMART_TOOLBAR_BUTTON;
  }
  
  smart->name = g_strdup(name);
  if (!tooltips) tooltips = gtk_tooltips_new ();
  if (button_p) smart->button = *button_p;
  else  smart->button = gtk_button_new ();
  smart->menu = gtk_menu_new ();
  smart->widget = (GtkWidget *)xffm_details->arbol->widgets.window;
  gtk_widget_show (smart->button);
  gtk_widget_show (smart->menu);
  /*gtk_container_add (GTK_CONTAINER (toolbar), smart->button);*/
  g_signal_connect (G_OBJECT (smart->button), "pressed", G_CALLBACK (open_menu1), (gpointer) smart);
  g_signal_connect (G_OBJECT (smart->button), "clicked", G_CALLBACK (close_menu1), (gpointer) smart);
  g_signal_connect (G_OBJECT (smart->button), "button_press_event", G_CALLBACK (button_press_callback),(gpointer) smart);

  if (smart->name) GLADE_HOOKUP_OBJECT(xffm_details->arbol->widgets.window,smart->button,smart->name);

  /*****************  popup buttons ***************************/
  for (i=0,id=0; button_info[i].image; i++,id++){
    if (strcmp(button_info[i].image,"-")==0){
	GtkWidget *separator = gtk_menu_item_new ();
	gtk_widget_show (separator);
	gtk_container_add (GTK_CONTAINER (smart->menu), separator);
	gtk_widget_set_sensitive (separator, FALSE);
	id--;
	continue;
    }
    smart->smart_button=(smart_button_t *)malloc(sizeof(smart_button_t));
    if (!smart->smart_button) assert_not_reached();
    smart->smart_button->id = i;
    smart->smart_button->tooltip=g_strdup(_(button_info[i].tooltip));
    if (button_info[i].cmd) smart->smart_button->cmd=g_strdup(button_info[i].cmd); /* used by dnd and panel */
    else smart->smart_button->cmd=NULL;
    smart->smart_button->smartp = (gpointer)smart;
   
   
    /*printf("loading image %s\n", button_info[i].image);*/

    
    if (button_info[i].caption) 
	button = (GtkWidget *)gtk_image_menu_item_new_with_mnemonic (button_info[i].caption);
    else 
	button = (GtkWidget *)gtk_image_menu_item_new_with_mnemonic ("");
    gui_mk_pixmap_menu(&(xffm_details->arbol->widgets), button_info[i].image,button,BIGGER_MENU_PIXMAP);
    

    /* replaceable image for top button */
    
    if (strncmp(button_info[i].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(&(xffm_details->arbol->widgets),button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(xffm_details->arbol->widgets.window, button_info[i].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
    } else {
    	pixbuf = icon_tell(&(xffm_details->arbol->widgets),GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[i].image);
    }
    if (!pixbuf) pixbuf=plain_icon(button_info[i].image);
    if (!pixbuf) {
	g_warning("no pixbuf loaded: %s",button_info[i].image);
	pixbuf = icon_tell(&(xffm_details->arbol->widgets),GTK_ICON_SIZE_SMALL_TOOLBAR,DEFAULT_PANEL_ICON);
    }
    if (pixbuf) {
      GdkPixbuf *p;
      if (smart->type == SMART_COLUMN_BUTTON) p=gdk_pixbuf_scale_simple ((const GdkPixbuf *)pixbuf,16,16,GDK_INTERP_BILINEAR);
      else p=gdk_pixbuf_copy(pixbuf);


      g_object_unref(G_OBJECT(pixbuf));
      insert_pixbuf_tag(&(xffm_details->arbol->widgets),"xffm/stock_go-down",&p, GTK_ICON_SIZE_SMALL_TOOLBAR,2,"SE",TRUE); 
      smart->smart_button->altimage = gtk_image_new_from_pixbuf (p);
      g_object_unref(p);
      gtk_widget_show (smart->smart_button->altimage);
      g_object_ref ((gpointer)smart->smart_button->altimage);
    } else {
	smart->smart_button->altimage = NULL;
    }
    
    smart->smart_button->callback = button_info[i].callback;

    
    gtk_widget_show (button);
    gtk_container_add (GTK_CONTAINER (smart->menu), button);
    gtk_tooltips_set_tip (tooltips, button, _(button_info[i].tooltip), NULL);

    
    g_signal_connect (G_OBJECT (button), "button_release_event", G_CALLBACK (menu_release_callback),(gpointer) smart->smart_button);
    g_signal_connect (G_OBJECT (button), "activate", G_CALLBACK (exec_menu), (gpointer)smart->smart_button);
    if (button_info[i].name) {
	GLADE_HOOKUP_OBJECT(xffm_details->arbol->widgets.window,button,g_strconcat(button_info[i].name,"_sb",NULL));
    }

  }
  
  if (tooltips) g_object_set_data (G_OBJECT (xffm_details->arbol->widgets.window), "tooltips", tooltips);

  /* this should come from config... */
  if (lastused >= i || lastused < 0) lastused=0;
  if (strncmp(button_info[lastused].image,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(&(xffm_details->arbol->widgets),button_info[lastused].image,GTK_ICON_SIZE_LARGE_TOOLBAR);
	/*pixbuf=gtk_widget_render_icon(xffm_details->arbol->widgets.window, button_info[lastused].image,GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);*/
  } else {
      	pixbuf = icon_tell(&(xffm_details->arbol->widgets),GTK_ICON_SIZE_SMALL_TOOLBAR,button_info[lastused].image);
  }
  {
    GdkPixbuf *p=NULL;
    if (pixbuf) {
	if (smart->type == SMART_COLUMN_BUTTON) p=gdk_pixbuf_scale_simple ((const GdkPixbuf *)pixbuf,16,16,GDK_INTERP_BILINEAR);
	else p=gdk_pixbuf_copy(pixbuf);

	g_object_unref(G_OBJECT(pixbuf));
    }
    insert_pixbuf_tag(&(xffm_details->arbol->widgets),"xffm/stock_go-down",&p, GTK_ICON_SIZE_SMALL_TOOLBAR,2,"SE",TRUE);
    smart->image = gtk_image_new_from_pixbuf (p);
    if (p) g_object_unref(G_OBJECT(p));
  }
  gtk_widget_show (smart->image);
  
  if (smart->type == SMART_COLUMN_BUTTON) { /* this applies to column buttons...*/
    GtkWidget *box = gtk_bin_get_child(GTK_BIN(smart->button));
    gtk_box_pack_start (GTK_BOX (box), smart->image, FALSE, FALSE, 0);
  } else {
    gtk_button_set_relief((GtkButton *)smart->button,GTK_RELIEF_NONE);
    gtk_container_add (GTK_CONTAINER (smart->button),smart->image);
  }

  GTK_WIDGET_UNSET_FLAGS (smart->button, GTK_CAN_FOCUS);
  smart->callback = button_info[lastused].callback;
  if (button_info[lastused].cmd) smart->cmd = g_strdup(button_info[lastused].cmd); /* used by panel buttons */
  else smart->cmd = NULL;
  
  {
    gchar *g;
    if (button_info[lastused].tooltip) 
	g=g_strdup(_(button_info[lastused].tooltip));
    else
	g=g_strdup(_("Press and hold for popup"));
    gtk_tooltips_set_tip (tooltips, smart->button, g, NULL);
    g_free(g);
  }

  g_signal_connect(G_OBJECT(smart->button), "drag_motion", G_CALLBACK(tb_drag_motion), NULL);
  gtk_drag_dest_set(smart->button, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY);

  if (smart) g_object_set_data(G_OBJECT(smart->button), "smart", (gpointer) smart);
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  return smart;
}

static  smart_t *smart_buttons(GtkWidget *toolbar,smart_button_init_t *button_info,gchar *name){
  smart_t *smart;  
  smart = mk_smart_button(button_info,name,NULL);
  gtk_container_add (GTK_CONTAINER (toolbar), smart->button);
  if (name && xffm_details->arbol->sidebar && strcmp(name,xffm_details->arbol->sidebar)==0){
      create_sidebar(smart,FALSE);
  }
  /*XXX: remove spacer? */
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  return smart;
}

static
void sb_iconview(GtkWidget *w){
   on_iconview_activate(NULL,NULL); 
}

static
void sb_clear_pasteboard(GtkWidget *w){
   treeview_clear_pasteboard_activate(NULL,NULL); 
}
static
void sb_refresh(GtkWidget *w){
    treeview_refresh_activate((GtkMenuItem *)w, NULL);
    
}

static
void sb_about(GtkWidget *w){
    gui_on_about_activate((GtkMenuItem *)w, NULL);
}

static
void on_settings_show(GtkMenuItem *w,gpointer data){   
    void *p;
    GtkDialog *d;
    
    if ((p=function_void("mcs-shm","xffmsettings","module_init"))!=NULL){
	TRACE("module_init=0x%x",(unsigned)p);
	d=(GtkDialog *)function_natural("mcs-shm","xffmsettings",p,"run_xffm_settings_dialog");
	if (d) {
	    gtk_dialog_run(d);
	}
    }	
    else {
	    g_warning("cannot load libxffmsettings");
    }
    return;
 
}
static
void sb_settings_show(GtkWidget *w){
    on_settings_show(NULL,NULL);
}

static
void on_tb_off(GtkWidget *w){
    exit(1);
    return;
 
}
static
void sb_printer_configuration(GtkWidget *w){
    on_printer_configuration_activate((GtkMenuItem *)w,NULL);
    return;
}
static
void sb_list_pasteboard(GtkWidget *w){
    treeview_list_pasteboard_activate((GtkMenuItem *)w,NULL);
    return;
}

static
void sb_xfmime_edit(GtkWidget *w){
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);
    const gchar *argv[]={"xfmime-edit",NULL};
    xffm_runvwd(widgets_p,NULL,argv);
    xffm_confirm(widgets_p,_("You can make xffm use an alternate icon theme with the XFFM_ICON_THEME environment variable"),NULL,"Ok");
    return;
 
}

#include "treeview_toolbar.i"

G_MODULE_EXPORT
void toolbar_buttons(void){
    static gboolean mapped=FALSE;
    GtkWidget *toolbar=lookup_widget(xffm_details->arbol->widgets.window,"toolbar_xftree");
    if (mapped) return;
    TRACE("xffm: loading toolbar buttons");
    smart_buttons(toolbar,exec_button_info,"exec_button");
    /*smart_buttons(toolbar,exec2_button_info,"exec2_button");*/
    smart_buttons(toolbar,go_button_info,"go_button");
    /*
     * these are now the funky button:
     * smart_buttons(toolbar,branch_button_info,"view_button");
     * smart_buttons(toolbar,column_button_info,"column_button");
     * */
    smart_buttons(toolbar,view_button_info,"view_button");
    /* separators added in normal button info */
    /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
    normal_buttons(toolbar,normal_button_info1);
    smart_buttons(toolbar,paste_button_info,"paste_button");
    gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
    smart_buttons(toolbar,new_button_info,"new_button");
    smart_buttons(toolbar,single_selection_button_info,"single_selection_button");
    normal_buttons(toolbar,normal_button_info1b);
    /* separator is added in normal button info */
    normal_buttons(toolbar,normal_button_info2);

    
    mapped=TRUE;
}

G_MODULE_EXPORT
int parse_panel_config(void){
   return 1; 
}
  
/*********************************************************************/
 
static 
void 
put_in_menu(		const gchar *menutext,
			const gchar *icon_id,
			GtkWidget *parent_menu,
			void *callback,
			const gchar *name,
			guint key)
{
    gchar *menuname;
    GtkWidget *menuitem = gtk_image_menu_item_new_with_mnemonic (_(menutext));
    gtk_widget_show (menuitem);
      TRACE("put_in_menu:%s, %s, %s",menutext,icon_id,name);

    gtk_container_add (GTK_CONTAINER (parent_menu), menuitem);
    /*XXX: probably should register all xffm stock icons as
     *       stock icons to use only gtk_image_new_from_stock,
     *       but apparently not much is gained, except the
     *       overhead from doing do
     *       */

      TRACE("put_in_menu:2");
    if (icon_id) {
	gui_mk_pixmap_menu(&(xffm_details->arbol->widgets), icon_id,menuitem,MENU_PIXMAP);
    }
      TRACE("put_in_menu:3");
    if (callback) {
	g_signal_connect ((gpointer) menuitem, "activate",G_CALLBACK (callback), NULL);
	if (key) {
	    GSList *l;
	    l = gtk_accel_groups_from_object((GObject *) xffm_details->arbol->widgets.window);
	    TRACE("TRACE: adding CTL+%c\n",key);
	    if(l && l->data){
		gtk_widget_add_accelerator (menuitem, "activate", 
			    (GtkAccelGroup *) (l->data),
                              key, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
	    }
	}
    }
    if (name) {
      menuname=g_strconcat(name,"_menuitem",NULL);
      GLADE_HOOKUP_OBJECT (xffm_details->arbol->widgets.window, menuitem, menuname);
    }
}

static 
void
mk_smart_menu(		GtkWidget *parent_menu,
			smart_button_init_t *button_info)
{
  int i;
  for (i=0; button_info[i].tooltip; i++){
      TRACE(" button_info[%d]",i);
    if (strcmp(button_info[i].tooltip,"-")==0){
	GtkWidget *separator = gtk_menu_item_new ();
	gtk_widget_show (separator);
	gtk_container_add (GTK_CONTAINER (parent_menu), separator);
	gtk_widget_set_sensitive (separator, FALSE);
        if (button_info[i].name)
	    GLADE_HOOKUP_OBJECT (xffm_details->arbol->widgets.window, separator, button_info[i].name);
	continue;
    } 
    else if (button_info[i].menu_callback) {
	put_in_menu(	(const gchar *)button_info[i].tooltip,
			(const gchar *)button_info[i].image,
			parent_menu,
			button_info[i].menu_callback,
			(const gchar *)button_info[i].name,
			button_info[i].key);
			
	

    }
    /*
    else {
	g_warning("skipping menu add %s\n",button_info[i].tooltip);
    }*/
    
  }
}

static 
void 
mk_toggle_menu(		GtkWidget *parent_menu,
			toggle_button_init_t *button_info)
{
  int i;
  GtkWidget *w;
  for (i=0; button_info[i].tag; i++){
    w = gtk_check_menu_item_new_with_mnemonic (_(button_info[i].tag));
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent_menu), w);
    GLADE_HOOKUP_OBJECT (xffm_details->arbol->widgets.window, w, button_info[i].name);
    g_signal_connect(w,"toggled", G_CALLBACK(button_info[i].callback),button_info[i].data);
    
  }
}

G_MODULE_EXPORT
void smart_menus(void){
    static gboolean mapped=FALSE;
    if (mapped) 
	return;
    TRACE("xffm: loading menus");
    mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"tools1_menu"),exec_button_info);
    /*mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"open1_menu"),exec2_button_info);*/
    mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"go1_menu"),go_button_info);
    mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"options1_menu"),view_button_info);
    mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"file1_menu"),new_button_info);
    /*mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"file1_menu"),single_selection_button_info);*/
    mk_toggle_menu(lookup_widget(xffm_details->arbol->widgets.window,"columns1_menu"),toggle_columns_info);
    mk_smart_menu(lookup_widget(xffm_details->arbol->widgets.window,"item22_menu"),popup_button_info);
    mapped=TRUE;
}

G_MODULE_EXPORT
GtkWidget * 
treeview_mk_popup_menu (GtkWidget *parent,
			GtkAccelGroup *accel_group,
			void *data){
    return common_mk_popup_menu (parent,accel_group,data);
}
G_MODULE_EXPORT
GtkWidget * 
treeview_mk_main_menu (	GtkWidget *parent,
			GtkAccelGroup *accel_group){
    return common_mk_main_menu(parent,accel_group);
}

