#ifndef __TOOLBAR__H_
#define __TOOLBAR__H_

enum {
    SMART_TOOLBAR_BUTTON,
    SMART_COLUMN_BUTTON,
    SMART_BUTTON_TYPES
};

typedef struct toggle_button_init_t {
    gchar *tag;
    gchar *name;
    gpointer callback;
    gpointer data;
} toggle_button_init_t;


typedef struct smart_button_init_t {
    gchar *image;
    gchar *tooltip;
    void (*callback) (GtkWidget *widget); /* callback used by internal buttons */
    gchar *name;
    /* XXX should use union here... */
    gchar *cmd; /* used by panel elements */
    gchar *caption;/* used by panel elements */
    gpointer menu_callback;/*  used by menu elements */
    guint key;
} smart_button_init_t;


typedef struct smart_button_t {
    int id;
    GtkWidget *altimage;
    gchar *tooltip;
    gchar *cmd;
    void (*callback) (GtkWidget *widget);
    GtkWidget *widget;
    gpointer smartp;
}smart_button_t;

typedef struct smart_t {
    gchar *cmd;
    gchar *name;
    gchar *tooltip;
    smart_button_t *smart_button;
    GtkWidget *menu;
    GtkWidget *button;
    GtkWidget *image;
    GtkWidget *widget;
    void (*callback) (GtkWidget *widget);
    int type;
    gpointer button_info;
}smart_t;

void toolbar_buttons(void);

int parse_panel_config(void);

/*funky:*/
smart_t *
mk_smart_button(	smart_button_init_t *button_info,
			gchar *name,
			GtkWidget **button_p);

void smart_menus(void);

GtkWidget * 
treeview_mk_main_menu (	GtkWidget *parent,
			GtkAccelGroup *accel_group);
GtkWidget * 
treeview_mk_popup_menu (GtkWidget *parent,
			GtkAccelGroup *accel_group,
			void *data);
void
treeview_autotype_C                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void treeview_run_activate(GtkMenuItem * menuitem, gpointer user_data);

void treeview_print_activate(GtkMenuItem * menuitem, gpointer user_data);
void treeview_remove_activate(GtkMenuItem * menuitem, gpointer user_data);
void treeview_mount (GtkMenuItem *menuitem, gpointer user_data);
void treeview_unmount (GtkMenuItem *menuitem, gpointer user_data);

void enable_refresh_by_toggle(gboolean value);

void toggle_dot(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data);
void on_column_click(GtkTreeViewColumn * column, gpointer data);
gboolean is_toggle_enabled(void);
gint treeview_refresh(widgets_t *widgets_p);
void treeview_on_refresh(GtkButton * button, gpointer user_data);
#endif

