
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <dirent.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "main_gui.h"
#include "support.h"
#include "primary.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

extern
void theme_changed (GtkOptionMenu *om, gpointer user_data);


void fill_string_option_menu (GtkOptionMenu *om, GSList *strings)
{
	GtkMenu			*menu;
	GtkWidget		*it;
	
	menu = GTK_MENU (gtk_menu_new ());

	while (strings) {
		it = gtk_menu_item_new_with_label ((gchar *)strings->data);
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), it);
		gtk_widget_show (it);
		
		strings = g_slist_next (strings);
	}

	gtk_option_menu_set_menu (om, GTK_WIDGET (menu));
	/*g_object_unref (menu); *//* FIXME is that right? */
}


const gchar *string_option_menu_get_selected(GtkOptionMenu *w)
{
	GtkOptionMenu		*om;
	GtkMenu			*menu;
	GtkLabel		*label;
	const gchar		*txt;
	
	/*om = GTK_OPTION_MENU (w);*/
	om = w;

	menu = GTK_MENU (gtk_option_menu_get_menu (om));

	label = GTK_LABEL (gtk_bin_get_child(GTK_BIN(om)));
	
	txt = gtk_label_get_text (label);
	if (!txt) txt="";
	
	return txt;
}


GtkWidget*
create_xfmime_edit (gchar *name)
{
  GtkWidget *xfmime_edit;
  GtkWidget *vbox1;
  GtkWidget *hpaned1;
  GtkWidget *scrolledwindow3;
  GtkWidget *treeview1;
  GtkWidget *scrolledwindow2;
  GtkWidget *treeview2;
  GtkWidget *hbox3;
  GtkWidget *optionmenu2;
  GtkWidget *hbuttonbox1;
  GtkWidget *save;
  GtkWidget *quit;

  xfmime_edit = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (xfmime_edit, 400, 537);
  gtk_window_set_title (GTK_WINDOW (xfmime_edit), "xfmime_edit");
  gtk_window_set_default_size (GTK_WINDOW (xfmime_edit), 640, 480);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (xfmime_edit), vbox1);

  hpaned1 = gtk_hpaned_new ();
  gtk_widget_show (hpaned1);
  gtk_box_pack_start (GTK_BOX (vbox1), hpaned1, TRUE, TRUE, 0);
  gtk_paned_set_position (GTK_PANED (hpaned1), 345);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow3);
  gtk_paned_pack1 (GTK_PANED (hpaned1), scrolledwindow3, FALSE, TRUE);

  treeview1 = gtk_tree_view_new ();
  gtk_widget_show (treeview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), treeview1);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_paned_pack2 (GTK_PANED (hpaned1), scrolledwindow2, TRUE, TRUE);

  treeview2 = gtk_tree_view_new ();
  gtk_widget_show (treeview2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), treeview2);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 0);

  optionmenu2 = gtk_option_menu_new ();
  gtk_widget_show (optionmenu2);
  gtk_box_pack_end (GTK_BOX (hbox3), optionmenu2, TRUE, TRUE, 0);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (hbox3), hbuttonbox1, FALSE, FALSE, 0);

  save = gtk_button_new_from_stock ("gtk-save");
  gtk_widget_show (save);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), save);
  GTK_WIDGET_SET_FLAGS (save, GTK_CAN_DEFAULT);

  quit = gtk_button_new_from_stock ("gtk-quit");
  gtk_widget_show (quit);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), quit);
  GTK_WIDGET_SET_FLAGS (quit, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) optionmenu2, "changed",
                    G_CALLBACK (theme_changed),
                    NULL);
  g_signal_connect ((gpointer) treeview1, "drag_data_received",
                    G_CALLBACK (on_drag_data),
                    NULL);
  g_signal_connect ((gpointer) treeview1, "drag_data_get",
                    G_CALLBACK (on_treeview1_drag_data_get),
                    NULL);
  g_signal_connect ((gpointer) treeview1, "drag_drop",
                    G_CALLBACK (on_treeview1_drag_drop),
                    NULL);
  g_signal_connect ((gpointer) treeview1, "drag_motion",
                    G_CALLBACK (on_drag_motion),
                    NULL);
  g_signal_connect ((gpointer) treeview2, "drag_data_get",
                    G_CALLBACK (on_treeview2_drag_data_get),
                    NULL);
  g_signal_connect ((gpointer) treeview2, "drag_motion",
                    G_CALLBACK (on_drag_motion),
                    NULL);
  g_signal_connect ((gpointer) treeview2, "drag_drop",
                    G_CALLBACK (on_treeview1_drag_drop),
                    NULL);
  g_signal_connect ((gpointer) save, "clicked",
                    G_CALLBACK (on_save_clicked),
                    NULL);
  g_signal_connect ((gpointer) quit, "clicked",
                    G_CALLBACK (on_quit_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (xfmime_edit, xfmime_edit, "xfmime_edit");
  GLADE_HOOKUP_OBJECT (xfmime_edit, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (xfmime_edit, hpaned1, "hpaned1");
  GLADE_HOOKUP_OBJECT (xfmime_edit, scrolledwindow3, "scrolledwindow3");
  GLADE_HOOKUP_OBJECT (xfmime_edit, treeview1, "treeview1");
  GLADE_HOOKUP_OBJECT (xfmime_edit, scrolledwindow2, "scrolledwindow2");
  GLADE_HOOKUP_OBJECT (xfmime_edit, treeview2, "treeview2");
  GLADE_HOOKUP_OBJECT (xfmime_edit, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (xfmime_edit, optionmenu2, "optionmenu2");
  GLADE_HOOKUP_OBJECT (xfmime_edit, hbuttonbox1, "hbuttonbox1");
  GLADE_HOOKUP_OBJECT (xfmime_edit, save, "save");
  GLADE_HOOKUP_OBJECT (xfmime_edit, quit, "quit");
  /* populate themes in option menu... */
  {
    DIR *directory;
    struct dirent *d;
    GSList *tmp,*theme_list=NULL;
    gchar **p,*dirs[]={"/usr/share/icons","/usr/local/share/icons",NULL};
    
    for (p=dirs; *p; p++){
	gchar *g;
	directory = opendir(*p);
	if(!directory) {
	    fprintf(stderr,"cannot open %s for read\n",*p);
	    continue;
	}
	while((d = readdir(directory)) != NULL)
	{
	    int ok;
	    if(strncmp(d->d_name, ".",1)==0)  continue;
	    if (strcmp(d->d_name,"hicolor")==0) continue;
	    g=g_build_filename(*p,d->d_name,"index.theme",NULL);
	    ok=g_file_test(g,G_FILE_TEST_EXISTS);
	    g_free(g);
	    if(!ok) continue;
	    if (strcmp(name,d->d_name)) theme_list = g_slist_append(theme_list,g_strdup(d->d_name));
	    else theme_list = g_slist_prepend(theme_list,g_strdup(d->d_name));
	}
	closedir(directory);
    }
    fill_string_option_menu ((GtkOptionMenu *)optionmenu2, theme_list);
    for (tmp=theme_list; tmp; tmp=tmp->next){
	g_free(tmp->data);
    }
    g_slist_free(theme_list);
  }

  return xfmime_edit;
}

