/*
 * Copyright (C) 2002-2005 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <dirent.h>
#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <dbh.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"
#include "actions_lib.h"
#include "combo-module.h"


#define RECENT_DBH "xffm","histories","xffm.recent.2.dbh"
#define COUNT_FILE_DIR "xffm"

/*#define IS_RECENT_TYPE(x) ((x)?strcmp((x)->module,"xffm_recent")==0:FALSE)
#define IS_FREQUENT_TYPE(x) ((x)?strcmp((x)->module,"xffm_frequent")==0:FALSE)*/

#define RECENT_DAYS (recent_days)
#define RECENT_TIME (RECENT_DAYS * 24 *3600)
#define FREQUENT_TIME	(frequent_count)
static GtkWidget *private_popup_widget=NULL;

static DBHashTable *recentbin = NULL;
static time_t now;
static const regex_t *target_preg;
static gboolean just_count;
static gboolean frequent;
static xfdir_t recent_xfdir;
static int target_type;
static unsigned int recentcount;
static unsigned frequent_count, recent_days;
static time_t historytime=0;
static DBHashTable * newbin;
static GList *undo_list=NULL;
static widgets_t *widgets_pW;


static void *monitor_dbh(record_entry_t *en){
    gchar *recentfile = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);
    struct stat st;
    void *result=NULL;
    TRACE("\n%s: <<<history 0x%x",module_name,(unsigned)historytime);

    if (stat(recentfile,&st) >= 0 && historytime != st.st_mtime){
	TRACE("TRACE: refreshing history 0x%x != 0x%x\n",(unsigned)historytime,(unsigned)st.st_mtime);
	result = GINT_TO_POINTER(1);
    }
    g_free(recentfile);
    return result;
}



static void
saveit(char *recentfile,char *path){
    DBHashTable *dbh;
    dbh=DBH_open(recentfile);
      if (dbh) {
	GString *gs;
	int hits=0;
	history_dbh_t *history_dbh;
	history_dbh = (history_dbh_t *)DBH_DATA(dbh);
	gs = g_string_new(path);
	sprintf((char *)DBH_KEY(dbh), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (DBH_load(dbh)){
	    hits = history_dbh->hits;
	} 
	DBH_close(dbh);
	/*if (hits < FREQUENT_TIME) continue;*/
      }
    return;
}

// FIXME: update for entire iconview list, just as you do for
// all treeviews...
static
int private_add2history(widgets_t *widgets_p, char *path)
{
    gchar *recentfile = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);
    GtkTreeIter iter, child;
    record_entry_t *en;
    int i,k;
    gboolean saved=FALSE;
    
    if (!path) return 0;
    
    TRACE("adding to recent: %s\n",path);
    if (xffm_details->arbol) (*xffm_details->arbol->set_load_wait)();
    
    COMBO_save_to_history(recentfile,path);
    /*{
	struct stat st;
	if (stat(recentfile,&st) >= 0) historytime[IS_FREQUENT_TYPE(en)]=st.st_mtime;
    }*/

    
    /* if recent loaded, check if path is in there,
     * if not, then add the row to the treeview. */
    if (widgets_p->type==ICONVIEW_TYPE) {
	saveit(recentfile,path);
    } else  if (widgets_p->type==TREEVIEW_TYPE) {
     for (k=0; k<TREECOUNT; k++){
      GtkTreeModel *treemodel=NULL;
      GtkTreeView * treeview = xffm_details->arbol->treestuff[k].treeview;
      if (treeview){
	  treemodel = gtk_tree_view_get_model(treeview);
      }
    	
      for (i=0;i<2;i++){
	if (i) {
	    if (!saved) saveit(recentfile,path);
	    saved=TRUE;
	    
	    /*if (hits < FREQUENT_TIME) continue;*/
	    if (!(*xffm_details->arbol->find_module_root)(treeview,&iter, &en,"xffm_frequent"))  continue;
	    (*xffm_details->arbol->get_module_root)(treeview, &iter, &en,"xffm_frequent");
	}
	else {
	    if (!(*xffm_details->arbol->find_module_root)(treeview,&iter, &en,"xffm_recent")) continue;
	    (*xffm_details->arbol->get_module_root)(treeview, &iter, &en,"xffm_recent");
	}
    
	TRACE("recent/frequent root is %s, isloaded=%d\n",en->path,IS_LOADED(en->type));
	if (IS_LOADED(en->type))
	{
	    /* check if not already there, if there, then just update...*/
	    gboolean found=FALSE;	
	    if(gtk_tree_model_iter_children(treemodel, &child, &iter)){
		do {
		    record_entry_t *c_en;
		    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
		    if (c_en && c_en->path && strlen(c_en->path) && strcmp(c_en->path,path)==0) found=TRUE;
		} while (gtk_tree_model_iter_next (treemodel,&child));    
	    }
	    if (!found){
		record_entry_t *c_en = stat_entry(path, en->type);
		if (c_en) {
		    gchar *g = g_path_get_basename(path);
		    (*xffm_details->arbol->add_row)(treemodel, &iter, NULL,NULL, c_en, g);
		    g_free(g);
		    (*xffm_details->arbol->erase_dummy_row)(treemodel, &iter,NULL);
		}
	    }
	} 
      } /* end for 0,1*/
     } /* end for k=all treeviews */
     (*xffm_details->arbol->unset_load_wait)();
    }
    return 1;
}


static void add_bin(DBHashTable * dbh)
{
    gchar *p;
    history_dbh_t *history = (history_dbh_t *)DBH_DATA(dbh);


    if (frequent && (history->hits < FREQUENT_TIME)) {
	return;
    }
    if (!frequent && now - history->last_hit > RECENT_TIME) {
	return;
    }
    
    p = g_path_get_basename(history->path);

    if(!p || strlen(p) < 1) return;
    if((target_preg && regexec(target_preg, (const char *)p, 0, NULL, 0)) || !g_file_test(history->path,G_FILE_TEST_EXISTS)) {
	g_free(p);
	return;
    }
    if(just_count) recentcount++;
    else {
	recent_xfdir.gl[recent_xfdir.pathc].en = stat_entry(history->path, target_type);
	if(!recent_xfdir.gl[recent_xfdir.pathc].en)
	{
	    g_warning("could not stat %s!!\n", history->path);
	    return;
	}
	recent_xfdir.gl[recent_xfdir.pathc].pathv = p;
	recent_xfdir.pathc++;
    }
    return;
}

static
xfdir_t *private_get_xfdir(record_entry_t *en, gboolean is_frequent)
{
    gchar *recentfile = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);

    
    recentcount = 0;		/* for count step */
    recent_xfdir.pathc = 0;	/* for read step */

    now = time(NULL);
    if (!en) return NULL;   

    if (is_frequent) frequent = TRUE; 
    else frequent = FALSE; 
    
    target_type = en->type;

    SET_LOADED(en->type);

    

    if (!g_file_test(recentfile,G_FILE_TEST_EXISTS)) {
errnoset:
	recent_xfdir.pathc=0;
	return &recent_xfdir;
    }
    if ((recentbin = DBH_openR(recentfile)) == NULL) {
nothing:
	recent_xfdir.pathc=0;
	return &recent_xfdir;
    }

/* returns compiled regex and sets filter in tree_entry */
    if (!en || !en->filter || strcmp(en->filter,"*")==0) {
	TRACE("target_preg is null");
	target_preg = NULL;
    }
    else {
	TRACE("target_preg is NOT null");
	target_preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
	/*target_preg = get_regex_filter(en);*/
    }

    just_count = TRUE;

    DBH_foreach_sweep(recentbin, add_bin);
    
    TRACE("TRACE:pathc=%d\n",recent_xfdir.pathc); 


    if(recentcount)
    {
	recent_xfdir.gl = (dir_t *) malloc(recentcount * sizeof(dir_t));
	if(!recent_xfdir.gl)
	{
	    DBH_close(recentbin);
	    goto errnoset;
	}
	just_count = FALSE;
	DBH_foreach_sweep(recentbin, add_bin);

	TRACE("TRACE:pathc=%d\n",recent_xfdir.pathc); 
	TRACE("TRACE:count=%d\n",recentcount); 

	DBH_close(recentbin);
    }
    else
    {
	DBH_close(recentbin);
	goto nothing;
    }

    {
	struct stat st;
	if (stat(recentfile,&st) >= 0) {
	    TRACE("TRACE: setting historytime=0x%x\n",(unsigned)st.st_mtime);
	    historytime=st.st_mtime;
	    TRACE("TRACE: rhistory 0x%x\n",(unsigned)historytime);
	}
    }
    return &recent_xfdir;
}



static void clear_bin(DBHashTable * dbh)
{
    history_dbh_t *history = (history_dbh_t *)DBH_DATA(dbh);
    if (frequent) {
	history->hits = 0;
    } else {
	history->last_hit = 0;
    }
    memcpy((void *)DBH_KEY(newbin),(void *)DBH_KEY(dbh),DBH_KEYLENGTH(dbh));
    memcpy(DBH_DATA(newbin),DBH_DATA(dbh),DBH_RECORD_SIZE(dbh));
    DBH_set_recordsize(newbin,DBH_RECORD_SIZE(dbh));
    if (history->hits || history->last_hit) DBH_update(newbin);
    return;
}

static
void on_clear(GtkWidget *w,gboolean is_frequent)
{
    GtkTreeIter parent;
    record_entry_t *en;
    GtkTreeView *treeview=NULL;
    GtkTreeModel *treemodel;
    const gchar *module_name=(is_frequent?"xffm_frequent":"xffm_recent");
    frequent = is_frequent;
  
    if (xffm_details->arbol) {
	gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
	treeview = xffm_details->arbol->treestuff[tree_id].treeview;
	treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;

	if ((*xffm_details->arbol->find_module_root)(treeview,&parent,&en,module_name)){
	    (*xffm_details->arbol->prune_row)(treemodel, &parent, NULL, en);
	    (*xffm_details->arbol->insert_dummy_row)(treemodel, &parent, NULL, en,NULL,NULL);
	}
    }

    if (fork()==0) {
	gchar *recentfile = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);
	gchar *n = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);
	gchar *newfile = g_strconcat(n,".new",NULL);
	g_free(n);
	
	if ((recentbin = DBH_open(recentfile)) != NULL){
	    if ((newbin=DBH_create(newfile,DBH_KEYLENGTH(recentbin)))!=NULL){
		DBH_foreach_sweep(recentbin, clear_bin);
		DBH_close(recentbin);
		DBH_close(newbin);
		unlink(recentfile);
		rename(newfile,recentfile);
	    } else {
		g_warning("Cannot create %s",newfile);
		DBH_close(recentbin);
	    }
	}
	else g_warning("Cannot open %s",recentfile);
	g_free(recentfile);	
	g_free(newfile);	
	_exit(321);
    }
    if (en) UNSET_LOADED(en->type);  
}

#if 0
static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeRowReference *reference;
    GtkTreeIter parent;
    record_entry_t *p_en;
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en) {
	return;
    }
    if (gtk_tree_model_iter_parent(treemodel, &parent, iter)){
        gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
        if (p_en && p_en->module) {
	    if (strcmp(p_en->module,module_id)!=0) return;
	}	
    }

    reference = gtk_tree_row_reference_new(treemodel, path);
    undo_list = g_list_prepend(undo_list, reference);    
    return;
}

#endif

static
void undo_history(GtkMenuItem * menuitem, gpointer data){
    widgets_t *widgets_p=(widgets_t *)data;
    gchar *recentfile;
    GList *tmp;
    record_entry_t *en;

    en = xffm_get_selected_entry(widgets_p);
// FIXME: only one item can be removed at a time (should also fix in find module)
    if (undo_list) {
	g_list_free(undo_list);
	undo_list=NULL;
    }
    if (en && en->path) undo_list=g_list_append(undo_list,en);
   
    
    if (!undo_list) {
	g_warning("%s",strerror(EINVAL));
	goto done;
    }
    {
      recentfile = g_build_filename(xdg_cache_dir(),RECENT_DBH,NULL);
    }
    if ((recentbin = DBH_open(recentfile)) != NULL){
      for (tmp=undo_list;tmp;tmp=tmp->next){
	GString *gs;
	record_entry_t *en;
	history_dbh_t *history = (history_dbh_t *)DBH_DATA(recentbin);
	TRACE("data=0x%x",(unsigned)tmp->data);
	if (!tmp->data) continue;
	en=(record_entry_t *)tmp->data;
	if (!en) continue;
	TRACE("..data=0x%x",(unsigned)tmp->data);
	gs = g_string_new(en->path);
	sprintf((char *)DBH_KEY(recentbin), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (DBH_load(recentbin)){
	    if (strcmp(module_id,"xffm_frequent")==0) {
		TRACE("history->hits = 0;");
		history->hits = 0; 
		DBH_update(recentbin);
	    } else if (strcmp(module_id,"xffm_recent")==0){
		TRACE("history->last_hit = 0;");
		history->last_hit = 0;
		DBH_update(recentbin);
	    } else {
		g_warning("entry is not correct type");
	    }
	}
      }
      DBH_close(recentbin);
    }
    /*if (stat(recentfile,&st) >= 0) historytime=st.st_mtime;*/
done:
    xffm_refresh_parent(widgets_p);
  return;
}

static 
void
write_to_file(const gchar *filename,unsigned int value){
    FILE *rc;
    gchar *recentfile = g_build_filename(xdg_config_dir(),COUNT_FILE_DIR,filename,NULL);
    rc=fopen(recentfile,"w");
    if (rc) {
        fprintf(rc,"%u",value);
        fclose(rc);
    }
    g_free(recentfile);
}

static 
unsigned int
read_from_file(const gchar *filename){
    FILE *rc;
    unsigned int value;
    gchar *recentfile = g_build_filename(xdg_config_dir(),COUNT_FILE_DIR,filename,NULL);
    rc=fopen(recentfile,"r");
    if (!rc) return 0;
    fscanf(rc,"%u",&value);
    fclose(rc);
    g_free(recentfile);
    return value;
}


static 
void 
set_threshold_activate(GtkMenuItem * menuitem, widgets_t *widgets_p,gboolean is_frequent)
{
        /* create the dialog */
    int response = GTK_RESPONSE_NONE;
    gchar *t;
    GtkWidget *hbox,*label,*entry,*button,*dialog = gtk_dialog_new();

    gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (widgets_p->window));
    
    place_dialog(widgets_p->window, dialog);
    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER (dialog), 6);

    if (is_frequent) {
	label=gtk_label_new(_("Hits"));
	gtk_window_set_title (GTK_WINDOW (dialog), _("Set frequency threshold"));
	t=g_strdup_printf("%d",frequent_count);
    }
    else {
	label=gtk_label_new(_("Days"));
	gtk_window_set_title (GTK_WINDOW (dialog), _("Set recent threshold"));
	t=g_strdup_printf("%d",recent_days);
    }

    
    entry=gtk_entry_new();

    gtk_entry_set_text(GTK_ENTRY(entry),t);
    hbox=gtk_hbox_new(FALSE, 6);
    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 0);
    gtk_widget_show_all (hbox);
   

    button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button,
                                  GTK_RESPONSE_CANCEL);
    button = gtk_button_new_from_stock (GTK_STOCK_OK);
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button,
                                  GTK_RESPONSE_YES);

    /* show dialog and return */
    response = gtk_dialog_run (GTK_DIALOG (dialog));
    if (response == GTK_RESPONSE_YES){
	if (is_frequent) {
	    frequent_count = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
	    write_to_file("frequentrc",frequent_count);
	}
	else {
	    recent_days = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
	    write_to_file("recentrc",recent_days);
	}
    }
    gtk_widget_hide (dialog);
    gtk_widget_destroy (dialog); 

}
static 
void 
on_set_recent_threshold_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    set_threshold_activate(menuitem,(widgets_t *)user_data,FALSE);
}
static 
void 
on_set_frequent_threshold_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    set_threshold_activate(menuitem,(widgets_t *)user_data,TRUE);
}

static
void on_clear_recent_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   on_clear((GtkWidget *) menuitem,GPOINTER_TO_INT(user_data));    
}

static
void frequent_refresh_activate(GtkMenuItem * menuitem, gpointer data)
{
    widgets_t *widgets_p=(widgets_t *)data;
    xffm_refresh(widgets_p);
}

static
void *
do_private_popup(void *p, void *q, gboolean is_frequent){
    record_entry_t *en=(record_entry_t *)p;
    widgets_t *widgets_p=(widgets_t *)q;
    if (!en) return NULL;
    if(!IS_ROOT_TYPE(en->type)){
	return NULL;
    }
    if (private_popup_widget) gtk_widget_destroy(private_popup_widget);
    {
	GtkWidget *w;
	private_popup_widget=gui_mk_menu(
	  widgets_p,		  /* window */
	  (is_frequent?_("Frequent"):_("Recent")), /* label */
	  NULL,   /* name */
	  NULL, 	  /* parent */
	  NULL,NULL); /* callback (or NULL)*/

	if (widgets_p->back_activate) {
	    w = gtk_image_menu_item_new_with_mnemonic (_("Back"));
	    gui_mk_pixmap_menu(widgets_p, "xffm/stock_go-back",w,MENU_PIXMAP);
	    gtk_widget_show (w);
	    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	    g_signal_connect ((gpointer) w, "activate",
                   G_CALLBACK (widgets_p->back_activate),
                   widgets_p);

	}

	if (widgets_p->type==TREEVIEW_TYPE) {
	    w = gtk_image_menu_item_new_with_mnemonic (_("Reload"));
	    gui_mk_pixmap_menu(widgets_p, "xffm/stock_refresh",w,MENU_PIXMAP);
	    gtk_widget_show (w);
	    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	    g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (frequent_refresh_activate),
                    widgets_p);
	}
	
        if (is_frequent) w = gtk_image_menu_item_new_with_mnemonic (_("Set frequency threshold"));
	else w = gtk_image_menu_item_new_with_mnemonic (_("Set recent threshold"));
	gui_mk_pixmap_menu(widgets_p, "xffm/question",w,MENU_PIXMAP);
	gtk_widget_show (w);
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	if (is_frequent) {
	    g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_set_frequent_threshold_activate),
                    widgets_p);
	} else {
	    g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_set_recent_threshold_activate),
                    widgets_p);
	}

        w = gtk_image_menu_item_new_with_mnemonic (_("Clear"));
	gui_mk_pixmap_menu(widgets_p, "xffm/stock_clear",w,MENU_PIXMAP);
	gtk_widget_show (w);
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	g_signal_connect ((gpointer) w, "activate",
		    G_CALLBACK (on_clear_recent_activate),
                    GINT_TO_POINTER(is_frequent));
	if (widgets_p->type==TREEVIEW_TYPE) 
	{
	    w = gtk_image_menu_item_new_with_mnemonic (_("Hide branch"));
	    gui_mk_pixmap_menu(widgets_p, "xffm/stock_remove",w,MENU_PIXMAP);
	    gtk_widget_show (w);
	    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	    g_signal_connect ((gpointer) w, "activate",
		    G_CALLBACK (xffm_details->arbol->hide_branch_activate),
                    NULL);
	}
    }
    gtk_menu_popup(GTK_MENU(private_popup_widget), NULL, NULL, NULL, NULL, 3, xffm_details->eventtime);	

    return GINT_TO_POINTER(1);
}


