/* (c) 2001-2005 Edscott Wilson Garcia GNU/GPL
 */

/*  functions to use tubo.c for listing contents of SMB shares 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 ****** SMBlist */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"
#include "smblookup.h"
#include "tubo.h"
#include "actions_lib.h"


#include "smb_challenges.i"
#include "smb_errors.i"
#include "smb_list.i"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT
LIBXFFM_MODULE


#define PARENT_MODULE "xffm_smb_ws"
#define CURRENT_MODULE "xffm_smb_list"

G_MODULE_EXPORT
const gchar * 
g_module_check_init(GModule *module){
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    TRACE("domain=%s", GETTEXT_PACKAGE);
#endif
    return NULL;
}

/****************   void  functions  ***********************/

G_MODULE_EXPORT
void *
get_netfile_cache_dir(void){
    static gchar *cache_dir=NULL;
    if (cache_dir) return (void *)cache_dir;

    cache_dir = g_build_filename(xdg_cache_dir(),"xffm","smb",NULL);  
    mkdir(cache_dir, 0770);
    if (!g_file_test(cache_dir,G_FILE_TEST_IS_DIR)) {
	g_free(cache_dir);
	cache_dir=NULL;
	return NULL;
    }
    
    return (void *)cache_dir;
}

G_MODULE_EXPORT
void *
module_name(void){
    return CURRENT_MODULE;
}

G_MODULE_EXPORT
void *
submodule_name(void){
    return CURRENT_MODULE;
}

G_MODULE_EXPORT
void *
clear_drop_entry(void){
    drop_en=NULL;
    return (GINT_TO_POINTER(1));
}

G_MODULE_EXPORT
void *
newdirectory_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
show_hidden_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
copy_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
cut_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
paste_menuitem(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xffm-samba";
}

/*******************  natural functions **********************/
G_MODULE_EXPORT
void *
date_column_string(void * p){
    return NULL;
}
G_MODULE_EXPORT
void *
size_column_string(void * p){
    static gchar *tag=NULL;
    record_entry_t *en=p;
    g_free(tag);
    if (!p) return ("");
    tag=g_strdup_printf("%ld",(long)en->st->st_size);
    return tag;
}
G_MODULE_EXPORT
void *
group_column_string(void * p){
    return ("");
}

G_MODULE_EXPORT
void *
owner_column_string(void * p){
    return ("");
}

G_MODULE_EXPORT
void *
mode_column_string(void * p){
    return NULL;
}
G_MODULE_EXPORT
void *
window_title(void * p){
    static gchar *t=NULL;
    record_entry_t *en=p;
    if (!en || !en->path) return NULL;
    g_free(t);
    t=g_strdup_printf(_("Xfsamba (%s)"),en->path);
    return (void *) t;
}


G_MODULE_EXPORT
void *
module_icon_id(void *p){
    record_entry_t *en = (record_entry_t *)p;
    if (!en) return "application/default";
    if(IS_XF_NETSHARE(en->subtype)) {
       return ("xfsmbshare.png");
    }
    if(IS_XF_NETIPC(en->subtype)) return ("xffm/ipc");
    if(IS_XF_NETPRINT(en->subtype)) return ("xffm/stock_print");
    if(IS_NETDIR(en->subtype)) { 
	 if (IS_EXPANDED(en->type)){
	      return "xffm/open_folder";
   	 } else {
	      return "xffm/closed_folder";
	 }
    }
    {
	    const gchar *g=MIME_get_type(en->path,FALSE);
	    if (strcmp(g,"undetermined type")==0) return "application/default";
	    else return (void *)g;
    }
}

G_MODULE_EXPORT
void *
parent_module_name(void *p){
    record_entry_t *en=(record_entry_t *)p;
    gchar *out;
    if (!en || !en->path || strlen(en->path)<2){
	TRACE("parent_module_name: !en || en->path (0x%x)",(unsigned)en);
	return PARENT_MODULE;
    }
    out=up_path(en->path);
    
	TRACE("parent_module_name: path found is %s",out);
    if (strchr(out+2,'/')==NULL){
	g_free(out);
	return PARENT_MODULE;
    }
    g_free(out);
    return CURRENT_MODULE;
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (IS_NETTHING(en->subtype)) return (void *)"Yes";
    return NULL;
}

G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en || !en->path) return NULL;
    return (GINT_TO_POINTER(1));
/*    if(IS_NETDIR(en->subtype)) return (GINT_TO_POINTER(1));
    if(IS_XF_NETSHARE(en->subtype)) return (GINT_TO_POINTER(1));

    TRACE("!valid_drop_site");
    return NULL;*/
}

G_MODULE_EXPORT
void *
set_drop_entry(void *p){
    drop_en=(record_entry_t *)p;
    return (GINT_TO_POINTER(1));
}

G_MODULE_EXPORT
void *
get_dnd_format(void *p){
    gchar *server,*n,*m;
    static gchar *format=NULL;
    record_entry_t *en=(record_entry_t *)p;

    if (!en || !en->path || !strlen(en->path)) return NULL;
    g_free(format);
    
    n=g_strdup(en->path);
    if (strncmp(n,"smb://",strlen("smb://"))==0) m=n+strlen("smb://");
    else if (strncmp(n,"SMB://",strlen("SMB://"))==0) m=n+strlen("SMB://");
    else if (strncmp(n,"//",strlen("//"))==0) m=n+strlen("//");
    else m=n;
    if (strchr(m,'/')) strtok(m,"/");   
    
    server=m;
    
    format = g_strdup_printf ("%s://%s@%s",
		 IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		 (en->tag)?en->tag:"GUEST%%",
		 server);
    g_free(n);
    TRACE("get_dnd_format:%s",format);
    
    return format;
}

G_MODULE_EXPORT
void *
get_dnd_path(void *p){
    gchar *n,*m, *remote_file;
    static gchar *dndpath=NULL;
    record_entry_t *en=(record_entry_t *)p;
    if (!en || !en->path || !strlen(en->path)) return NULL;
    g_free(dndpath);
    
    n=g_strdup(en->path);
    if (strncmp(n,"smb://",strlen("smb://"))==0) m=n+strlen("smb://");
    else if (strncmp(n,"SMB://",strlen("SMB://"))==0) m=n+strlen("SMB://");
    else if (strncmp(n,"//",strlen("//"))==0) m=n+strlen("//");
    else m=n;

    
    if (strchr(m,'/')) m=strstr(m,"/");   
    
    remote_file=g_strdup(m);

    if (IS_NETDIR(en->subtype) || IS_XF_NETSHARE(en->subtype)){
	dndpath = g_strdup_printf("%s/",remote_file);
    } else {
	dndpath = g_strdup_printf("%s",remote_file);
    }
    g_free(n);
    g_free(remote_file);
    TRACE("get_dnd_path: %s",dndpath);
    return dndpath;
}


/*******************  rational functions **********************/
G_MODULE_EXPORT
void *
up_entry(void *en_p,void *en_c){
    record_entry_t *en;
    gchar *n,*p;

    //if (!en_c || !((record_entry_t *)en_c)->path || !strchr(((record_entry_t *)en_c)->path,'/')) return NULL;
    if (!en_c || !((record_entry_t *)en_c)->path) return NULL;
    TRACE("copy entry: %s (kaput)",((record_entry_t *)en_c)->path);
    en = copy_entry((record_entry_t *)en_c);
    n=g_path_get_dirname(en->path);
    
    if (strncmp(n,"smb://",strlen("smb://"))==0) p=n+strlen("smb://");
    else if (strncmp(n,"SMB://",strlen("SMB://"))==0) p=n+strlen("SMB://");
    else if (strncmp(n,"//:",strlen("//"))==0) p=n+strlen("//");
    else p=n;
    g_free(en->path);
    en->path=n;

    if (!strchr(p,'/')){
	en->module=PARENT_MODULE;
	TRACE("new entry (parent module %s): %s",en->module,en->path);
    } else {
        TRACE("new entry: %s",en->path);
    }
    
    return (void *)en;
}

G_MODULE_EXPORT
void *
SMBget_cache_file(void *p,void *q){
	record_entry_t *en =(record_entry_t *)p;
	gchar *n,*m,*server,*remote_file;
	static gchar *file=NULL;
    widgets_t *widgets_p=(widgets_t *)q;
	
	GList *list=NULL;
	TRACE("%s is netfile",en->path);
	set_private_variables(q);
	
	/* download */
    n=g_strdup(en->path);
    if (strncmp(n,"smb://",strlen("smb://"))==0) m=n+strlen("smb://");
    else if (strncmp(n,"SMB://",strlen("SMB://"))==0) m=n+strlen("SMB://");
    else if (strncmp(n,"//",strlen("//"))==0) m=n+strlen("//");
    else m=n;
    if (strchr(m,'/')) strtok(m,"/");   
    
    server=m;
	remote_file=server+strlen(server)+1;
	TRACE("%s is netfile",remote_file);
	g_free(file);
	file = g_strdup_printf ("%s://%s@%s/%s\n",
		  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		  (en->tag)?en->tag:"GUEST%%",
		  server,remote_file);
	remote_file=g_path_get_basename(remote_file);
	g_free(n);
	uri_parse_list(file, &list);
	g_free(file);
	file=g_build_filename(get_netfile_cache_dir(),remote_file,NULL);
	g_free(remote_file);
#ifdef USE_NPIPE
#undef USE_NPIPE
#endif
#ifdef USE_NPIPE
	/* using named pipes does not work too well, because read/write
	 * is blocking. Thus the application may block depending on
	 * unpredictable user response...
	 * thus it is avoided for 4.2.x*/
	mkfifo(file,0660);
	private_GetFile(q,(gchar *)get_netfile_cache_dir(), list);
#else
	private_GetFile(q,(gchar *)get_netfile_cache_dir(), list);
	smb_wait(TRUE,widgets_p);
#endif
	TRACE("got file... (probably)");
        list = uri_free_list(list);

	return (void *)file;
}

/*****************************************************************/

G_MODULE_EXPORT
void *
SMBGetFile(void *p, void *q){

    if (!drop_en || !drop_en->path) {
	g_warning("!drop_en || !drop_en->path");
	return NULL;
    }
    set_private_variables(q);
    TRACE("at SMBGetFile");
    private_GetFile(q,drop_en->path, (GList *)p);
    return (GINT_TO_POINTER(1));
}

G_MODULE_EXPORT
void *
process_drop(void *p, void *q){
    gchar *tmpfile=NULL;
    GList *list=(GList *)p;
    gchar *target;
    widgets_t *widgets_p=(widgets_t *)q;

    set_private_variables(q);
    if (!drop_en) return NULL;
	
    cursor_wait(widgets_p->window);
    if(IS_NETDIR(drop_en->subtype) || 
	 IS_XF_NETSHARE(drop_en->subtype)|| 
	 IS_NETFILE(drop_en->subtype) 
      ){
        
      if (IS_XF_NETSHARE(drop_en->subtype)){
        target=g_strdup("/"); 	    
      } else {
	gchar *p,*m,*n=g_strdup(drop_en->path);
	if (strncmp(n,"smb://",strlen("smb://"))==0) m=n+strlen("smb://");
	else if (strncmp(n,"SMB://",strlen("SMB://"))==0) m=n+strlen("SMB://");
	else if (strncmp(n,"//",strlen("//"))==0) m=n+strlen("//");
	else m=n;
	p=strstr(m,"/")+1;
	target=g_strdup(strstr(p,"/"));
        if (IS_NETFILE(drop_en->subtype)) *strrchr(target,'/')=0;
	g_free(n);
      } 
     TRACE("TRACE:target=%s\n",target);
      
      tmpfile=CreateSMBTmpList(list,target,
		      IS_SAMBA_SERVER(drop_en->subtype),
		      widgets_p);
      g_free(target);
      target=NULL;
      if (!tmpfile) {
         TRACE("dbg:null tmpfile\n");
         /*fprintf(stderr,"dbg:null tmpfile\n");*/
	cursor_reset(widgets_p->window);
	 return NULL;
      }
      else TRACE("dbg:tmpfile=%s\n",tmpfile);
      SMBDropFile (drop_en,tmpfile,widgets_p);
    }
      cursor_reset(widgets_p->window);
  
    return (GINT_TO_POINTER(1));
}

G_MODULE_EXPORT
void *
extend_popup(void *p, void *q){
	set_private_variables(q);
    if (GTK_IS_CONTAINER (p)) {
	return NULL;
    } else {
	record_entry_t *en=(record_entry_t *)p;
	if (!en) return NULL;
	if(IS_NETFILE(en->subtype)) return GINT_TO_POINTER(1);
	if(IS_NETDIR(en->subtype)) return GINT_TO_POINTER(1);
	return NULL;
    }
}

G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    set_private_variables(q);
    widgets_t *widgets_p=(widgets_t *)q;
    return private_get_xfdir(en, widgets_p);
}

G_MODULE_EXPORT
void *
double_click(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    widgets_t *widgets_p=(widgets_t *)q;
    set_private_variables(q);
    if (!en || IS_NETDIR(en->subtype) || !IS_NETFILE(en->subtype)|| !en->path) {
	TRACE("xfsamba: nothing to do with double click");
	return NULL;
    }
    {
	      const gchar *prg = MIME_command (en->path);
	      if (!prg) {
		  xffm_open_with(widgets_p, en);
	      }
	      else {
		/* do double click action */
		/* double click on downloaded file */
		const gchar *file=SMBget_cache_file(en,widgets_p);
		record_entry_t *tmp_en = NULL;
		if (file) {
		    tmp_en=stat_entry ((gchar *)file, __LOCAL_TYPE);
		    TRACE("xfsamba: cache file is be %s for %s",file,en->path);
		}
		else {
		    TRACE("xfsamba: no cache file available for %s",en->path);
		}
		    
		if (!tmp_en){
		    print_diagnostics(widgets_p,"xffm/error",strerror(EINVAL),": ",file,NULL);
		} else {
		    /*XXX remove the executable bit... */
		    chmod (file,tmp_en->st->st_mode & (0777 ^ (S_IXUSR|S_IXGRP|S_IXOTH)));
		    tmp_en->st->st_mode &= (0777 ^ (S_IXUSR|S_IXGRP|S_IXOTH));	    
		    TRACE("created entry for %s",file);
		    xffm_open_with(widgets_p, tmp_en);
		    destroy_entry(tmp_en); 
		}
	      }
    }
    

    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
on_new_dir(void *p, void *q){
    record_entry_t *t_en=(record_entry_t *)p;
    widgets_t *widgets_p=(widgets_t *)q;
    
    TRACE("+module on_newdir...");
	set_private_variables(q);
    if (!t_en){
	g_warning("p==NULL");
	return GINT_TO_POINTER(2);
    }
      cursor_wait(widgets_p->window);

    /*if (!IS_NETDIR(t_en->subtype) && !IS_XF_NETSHARE(t_en->subtype)) {
	g_warning("incorrect entry type");
	return GINT_TO_POINTER(3);
    }*/
    {
	GtkTreeIter iter;
	GtkTreePath *treepath;
	GtkTreeRowReference *reference;
        GtkTreeModel *treemodel=NULL;
	GtkTreeView *treeview=NULL;
	GtkEntry *entry = (GtkEntry *) lookup_widget(widgets_p->window,"input_entry");
	gchar *the_name= g_strdup((gchar *)gtk_entry_get_text(entry));
	
        if (widgets_p->type==TREEVIEW_TYPE) {
	    record_entry_t *en;
	    int tree_id=(*xffm_details->arbol->get_active_tree_id)();
	    treeview=xffm_details->arbol->treestuff[tree_id].treeview;
	    treemodel = gtk_tree_view_get_model(treeview);
	    if (!(*xffm_details->arbol->get_selectpath_iter)(&iter,&en)) return FALSE; 
	    treepath=gtk_tree_model_get_path(treemodel,&iter);
	    reference = gtk_tree_row_reference_new(treemodel, treepath);
	    gtk_tree_path_free(treepath);
	} else if (widgets_p->type==ICONVIEW_TYPE){
	    gtk_paned_set_position(GTK_PANED(widgets_p->vpane), 10000);
	} else {
	    g_warning("incorrect parameters");
	    cursor_reset(widgets_p->window);
	    return GINT_TO_POINTER(4);
	}
    TRACE("module on_new...SMBmkdir");
	
	SMBmkdir (treeview,t_en,&iter,the_name,widgets_p);
	xffm_refresh(widgets_p);	    
	    
	g_free(the_name);
    }	   
      cursor_reset(widgets_p->window);
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
on_remove(void *p, void *q) 
{
      gchar *rmfile=NULL;
      widgets_t *widgets_p=(widgets_t *)q;
      
      GList *remote_remove_list = (GList *)p;

      WIDGET_P_CHECK;
      set_private_variables(widgets_p);

      
      /* the remove list will be in record entries  */
      gchar *remote_pass=NULL;
    
      
      cursor_wait(widgets_p->window);
	
      set_private_variables(widgets_p);
 
    

      remote_pass=get_remote_pass(remote_remove_list);
      TRACE("TRACE: this here creates the rm command file...\n");
      rmfile=CreateRmTmpList(remote_remove_list);
      TRACE("done with the rm command file...\n");
      if (!rmfile || !remote_pass){
	      print_diagnostics(widgets_p,"xffm/error",strerror(EACCES),NULL);
	      if (rmfile) unlink(rmfile);
      }
      else {
	    gchar *remote_location;
	    TRACE("remote location is...");
	    remote_location=get_remote_location(remote_remove_list);
	    TRACE("%s\n",remote_location);
            TRACE("TRACE: this here does the SMB delete:%s \n",rmfile);
	     query_result=SUCCESS;
	     SMBrmFile (remote_location,
			     remote_pass,
			     rmfile,
			     widgets_p);
	     g_free(remote_location);
	    
	     unlink(rmfile);
    	     print_status(widgets_p,"xffm/info", _("Command done"), NULL);

#if 0
	     
	     if (query_result==SUCCESS && xffm_details->arbol->widgets.window){
		 GList *tmp=remote_remove_list;
		 GtkTreeModel *treemodel=xffm_details->arbol->treestuff[get_active_tree_id()].treemodel;
		 for (;tmp;tmp=tmp->next){
		     remove_row(treemodel,NULL,
			     (GtkTreeRowReference *)tmp->data,
			     NULL);
	 
		 }
	     } 
	     /* refresh is automatic with iconview, should be with
	      * treeview as well...*/	
#endif
      }
      g_free(rmfile);
      g_free(remote_pass);
      cursor_reset(widgets_p->window);
   return GINT_TO_POINTER(1);
}

