/* (c) 2001-2005 Edscott Wilson Garcia GNU/GPL
 */

/*  functions to use tubo.c for listing contents of SMB shares 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  

 ****** SMBlist */


static record_entry_t *drop_en=NULL;

static GtkTreeView *smb_treeview;

static int query_result;
static void *smb_object;

static GList *listing=NULL;
/*static int input_over;*/
/* These variables *must* be thread safe (hence, use of _POSIX_PATH_MAX): */
static  char smb_server[_POSIX_PATH_MAX];
static  char smb_share[_POSIX_PATH_MAX];
static  char smb_dir[_POSIX_PATH_MAX];
static xfdir_t smb_xfdir;
static int smb_count;
static gboolean samba_server;
static gboolean showing_hidden;
enum {
	SHARE_NAME_COLUMN,
	SHARE_SIZE_COLUMN,
	SHARE_DATE_COLUMN,
	SHARE_COLUMNS
};

static void set_private_variables(widgets_t *widgets_p){
   if (widgets_p->type==TREEVIEW_TYPE) {
      int tree_id=(*xffm_details->arbol->get_active_tree_id)();
      smb_treeview=xffm_details->arbol->treestuff[tree_id].treeview;
  }
  else {
      smb_treeview=NULL;
  }    
}


#include "smb_download.i"


 
/* function to be run by parent after child has exited
*  and all data in pipe has been read : */
static void SMBListForkOver (pid_t pid, void *user_data){
    widgets_t *widgets_p=user_data;
  
  switch (query_result)
  {
  case CHALLENGED:
    print_status(widgets_p,"xffm/warning",
		    _("Query password has been requested"),
		    NULL);
    break;
  case FAILED:
    print_status(widgets_p,"xffm/error",
		    _("SMB query failed"),
		    NULL);
  default:

    print_status(widgets_p,"xffm/info",
		    _("Retrieve done"),
		    NULL);
    break;

  }
  smb_object=NULL;
}

static
xfdir_t *
private_get_xfdir (record_entry_t *en, widgets_t *widgets_p)
	//	char *pass,gboolean show_hidden)
{
  char *argument[7];
  char NMBcommand[_POSIX_PATH_MAX];
  char NMBshare[_POSIX_PATH_MAX];
  int i;
  if (!en) return NULL;
  TRACE("en=0x%x",(unsigned)en);
  if (!en->path || !strchr(en->path,'/')) return NULL;
  //init_smb_list(en->path,show_hidden);
  init_smb_list(en->path,SHOWS_HIDDEN(en->type));
  
and_ask_again:
  query_result=SUCCESS;
  if (en->tag) g_strstrip(en->tag);
  
 
  snprintf(NMBshare,_POSIX_PATH_MAX-1, "%s/%s",smb_server,smb_share);
  NMBshare[_POSIX_PATH_MAX-1]=0;
 
  if (strlen(smb_dir)){
     snprintf (NMBcommand,_POSIX_PATH_MAX-1, "ls \\\"%s\\\"/*", smb_dir);
     NMBcommand[_POSIX_PATH_MAX-1]=0;
  } else sprintf (NMBcommand, "ls /*");



  i=0;
  argument[i++]="smbclient";
  argument[i++]=NMBshare;
  argument[i++]="-U";
  if (en->tag && strlen(en->tag)) {
    argument[i++]=en->tag;
  }
  else {
    argument[i++]="GUEST%%";
  }
  argument[i++]="-c";
  argument[i++]=NMBcommand;
  argument[i++]=0;
  
  print_status(widgets_p,NULL,_("Retrieving..."),NULL);
  print_diagnostics(widgets_p,NULL,"XFSAMBA> ",
		  "smbclient"," ",NMBshare," ",
#ifdef DEBUG
		  "-U"," ",en->tag," ",
#endif
		  "-c", " ",NMBcommand,"\n",
		  NULL);

    show_text(widgets_p);
  smb_object = Tubo_full (fork_function,
	(void *)argument, 
	SMBListForkOver, 
	NULL, 
	SMBListStdout, 
	smb_stderr,widgets_p,15);
  while (smb_object){
     if (widgets_p->progress) set_progress_generic(widgets_p,-1,-1,1);
     while (gtk_events_pending()) gtk_main_iteration();
     usleep(5000);
  }
  if (query_result==SUCCESS && listing){
        smb_xfdir.pathc = g_list_length(listing);
        smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
	smb_count=0;
	g_list_foreach(listing,printout_listing,(gpointer)(en->tag));
        //hide_stop();
  } else if (query_result==SUCCESS && !listing){
        smb_xfdir.pathc = 0;
  } else if (query_result== CHALLENGED){
	const char *p;
        smb_xfdir.pathc = 0;
	p=xffm_get_smbuserpass(widgets_p,en);
       	if (p && strlen(p)) {
	       g_free(en->tag);
	       en->tag=g_strdup(p);
	       goto and_ask_again;
	} 	
  }else {
        smb_xfdir.pathc = 0;
  }
    hide_text(widgets_p->diagnostics);
  return (&smb_xfdir);
}
/**********************************************************/
static 
gchar *
up_path( gchar *in){
    
    gchar *out=g_strconcat(in,"/",NULL);
    TRACE("up_path: dupping %s->%s",in,out);
    /*if (strlen(out)>2 && strrchr(out+2,'/')) *(strrchr(out+2,'/')) = 0;
    TRACE("up_path: and then, out is %s",out);*/
    return out;
}

static gboolean is_netshare(char *path){
    TRACE("is_netshare: %s",path);
    if (strlen(path)>2){
	gchar *p= strchr(path+2,'/');
	if (!p) return FALSE;
	if (!strchr(p+1,'/')) return TRUE;
    }
    return FALSE;
}

static
void
SMBmkdir (GtkTreeView *treeview,record_entry_t *t_en,
	       GtkTreeIter *iter,gchar *name,
	       widgets_t *widgets_p)
{
  char *argv[12];
  gchar *m,*n,*t,*g=NULL,*target=NULL;
  gchar *command=NULL;

  GtkTreeModel *treemodel = NULL;
  TRACE("target=%s, name=%s",t_en->path,name);

  if (treeview) treemodel = gtk_tree_view_get_model(treeview);

  /* this should no longer be necessary...
  if (!IS_XF_NETSHARE(t_en->subtype) && 
	!IS_NETDIR(t_en->subtype))  return;*/
  init_smb_list(t_en->path,SHOWS_HIDDEN(t_en->type));
  
  argv[0]="smbclient";
  n=g_strdup(t_en->path);
  if (strncmp(n,"smb:",strlen("smb:"))==0) m=n+strlen("smb:");
  else if (strncmp(n,"SMB:",strlen("SMB:"))==0) m=n+strlen("SMB:");
  else m=n;
  t=g_strdup(m);
  g=g_strdup(m);
  g_free(n);
   
  n=strchr(g+2,'/');
  if (strchr(n+1,'/')) *(strchr(n+1,'/'))=0;
  

  if (is_netshare(t)){
    target=g_strdup("/"); 	    
  } else {
    gchar *p;
    n=strchr(t+2,'/')+1;
    p=strchr(n,'/');
    target=g_strdup(p);
  } 

  TRACE("server=%s target=%s",g,target);
  command=g_strconcat("cd /;cd \"",target,"\";mkdir \"",name,"\";\n",NULL);
  TRACE("command=%s",command);
  
  g_free(t);
  g_free(target);
  target=NULL;
  
  argv[1]=g;
  argv[2]="-U";
  argv[3]=t_en->tag; /* user%pass */
  argv[4]="-c";
  argv[5]=command;
  argv[6]=0;
  
   
  show_text(widgets_p);
  print_diagnostics(widgets_p,NULL, "mkdir",t_en->path,"/",name,"\n",NULL);
  print_status(widgets_p,"xffm/warning","mkdir...",NULL);

   TRACE("%s %s %s %s %s %s",argv[0],argv[1],argv[2],argv[3],
		  argv[4],argv[5]); 
  
  
  /* wait until OK to proceed */
  smb_wait(FALSE,widgets_p);
  if(treeview) (*xffm_details->arbol->reset_dummy_row)(treemodel,iter,NULL,NULL,"xffm/warning",_("Loading..."));
  
    show_text(widgets_p);
  smb_object = Tubo_full (fork_function, 
		  (void *)argv,
		  SMBDropForkOver, 
		  NULL, 
		  SMBListStdout,
		  smb_stderr,widgets_p,15);

  smb_wait(TRUE,widgets_p);
    hide_text(widgets_p->diagnostics);
  g_free(g);  
  g_free(command);
  cursor_reset (widgets_p->window);
  return;
}


static
void
private_GetFile (widgets_t *widgets_p,char *target,GList *list)
{
  char *dndS,*host=NULL,*user,*orig_share=NULL,*share,*file,*filename=NULL;
  gchar *url;
  gchar *s;
  gchar *fname;
  FILE *tmpfile=NULL;
  char *w;
  int i;
  static gchar *SMBtmpfile=NULL;
  gboolean first=TRUE,isdir;
  gboolean samba_server=FALSE;
  

  TRACE("target is %s",target);  
  
  if (widgets_p->type==TREEVIEW_TYPE) {
      int tree_id=(*xffm_details->arbol->get_active_tree_id)();
      smb_treeview=xffm_details->arbol->treestuff[tree_id].treeview;
  }
  else  {
      smb_treeview=NULL;
  }   
  s=g_find_program_in_path("smbclient");
  if (!s){
	  print_diagnostics(widgets_p,"xffm/error",strerror(ENOENT),":","smbclient","\n",NULL);
	  return;
  }

  if ((fname=randomTmpName(NULL))==NULL) return;
    if ((tmpfile=fopen(fname,"w"))==NULL) {
	print_diagnostics(widgets_p,"xffm/error",strerror(EPERM),":",(fname)?fname:"?","\n",NULL);
	g_free(fname);
	return;
  }
 download_count=0;
  
 for (;list!=NULL;list=list->next){
  url = list->data;
  dndS=url;

  TRACE("dndS=%s",dndS);
  if (strncmp("smb://",dndS,strlen("smb://")) &&
      strncmp("SMB://",dndS,strlen("SMB://")!=0)		  ) {
	incorrect_DND:
	print_status(widgets_p,"xffm/error",strerror(EINVAL), NULL);
	print_diagnostics(widgets_p,"xffm/error",strerror(EINVAL), "\n",NULL);
	return;
  }
  if (strncmp("SMB://",dndS,strlen("SMB://"))==0) samba_server=TRUE;
  user=dndS+strlen("smb://");
  user=strtok(user,"@");  if (!user) goto incorrect_DND;
  /* XXX:  : changed for / */
  /*host=strtok(NULL,":");  if (!host) goto incorrect_DND;*/
  host=strtok(NULL,"/");  if (!host) goto incorrect_DND;
  share=strtok(NULL,"/"); if (!share) goto incorrect_DND;
  file=share+strlen(share)+1;
  TRACE("user=%s, host=%s, share=%s, file=%s",user,host,share,file);
 
  w=strrchr(file,'/');
  if (w) {
	  if (w[1]==0) {
	    isdir=TRUE;
	    w[0]=0;
            w=strrchr(file,'/');
	    if (!w) w=file;
	    else w++; 
	  } else {
	    isdir=FALSE;
	    w++;
	  }
	  if (!strlen(w)) continue;
	  else filename=g_strdup(w);	  
  }
  else {
	  isdir=FALSE;
	  filename=g_strdup(file);
  }

  for (i=0;i<strlen(file);i++) if (file[i]=='/') file[i]='\\'; 
/* 2.5- get drop target */  
  
/* 3- download via tubo */ 
  if (first){
    first=FALSE;
    orig_share=g_strdup(share);
    fprintf(tmpfile,"//%s/%s\n",host,share);
    fprintf(tmpfile,"%s\n",user);
  }
  /* only process files from first drop */
  if (orig_share && strcmp(share,orig_share)!=0) {
	  print_diagnostics(widgets_p,"xffm/error", _("Only drops from a single share are allowed"), NULL);
	  g_free(orig_share);orig_share=NULL;
	  return;
  }
  {
    gchar *local_file=g_strdup(filename);
    gchar *tgt=g_build_filename(target,local_file,NULL);
    show_text(widgets_p);
   print_diagnostics(widgets_p,NULL,"get ", file," ",local_file,";\n",NULL);
   if (isdir){
      fprintf(tmpfile,"lcd \"%s\";cd \"/%s\";cd ..;prompt;recurse; mget \"%s\";recurse;prompt;cd /;",target,file,local_file);
    } else {
      struct stat st;
      stat (tgt,&st);
      fprintf(tmpfile,"lcd \"%s\";get \"%s\" \"%s\";", target,file,local_file); 
      TRACE("lcd \"%s\";get \"%s\" \"%s\";", target,file,local_file); 
#if 0
      /* trash whatever exists so that download monitoring can work. */
      /* I exclude fifo's for double click mechanics. */
#ifdef USE_NPIPE
      if (!S_ISFIFO(st.st_mode))
#endif
      {
	if (getenv("XFFM_DEFAULT_UNLINK") && strcmp(getenv("XFFM_DEFAULT_UNLINK"),"unlink")==0){
	    TRACE("unlinking %s",tgt);
	    xffm_unlink(widgets_p,tgt);
	} else {
	    TRACE("trashing %s",tgt);
	    xffm_waste(widgets_p, tgt);
	}
      }
#endif
    }
    download_list = g_list_append(download_list, tgt);
    download_count++;
    g_free(local_file);local_file=NULL;
  }
 } /* end for list elements */
 
  fclose(tmpfile);
  if (SMBtmpfile) g_free(SMBtmpfile);
  SMBtmpfile=fname; 
  if (filename) {
	  g_free(filename);
  }
  filename=NULL;
  /* wait until OK to proceed */
  cursor_wait (widgets_p->window);
  smb_wait(FALSE,widgets_p);
  download_window(widgets_p->window,host);
  SMBResult=0;
    show_text(widgets_p);
  smb_object = Tubo_full (SMBFork,
		  (void *)SMBtmpfile,
		  SMBForkOver, 
		  NULL, 
		  SMBStdout, 
		  smb_stderr,widgets_p,15);
  smb_wait(TRUE,widgets_p);
   hide_text(widgets_p->diagnostics);
  if (orig_share) {
	  g_free(orig_share);
	  orig_share=NULL;
  }
  cursor_reset (widgets_p->window);

  return;
}

/*******************************************************/

static
void
SMBDropFile (record_entry_t *t_en,char *tmpfile,widgets_t *widgets_p)
{
  char *argv[12];
  gchar *n,*m,*path;
  if (!IS_XF_NETSHARE(t_en->subtype) && !IS_NETFILE(t_en->subtype) && !IS_NETDIR(t_en->subtype))
	  return;
  init_smb_list(t_en->path,SHOWS_HIDDEN(t_en->type));
  
  argv[0]="smbclient";

    n=g_strdup(t_en->path);
    
    if (strncmp(n,"smb:",strlen("smb:"))==0) m=n+strlen("smb:");
    else if (strncmp(n,"SMB:",strlen("SMB:"))==0) m=n+strlen("SMB:");
    else m=n;
    
    path=m;

  
  /*argv[1]=netbios...; */
  if (!IS_XF_NETSHARE(t_en->subtype)){
    gchar *p;
    p=strchr(path+2,'/')+1;
    *strchr(p,'/')=0;
  } 
  argv[1]=path;
  argv[2]="-U";
  argv[3]=t_en->tag; /* user%pass */
  argv[4]="-c";
  argv[5]=tmpfile;
  argv[6]=0;
  
  show_text(widgets_p);
  print_diagnostics(widgets_p,NULL,_("Copying all selected files"),"\n",NULL);
  print_status(widgets_p,NULL,_("Copying all selected files"),NULL);
  
  
  /* wait until OK to proceed */
  smb_wait(FALSE,widgets_p);
  
    show_text(widgets_p);
  smb_object = Tubo_full (SMBDropFork, 
		  (void *)argv,
		  SMBDropForkOver, 
		  NULL, 
		  SMBListStdout,
		  smb_stderr,widgets_p,15);

  smb_wait(TRUE,widgets_p);
   hide_text(widgets_p->diagnostics);
  g_free(n);

  //unlink(tmpfile);
  return;
}

/***************************************************/

static
void
SMBrmFile (char *remote_location,
	        char *remote_pass,char *tmpfile,
		widgets_t *widgets_p)
{
  char *argv[12];
  
  /* remote_location == remote_server / remote_share */

    /*if (strncmp(remote_location,"smb:",strlen("smb:"))==0) remote_location += strlen("smb:");
    else if (strncmp(remote_location,"SMB:",strlen("SMB:"))==0) remote_location += strlen("SMB:");*/

    TRACE("remote_location--> %s",remote_location);
    TRACE("remote_pass--> %s",remote_pass);
    TRACE("tmpfile--> %s",tmpfile);
  argv[0]="smbclient";
  
  argv[1]=remote_location;
  argv[2]="-U";
  argv[3]=remote_pass; /* user%pass */
  argv[4]="-c";
  argv[5]=tmpfile;
  argv[6]=0;
  

  TRACE("--> %s %s %s %s %s %s",argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]);
  
  show_text(widgets_p);
  print_diagnostics(widgets_p,NULL,_("Removing all selected files"),"\n",NULL);
  print_status(widgets_p,"xffm/warning",_("Removing all selected files"),NULL);
  
  
  /* wait until OK to proceed */
  smb_wait(FALSE,widgets_p);
  
    show_text(widgets_p);
  smb_object = Tubo_full (SMBDropFork, 
		  (void *)argv,
		  SMBDropForkOver, 
		  NULL, 
		  SMBrmStdout,
		  smb_stderr,widgets_p,15);

  smb_wait(TRUE,widgets_p);
    hide_text(widgets_p->diagnostics);

  return ;
}


static
char  *CreateSMBTmpList (GList *in_list,char *target,gboolean samba_server,
			widgets_t *widgets_p){
    FILE *tmpfile;
    gchar *url;
    char *w;
    gchar *fname=NULL;
    int nitems=0;
    struct stat s;
    GList *list;
    
    nitems=0;
#ifdef DEBUG
    for (list=in_list;list;list=list->next){
	gchar *url=list->data;
	DBG("url=%s",url);
    }
#endif

    if ((fname=randomTmpName(NULL))==NULL) return NULL;
    if ((tmpfile=fopen(fname,"w"))==NULL) {
	g_free(fname);
	return NULL;
    }
    fprintf(tmpfile,"cd /;cd \"%s\";\n",target);
    for (list=in_list;list;list=list->next){
        url = list->data;
		 nitems++;
		 if (!strchr(url,'/')) {
			 fclose(tmpfile);
			 unlink (fname);
			 g_free(fname);
			 return NULL;
		 }
		 w=g_strdup(strrchr(url,'/')+1);
		 if (lstat(url,&s)<0){
			 print_diagnostics(widgets_p,"xffm/error",
					 strerror(errno),":\n",
					 url,"\n",NULL);
			 fclose(tmpfile);
			 g_free(fname);
			 unlink (fname);
			 g_free(w);
			 w=NULL;
			 return NULL;
		 } 
		 if (S_ISREG(s.st_mode)) {
  		   fprintf(tmpfile,"put \"%s\" \"%s\";\n",url,w);
		 }
		 else if (S_ISDIR(s.st_mode)) {
	  	   fprintf(tmpfile,"mkdir \"%s\";\n",w);
	  	   fprintf(tmpfile,"cd \"%s\";\n",w);
	  	   fprintf(tmpfile,"prompt;recurse;\n");
	  	   fprintf(tmpfile,"lcd \"%s\";\n",url);
	  	   fprintf(tmpfile,"mput *;\n");
	  	   fprintf(tmpfile,"prompt;recurse;\n");
    		   fprintf(tmpfile,"cd /;cd \"%s\";\n",target);
		 }
		 else { /*CHR, BLK, FIFO, LNK, SOCK */
 			 print_diagnostics(widgets_p,"xffm/error",
					  strerror(EBADF),":\n",
					 url,"\n",NULL);
	         }
		 fflush(NULL);
		 g_free(w);
		 w=NULL;
    }
    fprintf(tmpfile,"ls;\n");
    fclose (tmpfile);
    /*fprintf(stderr,"dbg:nitems = %d\n",nitems);*/
    if (!nitems) {
       /*fprintf(stderr,"dbg:nitems = %d\n",nitems);*/
	    g_free(fname);
	    unlink(fname);
	    return NULL;
    }
    /*fprintf(stderr,"dbg: same device=%d\n",same_device);*/
    return fname;
}


static gchar *get_remote_location(GList *remote_remove_list){
    record_entry_t *en;
   gchar *n,*m,*location=NULL;
    en = (record_entry_t *)remote_remove_list->data;
    
    n=g_strdup(en->path);
    if (strncmp(n,"smb:",strlen("smb:"))==0) m=n+strlen("smb:");
    else if (strncmp(n,"SMB:",strlen("SMB:"))==0) m=n+strlen("SMB:");
    else m=n;
    
    location=g_strdup(m);
    g_free(n);
    if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	   if (!strchr(location+2,'/')) {
	       g_warning("this should not happen");
	       return NULL;
	   }
	   strtok(strchr(location+2,'/')+1,"/");
	   /*printf("TRACE:location=%s\n",location);*/
	   if (!location || !strlen(location)) {
	       g_warning("this should not happen");
	       return NULL;
	   }
    }
    return location;
}

static gchar *get_remote_pass(GList *remote_remove_list){
    record_entry_t *en;
 
    if (!remote_remove_list){
	g_warning("!remote_remove_list");
	return NULL;
    }
    en = (record_entry_t *)remote_remove_list->data;
    
    TRACE("en=0x%x",(unsigned)en);
    /*TRACE("treeview=0x%x, en, path and tag: %s, %s",(unsigned)treeview,en->path, en->tag);*/
    return g_strdup(en->tag);
}



static char  *CreateRmTmpList(GList *remote_remove_list){
  GList *tmp;
  record_entry_t *en;
  FILE *tmpfile;
  gchar *path,*directory=NULL,*file=NULL;
  gchar *fname;
       
  if ((fname=randomTmpName(NULL))==NULL) return NULL;
  if ((tmpfile=fopen(fname,"w"))==NULL) {
      g_free(fname);
      return NULL;
  }
    TRACE("3remote_remove_list=0x%x",(unsigned)remote_remove_list);

  for (tmp=remote_remove_list;tmp;tmp=tmp->next){
    gchar *n,*m;
    en = (record_entry_t *)tmp->data;
    
    n=g_strdup(en->path);
    if (strncmp(n,"smb:",strlen("smb:"))==0) m=n+strlen("smb:");
    else if (strncmp(n,"SMB:",strlen("SMB:"))==0) m=n+strlen("SMB:");
    else m=n;/* this gives us path with share.*/

    TRACE("en->path=%s",en->path);
    
    path=strstr(m+2,"/")+1; /* this gives us path with share.*/    
    path=g_strdup(strstr(path,"/"));/* this gives us the path.*/
    g_free(n);
    file=strrchr(path,'/');
    if (!file) assert_not_reached();
    file++;
    if (!strlen(file)) assert_not_reached();
    directory=g_strdup(path);
    if (!strchr(directory,'/')) assert_not_reached();
    *(strrchr(directory,'/'))=0;
    if (!strlen(directory)) {directory[0]='/';directory[1]=0;}
    /* smbclient is screwed with window server here. */
    fprintf(tmpfile,"cd \"%s\";\n",directory);
    TRACE("cd \"%s\";\n",directory);
    if (IS_NETDIR(en->subtype)){
	fprintf(tmpfile,"rmdir \"%s\";\n",file);
	TRACE("rmdir \"%s\";\n",file);
        /*fprintf(tmpfile,"cd /;rmdir \"%s\\\";\n",t);	     */
     } else {
        if (!IS_SAMBA_SERVER(en->subtype)){
	  char *g;
	  for(g=file;*g;g++)if (*g=='/')*g='\\';
	}
	fprintf(tmpfile,"del \"%s\";\n",file);
	TRACE("del \"%s\";\n",file);
     }
     g_free(path);path=NULL;
     g_free(directory);directory=NULL;
   }
   fclose (tmpfile);
   return fname;
}


