dnl Checks for the --with-maildir option on ./configure, if given it sets the 
dnl _CONF_PATH_MAILDIR  accordingly.

AC_DEFUN([MAILDIR], [
AC_ARG_WITH(maildir, [  --with-maildir=DIR      mail spool directory],
  cv_maildir=$withval
  AC_MSG_RESULT("$cv_maildir")
,
 [AC_CACHE_CHECK(where new mail is stored, cv_maildir,
    [cv_maildir=no
         if test -d /var/mail; then
                cv_maildir=/var/mail
         elif test -d /var/spool/mail; then
                cv_maildir=/var/spool/mail
         elif test -d /usr/spool/mail; then
                cv_maildir=/usr/spool/mail
         elif test -d /usr/mail; then
                cv_maildir=/usr/mail
         fi])
  ]
)

if test $cv_maildir = no; then
    CV_ERROR("Could not find mail spool directory.")
else
    AC_DEFINE_UNQUOTED([_CONF_PATH_MAILDIR], "$cv_maildir",
	[Where new mail is stored])
fi
])
