/* $Id: log.cpp,v 1.10 2004/01/02 04:05:36 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>

#define MAX_LOG 256

static FD_Log *log_obj = NULL;
static int ready = 0;
static int log_lines = 0;
static FILE *lfd = NULL;

extern cfgfile Config;
#include <cfgfile.h>

void xfm_log_close_fd() {
	if(lfd)
		fclose(lfd);
	lfd = NULL;
}

void xfm_log_reopen_fd() {
	xfm_log_close_fd();
	if((lfd = fopen(Config.get("logfile", "").c_str(), "a")) == NULL) {
		display_msg(MSG_WARN, "log", "Can not open\n%s",
					Config.get("logfile", "").c_str());
		fl_set_button(log_obj->Log_Tofile, 0);
		return;
	}
	fl_set_button(log_obj->Log_Tofile, 1);
}

void Log_Win_Call(FL_OBJECT * obj, long param) {
}

void Log_Close_Call(FL_OBJECT * obj, long param) {
	char geom[16];

	if(ready) {
		sprintf(geom, "%d %d", log_obj->Log->w, log_obj->Log->h);
		Config.set("loggeom", geom);
		fl_hide_form(log_obj->Log);
	}
	ready = 0;
	fl_set_menu_item_mode(menu_misc, 8, FL_PUP_BOX);
}

void Log_Clear_Call(FL_OBJECT * obj, long param) {
	fl_clear_browser(log_obj->Log_Win);
	log_lines = 0;
	if(lfd) {
		if(fflush(lfd) != 0)
			xfm_log_reopen_fd();
	}
}

void Log_Tofile_Call(FL_OBJECT * obj, long param) {
	char *lfname;
	time_t ltime;

	ltime = time(NULL);

	if(fl_get_button(obj)) {
		if(lfd)
			fclose(lfd);
		lfd = NULL;
		fl_set_fselector_title("Choose log file name");
		if(!
		   (lfname =
			(char *) fl_show_file_selector("Log to", "", "",
										   "xflog.txt"))) {
			fl_set_button(obj, 0);
			return;
		}

		if((lfd = fopen(lfname, "a")) == NULL) {
			display_msg(MSG_WARN, "log", "Can not open\n%s", lfname);
			fl_set_button(obj, 0);
			return;
		}
		Config.set("logfile", lfname);
		fprintf(lfd, "--- XFMail log started: %s", ctime(&ltime));
	} else {
		if(lfd) {
			fprintf(lfd, "--- XFMail log finished: %s", ctime(&ltime));
			fclose(lfd);
		}
		Config.remove("logfile");
		lfd = NULL;
	}
}

void xfm_log_str(char *str) {
	if(!log_obj)
		return;

	if(!str)
		return;

	if((strlen(str) < 1) || (strlen(str) > 200))
		return;

	if(log_lines > MAX_LOG) {
		fl_clear_browser(log_obj->Log_Win);
		log_lines = 0;
		if(lfd) {
			if(fflush(lfd) != 0)
				xfm_log_reopen_fd();
		}
	}

	fl_addto_browser(log_obj->Log_Win, str);

	if(lfd) {
		if(fputs(str, lfd) != 0)
			xfm_log_reopen_fd();
		if(lfd)
			fputc('\n', lfd);
	}
	log_lines++;
	return;
}

int xfm_log_close(FL_FORM * form, void *data) {
	log_win();
	return FL_IGNORE;
}

void xfm_log_init() {
	log_obj = create_form_Log();
	fl_set_form_atclose(log_obj->Log, xfm_log_close, NULL);
	fl_set_form_minsize(log_obj->Log, 410, 160);
	if(Config.exist("logfile"))
		xfm_log_reopen_fd();
	else
		fl_set_button(log_obj->Log_Tofile, 0);
}

void xfm_log_free() {
	fl_free(log_obj);
}

void log_win() {
	int w, h;
	char geom[16];

	if(ready) {
		sprintf(geom, "%d %d", log_obj->Log->w, log_obj->Log->h);
		Config.set("loggeom", geom);
		fl_hide_form(log_obj->Log);
		ready = 0;
		fl_set_menu_item_mode(menu_misc, 8, FL_PUP_BOX);

		return;
	}

	ready = 1;
	fl_set_menu_item_mode(menu_misc, 8, FL_PUP_CHECK);

	Config.setFlags("loggeom", CF_NOTCHANGED);
	w = 410;
	h = 160;
	sscanf(Config.get("loggeom", "").c_str(), "%d %d", &w, &h);
	if(log_obj == NULL) {
		log_obj = create_form_Log();
		fl_set_form_atclose(log_obj->Log, xfm_log_close, NULL);
	}

	fl_set_form_minsize(log_obj->Log, 410, 160);
	fl_set_form_size(log_obj->Log, w, h);
	fl_show_form(log_obj->Log, FL_PLACE_FREE_CENTER, FL_TRANSIENT,
				 "Log window");

	return;
}
