/* $Id: view_edit.cpp,v 1.11 2004/01/02 04:05:37 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <glib.h>

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"
#include "exit.xpm"
#include "print.xpm"

extern cfgfile Config;

static FD_config_viewedit *edit_obj;
static FD_config_viewedit *view_obj;
int markincl, headcolor, hurlcol;

void View_EView_Call(FL_OBJECT * obj, long param) {
}

void View_Wrap_Call(FL_OBJECT * obj, long param) {
}

void View_Ext_Call(FL_OBJECT * obj, long param) {
}

void View_Preview_Call(FL_OBJECT * obj, long param) {
	fl_show_alert("WARNING", "The change will take effect",
				  "only after you restart XFMail", 1);
	if(fl_get_button(obj))
		Config.set("msgpane", 100);
	else
		Config.set("msgpane", 0);
}
void Mark_HColor_Call(FL_OBJECT * obj, long param) {
	headcolor = fl_show_colormap(FL_RED);
	fl_set_object_color(obj, headcolor, FL_BLACK);
}

void Mark_MColor_Call(FL_OBJECT * obj, long param) {
	markincl = fl_show_colormap(FL_BLUE);
	fl_set_object_color(obj, markincl, FL_BLACK);
}

void Mark_UColor_Call(FL_OBJECT * obj, long param) {
	hurlcol = fl_show_colormap(FL_RED);
	fl_set_object_color(obj, hurlcol, FL_BLACK);
}

void Mark_Include_Call(FL_OBJECT * obj, long param) {
	if(fl_get_button(obj))
		markincl = view_obj->View_MColor->col1;
	else
		markincl = 0;
}

void View_Header_Call(FL_OBJECT * obj, long param) {
	headcolor = view_obj->View_HColor->col1;
}

void Mark_HURLS_Call(FL_OBJECT * obj, long param) {
	if(fl_get_button(obj))
		hurlcol = view_obj->View_UColor->col1;
	else
		hurlcol = 0;
}

void Edit_EEdit_Call(FL_OBJECT * obj, long param) {
}

void Edit_Wrap_Call(FL_OBJECT * obj, long param) {
}

void Edit_Keymap_Call(FL_OBJECT * obj, long param) {
	fl_deactivate_form(edit_obj->config_viewedit);
	keymap_conf();
	fl_activate_form(edit_obj->config_viewedit);
}

void Send_Confirm_Call(FL_OBJECT * obj, long param) {
}

void view_conf(int set_default, FD_config_viewedit * form) {

	view_obj = form;

	fl_clear_choice(view_obj->Send_Confirm);
	fl_addto_choice(view_obj->Send_Confirm, "Always");
	fl_addto_choice(view_obj->Send_Confirm, "Ask");
	fl_addto_choice(view_obj->Send_Confirm, "Never");

	fl_set_choice(view_obj->Send_Confirm,
				  Config.getIntDefault("vconfirm", 2,
									   set_default));
	fl_set_counter_bounds(view_obj->View_Wrap, 40, 200);
	fl_set_counter_precision(view_obj->View_Wrap, 0);
	fl_set_counter_step(view_obj->View_Wrap, 1, 1);
	fl_set_counter_value(view_obj->View_Wrap, (double) ((double)
														Config.getIntDefault(
														 "viewrap", 80,
														 set_default)));
	fl_set_input(view_obj->View_EView, Config.get("extview", "/usr/bin/X11/xedit", set_default).c_str());
	fl_set_input(view_obj->View_URL, Config.get("urlview", "", set_default).c_str());
	fl_set_input(view_obj->View_FTP, Config.get("ftprog", "", set_default).c_str());
	headcolor = Config.getIntDefault("headcolor", FL_RED, set_default);
	fl_set_button(view_obj->View_Header,
				  Config.getIntDefault("sheader", 0,
									   set_default));
	fl_set_object_color(view_obj->View_HColor, headcolor, FL_BLACK);
	markincl = Config.getIntDefault("markincl", 0, set_default);
	fl_set_button(view_obj->Mark_Included, markincl ? 1 : 0);
	fl_set_object_color(view_obj->View_MColor, markincl, FL_BLACK);
	hurlcol = Config.getIntDefault("showurl", 0, set_default);
	fl_set_button(view_obj->Mark_HURLS, hurlcol ? 1 : 0);
	fl_set_object_color(view_obj->View_UColor, hurlcol, FL_BLACK);

	fl_set_button(view_obj->View_Ext,
				  Config.getIntDefault("viewexit", 0,
									   set_default));
	fl_set_button(view_obj->View_Internal,
				  Config.getIntDefault("intview", 0,
									   set_default));
	fl_set_button(view_obj->View_Ofold,
				  Config.getIntDefault("switchfold", 1,
									   set_default));
	fl_set_button(view_obj->View_Preview,
				  Config.getIntDefault("msgpane", 0,
									   set_default) ? 1 : 0);
}
void handle_view_input(FD_config_viewedit * form) {
	view_obj = form;
	Config.set("viewrap", (int) fl_get_counter_value(view_obj->View_Wrap));
	Config.set("extview", (char *) fl_get_input(view_obj->View_EView));
	Config.set("urlview", (char *) fl_get_input(view_obj->View_URL));
	Config.set("ftprog", (char *) fl_get_input(view_obj->View_FTP));
	Config.set("sheader", fl_get_button(view_obj->View_Header));
	Config.set("headcolor", headcolor);
	Config.set("markincl", markincl);
	Config.set("showurl", hurlcol);
	Config.set("vconfirm", fl_get_choice(view_obj->Send_Confirm));
	Config.set("viewexit", fl_get_button(view_obj->View_Ext));
	Config.set("intview", fl_get_button(view_obj->View_Internal));
	Config.set("switchfold", fl_get_button(view_obj->View_Ofold)); 
	return;
}
void edit_conf(int set_default, FD_config_viewedit * form) {
	int wrap;
	edit_obj = form;
	wrap = Config.getIntDefault("editwrap", -80, set_default);
	fl_set_counter_bounds(edit_obj->Edit_Wrap, 40, 200);
	fl_set_counter_precision(edit_obj->Edit_Wrap, 0);
	fl_set_counter_step(edit_obj->Edit_Wrap, 1, 1);
	fl_set_counter_value(edit_obj->Edit_Wrap, (double) abs(wrap));

	fl_set_button(edit_obj->Edit_Word_Wrap, wrap < 0 ? 1 : 0);
	fl_set_button(edit_obj->Edit_Paste_Cursor,
				  Config.getIntDefault("editpastecur", 1,
									   set_default));
	fl_set_input(edit_obj->Edit_EEdit, Config.get("extedit", "/usr/bin/X11/xedit", set_default).c_str());
}
void handle_edit_input(FD_config_viewedit * form) {
	int wrap;
	edit_obj = form;
	wrap = (int) fl_get_counter_value(edit_obj->Edit_Wrap);
	if(fl_get_button(edit_obj->Edit_Word_Wrap))
		wrap *= -1;

	Config.set("editwrap", wrap);
	Config.set("extedit", (char *) fl_get_input(edit_obj->Edit_EEdit));
	Config.set("editpastecur", fl_get_button(edit_obj->Edit_Paste_Cursor)); 
	return;
}

int close_intview_form(FL_FORM * form, void *data) {
	struct _proc_info *pinfo;

	if(form->u_vdata) {
		pinfo = (struct _proc_info *) form->u_vdata;
		if(pinfo->handle)
			(pinfo->handle) (pinfo);
		free(pinfo);
	}
	fl_hide_form(form);
	fl_free_form(form);

	return FL_IGNORE;
}

void cb_intview_button_exit(FL_OBJECT * obj, long param) {
	close_intview_form(obj->form, obj->form);
}

void cb_intview_button_print(FL_OBJECT * obj, long param) {
	struct _proc_info pinfo;

	if(!obj->u_cdata || !*obj->u_cdata)
		return;

	init_pinfo(&pinfo);
	pinfo.wait = WAIT_BG;

	exec_child(get_print_command(obj->u_cdata), &pinfo);
	return;
}

void cb_view_browser(FL_OBJECT * obj, long param) {
}

int file_view(char *file, struct _proc_info *pinfo) {
	static char viewfile[255];
	struct _proc_info *npinfo;
	FL_OBJECT *obj;
	FL_FORM *viewform;
	size_t i;
	int added, w, h;
	char command[255], *e;

	if(!file)
		return -1;

	strcpy(viewfile, file);
	if(!Config.getInt("intview", 0)) {
		e = const_cast<char *>(Config.get("extview", "/usr/bin/X11/xedit").c_str());
		command[0] = '\0';
		added = 0;
		for(i = 0; i < strlen(e); i++) {
			if((e[i] == '$') && (e[i + 1] == 'f') && i
			   && (e[i - 1] == ' ')) {
				added = 1;
				i++;
				strcat(command, file);
			} else {
				command[strlen(command) + 1] = '\0';
				command[strlen(command)] = e[i];
			}
		}

		if(!added) {
			strcat(command, " ");
			strcat(command, file);
		}

		return exec_child(command, pinfo);
	}

	npinfo = dup_pid_info(pinfo);
	viewform = fl_bgn_form(FL_NO_BOX, 805, 605);
	fl_add_box(FL_FLAT_BOX, 0, 0, 805, 605, "");
	viewform->u_vdata = npinfo;

	obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON, 3, 2, 35, 33, "");
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, NorthWestGravity, 0);
	fl_set_object_posthandler(obj, post_handler);
	obj->u_vdata = const_cast < char *>("Exit viewer (Alt+X)");
	fl_set_pixmapbutton_data(obj, exit_xpm);
	fl_set_object_callback(obj, cb_intview_button_exit, 0);
	fl_set_button_shortcut(obj, "#X", 0);

	obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON, 45, 2, 35, 33, "");
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, NorthWestGravity, 0);
	fl_set_object_posthandler(obj, post_handler);
	obj->u_vdata = const_cast < char *>("Print text (Alt+P)");
	obj->u_cdata = viewfile;
	fl_set_pixmapbutton_data(obj, print_xpm);
	fl_set_object_callback(obj, cb_intview_button_print, 0);
	fl_set_button_shortcut(obj, "#P", 0);

	obj = fl_add_textedit(FL_NORMAL_TEXTEDIT, 3, 40, 799, 562, "");
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, NorthWestGravity, SouthEastGravity);
	fl_set_textedit_color(obj,
						  Config.getInt("ViewBgCol", FL_TOP_BCOL),
						  Config.getInt("ViewFgCol", FL_BLACK), FL_BLUE, 0);
	fl_set_textedit_fontstyle(obj,
							  Config.getInt("ViewFStyle", FL_NORMAL_STYLE));
	fl_set_textedit_fontsize(obj,
							 Config.getInt("ViewFSize", FL_NORMAL_SIZE));
	fl_textedit_readonly(obj, 1);
	fl_set_object_callback(obj, cb_view_browser, 0);
	fl_set_form_atclose(viewform, close_intview_form, viewform);
	fl_end_form();
	fl_set_form_minsize(viewform, 600, 300);
	sscanf(Config.get("msgformsize", "800 600").c_str(), "%d %d", &w, &h);
	if(Config.getInt("wplace", 1))
		fl_set_initial_placement(viewform, 100, 150, w, h);
	else
		fl_set_form_size(viewform, w, h);

	fl_set_form_icon(viewform, icon_MailEdit, icon_MailEdit_sh);
	fl_load_textedit(obj, file);
	fl_show_form(viewform, FL_PLACE_FREE, FL_FULLBORDER, file);

	return 0;
}
