#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include "user.h"

/* Grabbed from comp.unix.programming FAQ */
static void closeall(void)
{
	int fd = 0;
	int fdlimit = sysconf(_SC_OPEN_MAX);

	while (fd < fdlimit)
		close(fd++);
}

/* again from c.u.p FAQ */
static int fork2(void)
{
	pid_t pid;
	int status;

	if (!(pid = fork()))
	{
		switch (fork())
		{
		       case 0:  return 0;
		       case -1: _exit(errno);    /* assumes all errnos are <256 */
		       default: _exit(0);
		}
	}

	if (pid < 0 || waitpid(pid,&status,0) < 0)
		return -1;

	if (WIFEXITED(status)) {
		if (WEXITSTATUS(status) == 0)
			return 1;
		else
			errno = WEXITSTATUS(status);
	} else
		errno = EINTR;  /* well, sort of :-) */

	return -1;
}

static char *convert_home(char *s)
{
	char *c, *h = user_get_homedir(getuid());

	if (s[0] == '~' && s[1] == '/' && h != NULL)
		c = strcat(strcpy(malloc(strlen(h) + strlen(s)), h), s+1);
	else
		c = strdup(s);

	free(h);
	return c;
}

int execute(char *cmd)
{
	int ret = -1;

	if (cmd != NULL && cmd[0] != '\0') {
		ret = fork2();
		if (ret == 0) {
			/* child */
			cmd = convert_home(cmd);
			closeall();
			execl(cmd, cmd, NULL);
			exit(127);
		}
	}
	return ret;
}

