#include "interface_glob.h"
#include "runtime.h"
#include "widgets.h"
#include "cfg.h"
#include "useful.h"
#include "../config.h"
#if HAVE_LIBMYSQL
	#include "mysql_backend.h"
#endif

#include <netinet/in.h>
#include <gtk/gtk.h>

struct tMoveData *move_delta_activity;

void interface_glob_init()
{
	move_delta_activity = NULL;
}

void interface_glob_wdg_autohangup_2_line(int lineid)
{
	struct tline * line = runtime_get_line(lineid);
	if ( !line )
	{
		g_print("bad lineid in interface_glob_line_2_wdg_autohangup()\n");
		return;
	}
	if ( !wdg_autohup->realized ) return;
	line->ahup->activated = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_activated));
	if ( (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_linemaster->chk_ahup)) != line->ahup->activated)
			&& (runtime->selected_line) && (runtime->selected_line->num == lineid) )
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_linemaster->chk_ahup), line->ahup->activated);
	line->ahup->activity_mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_activity_mode));
	line->ahup->btime = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_time));
	line->ahup->bup = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_up));
	line->ahup->bdown = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_down));
	line->ahup->btotal_up = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_total_up));
	line->ahup->btotal_down = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_total_down));
	line->ahup->logic_or = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_autohup->rb_ahup_or));
	line->ahup->time = gtk_spin_button_get_value_as_int(wdg_autohup->sp_ahup_time)*60;
	line->ahup->up = gtk_spin_button_get_value_as_int(wdg_autohup->sp_ahup_up);
	line->ahup->down = gtk_spin_button_get_value_as_int(wdg_autohup->sp_ahup_down);
	line->ahup->total_up = gtk_spin_button_get_value_as_int(wdg_autohup->sp_ahup_total_up);
	line->ahup->total_down = gtk_spin_button_get_value_as_int(wdg_autohup->sp_ahup_total_down);
}

void interface_glob_line_2_wdg_autohangup(int lineid)
{
	struct tline * line = runtime_get_line(lineid);
	if ( !line )
	{
		g_print("bad lineid in interface_glob_wdg_autohangup_2_line()\n");
		return;
	}
	if ( !wdg_autohup->realized ) return;
	wdg_autohup->selected_line = line;
	gtk_spin_button_set_value(wdg_autohup->sp_ahup_time, line->ahup->time / 60);
	gtk_spin_button_set_value(wdg_autohup->sp_ahup_up, line->ahup->up);
	gtk_spin_button_set_value(wdg_autohup->sp_ahup_down, line->ahup->down);
	gtk_spin_button_set_value(wdg_autohup->sp_ahup_total_up, line->ahup->total_up);
	gtk_spin_button_set_value(wdg_autohup->sp_ahup_total_down, line->ahup->total_down);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_activated), line->ahup->activated);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_activity_mode), line->ahup->activity_mode);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_time), line->ahup->btime);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_up), line->ahup->bup);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_down), line->ahup->bdown);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_total_up), line->ahup->btotal_up);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_total_down), line->ahup->btotal_down);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->rb_ahup_or), line->ahup->logic_or);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->rb_ahup_and), !line->ahup->logic_or);
}

void interface_propagate_line_data(struct tline* line)
{
	int row = runtime_get_clid_line(line);
	if ( !line || !row ) return;
	row--;
	runtime_load_line_strings(line);
	if ( wdg_linemaster->realized )
	{
		gtk_clist_set_text(wdg_linemaster->cl_lines, row, 3, line->sstime);
		gtk_clist_set_text(wdg_linemaster->cl_lines, row, 4, line->sdns);
		gtk_clist_set_text(wdg_linemaster->cl_lines, row, 5, line->sups);
		gtk_clist_set_text(wdg_linemaster->cl_lines, row, 6, line->sdnt);
		gtk_clist_set_text(wdg_linemaster->cl_lines, row, 7, line->supt);
		if ( line == runtime->selected_line )
		{
			gtk_label_set_text(wdg_linemaster->lb_server_time, line->sstime);
			gtk_label_set_text(wdg_linemaster->lb_client_time, line->sctime);
			gtk_label_set_text(wdg_linemaster->lb_channels, line->schan);
			gtk_label_set_text(wdg_linemaster->lb_up_current, line->sups);
			gtk_label_set_text(wdg_linemaster->lb_down_current, line->sdns);
			gtk_label_set_text(wdg_linemaster->lb_up_average, line->supl);
			gtk_label_set_text(wdg_linemaster->lb_down_average, line->sdnl);
			gtk_label_set_text(wdg_linemaster->lb_up_total, line->supt);
			gtk_label_set_text(wdg_linemaster->lb_down_total, line->sdnt);
			gtk_label_set_text(wdg_linemaster->lb_up_max, line->smax_up);
			gtk_label_set_text(wdg_linemaster->lb_down_max, line->smax_dn);
			gtk_label_set_text(wdg_linemaster->lb_up_capab, line->scap_up);
			gtk_label_set_text(wdg_linemaster->lb_down_capab, line->scap_dn);
			if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_linemaster->chk_ahup))
						!= line->ahup->activated)
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_linemaster->chk_ahup), line->ahup->activated);
		}
	}
	if ( wdg_activity->realized && (line == runtime->selected_line) )
	{
		float up = 0, down = 0;
		if ( (float)line->ahup->max_up > 0 )
			up = (float)line->up_short / ((float)line->ahup->max_up);
		if ( (float)line->ahup->max_down > 0 )
			down = (float)line->down_short / ((float)line->ahup->max_down);
		if ( up > 1.0 ) up = 1.0;
		else if ( up < 0.0 ) up = 0.0;
		if ( down > 1.0 ) down = 1.0;
		else if ( down < 0.0 ) down = 0.0;
		gtk_progress_bar_update(wdg_activity->prg_up, up);
		gtk_progress_bar_update(wdg_activity->prg_down, down);
	}
}

void interface_load_into_wnd_config()
{
	if ( !wdg_config->realized )
	{
		g_warning("load_into_wnd_config(): wdg_config->realized == FALSE\n");
		return;
	}
	if ( config->server_hostname )
		gtk_entry_set_text(wdg_config->ent_srv_hostname, config->server_hostname);
	if ( config->user_name )
		gtk_entry_set_text(wdg_config->ent_username, config->user_name);
	if ( config->user_passwd )
		gtk_entry_set_text(wdg_config->ent_passwd, config->user_passwd);
	gtk_spin_button_set_value(wdg_config->sp_srv_port, (float)htons(config->server_port));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_srv_autoconnect), config->server_connect_on_startup);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_srv_reconnect), config->server_try_reconnecting);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_save_passwd), config->user_save_passwd);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_wnd_events), config->misc_event_window);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_start_minimized), config->start_minimized);
	if ( config->online_script )
		gtk_entry_set_text(wdg_config->ent_online, config->online_script);
	if ( config->offline_script )
		gtk_entry_set_text(wdg_config->ent_offline, config->offline_script);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_mysql_enable), config->mysql_enable);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_config->chk_addrbook_ask), config->addrbook_ask);
	if ( config->mysql_host )
		gtk_entry_set_text(wdg_config->ent_mysql_host, config->mysql_host);
	if ( config->mysql_user )
		gtk_entry_set_text(wdg_config->ent_mysql_user, config->mysql_user);
	if ( config->mysql_pass )
		gtk_entry_set_text(wdg_config->ent_mysql_pass, config->mysql_pass);
	if ( config->mysql_db )
		gtk_entry_set_text(wdg_config->ent_mysql_db, config->mysql_db);
}

void interface_save_from_wnd_config()
{
	if ( !wdg_config->realized )
	{
		g_warning("save_from_wnd_config(): wdg_config->realized == FALSE\n");
		return;
	}
	// get server hostname
	get_entry_text(wdg_config->ent_srv_hostname, &(config->server_hostname));
	// get username
	get_entry_text(wdg_config->ent_username, &(config->user_name));
	// get password
	get_entry_text(wdg_config->ent_passwd, &(config->user_passwd));
	// get boolean values
	config->server_port = htons(gtk_spin_button_get_value_as_int(wdg_config->sp_srv_port));
	config->server_connect_on_startup = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_srv_autoconnect));
	config->server_try_reconnecting = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_srv_reconnect));
	config->user_save_passwd = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_save_passwd));
	config->misc_event_window = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_wnd_events));
	config->start_minimized = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_start_minimized));
	// get online / offline scripts
	get_entry_text(wdg_config->ent_online, &(config->online_script));
	get_entry_text(wdg_config->ent_offline, &(config->offline_script));
	get_entry_text(wdg_config->ent_mysql_host, &(config->mysql_host));
	get_entry_text(wdg_config->ent_mysql_user, &(config->mysql_user));
	get_entry_text(wdg_config->ent_mysql_pass, &(config->mysql_pass));
	get_entry_text(wdg_config->ent_mysql_db, &(config->mysql_db));
	config->mysql_enable = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_mysql_enable));
	config->addrbook_ask = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg_config->chk_addrbook_ask));

	// reinit mysql stuff:
	#if HAVE_LIBMYSQL
		if ( config->mysql_enable )
			sqlbe_init( // cleanup will be called automatically
					config->mysql_host,
					config->mysql_user,
					config->mysql_pass,
					config->mysql_db
				);
	#endif
}
