
/*
 * SUBS.C
 *
 */

#include "defs.h"

Prototype void fatal(Node *node, const char *ctl, ...);

void
fatal(Node *node, const char *ctl, ...)
{
    if (node) {
	INode *in;

	if ((in = node->no_INode) != NULL) {
	    fprintf(stderr, "%s:%d\t", in->in_Node.no_Name, node->no_ILine);

	    /*
	     * if the error occured while parsing, dump the parse hierarchy
	     */

	    if (in->in_Fi) {
		while ((in = in->in_Parent) != NULL) {
		    fprintf(stderr, "(from %s:%d)", in->in_Node.no_Name, in->in_Node.no_ILine);
		}
	    }
	}
    }
    {
	va_list va;

	va_start(va, ctl);
	vfprintf(stderr, ctl, va);
	va_end(va);
    }
    exit(FATALEXIT);
    /* not reached */
}

