/***************************************************************************
                          mplayer.cpp  -  description
                             -------------------
    begin                : Wed Jan 28 2004
    copyright            : (C) 2004 by Rajendra R Patil
    email                : rajendra_p123@yahoo.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlistbox.h>
#include <qdesktopwidget.h>
#include <qapplication.h>

#include <config.h>
#include "mplayer.h"
#ifdef HAVE_MPLAYER
#include <qfiledialog.h>
#include <qregexp.h>
#include <kwin.h>
#include <kwinmodule.h>


MPlayer::MPlayer(bool noborder, bool noscreen) {
   
  this->noborder=noborder;
  this->noscreen=noscreen;
		
  mp = new QProcess();
  mp->addArgument("mplayer");
  mp->addArgument("slave");
  mp->addArgument("geometry");
  mp->addArgument("640:480");
	
  currvol = 10;
  currtime = 0;
  currPtr = 0;
  isfullscreen = false;	
}

MPlayer::~MPlayer(){

  if (mp->isRunning()) { 

    if (screen) 
      delete screen; 
  
    mp->kill(); 
    delete mp ;
  }
}

void MPlayer::setPara(bool a, bool b) {
  
  if (noscreen == b && b) {
    noborder = a;
    return;
  }
	
  if (noborder !=a || noscreen != b) {
    noborder = a;
    noscreen = b;
    if (screen && mp->isRunning()) {
      int r = KMessageBox::questionYesNo(0, "Restart Playing Now to load new settings?", "Config changed");
      if (r == KMessageBox::Yes)
	play();
    }
  }
}

int MPlayer::currPtrP() {

  return currPtr;
}

void MPlayer::over() {
    
  currtime++;
  QMessageBox::message("currtime", QString::number(currtime));
}

void MPlayer::exitPlayer() {    
  
  if (mp->isRunning() && screen)
    delete screen;
  
  running = false;
  sendCommand("quit");
}


int MPlayer::getCurrentTime() {

  return currtime;
}

bool MPlayer::getRepeat() {

  return false; 
}

bool MPlayer::getShuffle() {

  return false;
} 

QString MPlayer::getTitle() {
  
  QString str = (*playlist.at(currPtr));
  return str.remove(0, str.findRev(QRegExp("/")) + 1);
}

int MPlayer::getTrackTime() {
  
  return 300;
}
int MPlayer::getVolume() {
  
  return 0;
} 

bool MPlayer::isPlayerRunning() {

  if(!mp->isRunning() && running && (currPtr < playlist.count())) {
    
    next();
    return true;
  } else {
    return (mp->isRunning());
  }
}

bool MPlayer::isPlaying() {

  return mp->isRunning();        
}

void MPlayer::next() {
   
  currPtr++;
  if (currPtr >= playlist.count()) { 
    stop();
    running = false; 
    currPtr = 0;
    return;
  } else {
    if (screen)
      delete screen;
    screen = new QWidget();
    if (running) play();
  }
}

void MPlayer:: openFileSelector() {

  QString types("video files (*.dat *.mpeg *.mpg);;"
		"audio files (*.mp3 *.wav *.voc);;"
		"All files (*.*)");
  
  playlist += QFileDialog::getOpenFileNames(types,
					    "/mnt",
					    0,
					    "open file dialog",
					    "Tell me which movie to play");
  
  filename = (*playlist.at(currPtr)); 
}

void MPlayer::pause() {
  
  sendCommand("pause");
}

void MPlayer::play() {

  filename = (*playlist.at(currPtr));
  
  if (!filename) 
    openFileSelector();

  if (filename) {
    if(mp->isRunning())
      stop();

    int ht = 600, wt = 800;
    
    ht = QApplication::desktop()->screen(0)->height();
    wt = QApplication::desktop()->screen(0)->width();
    screen = new QWidget();
    
    mp = new QProcess();
    mp->addArgument("mplayer");
    mp->addArgument("slave");
    mp->addArgument("geometry");
    mp->addArgument("640:480");
    
    if (noscreen) {
      mp->addArgument("rootwin");
    } else {	
#ifdef HAVE_KDE32
      if (noborder) {
	mp->addArgument("wid");
	mp->addArgument(QString::number(screen->winId()));
      }
#endif
    }
    
    mp->addArgument(filename);
    
    if(!mp->start()) {
	QMessageBox::critical(0, "error", "unable to start mplayer");
    }

    running = true;
    
#ifdef HAVE_KDE32
    
    KWin::setState(screen->winId(), NET::SkipTaskbar | NET::KeepAbove);
    KWin::setType(screen->winId(), NET::Override);
#endif
    screen->setCaption(QString("RMPlayer  %1").arg(getTitle()));
    screen->setGeometry(wt - 350,ht - 300, 350, 244);
  }
}

void MPlayer::playvcd() {

  if (mp->isRunning())
    stop();
  
  mp = new QProcess();
  mp->addArgument("mplayer");
  mp->addArgument("slave");
  mp->addArgument("geometry");
  mp->addArgument("640:480");
  mp->addArgument("vcd://1");
  
  if (!mp->start()) {
    QMessageBox::critical(0,"error","unable to start mplayer");
  }
  running = true;
}
void MPlayer::playdvd() {
    
  if (mp->isRunning())
    stop();
  
  mp = new QProcess();
  mp->addArgument("mplayer");
  mp->addArgument("slave");
  mp->addArgument("geometry");
  mp->addArgument("640:480");
  mp->addArgument("dvd://1");
  
  if (!mp->start()) {
    QMessageBox::critical(0, "error", "unable to start mplayer");
  }
  
  running = true;
}

void MPlayer::playerFullscreen() {

  if (mp->isRunning()) 
    sendCommand("vo_fullscreen");

#ifdef HAVE_KDE32
  if (noborder) {
    if (isfullscreen) {
      KWin::clearState(screen->winId(), NET::FullScreen);
      KWin::setState(screen->winId(), NET::KeepAbove);
      
      isfullscreen = 0;
    } else { 
      KWin::clearState(screen->winId(), NET::KeepAbove);
      KWin::setState(screen->winId(),NET::FullScreen);
      isfullscreen = 1;
    }
  }
#endif
}

void MPlayer::play(int i) {
  
  currPtr = i;
  play();  
}

QStringList MPlayer::playlistIs() {

  return playlist;  
}

void MPlayer::playlistAdd(QString files) {

  if (files.startsWith("file:"))
    files.remove(0, 5);
  
  files.replace("%20", " ");
  files.replace("%3A", ":");

  // don't add "." and ".." ("hidden" files also get sortet out...)
  if (QFileInfo(files).fileName().startsWith(".")) 
    return;

  QFileInfo file(files);

  if (file.isDir()) {
    qDebug("xmmskde: dir: " + files);
    QDir dir(files);
    QStringList filelist(dir.entryList());

    // add the files in the directory, recursive
    for (QStringList::Iterator it = filelist.begin();
	 it != filelist.end(); ++it) {
      playlistAdd(dir.absPath() + "/" + (*it));
    }
  }
  //QRegExp rx("/.*\\.[mpeg|mp3|dat|mpg|wav]",false);
          
  if(files.endsWith(".dat") || files.endsWith(".mpeg") || 
     files.endsWith(".mp3") || files.endsWith(".DAT") || 
     files.endsWith(".MPEG") || files.endsWith(".MP3"))
    
    playlist += files;
  
}
void MPlayer::playlistAdd(QStringList files) {

  for (QStringList::Iterator it = files.begin();
       it != files.end(); ++it)
    playlistAdd((*it));
}

void MPlayer::playlistClear() {
  
  playlist.clear();
  currPtr = 0;
}

void MPlayer::previous() {

  currPtr;
  if (currPtr < 0) currPtr = 0;
  play();
}

void MPlayer::sendCommand(QString cmd) {
  
  if (mp->isRunning()) { 
    cmd.append("\n"); 
    mp->writeToStdin(cmd); 
  }
}

void MPlayer::setCurrentTime(int time) {

  QString c = QString("seek %1 0").arg(time);
  sendCommand(c);
  currtime = time;
}

void MPlayer::setVolume(int vol) {

}

void MPlayer::startPlayer() {
  
  running = true;
  play();
}

void MPlayer::stop() {

  running = false;
  sendCommand("quit");

  if (screen)
    delete screen;
}

#endif
