/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 35 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };


#line 34 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqliteParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqliteParserARG_STORE     Code to store %extra_argument into yypParser
**    sqliteParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 219
#define YYACTIONTYPE unsigned short int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  Select* yy11;
  int yy52;
  ExprList* yy62;
  IdList* yy92;
  Token yy210;
  struct TrigEvent yy234;
  Expr * yy270;
  struct {int value; int mask;} yy279;
  struct LimitVal yy280;
  Expr* yy334;
  SrcList* yy335;
  TriggerStep * yy347;
  int yy437;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARG_SDECL Parse *pParse;
#define sqliteParserARG_PDECL ,Parse *pParse
#define sqliteParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqliteParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 555
#define YYNRULE 287
#define YYERRORSYMBOL 155
#define YYERRSYMDT yy437
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   104,  258,  174,  219,  215,   10,  162,  129,   20,  131,
 /*    10 */   258,    2,  327,    3,   40,   62,  474,  325,  368,  329,
 /*    20 */   154,  643,   49,   22,   41,  827,  106,  355,  330,  327,
 /*    30 */    69,   83,  537,  324,  385,   37,   32,    5,    1,  530,
 /*    40 */   127,  168,  539,   14,   36,   37,   86,  352,  458,  123,
 /*    50 */   143,  371,  119,  554,  256,    3,   84,  221,  166,   20,
 /*    60 */   560,   21,  307,  256,  177,  380,  157,  156,  183,  843,
 /*    70 */   309,  121,  142,  351,   22,  133,  117,   47,  146,  125,
 /*    80 */   139,  161,   46,  351,   44,    8,  115,   73,  144,  103,
 /*    90 */    15,  386,   54,  152,  302,  357,  174,  219,  229,  135,
 /*   100 */   112,  143,   16,  150,  443,  148,  384,  257,  104,  225,
 /*   110 */    64,    9,   21,  106,  162,  129,  257,  131,   60,  111,
 /*   120 */   106,  363,  368,  142,   69,   67,  293,  154,  154,  455,
 /*   130 */    68,  355,   97,  220,  179,  227,  175,   62,  105,  325,
 /*   140 */    35,   17,  256,   13,  181,   43,  449,  193,  127,  103,
 /*   150 */   106,  327,  209,  779,   69,  371,  555,  123,  143,  324,
 /*   160 */   119,  297,  154,   66,   31,   70,  166,  174,  219,  295,
 /*   170 */   310,  340,  177,  106,  157,  156,  183,  185,  113,  121,
 /*   180 */   142,  332,  201,  133,  117,  285,  146,  125,  139,  161,
 /*   190 */   333,  106,  231,   95,  115,  257,  144,  553,  184,  357,
 /*   200 */   152,  152,  319,  553,   46,  337,   44,  135,  112,  341,
 /*   210 */   150,  150,  148,  148,   54,  334,  302,  104,   64,  260,
 /*   220 */   146,  631,  106,  162,  129,  363,  131,  111,  172,  205,
 /*   230 */   144,  137,  780,   67,  331,  152,  299,  154,   68,  189,
 /*   240 */    60,  195,  179,   18,  175,  150,  105,  148,  174,  219,
 /*   250 */   238,  171,  181,   20,  172,  193,  552,  127,  317,   20,
 /*   260 */   106,  389,  552,  563,   73,  435,  123,  143,   22,  119,
 /*   270 */   424,   66,  106,  248,   22,  166,   20,  171,    6,   11,
 /*   280 */     4,  172,  197,  157,  156,  292,  113,   29,  121,  142,
 /*   290 */   250,   22,  133,  117,  172,  146,  125,  139,  161,  564,
 /*   300 */   797,  256,  169,  115,  171,  144,   21,  307,   69,   18,
 /*   310 */   152,  173,   21,  502,  368,  309,  135,  171,  353,  437,
 /*   320 */   150,  343,  148,  355,   20,   69,  104,  191,  169,   21,
 /*   330 */   440,  438,  162,  129,   20,  131,  489,   12,  228,   22,
 /*   340 */   241,   20,  350,  532,  277,  529,  154,  371,  583,   22,
 /*   350 */   172,  279,  531,  533,  257,  169,   22,  245,   69,  129,
 /*   360 */   172,  131,  483,  172,  778,   19,  127,  390,  169,  437,
 /*   370 */   242,  396,  154,  171,  315,  123,  143,   21,  119,  114,
 /*   380 */   440,  442,  392,  171,  166,  289,  171,   21,   65,   38,
 /*   390 */   342,  357,  157,  156,   21,   24,  788,  121,  142,  632,
 /*   400 */   567,  133,  117,  106,  146,  125,  139,  161,  246,  247,
 /*   410 */   575,  479,  115,  172,  144,  486,  450,  363,   52,  152,
 /*   420 */   653,  382,  381,  832,  169,  135,  481,  133,  137,  150,
 /*   430 */   146,  148,  104,  269,  169,  370,  171,  169,  162,  129,
 /*   440 */   144,  131,  174,  218,  411,  152,  423,   53,  270,  272,
 /*   450 */   266,  135,  154,  434,  172,  150,  420,  148,  316,  272,
 /*   460 */   322,  306,  172,  419,  270,  312,  106,  291,  272,  360,
 /*   470 */   283,   75,  127,  830,  270,   26,  412,  171,  272,  365,
 /*   480 */   409,  123,  143,  270,  119,  171,   58,  169,   91,  410,
 /*   490 */   166,  272,  374,  270,  272,  431,  528,  568,  157,  156,
 /*   500 */   710,  290,  473,  121,  142,  116,  270,  133,  117,  270,
 /*   510 */   146,  125,  139,  161,  655,   59,  473,  170,  115,  469,
 /*   520 */   144,  421,  716,   30,  239,  152,  106,  118,  169,  106,
 /*   530 */   540,  135,  413,  510,  120,  150,  169,  148,  122,  124,
 /*   540 */   106,  104,  213,  126,  128,  130,  132,  162,  129,  134,
 /*   550 */   131,  106,  136,   34,  138,   89,  141,  804,  106,  145,
 /*   560 */   147,  154,  106,  106,  149,  824,  217,  106,  106,  106,
 /*   570 */   106,  151,  153,  106,  155,   28,  106,  159,  106,  158,
 /*   580 */   106,  127,  163,  106,  106,  165,  217,  176,  106,  261,
 /*   590 */   123,  143,  268,  119,   69,  106,  106,  243,  106,  166,
 /*   600 */   178,  180,  182,  253,  190,  278,  106,  157,  156,  106,
 /*   610 */   217,  106,  121,  142,  192,  280,  133,  117,  658,  146,
 /*   620 */   125,  139,  161,  260,  106,  106,  106,  115,  106,  144,
 /*   630 */   314,  210,  212,  268,  152,  214,  416,  222,  106,  294,
 /*   640 */   135,  336,  224,  339,  150,  104,  148,  216,  235,  260,
 /*   650 */   240,  162,  129,  274,  131,  106,  106,  284,  346,  106,
 /*   660 */   335,  106,  338,  369,  268,  154,  106,  230,   69,  275,
 /*   670 */   268,  268,  106,  267,  106,  406,  268,  106,  414,  387,
 /*   680 */   819,  287,   69,  453,  405,  127,  313,  106,  415,  457,
 /*   690 */   463,  296,  416,  395,  123,  143,  470,  119,  418,  106,
 /*   700 */   418,  645,  275,  166,  820,  471,   73,  106,   69,  680,
 /*   710 */   710,  157,  156,  106,  323,  275,  121,  142,  455,  466,
 /*   720 */   133,  117,  444,  146,  125,  139,  161,  467,  470,  106,
 /*   730 */    69,  115,   73,  144,  239,  500,   39,   33,  152,  345,
 /*   740 */   569,  507,   42,  300,  135,  361,  275,  536,  150,  104,
 /*   750 */   148,  366,  375,  508,   10,  162,  129,  432,  131,  680,
 /*   760 */    45,  796,  570,  574,   48,  543,  535,    7,   51,  154,
 /*   770 */   680,   50,   55,  464,   56,   63,  584,  472,  585,  521,
 /*   780 */    57,   23,  680,   73,   61,  515,  388,   71,   74,  127,
 /*   790 */    72,  490,  239,   76,  549,   77,  236,  478,  123,  143,
 /*   800 */    25,  119,   79,   78,  234,   93,   80,  166,   82,  511,
 /*   810 */    85,   81,   88,   87,   90,  157,  156,   92,   94,   96,
 /*   820 */   121,  142,  100,  512,  133,  117,   98,  146,  125,  139,
 /*   830 */   161,   99,  101,  102,   10,  115,  137,  144,  107,  108,
 /*   840 */   104,  110,  152,  109,  140,  825,  162,  129,  135,  131,
 /*   850 */   154,  526,  150,  160,  148,  167,  514,  659,   27,  660,
 /*   860 */   154,  661,   73,  211,  186,  187,  188,  194,  177,  198,
 /*   870 */   196,  199,  183,  200,  202,  203,  206,  204,  208,  495,
 /*   880 */   127,  207,  524,  233,  226,  237,  217,  244,  232,  123,
 /*   890 */   143,  249,  119,  252,  262,  251,  254,  275,  166,  255,
 /*   900 */   259,  273,  264,  263,  112,  265,  157,  156,  276,  281,
 /*   910 */   271,  121,  142,  288,   64,  133,  117,  282,  146,  125,
 /*   920 */   139,  161,  298,  111,  303,  301,  115,  321,  144,   67,
 /*   930 */   304,  344,  308,  152,   68,  326,  348,  328,  179,  135,
 /*   940 */   175,  306,  105,  150,  349,  148,  104,  305,  181,  311,
 /*   950 */   318,  193,  162,  129,  320,  131,  358,  347,  356,  359,
 /*   960 */   372,  364,  373,  376,  362,  383,  154,   66,  367,  354,
 /*   970 */   377,   49,  391,  379,  378,  393,  394,  397,  400,  401,
 /*   980 */   398,  402,  113,  407,  781,  812,  127,  403,  404,  408,
 /*   990 */   817,  818,  399,  417,  422,  123,  143,  426,  119,  425,
 /*  1000 */   427,  429,  428,  430,  166,  786,  433,  787,  436,  439,
 /*  1010 */   811,  441,  157,  156,  826,  446,  444,  121,  142,  447,
 /*  1020 */   448,  133,  117,  445,  146,  125,  139,  161,  452,  828,
 /*  1030 */   454,  451,  115,  456,  144,  459,  462,  460,  461,  152,
 /*  1040 */   465,  468,  829,  475,  476,  135,  831,  485,  480,  150,
 /*  1050 */   652,  148,  164,  477,  482,  654,  484,  794,  162,  129,
 /*  1060 */   487,  131,  488,  491,  837,  492,  493,  709,  498,  712,
 /*  1070 */   494,  497,  154,  496,  503,  499,  501,  504,  505,  506,
 /*  1080 */   509,  513,  715,  717,  718,  519,  522,  518,  516,  517,
 /*  1090 */   520,  523,  127,  795,  527,  525,  798,  534,  799,  800,
 /*  1100 */   801,  123,  143,  802,  119,  805,  807,  541,  808,  538,
 /*  1110 */   166,  806,  542,  803,  548,  545,  546,  507,  157,  156,
 /*  1120 */   507,  544,  838,  121,  142,  841,  547,  133,  117,  550,
 /*  1130 */   146,  125,  139,  161,  551,  507,  507,  507,  115,  507,
 /*  1140 */   144,  507,  507,  507,  507,  152,  507,  507,  507,  507,
 /*  1150 */   507,  135,  507,  507,  507,  150,  507,  148,  223,  507,
 /*  1160 */   507,  507,  507,  507,  162,  129,  507,  131,  507,  507,
 /*  1170 */   507,  507,  507,  507,  507,  507,  507,  507,  154,  507,
 /*  1180 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1190 */   507,  507,  507,  507,  507,  507,  507,  507,  127,  507,
 /*  1200 */   507,  507,  507,  507,  507,  507,  507,  123,  143,  507,
 /*  1210 */   119,  507,  507,  507,  507,  507,  166,  507,  507,  507,
 /*  1220 */   507,  507,  507,  507,  157,  156,  507,  507,  507,  121,
 /*  1230 */   142,  507,  507,  133,  117,  507,  146,  125,  139,  161,
 /*  1240 */   507,  507,  507,  507,  115,  507,  144,  507,  507,  507,
 /*  1250 */   507,  152,  507,  507,  507,  507,  507,  135,  507,  507,
 /*  1260 */   507,  150,  507,  148,  104,  507,  507,  507,  507,  507,
 /*  1270 */   162,  129,  507,  131,  507,  507,  507,  507,  507,  507,
 /*  1280 */   507,  507,  507,  507,  154,  507,  507,  507,  507,  507,
 /*  1290 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1300 */   507,  507,  507,  507,  127,  507,  507,  507,  507,  507,
 /*  1310 */   507,  507,  507,  123,  143,  507,  119,  507,  507,  507,
 /*  1320 */   507,  507,  166,  507,  507,  507,  507,  507,  507,  507,
 /*  1330 */   157,  156,  507,  507,  507,  121,  142,  507,  507,  133,
 /*  1340 */   117,  507,  146,  125,  139,  161,  507,  162,  129,  507,
 /*  1350 */   131,  507,  144,  507,  507,  507,  507,  152,  507,  507,
 /*  1360 */   507,  154,  507,  135,  507,  507,  507,  150,  507,  148,
 /*  1370 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1380 */   507,  127,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1390 */   123,  143,  507,  119,  507,  507,  507,  507,  507,  166,
 /*  1400 */   507,  507,  507,  507,  507,  177,  507,  157,  156,  183,
 /*  1410 */   507,  507,  121,  142,  507,  507,  133,  117,  507,  146,
 /*  1420 */   125,  139,  161,  177,  507,  507,  507,  183,  507,  144,
 /*  1430 */   507,  507,  507,  507,  152,  507,  507,  507,  507,  507,
 /*  1440 */   135,  112,  507,  507,  150,  507,  148,  507,  507,  507,
 /*  1450 */   507,   64,  507,  507,  507,  507,  507,  507,  507,  112,
 /*  1460 */   111,  507,  507,  507,  507,  507,   67,  507,  507,   64,
 /*  1470 */   507,   68,  507,  507,  507,  179,  507,  175,  111,  105,
 /*  1480 */   507,  507,  507,  507,   67,  181,  507,  507,  193,   68,
 /*  1490 */   507,  507,  507,  179,  507,  175,  507,  105,  129,  507,
 /*  1500 */   131,  507,  286,  181,   66,  507,  193,  507,  507,  507,
 /*  1510 */   507,  154,  507,  507,  507,  507,  507,  507,  507,  113,
 /*  1520 */   507,  507,   66,  507,  507,  507,  507,  507,  507,  507,
 /*  1530 */   507,  507,  507,  507,  507,  507,  507,  113,  507,  507,
 /*  1540 */   123,  507,  507,  119,  507,  507,  507,  507,  507,  507,
 /*  1550 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
 /*  1560 */   507,  507,  121,  507,  507,  507,  133,  117,  507,  146,
 /*  1570 */   507,  507,  507,  507,  507,  507,  507,  507,  507,  144,
 /*  1580 */   507,  507,  507,  507,  152,  507,  507,  507,  507,  507,
 /*  1590 */   135,  507,  507,  507,  150,  507,  148,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */     5,    6,  157,  158,  159,   90,   11,   12,   59,   14,
 /*    10 */     6,  154,   32,  156,  132,   18,   34,   20,   18,  137,
 /*    20 */    25,  106,   32,   74,   27,   43,  181,   27,   31,   32,
 /*    30 */   185,   68,   83,  151,  142,  143,  144,  106,  139,   90,
 /*    40 */    45,  196,   93,    1,  142,  143,   83,  145,   66,   54,
 /*    50 */    55,   51,   57,  154,   59,  156,   93,   11,   63,   59,
 /*    60 */   106,  112,   82,   59,   13,   85,   71,   72,   17,  170,
 /*    70 */    90,   76,   77,  181,   74,   80,   81,   87,   83,   84,
 /*    80 */    85,   86,   85,  181,   87,  206,   91,  105,   93,  157,
 /*    90 */    48,    6,   95,   98,   97,   95,  157,  158,  159,  104,
 /*   100 */    49,   55,   60,  108,  122,  110,  204,  112,    5,   63,
 /*   110 */    59,  184,  112,  181,   11,   12,  112,   14,  121,   68,
 /*   120 */   181,  121,   18,   77,  185,   74,  157,   25,   25,  181,
 /*   130 */    79,   27,  200,   87,   83,  196,   85,   18,   87,   20,
 /*   140 */    22,   99,   59,  101,   93,  137,  198,   96,   45,  157,
 /*   150 */   181,   32,   42,   43,  185,   51,    0,   54,   55,  151,
 /*   160 */    57,  110,   25,  112,   79,  196,   63,  157,  158,  159,
 /*   170 */    34,   49,   13,  181,   71,   72,   17,  136,  127,   76,
 /*   180 */    77,   59,    1,   80,   81,  131,   83,   84,   85,   86,
 /*   190 */    68,  181,  200,  201,   91,  112,   93,   47,  157,   95,
 /*   200 */    98,   98,   66,   47,   85,   83,   87,  104,   49,   87,
 /*   210 */   108,  108,  110,  110,   95,   93,   97,    5,   59,  165,
 /*   220 */    83,  103,  181,   11,   12,  121,   14,   68,   46,   48,
 /*   230 */    93,  177,  129,   74,  112,   98,  157,   25,   79,  129,
 /*   240 */   121,   60,   83,  116,   85,  108,   87,  110,  157,  158,
 /*   250 */   159,   69,   93,   59,   46,   96,  106,   45,  122,   59,
 /*   260 */   181,  205,  106,  106,  105,  209,   54,   55,   74,   57,
 /*   270 */   214,  112,  181,   73,   74,   63,   59,   69,  138,   26,
 /*   280 */   140,   46,  101,   71,   72,  103,  127,  147,   76,   77,
 /*   290 */    73,   74,   80,   81,   46,   83,   84,   85,   86,  106,
 /*   300 */   106,   59,  120,   91,   69,   93,  112,   82,  185,  116,
 /*   310 */    98,  103,  112,  173,   18,   90,  104,   69,   22,  196,
 /*   320 */   108,   79,  110,   27,   59,  185,    5,  115,  120,  112,
 /*   330 */   207,  208,   11,   12,   59,   14,  196,  193,  103,   74,
 /*   340 */    22,   59,  165,  179,   79,  181,   25,   51,   39,   74,
 /*   350 */    46,  103,  188,  189,  112,  120,   74,   22,  185,   12,
 /*   360 */    46,   14,   64,   46,   43,  181,   45,  113,  120,  196,
 /*   370 */    52,  117,   25,   69,   16,   54,   55,  112,   57,  157,
 /*   380 */   207,  208,  128,   69,   63,  110,   69,  112,   79,  212,
 /*   390 */   213,   95,   71,   72,  112,  206,   64,   76,   77,  103,
 /*   400 */   106,   80,   81,  181,   83,   84,   85,   86,   73,   74,
 /*   410 */   106,  113,   91,   46,   93,  117,   22,  121,   33,   98,
 /*   420 */   106,  151,  152,  106,  120,  104,  128,   80,  177,  108,
 /*   430 */    83,  110,    5,  166,  120,  184,   69,  120,   11,   12,
 /*   440 */    93,   14,  157,  158,   34,   98,  114,   62,  181,  166,
 /*   450 */   167,  104,   25,  121,   46,  108,    2,  110,  100,  166,
 /*   460 */   167,  191,   46,    9,  181,  107,  181,    4,  166,  167,
 /*   470 */   194,  195,   45,  106,  181,  206,   66,   69,  166,  167,
 /*   480 */   102,   54,   55,  181,   57,   69,    7,  120,   22,  111,
 /*   490 */    63,  166,  167,  181,  166,  167,   45,  106,   71,   72,
 /*   500 */   106,   38,  157,   76,   77,  157,  181,   80,   81,  181,
 /*   510 */    83,   84,   85,   86,  106,   36,  157,    4,   91,  174,
 /*   520 */    93,   67,  106,  148,  130,   98,  181,  157,  120,  181,
 /*   530 */    79,  104,  122,  174,  157,  108,  120,  110,  157,  157,
 /*   540 */   181,    5,  115,  157,  157,  157,  157,   11,   12,  157,
 /*   550 */    14,  181,  157,  103,  157,   89,  157,  106,  181,  157,
 /*   560 */   157,   25,  181,  181,  157,   10,   22,  181,  181,  181,
 /*   570 */   181,  157,  157,  181,  157,  206,  181,   85,  181,   87,
 /*   580 */   181,   45,  157,  181,  181,  157,   22,  157,  181,  131,
 /*   590 */    54,   55,   22,   57,  185,  181,  181,  197,  181,   63,
 /*   600 */   157,  157,  157,  203,  157,  196,  181,   71,   72,  181,
 /*   610 */    22,  181,   76,   77,  157,  131,   80,   81,  105,   83,
 /*   620 */    84,   85,   86,  165,  181,  181,  181,   91,  181,   93,
 /*   630 */    31,  157,  157,   22,   98,  157,   22,  157,  181,  103,
 /*   640 */   104,   49,  157,   49,  108,    5,  110,  103,  157,  165,
 /*   650 */   157,   11,   12,  157,   14,  181,  181,  157,   22,  181,
 /*   660 */    68,  181,   68,  157,   22,   25,  181,  103,  185,   39,
 /*   670 */    22,   22,  181,  103,  181,  157,   22,  181,   88,  196,
 /*   680 */    90,  181,  185,  157,  129,   45,   87,  181,  171,  157,
 /*   690 */   171,  103,   22,  196,   54,   55,   22,   57,  181,  181,
 /*   700 */   181,   70,   39,   63,   90,  157,  105,  181,  185,   79,
 /*   710 */   106,   71,   72,  181,  103,   39,   76,   77,  181,  196,
 /*   720 */    80,   81,   91,   83,   84,   85,   86,  126,   22,  181,
 /*   730 */   185,   91,  105,   93,  130,  198,  133,  146,   98,  103,
 /*   740 */   106,  196,  181,  103,  104,  103,   39,   49,  108,    5,
 /*   750 */   110,  103,  103,  126,   90,   11,   12,  103,   14,   52,
 /*   760 */   184,  106,  106,  106,  184,    8,   68,   10,   65,   25,
 /*   770 */   107,  169,   75,  103,  202,   79,   39,  103,   39,  124,
 /*   780 */   184,   24,  106,  105,  184,   28,   29,  180,  153,   45,
 /*   790 */   185,   34,  130,  161,   37,  217,   56,   40,   54,   55,
 /*   800 */    43,   57,  163,  162,   58,   92,  187,   63,   78,  103,
 /*   810 */    68,  178,  199,   68,  199,   71,   72,  199,   15,   22,
 /*   820 */    76,   77,   20,   66,   80,   81,  141,   83,   84,   85,
 /*   830 */    86,  202,   59,  164,   90,   91,  177,   93,   39,  181,
 /*   840 */     5,  181,   98,   39,  177,   10,   11,   12,  104,   14,
 /*   850 */    25,   94,  108,   87,  110,   79,   99,  105,  101,  105,
 /*   860 */    25,  105,  105,  129,  135,  134,   43,   79,   13,   22,
 /*   870 */   103,  181,   17,  103,   22,  181,   22,  103,  103,  122,
 /*   880 */    45,  181,  125,  202,   79,   15,   22,  175,  141,   54,
 /*   890 */    55,  181,   57,   73,  183,  181,  181,   39,   63,  150,
 /*   900 */   181,   90,  124,  215,   49,   79,   71,   72,  181,  183,
 /*   910 */   202,   76,   77,   39,   59,   80,   81,  215,   83,   84,
 /*   920 */    85,   86,  103,   68,  181,  184,   91,   79,   93,   74,
 /*   930 */   168,  199,  181,   98,   79,  164,  103,  169,   83,  104,
 /*   940 */    85,  191,   87,  108,  165,  110,    5,  192,   93,  190,
 /*   950 */   190,   96,   11,   12,  190,   14,   75,  199,  181,   79,
 /*   960 */    75,   79,   79,   97,  184,  204,   25,  112,  184,  204,
 /*   970 */   181,   32,  181,  192,  168,  181,    6,  181,   90,  181,
 /*   980 */   211,  150,  127,   50,  129,   10,   45,  160,  216,   41,
 /*   990 */    90,   90,  210,  181,   88,   54,   55,  181,   57,   64,
 /*  1000 */    90,  150,  181,   79,   63,  106,  184,   64,   10,   43,
 /*  1010 */   106,  106,   71,   72,   43,  186,   91,   76,   77,  181,
 /*  1020 */   107,   80,   81,  193,   83,   84,   85,   86,   45,  106,
 /*  1030 */   217,  181,   91,   45,   93,  186,   79,   70,  181,   98,
 /*  1040 */   172,   79,  106,   52,  181,  104,  106,  150,  181,  108,
 /*  1050 */   106,  110,    5,  217,  181,  106,  181,  106,   11,   12,
 /*  1060 */   181,   14,  150,   52,  106,  181,  150,  106,  150,  106,
 /*  1070 */   217,  181,   25,  186,   70,  107,  217,  181,  150,  172,
 /*  1080 */    79,  186,  106,   70,   70,   52,   35,  150,  186,  181,
 /*  1090 */   181,  112,   45,  106,  165,  181,  106,  182,  106,  106,
 /*  1100 */   106,   54,   55,  106,   57,  106,  106,  181,  106,  182,
 /*  1110 */    63,  106,  103,  106,   30,  165,    6,  218,   71,   72,
 /*  1120 */   218,  149,  106,   76,   77,  106,  181,   80,   81,  149,
 /*  1130 */    83,   84,   85,   86,  181,  218,  218,  218,   91,  218,
 /*  1140 */    93,  218,  218,  218,  218,   98,  218,  218,  218,  218,
 /*  1150 */   218,  104,  218,  218,  218,  108,  218,  110,    5,  218,
 /*  1160 */   218,  218,  218,  218,   11,   12,  218,   14,  218,  218,
 /*  1170 */   218,  218,  218,  218,  218,  218,  218,  218,   25,  218,
 /*  1180 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1190 */   218,  218,  218,  218,  218,  218,  218,  218,   45,  218,
 /*  1200 */   218,  218,  218,  218,  218,  218,  218,   54,   55,  218,
 /*  1210 */    57,  218,  218,  218,  218,  218,   63,  218,  218,  218,
 /*  1220 */   218,  218,  218,  218,   71,   72,  218,  218,  218,   76,
 /*  1230 */    77,  218,  218,   80,   81,  218,   83,   84,   85,   86,
 /*  1240 */   218,  218,  218,  218,   91,  218,   93,  218,  218,  218,
 /*  1250 */   218,   98,  218,  218,  218,  218,  218,  104,  218,  218,
 /*  1260 */   218,  108,  218,  110,    5,  218,  218,  218,  218,  218,
 /*  1270 */    11,   12,  218,   14,  218,  218,  218,  218,  218,  218,
 /*  1280 */   218,  218,  218,  218,   25,  218,  218,  218,  218,  218,
 /*  1290 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1300 */   218,  218,  218,  218,   45,  218,  218,  218,  218,  218,
 /*  1310 */   218,  218,  218,   54,   55,  218,   57,  218,  218,  218,
 /*  1320 */   218,  218,   63,  218,  218,  218,  218,  218,  218,  218,
 /*  1330 */    71,   72,  218,  218,  218,   76,   77,  218,  218,   80,
 /*  1340 */    81,  218,   83,   84,   85,   86,  218,   11,   12,  218,
 /*  1350 */    14,  218,   93,  218,  218,  218,  218,   98,  218,  218,
 /*  1360 */   218,   25,  218,  104,  218,  218,  218,  108,  218,  110,
 /*  1370 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1380 */   218,   45,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1390 */    54,   55,  218,   57,  218,  218,  218,  218,  218,   63,
 /*  1400 */   218,  218,  218,  218,  218,   13,  218,   71,   72,   17,
 /*  1410 */   218,  218,   76,   77,  218,  218,   80,   81,  218,   83,
 /*  1420 */    84,   85,   86,   13,  218,  218,  218,   17,  218,   93,
 /*  1430 */   218,  218,  218,  218,   98,  218,  218,  218,  218,  218,
 /*  1440 */   104,   49,  218,  218,  108,  218,  110,  218,  218,  218,
 /*  1450 */   218,   59,  218,  218,  218,  218,  218,  218,  218,   49,
 /*  1460 */    68,  218,  218,  218,  218,  218,   74,  218,  218,   59,
 /*  1470 */   218,   79,  218,  218,  218,   83,  218,   85,   68,   87,
 /*  1480 */   218,  218,  218,  218,   74,   93,  218,  218,   96,   79,
 /*  1490 */   218,  218,  218,   83,  218,   85,  218,   87,   12,  218,
 /*  1500 */    14,  218,  110,   93,  112,  218,   96,  218,  218,  218,
 /*  1510 */   218,   25,  218,  218,  218,  218,  218,  218,  218,  127,
 /*  1520 */   218,  218,  112,  218,  218,  218,  218,  218,  218,  218,
 /*  1530 */   218,  218,  218,  218,  218,  218,  218,  127,  218,  218,
 /*  1540 */    54,  218,  218,   57,  218,  218,  218,  218,  218,  218,
 /*  1550 */   218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
 /*  1560 */   218,  218,   76,  218,  218,  218,   80,   81,  218,   83,
 /*  1570 */   218,  218,  218,  218,  218,  218,  218,  218,  218,   93,
 /*  1580 */   218,  218,  218,  218,   98,  218,  218,  218,  218,  218,
 /*  1590 */   104,  218,  218,  218,  108,  218,  110,
};
#define YY_SHIFT_USE_DFLT (-86)
static short yy_shift_ofst[] = {
 /*     0 */   150,  156,  -86,  757,  -69,  -86,  -46,  127,  -85,  157,
 /*    10 */   253,   42,  -86,  -86,  -86,  -86,  -86,  -86,  282,  -86,
 /*    20 */   -86,  -86,  -86,  193,  294,  193,  391,  193,  634,   85,
 /*    30 */   656,  282,  118,  450,  657,    0,  -86,   83,  -86,   -3,
 /*    40 */   -86,  282,  119,  -86,  664,  -86,  -10,  664,  -86,  703,
 /*    50 */   -86,  385,  -86,  -86,  697,  479,  664,  -86,  -86,  -86,
 /*    60 */   664,  -86,  696, 1410,  309,   51,  737,  739,  159,  -86,
 /*    70 */   182,  678,  -86,  463,  -86,  318,  662,  740,  746,  713,
 /*    80 */   730,  -86,  -37,  -86,  742,  -86,  745,  -86,  466,  -37,
 /*    90 */   -86,  -37,  -86,  803, 1410,  797, 1410,  802,  479,  -86,
 /*   100 */   773,  -86,  -86,  941, 1410,  -86,  799,  282,  804,  282,
 /*   110 */   -86,  -86,  -86,  -86, 1336, 1410, 1259, 1410,  347, 1410,
 /*   120 */   347, 1410,  347, 1410,  347, 1410, 1486, 1410, 1486, 1410,
 /*   130 */   137, 1410,  137, 1410,  137, 1410,  137, 1410, 1486,   46,
 /*   140 */  1410, 1486,  -86,  -86, 1410,  102, 1410,  102, 1410,  825,
 /*   150 */  1410,  825, 1410,  825, 1410,  -86,  -86,  492,  -86,  766,
 /*   160 */   -86,  -86, 1410, 1047, 1410, 1486,  776,  159,  208,  513,
 /*   170 */   752,  754,  756,  -86,  941, 1410, 1336, 1410,  -86, 1410,
 /*   180 */   -86, 1410,  -86,  855,  103,  734,  110,  823,  -86, 1410,
 /*   190 */   212, 1410,  941,  788,  181,  767,  -86,  847,  282,  770,
 /*   200 */   -86,  852,  282,  774,  -86,  854,  282,  775,  -86, 1410,
 /*   210 */   321, 1410,  427, 1410,  941,  544,  -86, 1410,  -86,  -86,
 /*   220 */   -86, 1410, 1153, 1410, 1336,  805,  159,  235,  -86,  564,
 /*   230 */   -86,  802,  479,  -86, 1410,  941,  870, 1410,  864, 1410,
 /*   240 */   941,  -86,  -86,  335,  -86,  -86,  -86,  200,  -86,  217,
 /*   250 */   -86,  820,  -86,  265,  858,    4,  -86,  -86,  282,  -86,
 /*   260 */   -86,  811,  778,  -86,  826,  282,  570,  -86,  282,  -86,
 /*   270 */   479,  -86,  -86, 1410,  941,  282,  -86,  678,  248,    4,
 /*   280 */   811,  778,  -86, 1392,   -5,  -86,  -86,  874,  275,  -86,
 /*   290 */   -86,  -86,  -86,  536,  -86,  588,  -86,  819,  -86,  640,
 /*   300 */   664,  -86,  282,  848,  -86,  225,  -86,  282,  -86,  136,
 /*   310 */   358,  -86,  599,  -86,  -86,  -86,  -86,  358,  -86,  358,
 /*   320 */   -86,  282,  611,  -86,  -86,  773,  -86,  703,  -86,  -86,
 /*   330 */   122,  -86,  -86,  -86,  592,  -86,  -86,  594,  -86,  -86,
 /*   340 */   -86,  -86,  242,  -37,  636,  -86,  -37,  833,  -86,  -86,
 /*   350 */   -86,  -86,  296,  104,  -86,  282,  -86,  881,  880,  282,
 /*   360 */   642,  664,  -86,  882,  282,  648,  664,  -86, 1410,  744,
 /*   370 */   -86,  885,  883,  282,  649,  866,  282,  848,  -86,  -20,
 /*   380 */   939,  -86,  -86,  -86,  -86,  -86,  678,  304,  332,  254,
 /*   390 */   282,  -86,  282,  970,  678,  314,  282,  454,  410,  888,
 /*   400 */   282,  858,  933,  555,  975, 1410,  835,  948,  378,  -86,
 /*   410 */   -86,  900,  901,  590,  282,  614,  282,  -86,  -86,  -86,
 /*   420 */   -86,  906,  -86,  -86,  935,  282,  910,  282,  630,  924,
 /*   430 */   282,  654,  -85,  899,  943,  998,  -18,  317,  966,  904,
 /*   440 */   905,  -18,  971,  925,   42,  -86,  282,  913,  282,  394,
 /*   450 */   282,  983, 1410,  941,  923,  988, 1410,  941,  631,  967,
 /*   460 */   282,  957,  282,  670,  -86,  601,  367,  962, 1410,  674,
 /*   470 */  1410,  941,  936,  941,  991,  282,  604,  940,  298,  282,
 /*   480 */   944,  282,  949,  282,  676,  951,  282,  676,  958,  408,
 /*   490 */  1011,  282,  858,  604,  961,  925,  282,  663,  968,  282,
 /*   500 */   394,  963, 1004,  282,  858,  957,  627,  416, 1001, 1410,
 /*   510 */   706,  976,  631, 1013, 1014,  925,  282,  707, 1033,  282,
 /*   520 */   655, 1051,  979,  987,  194,  990,   83,  451,  -51,  992,
 /*   530 */   993,  994,  997,  698,  999, 1000, 1002,  698, 1005,  -86,
 /*   540 */   282, 1009, 1007, 1084,   83, 1110,  282, 1016,  -86, 1084,
 /*   550 */   282, 1019,  -86,  -86,  -86,
};
#define YY_REDUCE_USE_DFLT (-156)
static short yy_reduce_ofst[] = {
 /*     0 */  -101, -143, -156,  140, -156, -156, -156, -121,  -73, -156,
 /*    10 */  -156,  144, -156, -156, -156, -156, -156, -156,  184, -156,
 /*    20 */  -156, -156, -156,  189, -156,  269, -156,  369, -156,  375,
 /*    30 */  -156, -108,  591, -156, -156,  -98, -156,  177,  603, -118,
 /*    40 */  -156,  561,    8, -156,  576, -156, -156,  580, -156,  602,
 /*    50 */  -156, -156, -156, -156, -156,  572,  596, -156, -156, -156,
 /*    60 */   600, -156, -156,   79, -156,   10, -156, -156,  -31, -156,
 /*    70 */   607,  605, -156,  635,  276,  632,  578,  641,  639,  619,
 /*    80 */   633, -156,  613, -156, -156, -156, -156, -156, -156,  615,
 /*    90 */  -156,  618, -156, -156,   -8, -156,  -68,  685,  629, -156,
 /*   100 */   669, -156, -156,  659,  222, -156, -156,  658, -156,  660,
 /*   110 */  -156, -156, -156, -156,  659,  348,  659,  370,  659,  377,
 /*   120 */   659,  381,  659,  382,  659,  386,  659,  387,  659,  388,
 /*   130 */   659,  389,  659,  392,  659,  395,  659,  397,  659,  667,
 /*   140 */   399,  659, -156, -156,  402,  659,  403,  659,  407,  659,
 /*   150 */   414,  659,  415,  659,  417,  659, -156, -156, -156, -156,
 /*   160 */  -156, -156,  425,  659,  428,  659, -156, -155,  607, -156,
 /*   170 */  -156, -156, -156, -156,  659,  430,  659,  443,  659,  444,
 /*   180 */   659,  445,  659,   41,  659,  729,  731, -156, -156,  447,
 /*   190 */   659,  457,  659, -156, -156, -156, -156, -156,  690, -156,
 /*   200 */  -156, -156,  694, -156, -156, -156,  700, -156, -156,  474,
 /*   210 */   659,  475,  659,  478,  659, -156, -156,  285, -156, -156,
 /*   220 */  -156,  480,  659,  485,  659, -156,  -61,  607, -156, -156,
 /*   230 */  -156,  747,  681, -156,  491,  659, -156,   91, -156,  493,
 /*   240 */   659, -156,  400,  712, -156, -156, -156,  710, -156,  714,
 /*   250 */  -156, -156, -156,  715,  749,  458, -156, -156,  719, -156,
 /*   260 */  -156,  711,  688, -156, -156,  283, -156, -156,  267, -156,
 /*   270 */   708, -156, -156,  496,  659,  727, -156,  409,  607,  484,
 /*   280 */   726,  702, -156,  500,   54, -156, -156, -156,  658, -156,
 /*   290 */  -156, -156, -156,  659, -156, -156, -156, -156, -156,  659,
 /*   300 */   741, -156,  743,  762,  755,  750, -156,  751, -156, -156,
 /*   310 */   759, -156, -156, -156, -156, -156, -156,  760, -156,  764,
 /*   320 */  -156,  293, -156, -156, -156,  771, -156,  768, -156, -156,
 /*   330 */  -156, -156, -156, -156, -156, -156, -156, -156, -156, -156,
 /*   340 */  -156, -156,  779,  732, -156, -156,  758, -156, -156, -156,
 /*   350 */  -156, -156,  761,  765, -156,  777, -156, -156, -156,  302,
 /*   360 */  -156,  780, -156, -156,  312, -156,  784, -156,  506,  251,
 /*   370 */  -156, -156, -156,  325, -156, -156,  789,  806,  781,  270,
 /*   380 */  -156, -156, -156, -156, -156, -156,  483,  607,   56, -156,
 /*   390 */   791, -156,  794, -156,  497,  607,  796,  769,  782, -156,
 /*   400 */   798,  831,  827,  772, -156,  518,  659, -156, -156, -156,
 /*   410 */  -156, -156, -156, -156,  517, -156,  812, -156, -156, -156,
 /*   420 */  -156, -156, -156, -156, -156,  816, -156,  821,  851, -156,
 /*   430 */   328, -156,  822, -156, -156, -156,  123,  607, -156, -156,
 /*   440 */  -156,  173, -156,  829,  830, -156,  838, -156,  -52,  813,
 /*   450 */   850, -156,  526,  659, -156, -156,  532,  659,  849, -156,
 /*   460 */   857,  868,  519, -156, -156,  523,  607, -156,  345, -156,
 /*   470 */   548,  659, -156,  659, -156,  863,  836, -156, -156,  867,
 /*   480 */  -156,  873, -156,  875,  897, -156,  879,  912, -156,  607,
 /*   490 */  -156,  884,  916,  853, -156,  887,  890,  918, -156,  537,
 /*   500 */   859, -156, -156,  896,  928,  907,  545,  607, -156,  359,
 /*   510 */  -156, -156,  895, -156, -156,  902,  908,  937, -156,  909,
 /*   520 */  -156, -156, -156, -156,  914, -156,  929, -156,  164, -156,
 /*   530 */  -156, -156, -156,  915, -156, -156, -156,  927, -156, -156,
 /*   540 */   926, -156, -156,  972,  950, -156,  945, -156, -156,  980,
 /*   550 */   953, -156, -156, -156, -156,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   562,  562,  557,  842,  842,  558,  842,  564,  842,  842,
 /*    10 */   842,  842,  644,  647,  648,  649,  650,  651,  565,  566,
 /*    20 */   583,  584,  585,  842,  842,  842,  842,  842,  842,  842,
 /*    30 */   842,  842,  842,  842,  842,  842,  576,  586,  596,  578,
 /*    40 */   595,  842,  842,  597,  643,  608,  842,  643,  609,  628,
 /*    50 */   626,  842,  629,  630,  842,  698,  643,  610,  696,  697,
 /*    60 */   643,  611,  842,  842,  727,  785,  733,  728,  842,  656,
 /*    70 */   842,  842,  657,  665,  667,  674,  710,  701,  703,  691,
 /*    80 */   705,  662,  842,  592,  842,  593,  842,  594,  706,  842,
 /*    90 */   707,  842,  708,  842,  842,  692,  842,  699,  698,  693,
 /*   100 */   842,  580,  700,  695,  842,  726,  842,  842,  729,  842,
 /*   110 */   730,  731,  732,  734,  737,  842,  738,  842,  739,  842,
 /*   120 */   740,  842,  741,  842,  742,  842,  743,  842,  744,  842,
 /*   130 */   745,  842,  746,  842,  747,  842,  748,  842,  749,  842,
 /*   140 */   842,  750,  751,  752,  842,  753,  842,  754,  842,  755,
 /*   150 */   842,  756,  842,  757,  842,  758,  759,  842,  760,  842,
 /*   160 */   763,  761,  842,  842,  842,  769,  842,  785,  842,  842,
 /*   170 */   842,  842,  842,  772,  784,  842,  764,  842,  765,  842,
 /*   180 */   766,  842,  767,  842,  842,  842,  842,  842,  775,  842,
 /*   190 */   842,  842,  776,  842,  842,  842,  833,  842,  842,  842,
 /*   200 */   834,  842,  842,  842,  835,  842,  842,  842,  836,  842,
 /*   210 */   842,  842,  842,  842,  777,  842,  771,  785,  782,  783,
 /*   220 */   762,  842,  842,  842,  770,  842,  785,  842,  774,  842,
 /*   230 */   773,  699,  698,  694,  842,  704,  842,  785,  702,  842,
 /*   240 */   711,  666,  677,  675,  676,  682,  683,  842,  684,  842,
 /*   250 */   685,  842,  686,  842,  680,  673,  581,  582,  842,  671,
 /*   260 */   672,  688,  690,  678,  842,  842,  842,  689,  842,  791,
 /*   270 */   698,  793,  792,  842,  687,  842,  681,  842,  842,  673,
 /*   280 */   688,  690,  679,  842,  673,  668,  669,  842,  842,  670,
 /*   290 */   663,  664,  768,  842,  725,  842,  735,  842,  736,  842,
 /*   300 */   643,  612,  842,  789,  616,  613,  617,  842,  618,  842,
 /*   310 */   842,  619,  842,  622,  623,  624,  625,  842,  620,  842,
 /*   320 */   621,  842,  842,  790,  614,  842,  615,  628,  627,  598,
 /*   330 */   842,  599,  600,  601,  842,  602,  605,  842,  603,  606,
 /*   340 */   604,  607,  587,  842,  842,  588,  842,  842,  589,  591,
 /*   350 */   590,  579,  842,  842,  633,  842,  636,  842,  842,  842,
 /*   360 */   842,  643,  637,  842,  842,  842,  643,  638,  842,  643,
 /*   370 */   639,  842,  842,  842,  842,  842,  842,  789,  616,  641,
 /*   380 */   842,  640,  642,  634,  635,  577,  842,  842,  573,  842,
 /*   390 */   842,  571,  842,  842,  842,  842,  842,  816,  842,  842,
 /*   400 */   842,  680,  821,  842,  842,  842,  842,  842,  842,  822,
 /*   410 */   823,  842,  842,  842,  842,  842,  842,  723,  724,  813,
 /*   420 */   814,  842,  815,  572,  842,  842,  842,  842,  842,  842,
 /*   430 */   842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
 /*   440 */   842,  842,  842,  645,  842,  646,  842,  842,  842,  842,
 /*   450 */   842,  842,  842,  713,  842,  842,  842,  714,  842,  842,
 /*   460 */   842,  721,  842,  842,  722,  842,  842,  842,  842,  842,
 /*   470 */   842,  719,  842,  720,  842,  842,  842,  842,  842,  842,
 /*   480 */   842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
 /*   490 */   842,  842,  680,  842,  842,  645,  842,  842,  842,  842,
 /*   500 */   842,  842,  842,  842,  680,  721,  842,  842,  842,  842,
 /*   510 */   842,  842,  842,  842,  842,  645,  842,  842,  842,  842,
 /*   520 */   842,  842,  842,  842,  842,  842,  842,  842,  810,  842,
 /*   530 */   842,  842,  842,  842,  842,  842,  842,  842,  842,  809,
 /*   540 */   842,  842,  842,  840,  842,  842,  842,  842,  839,  840,
 /*   550 */   842,  842,  559,  561,  556,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
   59,  /*      ABORT => ID */
   59,  /*      AFTER => ID */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*        ALL => nothing */
    0,  /*        AND => nothing */
    0,  /*         AS => nothing */
   59,  /*        ASC => ID */
   59,  /*     ATTACH => ID */
   59,  /*     BEFORE => ID */
   59,  /*      BEGIN => ID */
    0,  /*    BETWEEN => nothing */
    0,  /*     BITAND => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*      BITOR => nothing */
    0,  /*         BY => nothing */
   59,  /*    CASCADE => ID */
    0,  /*       CASE => nothing */
    0,  /*      CHECK => nothing */
   59,  /*    CLUSTER => ID */
    0,  /*    COLLATE => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*      COMMA => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*     COMMIT => nothing */
    0,  /*     CONCAT => nothing */
   59,  /*   CONFLICT => ID */
    0,  /* CONSTRAINT => nothing */
   59,  /*       COPY => ID */
    0,  /*     CREATE => nothing */
   59,  /*   DATABASE => ID */
    0,  /*    DEFAULT => nothing */
    0,  /* DEFERRABLE => nothing */
   59,  /*   DEFERRED => ID */
    0,  /*     DELETE => nothing */
   59,  /* DELIMITERS => ID */
   59,  /*       DESC => ID */
   59,  /*     DETACH => ID */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       DROP => nothing */
   59,  /*       EACH => ID */
    0,  /*       ELSE => nothing */
   59,  /*        END => ID */
    0,  /* END_OF_FILE => nothing */
    0,  /*         EQ => nothing */
    0,  /*     EXCEPT => nothing */
   59,  /*    EXPLAIN => ID */
   59,  /*       FAIL => ID */
    0,  /*      FLOAT => nothing */
   59,  /*        FOR => ID */
    0,  /*    FOREIGN => nothing */
    0,  /*       FROM => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*         GE => nothing */
   59,  /*       GLOB => ID */
    0,  /*      GROUP => nothing */
    0,  /*         GT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*         ID => nothing */
   59,  /*     IGNORE => ID */
    0,  /*    ILLEGAL => nothing */
   59,  /*  IMMEDIATE => ID */
    0,  /*         IN => nothing */
    0,  /*      INDEX => nothing */
   59,  /*  INITIALLY => ID */
    0,  /*     INSERT => nothing */
   59,  /*    INSTEAD => ID */
    0,  /*    INTEGER => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*       INTO => nothing */
    0,  /*         IS => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*       JOIN => nothing */
    0,  /*    JOIN_KW => nothing */
   59,  /*        KEY => ID */
    0,  /*         LE => nothing */
   59,  /*       LIKE => ID */
    0,  /*      LIMIT => nothing */
    0,  /*         LP => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*         LT => nothing */
   59,  /*      MATCH => ID */
    0,  /*      MINUS => nothing */
    0,  /*         NE => nothing */
    0,  /*        NOT => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*       NULL => nothing */
   59,  /*         OF => ID */
   59,  /*     OFFSET => ID */
    0,  /*         ON => nothing */
    0,  /*         OR => nothing */
    0,  /*      ORDER => nothing */
    0,  /*       PLUS => nothing */
   59,  /*     PRAGMA => ID */
    0,  /*    PRIMARY => nothing */
   59,  /*      RAISE => ID */
    0,  /* REFERENCES => nothing */
    0,  /*        REM => nothing */
   59,  /*    REPLACE => ID */
   59,  /*   RESTRICT => ID */
    0,  /*   ROLLBACK => nothing */
   59,  /*        ROW => ID */
    0,  /*         RP => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*       SEMI => nothing */
    0,  /*        SET => nothing */
    0,  /*      SLASH => nothing */
    0,  /*      SPACE => nothing */
    0,  /*       STAR => nothing */
   59,  /*  STATEMENT => ID */
    0,  /*     STRING => nothing */
    0,  /*      TABLE => nothing */
   59,  /*       TEMP => ID */
    0,  /*       THEN => nothing */
    0,  /* TRANSACTION => nothing */
   59,  /*    TRIGGER => ID */
    0,  /*     UMINUS => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*      UNION => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*      USING => nothing */
   59,  /*     VACUUM => ID */
    0,  /*     VALUES => nothing */
    0,  /*   VARIABLE => nothing */
   59,  /*       VIEW => ID */
    0,  /*       WHEN => nothing */
    0,  /*      WHERE => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  yyStackEntry *yytop;          /* Pointer to the top stack element */
  sqliteParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "ABORT",         "AFTER",         "AGG_FUNCTION",
  "ALL",           "AND",           "AS",            "ASC",         
  "ATTACH",        "BEFORE",        "BEGIN",         "BETWEEN",     
  "BITAND",        "BITNOT",        "BITOR",         "BY",          
  "CASCADE",       "CASE",          "CHECK",         "CLUSTER",     
  "COLLATE",       "COLUMN",        "COMMA",         "COMMENT",     
  "COMMIT",        "CONCAT",        "CONFLICT",      "CONSTRAINT",  
  "COPY",          "CREATE",        "DATABASE",      "DEFAULT",     
  "DEFERRABLE",    "DEFERRED",      "DELETE",        "DELIMITERS",  
  "DESC",          "DETACH",        "DISTINCT",      "DOT",         
  "DROP",          "EACH",          "ELSE",          "END",         
  "END_OF_FILE",   "EQ",            "EXCEPT",        "EXPLAIN",     
  "FAIL",          "FLOAT",         "FOR",           "FOREIGN",     
  "FROM",          "FUNCTION",      "GE",            "GLOB",        
  "GROUP",         "GT",            "HAVING",        "ID",          
  "IGNORE",        "ILLEGAL",       "IMMEDIATE",     "IN",          
  "INDEX",         "INITIALLY",     "INSERT",        "INSTEAD",     
  "INTEGER",       "INTERSECT",     "INTO",          "IS",          
  "ISNULL",        "JOIN",          "JOIN_KW",       "KEY",         
  "LE",            "LIKE",          "LIMIT",         "LP",          
  "LSHIFT",        "LT",            "MATCH",         "MINUS",       
  "NE",            "NOT",           "NOTNULL",       "NULL",        
  "OF",            "OFFSET",        "ON",            "OR",          
  "ORDER",         "PLUS",          "PRAGMA",        "PRIMARY",     
  "RAISE",         "REFERENCES",    "REM",           "REPLACE",     
  "RESTRICT",      "ROLLBACK",      "ROW",           "RP",          
  "RSHIFT",        "SELECT",        "SEMI",          "SET",         
  "SLASH",         "SPACE",         "STAR",          "STATEMENT",   
  "STRING",        "TABLE",         "TEMP",          "THEN",        
  "TRANSACTION",   "TRIGGER",       "UMINUS",        "UNCLOSED_STRING",
  "UNION",         "UNIQUE",        "UPDATE",        "UPLUS",       
  "USING",         "VACUUM",        "VALUES",        "VARIABLE",    
  "VIEW",          "WHEN",          "WHERE",         "as",          
  "carg",          "carglist",      "case_else",     "case_exprlist",
  "case_operand",  "ccons",         "cmd",           "cmdlist",     
  "cmdx",          "collate",       "column",        "columnid",    
  "columnlist",    "conslist",      "conslist_opt",  "create_table",
  "create_table_args",  "database_kw_opt",  "dbnm",          "defer_subclause",
  "defer_subclause_opt",  "distinct",      "ecmd",          "error",       
  "explain",       "expr",          "expritem",      "exprlist",    
  "foreach_clause",  "from",          "groupby_opt",   "having_opt",  
  "id",            "ids",           "idxitem",       "idxlist",     
  "idxlist_opt",   "init_deferred_pred_opt",  "input",         "inscollist",  
  "inscollist_opt",  "insert_cmd",    "itemlist",      "joinop",      
  "joinop2",       "likeop",        "limit_opt",     "minus_num",   
  "multiselect_op",  "nm",            "number",        "on_opt",      
  "onconf",        "oneselect",     "orconf",        "orderby_opt", 
  "plus_num",      "plus_opt",      "refact",        "refarg",      
  "refargs",       "resolvetype",   "sclp",          "selcollist",  
  "select",        "seltablist",    "setlist",       "signed",      
  "sortitem",      "sortlist",      "sortorder",     "stl_prefix",  
  "tcons",         "temp",          "trans_opt",     "trigger_cmd", 
  "trigger_cmd_list",  "trigger_decl",  "trigger_event",  "trigger_time",
  "type",          "typename",      "uniqueflag",    "using_opt",   
  "when_clause",   "where_opt",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= ecmd",
 /*   2 */ "cmdlist ::= cmdlist ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt onconf",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP select RP as on_opt using_opt",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "joinop ::= COMMA",
 /* 128 */ "joinop ::= JOIN",
 /* 129 */ "joinop ::= JOIN_KW JOIN",
 /* 130 */ "joinop ::= JOIN_KW nm JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 132 */ "on_opt ::= ON expr",
 /* 133 */ "on_opt ::=",
 /* 134 */ "using_opt ::= USING LP idxlist RP",
 /* 135 */ "using_opt ::=",
 /* 136 */ "orderby_opt ::=",
 /* 137 */ "orderby_opt ::= ORDER BY sortlist",
 /* 138 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 139 */ "sortlist ::= sortitem collate sortorder",
 /* 140 */ "sortitem ::= expr",
 /* 141 */ "sortorder ::= ASC",
 /* 142 */ "sortorder ::= DESC",
 /* 143 */ "sortorder ::=",
 /* 144 */ "collate ::=",
 /* 145 */ "collate ::= COLLATE id",
 /* 146 */ "groupby_opt ::=",
 /* 147 */ "groupby_opt ::= GROUP BY exprlist",
 /* 148 */ "having_opt ::=",
 /* 149 */ "having_opt ::= HAVING expr",
 /* 150 */ "limit_opt ::=",
 /* 151 */ "limit_opt ::= LIMIT signed",
 /* 152 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 153 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 154 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 155 */ "where_opt ::=",
 /* 156 */ "where_opt ::= WHERE expr",
 /* 157 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 158 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 159 */ "setlist ::= nm EQ expr",
 /* 160 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 161 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 162 */ "insert_cmd ::= INSERT orconf",
 /* 163 */ "insert_cmd ::= REPLACE",
 /* 164 */ "itemlist ::= itemlist COMMA expr",
 /* 165 */ "itemlist ::= expr",
 /* 166 */ "inscollist_opt ::=",
 /* 167 */ "inscollist_opt ::= LP inscollist RP",
 /* 168 */ "inscollist ::= inscollist COMMA nm",
 /* 169 */ "inscollist ::= nm",
 /* 170 */ "expr ::= LP expr RP",
 /* 171 */ "expr ::= NULL",
 /* 172 */ "expr ::= ID",
 /* 173 */ "expr ::= JOIN_KW",
 /* 174 */ "expr ::= nm DOT nm",
 /* 175 */ "expr ::= nm DOT nm DOT nm",
 /* 176 */ "expr ::= INTEGER",
 /* 177 */ "expr ::= FLOAT",
 /* 178 */ "expr ::= STRING",
 /* 179 */ "expr ::= VARIABLE",
 /* 180 */ "expr ::= ID LP exprlist RP",
 /* 181 */ "expr ::= ID LP STAR RP",
 /* 182 */ "expr ::= expr AND expr",
 /* 183 */ "expr ::= expr OR expr",
 /* 184 */ "expr ::= expr LT expr",
 /* 185 */ "expr ::= expr GT expr",
 /* 186 */ "expr ::= expr LE expr",
 /* 187 */ "expr ::= expr GE expr",
 /* 188 */ "expr ::= expr NE expr",
 /* 189 */ "expr ::= expr EQ expr",
 /* 190 */ "expr ::= expr BITAND expr",
 /* 191 */ "expr ::= expr BITOR expr",
 /* 192 */ "expr ::= expr LSHIFT expr",
 /* 193 */ "expr ::= expr RSHIFT expr",
 /* 194 */ "expr ::= expr likeop expr",
 /* 195 */ "expr ::= expr NOT likeop expr",
 /* 196 */ "likeop ::= LIKE",
 /* 197 */ "likeop ::= GLOB",
 /* 198 */ "expr ::= expr PLUS expr",
 /* 199 */ "expr ::= expr MINUS expr",
 /* 200 */ "expr ::= expr STAR expr",
 /* 201 */ "expr ::= expr SLASH expr",
 /* 202 */ "expr ::= expr REM expr",
 /* 203 */ "expr ::= expr CONCAT expr",
 /* 204 */ "expr ::= expr ISNULL",
 /* 205 */ "expr ::= expr IS NULL",
 /* 206 */ "expr ::= expr NOTNULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "expr ::= LP select RP",
 /* 214 */ "expr ::= expr BETWEEN expr AND expr",
 /* 215 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 216 */ "expr ::= expr IN LP exprlist RP",
 /* 217 */ "expr ::= expr IN LP select RP",
 /* 218 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 219 */ "expr ::= expr NOT IN LP select RP",
 /* 220 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 221 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 222 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 223 */ "case_else ::= ELSE expr",
 /* 224 */ "case_else ::=",
 /* 225 */ "case_operand ::= expr",
 /* 226 */ "case_operand ::=",
 /* 227 */ "exprlist ::= exprlist COMMA expritem",
 /* 228 */ "exprlist ::= expritem",
 /* 229 */ "expritem ::= expr",
 /* 230 */ "expritem ::=",
 /* 231 */ "cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf",
 /* 232 */ "uniqueflag ::= UNIQUE",
 /* 233 */ "uniqueflag ::=",
 /* 234 */ "idxlist_opt ::=",
 /* 235 */ "idxlist_opt ::= LP idxlist RP",
 /* 236 */ "idxlist ::= idxlist COMMA idxitem",
 /* 237 */ "idxlist ::= idxitem",
 /* 238 */ "idxitem ::= nm sortorder",
 /* 239 */ "cmd ::= DROP INDEX nm dbnm",
 /* 240 */ "cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING",
 /* 241 */ "cmd ::= COPY orconf nm dbnm FROM nm",
 /* 242 */ "cmd ::= VACUUM",
 /* 243 */ "cmd ::= VACUUM nm",
 /* 244 */ "cmd ::= PRAGMA ids EQ nm",
 /* 245 */ "cmd ::= PRAGMA ids EQ ON",
 /* 246 */ "cmd ::= PRAGMA ids EQ plus_num",
 /* 247 */ "cmd ::= PRAGMA ids EQ minus_num",
 /* 248 */ "cmd ::= PRAGMA ids LP nm RP",
 /* 249 */ "cmd ::= PRAGMA ids",
 /* 250 */ "plus_num ::= plus_opt number",
 /* 251 */ "minus_num ::= MINUS number",
 /* 252 */ "number ::= INTEGER",
 /* 253 */ "number ::= FLOAT",
 /* 254 */ "plus_opt ::= PLUS",
 /* 255 */ "plus_opt ::=",
 /* 256 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 257 */ "trigger_decl ::= temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 258 */ "trigger_time ::= BEFORE",
 /* 259 */ "trigger_time ::= AFTER",
 /* 260 */ "trigger_time ::= INSTEAD OF",
 /* 261 */ "trigger_time ::=",
 /* 262 */ "trigger_event ::= DELETE",
 /* 263 */ "trigger_event ::= INSERT",
 /* 264 */ "trigger_event ::= UPDATE",
 /* 265 */ "trigger_event ::= UPDATE OF inscollist",
 /* 266 */ "foreach_clause ::=",
 /* 267 */ "foreach_clause ::= FOR EACH ROW",
 /* 268 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 269 */ "when_clause ::=",
 /* 270 */ "when_clause ::= WHEN expr",
 /* 271 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 272 */ "trigger_cmd_list ::=",
 /* 273 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 274 */ "trigger_cmd ::= INSERT orconf INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 275 */ "trigger_cmd ::= INSERT orconf INTO nm inscollist_opt select",
 /* 276 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 277 */ "trigger_cmd ::= select",
 /* 278 */ "expr ::= RAISE LP IGNORE RP",
 /* 279 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 280 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 281 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 282 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 283 */ "cmd ::= ATTACH database_kw_opt ids AS nm",
 /* 284 */ "database_kw_opt ::= DATABASE",
 /* 285 */ "database_kw_opt ::=",
 /* 286 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 135:
#line 675 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1289 "parse.c"
      break;
    case 157:
#line 520 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1294 "parse.c"
      break;
    case 158:
#line 694 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1299 "parse.c"
      break;
    case 159:
#line 692 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1304 "parse.c"
      break;
    case 161:
#line 342 "parse.y"
{sqliteSrcListDelete((yypminor->yy335));}
#line 1309 "parse.c"
      break;
    case 162:
#line 436 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1314 "parse.c"
      break;
    case 163:
#line 441 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1319 "parse.c"
      break;
    case 167:
#line 717 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1324 "parse.c"
      break;
    case 168:
#line 719 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1329 "parse.c"
      break;
    case 171:
#line 499 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1334 "parse.c"
      break;
    case 172:
#line 497 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1339 "parse.c"
      break;
    case 174:
#line 491 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1344 "parse.c"
      break;
    case 183:
#line 397 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1349 "parse.c"
      break;
    case 185:
#line 277 "parse.y"
{sqliteSelectDelete((yypminor->yy11));}
#line 1354 "parse.c"
      break;
    case 187:
#line 408 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1359 "parse.c"
      break;
    case 194:
#line 313 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1364 "parse.c"
      break;
    case 195:
#line 311 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1369 "parse.c"
      break;
    case 196:
#line 275 "parse.y"
{sqliteSelectDelete((yypminor->yy11));}
#line 1374 "parse.c"
      break;
    case 197:
#line 338 "parse.y"
{sqliteSrcListDelete((yypminor->yy335));}
#line 1379 "parse.c"
      break;
    case 198:
#line 466 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1384 "parse.c"
      break;
    case 200:
#line 412 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1389 "parse.c"
      break;
    case 201:
#line 410 "parse.y"
{sqliteExprListDelete((yypminor->yy62));}
#line 1394 "parse.c"
      break;
    case 203:
#line 340 "parse.y"
{sqliteSrcListDelete((yypminor->yy335));}
#line 1399 "parse.c"
      break;
    case 207:
#line 809 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy347));}
#line 1404 "parse.c"
      break;
    case 208:
#line 801 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy347));}
#line 1409 "parse.c"
      break;
    case 210:
#line 785 "parse.y"
{sqliteIdListDelete((yypminor->yy234).b);}
#line 1414 "parse.c"
      break;
    case 215:
#line 402 "parse.y"
{sqliteIdListDelete((yypminor->yy92));}
#line 1419 "parse.c"
      break;
    case 217:
#line 460 "parse.y"
{sqliteExprDelete((yypminor->yy334));}
#line 1424 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->yytop->major]);
  }
#endif
  yymajor = pParser->yytop->major;
  yy_destructor( yymajor, &pParser->yytop->minor);
  pParser->yyidx--;
  pParser->yytop--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[pParser->yytop->stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[pParser->yytop->stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[pParser->yytop->stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
 
  i = yy_reduce_ofst[pParser->yytop->stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[pParser->yytop->stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[pParser->yytop->stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->yyidx++;
  yypParser->yytop++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqliteParserARG_FETCH;
     yypParser->yyidx--;
     yypParser->yytop--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yypParser->yytop->stateno = yyNewState;
  yypParser->yytop->major = yyMajor;
  yypParser->yytop->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 170, 1 },
  { 139, 1 },
  { 139, 2 },
  { 154, 3 },
  { 154, 1 },
  { 140, 1 },
  { 156, 1 },
  { 156, 0 },
  { 138, 3 },
  { 206, 0 },
  { 206, 1 },
  { 206, 2 },
  { 138, 2 },
  { 138, 2 },
  { 138, 2 },
  { 138, 2 },
  { 147, 4 },
  { 205, 1 },
  { 205, 0 },
  { 148, 4 },
  { 148, 2 },
  { 144, 3 },
  { 144, 1 },
  { 142, 3 },
  { 143, 1 },
  { 164, 1 },
  { 165, 1 },
  { 165, 1 },
  { 181, 1 },
  { 181, 1 },
  { 181, 1 },
  { 212, 0 },
  { 212, 1 },
  { 212, 4 },
  { 212, 6 },
  { 213, 1 },
  { 213, 2 },
  { 199, 1 },
  { 199, 2 },
  { 199, 2 },
  { 133, 2 },
  { 133, 0 },
  { 132, 3 },
  { 132, 1 },
  { 132, 2 },
  { 132, 2 },
  { 132, 2 },
  { 132, 3 },
  { 132, 3 },
  { 132, 2 },
  { 132, 3 },
  { 132, 3 },
  { 132, 2 },
  { 137, 2 },
  { 137, 3 },
  { 137, 4 },
  { 137, 2 },
  { 137, 5 },
  { 137, 4 },
  { 137, 1 },
  { 137, 2 },
  { 192, 0 },
  { 192, 2 },
  { 191, 2 },
  { 191, 3 },
  { 191, 3 },
  { 191, 3 },
  { 190, 2 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 151, 3 },
  { 151, 2 },
  { 169, 0 },
  { 169, 2 },
  { 169, 2 },
  { 146, 0 },
  { 146, 2 },
  { 145, 3 },
  { 145, 2 },
  { 145, 1 },
  { 204, 2 },
  { 204, 6 },
  { 204, 5 },
  { 204, 3 },
  { 204, 10 },
  { 152, 0 },
  { 152, 1 },
  { 184, 0 },
  { 184, 3 },
  { 186, 0 },
  { 186, 2 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 138, 3 },
  { 138, 6 },
  { 138, 3 },
  { 138, 1 },
  { 196, 1 },
  { 196, 3 },
  { 180, 1 },
  { 180, 2 },
  { 180, 1 },
  { 180, 1 },
  { 185, 9 },
  { 153, 1 },
  { 153, 1 },
  { 153, 0 },
  { 194, 2 },
  { 194, 0 },
  { 195, 3 },
  { 195, 2 },
  { 195, 4 },
  { 131, 2 },
  { 131, 1 },
  { 131, 0 },
  { 161, 0 },
  { 161, 2 },
  { 203, 2 },
  { 203, 0 },
  { 197, 6 },
  { 197, 7 },
  { 150, 0 },
  { 150, 2 },
  { 175, 1 },
  { 175, 1 },
  { 175, 2 },
  { 175, 3 },
  { 175, 4 },
  { 183, 2 },
  { 183, 0 },
  { 215, 4 },
  { 215, 0 },
  { 187, 0 },
  { 187, 3 },
  { 201, 5 },
  { 201, 3 },
  { 200, 1 },
  { 202, 1 },
  { 202, 1 },
  { 202, 0 },
  { 141, 0 },
  { 141, 2 },
  { 162, 0 },
  { 162, 3 },
  { 163, 0 },
  { 163, 2 },
  { 178, 0 },
  { 178, 2 },
  { 178, 4 },
  { 178, 4 },
  { 138, 5 },
  { 217, 0 },
  { 217, 2 },
  { 138, 7 },
  { 198, 5 },
  { 198, 3 },
  { 138, 9 },
  { 138, 6 },
  { 173, 2 },
  { 173, 1 },
  { 174, 3 },
  { 174, 1 },
  { 172, 0 },
  { 172, 3 },
  { 171, 3 },
  { 171, 1 },
  { 157, 3 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 3 },
  { 157, 5 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 4 },
  { 157, 4 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 4 },
  { 177, 1 },
  { 177, 1 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 2 },
  { 157, 3 },
  { 157, 2 },
  { 157, 3 },
  { 157, 4 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 3 },
  { 157, 5 },
  { 157, 6 },
  { 157, 5 },
  { 157, 5 },
  { 157, 6 },
  { 157, 6 },
  { 157, 5 },
  { 135, 5 },
  { 135, 4 },
  { 134, 2 },
  { 134, 0 },
  { 136, 1 },
  { 136, 0 },
  { 159, 3 },
  { 159, 1 },
  { 158, 1 },
  { 158, 0 },
  { 138, 11 },
  { 214, 1 },
  { 214, 0 },
  { 168, 0 },
  { 168, 3 },
  { 167, 3 },
  { 167, 1 },
  { 166, 2 },
  { 138, 4 },
  { 138, 9 },
  { 138, 6 },
  { 138, 1 },
  { 138, 2 },
  { 138, 4 },
  { 138, 4 },
  { 138, 4 },
  { 138, 4 },
  { 138, 5 },
  { 138, 2 },
  { 188, 2 },
  { 179, 2 },
  { 182, 1 },
  { 182, 1 },
  { 189, 1 },
  { 189, 0 },
  { 138, 5 },
  { 209, 10 },
  { 211, 1 },
  { 211, 1 },
  { 211, 2 },
  { 211, 0 },
  { 210, 1 },
  { 210, 1 },
  { 210, 1 },
  { 210, 3 },
  { 160, 0 },
  { 160, 3 },
  { 160, 3 },
  { 216, 0 },
  { 216, 2 },
  { 208, 3 },
  { 208, 0 },
  { 207, 6 },
  { 207, 9 },
  { 207, 6 },
  { 207, 4 },
  { 207, 1 },
  { 157, 4 },
  { 157, 6 },
  { 157, 6 },
  { 157, 6 },
  { 138, 4 },
  { 138, 5 },
  { 149, 1 },
  { 149, 0 },
  { 138, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqliteParserARG_FETCH;
  yymsp = yypParser->yytop;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for cmdlist */
        break;
      case 1:
        /* No destructor defined for ecmd */
        break;
      case 2:
        /* No destructor defined for cmdlist */
        /* No destructor defined for ecmd */
        break;
      case 3:
        /* No destructor defined for explain */
        /* No destructor defined for cmdx */
        /* No destructor defined for SEMI */
        break;
      case 4:
        /* No destructor defined for SEMI */
        break;
      case 5:
#line 77 "parse.y"
{ sqliteExec(pParse); }
#line 1942 "parse.c"
        /* No destructor defined for cmd */
        break;
      case 6:
#line 78 "parse.y"
{ sqliteBeginParse(pParse, 1); }
#line 1948 "parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
#line 79 "parse.y"
{ sqliteBeginParse(pParse, 0); }
#line 1954 "parse.c"
        break;
      case 8:
#line 84 "parse.y"
{sqliteBeginTransaction(pParse,yymsp[0].minor.yy52);}
#line 1959 "parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 9:
        break;
      case 10:
        /* No destructor defined for TRANSACTION */
        break;
      case 11:
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for nm */
        break;
      case 12:
#line 88 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1975 "parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 13:
#line 89 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1982 "parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 14:
#line 90 "parse.y"
{sqliteRollbackTransaction(pParse);}
#line 1989 "parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 15:
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 16:
#line 95 "parse.y"
{
   sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy210,yymsp[-2].minor.yy52,0);
}
#line 2002 "parse.c"
        /* No destructor defined for TABLE */
        break;
      case 17:
#line 99 "parse.y"
{yygotominor.yy52 = 1;}
#line 2008 "parse.c"
        /* No destructor defined for TEMP */
        break;
      case 18:
#line 100 "parse.y"
{yygotominor.yy52 = 0;}
#line 2014 "parse.c"
        break;
      case 19:
#line 101 "parse.y"
{
  sqliteEndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 2021 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 20:
#line 104 "parse.y"
{
  sqliteEndTable(pParse,0,yymsp[0].minor.yy11);
  sqliteSelectDelete(yymsp[0].minor.yy11);
}
#line 2032 "parse.c"
        /* No destructor defined for AS */
        break;
      case 21:
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 22:
        /* No destructor defined for column */
        break;
      case 23:
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 24:
#line 116 "parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy210);}
#line 2051 "parse.c"
        break;
      case 25:
#line 122 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2056 "parse.c"
        break;
      case 26:
#line 138 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2061 "parse.c"
        break;
      case 27:
#line 139 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2066 "parse.c"
        break;
      case 28:
#line 144 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2071 "parse.c"
        break;
      case 29:
#line 145 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2076 "parse.c"
        break;
      case 30:
#line 146 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2081 "parse.c"
        break;
      case 31:
        break;
      case 32:
#line 149 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy210,&yymsp[0].minor.yy210);}
#line 2088 "parse.c"
        break;
      case 33:
#line 150 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy210,&yymsp[0].minor.yy0);}
#line 2093 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 34:
#line 152 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy210,&yymsp[0].minor.yy0);}
#line 2100 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 35:
#line 154 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2109 "parse.c"
        break;
      case 36:
#line 155 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210;}
#line 2114 "parse.c"
        /* No destructor defined for ids */
        break;
      case 37:
#line 157 "parse.y"
{ yygotominor.yy52 = atoi(yymsp[0].minor.yy0.z); }
#line 2120 "parse.c"
        break;
      case 38:
#line 158 "parse.y"
{ yygotominor.yy52 = atoi(yymsp[0].minor.yy0.z); }
#line 2125 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 39:
#line 159 "parse.y"
{ yygotominor.yy52 = -atoi(yymsp[0].minor.yy0.z); }
#line 2131 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 40:
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 41:
        break;
      case 42:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        /* No destructor defined for ccons */
        break;
      case 43:
        /* No destructor defined for ccons */
        break;
      case 44:
#line 164 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2151 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 45:
#line 165 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2157 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 46:
#line 166 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2163 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 47:
#line 167 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2169 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 48:
#line 168 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2176 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 49:
#line 169 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2183 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
#line 170 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2189 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 51:
#line 171 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2196 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 52:
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 53:
        /* No destructor defined for NULL */
        /* No destructor defined for onconf */
        break;
      case 54:
#line 178 "parse.y"
{sqliteAddNotNull(pParse, yymsp[0].minor.yy52);}
#line 2211 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 55:
#line 179 "parse.y"
{sqliteAddPrimaryKey(pParse,0,yymsp[0].minor.yy52);}
#line 2218 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 56:
#line 180 "parse.y"
{sqliteCreateIndex(pParse,0,0,0,yymsp[0].minor.yy52,0,0);}
#line 2226 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 57:
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(157,&yymsp[-2].minor);
        /* No destructor defined for RP */
        /* No destructor defined for onconf */
        break;
      case 58:
#line 183 "parse.y"
{sqliteCreateForeignKey(pParse,0,&yymsp[-2].minor.yy210,yymsp[-1].minor.yy92,yymsp[0].minor.yy52);}
#line 2239 "parse.c"
        /* No destructor defined for REFERENCES */
        break;
      case 59:
#line 184 "parse.y"
{sqliteDeferForeignKey(pParse,yymsp[0].minor.yy52);}
#line 2245 "parse.c"
        break;
      case 60:
#line 185 "parse.y"
{
   sqliteAddCollateType(pParse, sqliteCollateType(yymsp[0].minor.yy210.z, yymsp[0].minor.yy210.n));
}
#line 2252 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 61:
#line 195 "parse.y"
{ yygotominor.yy52 = OE_Restrict * 0x010101; }
#line 2258 "parse.c"
        break;
      case 62:
#line 196 "parse.y"
{ yygotominor.yy52 = (yymsp[-1].minor.yy52 & yymsp[0].minor.yy279.mask) | yymsp[0].minor.yy279.value; }
#line 2263 "parse.c"
        break;
      case 63:
#line 198 "parse.y"
{ yygotominor.yy279.value = 0;     yygotominor.yy279.mask = 0x000000; }
#line 2268 "parse.c"
        /* No destructor defined for MATCH */
        /* No destructor defined for nm */
        break;
      case 64:
#line 199 "parse.y"
{ yygotominor.yy279.value = yymsp[0].minor.yy52;     yygotominor.yy279.mask = 0x0000ff; }
#line 2275 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for DELETE */
        break;
      case 65:
#line 200 "parse.y"
{ yygotominor.yy279.value = yymsp[0].minor.yy52<<8;  yygotominor.yy279.mask = 0x00ff00; }
#line 2282 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for UPDATE */
        break;
      case 66:
#line 201 "parse.y"
{ yygotominor.yy279.value = yymsp[0].minor.yy52<<16; yygotominor.yy279.mask = 0xff0000; }
#line 2289 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for INSERT */
        break;
      case 67:
#line 203 "parse.y"
{ yygotominor.yy52 = OE_SetNull; }
#line 2296 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for NULL */
        break;
      case 68:
#line 204 "parse.y"
{ yygotominor.yy52 = OE_SetDflt; }
#line 2303 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for DEFAULT */
        break;
      case 69:
#line 205 "parse.y"
{ yygotominor.yy52 = OE_Cascade; }
#line 2310 "parse.c"
        /* No destructor defined for CASCADE */
        break;
      case 70:
#line 206 "parse.y"
{ yygotominor.yy52 = OE_Restrict; }
#line 2316 "parse.c"
        /* No destructor defined for RESTRICT */
        break;
      case 71:
#line 208 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2322 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for DEFERRABLE */
        break;
      case 72:
#line 209 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2329 "parse.c"
        /* No destructor defined for DEFERRABLE */
        break;
      case 73:
#line 211 "parse.y"
{yygotominor.yy52 = 0;}
#line 2335 "parse.c"
        break;
      case 74:
#line 212 "parse.y"
{yygotominor.yy52 = 1;}
#line 2340 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for DEFERRED */
        break;
      case 75:
#line 213 "parse.y"
{yygotominor.yy52 = 0;}
#line 2347 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for IMMEDIATE */
        break;
      case 76:
        break;
      case 77:
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 78:
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 79:
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 80:
        /* No destructor defined for tcons */
        break;
      case 81:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        break;
      case 82:
#line 225 "parse.y"
{sqliteAddPrimaryKey(pParse,yymsp[-2].minor.yy92,yymsp[0].minor.yy52);}
#line 2376 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 83:
#line 227 "parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-2].minor.yy92,yymsp[0].minor.yy52,0,0);}
#line 2385 "parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 84:
        /* No destructor defined for CHECK */
  yy_destructor(157,&yymsp[-1].minor);
        /* No destructor defined for onconf */
        break;
      case 85:
#line 230 "parse.y"
{
    sqliteCreateForeignKey(pParse, yymsp[-6].minor.yy92, &yymsp[-3].minor.yy210, yymsp[-2].minor.yy92, yymsp[-1].minor.yy52);
    sqliteDeferForeignKey(pParse, yymsp[0].minor.yy52);
}
#line 2401 "parse.c"
        /* No destructor defined for FOREIGN */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        /* No destructor defined for REFERENCES */
        break;
      case 86:
#line 235 "parse.y"
{yygotominor.yy52 = 0;}
#line 2411 "parse.c"
        break;
      case 87:
#line 236 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2416 "parse.c"
        break;
      case 88:
#line 244 "parse.y"
{ yygotominor.yy52 = OE_Default; }
#line 2421 "parse.c"
        break;
      case 89:
#line 245 "parse.y"
{ yygotominor.yy52 = yymsp[0].minor.yy52; }
#line 2426 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for CONFLICT */
        break;
      case 90:
#line 246 "parse.y"
{ yygotominor.yy52 = OE_Default; }
#line 2433 "parse.c"
        break;
      case 91:
#line 247 "parse.y"
{ yygotominor.yy52 = yymsp[0].minor.yy52; }
#line 2438 "parse.c"
        /* No destructor defined for OR */
        break;
      case 92:
#line 248 "parse.y"
{ yygotominor.yy52 = OE_Rollback; }
#line 2444 "parse.c"
        /* No destructor defined for ROLLBACK */
        break;
      case 93:
#line 249 "parse.y"
{ yygotominor.yy52 = OE_Abort; }
#line 2450 "parse.c"
        /* No destructor defined for ABORT */
        break;
      case 94:
#line 250 "parse.y"
{ yygotominor.yy52 = OE_Fail; }
#line 2456 "parse.c"
        /* No destructor defined for FAIL */
        break;
      case 95:
#line 251 "parse.y"
{ yygotominor.yy52 = OE_Ignore; }
#line 2462 "parse.c"
        /* No destructor defined for IGNORE */
        break;
      case 96:
#line 252 "parse.y"
{ yygotominor.yy52 = OE_Replace; }
#line 2468 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 97:
#line 256 "parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy210,0);}
#line 2474 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 98:
#line 260 "parse.y"
{
  sqliteCreateView(pParse, &yymsp[-5].minor.yy0, &yymsp[-2].minor.yy210, yymsp[0].minor.yy11, yymsp[-4].minor.yy52);
}
#line 2483 "parse.c"
        /* No destructor defined for VIEW */
        /* No destructor defined for AS */
        break;
      case 99:
#line 263 "parse.y"
{
  sqliteDropTable(pParse, &yymsp[0].minor.yy210, 1);
}
#line 2492 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for VIEW */
        break;
      case 100:
#line 269 "parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy11, SRT_Callback, 0, 0, 0, 0);
  sqliteSelectDelete(yymsp[0].minor.yy11);
}
#line 2502 "parse.c"
        break;
      case 101:
#line 279 "parse.y"
{yygotominor.yy11 = yymsp[0].minor.yy11;}
#line 2507 "parse.c"
        break;
      case 102:
#line 280 "parse.y"
{
  if( yymsp[0].minor.yy11 ){
    yymsp[0].minor.yy11->op = yymsp[-1].minor.yy52;
    yymsp[0].minor.yy11->pPrior = yymsp[-2].minor.yy11;
  }
  yygotominor.yy11 = yymsp[0].minor.yy11;
}
#line 2518 "parse.c"
        break;
      case 103:
#line 288 "parse.y"
{yygotominor.yy52 = TK_UNION;}
#line 2523 "parse.c"
        /* No destructor defined for UNION */
        break;
      case 104:
#line 289 "parse.y"
{yygotominor.yy52 = TK_ALL;}
#line 2529 "parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 105:
#line 290 "parse.y"
{yygotominor.yy52 = TK_INTERSECT;}
#line 2536 "parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 106:
#line 291 "parse.y"
{yygotominor.yy52 = TK_EXCEPT;}
#line 2542 "parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 107:
#line 293 "parse.y"
{
  yygotominor.yy11 = sqliteSelectNew(yymsp[-6].minor.yy62,yymsp[-5].minor.yy335,yymsp[-4].minor.yy334,yymsp[-3].minor.yy62,yymsp[-2].minor.yy334,yymsp[-1].minor.yy62,yymsp[-7].minor.yy52,yymsp[0].minor.yy280.limit,yymsp[0].minor.yy280.offset);
}
#line 2550 "parse.c"
        /* No destructor defined for SELECT */
        break;
      case 108:
#line 301 "parse.y"
{yygotominor.yy52 = 1;}
#line 2556 "parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 109:
#line 302 "parse.y"
{yygotominor.yy52 = 0;}
#line 2562 "parse.c"
        /* No destructor defined for ALL */
        break;
      case 110:
#line 303 "parse.y"
{yygotominor.yy52 = 0;}
#line 2568 "parse.c"
        break;
      case 111:
#line 314 "parse.y"
{yygotominor.yy62 = yymsp[-1].minor.yy62;}
#line 2573 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 112:
#line 315 "parse.y"
{yygotominor.yy62 = 0;}
#line 2579 "parse.c"
        break;
      case 113:
#line 316 "parse.y"
{
   yygotominor.yy62 = sqliteExprListAppend(yymsp[-2].minor.yy62,yymsp[-1].minor.yy334,yymsp[0].minor.yy210.n?&yymsp[0].minor.yy210:0);
}
#line 2586 "parse.c"
        break;
      case 114:
#line 319 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-1].minor.yy62, sqliteExpr(TK_ALL, 0, 0, 0), 0);
}
#line 2593 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 115:
#line 322 "parse.y"
{
  Expr *pRight = sqliteExpr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-3].minor.yy62, sqliteExpr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2603 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for STAR */
        break;
      case 116:
#line 332 "parse.y"
{ yygotominor.yy210 = yymsp[0].minor.yy210; }
#line 2610 "parse.c"
        /* No destructor defined for AS */
        break;
      case 117:
#line 333 "parse.y"
{ yygotominor.yy210 = yymsp[0].minor.yy210; }
#line 2616 "parse.c"
        break;
      case 118:
#line 334 "parse.y"
{ yygotominor.yy210.n = 0; }
#line 2621 "parse.c"
        break;
      case 119:
#line 346 "parse.y"
{yygotominor.yy335 = sqliteMalloc(sizeof(*yygotominor.yy335));}
#line 2626 "parse.c"
        break;
      case 120:
#line 347 "parse.y"
{yygotominor.yy335 = yymsp[0].minor.yy335;}
#line 2631 "parse.c"
        /* No destructor defined for FROM */
        break;
      case 121:
#line 352 "parse.y"
{
   yygotominor.yy335 = yymsp[-1].minor.yy335;
   if( yygotominor.yy335 && yygotominor.yy335->nSrc>0 ) yygotominor.yy335->a[yygotominor.yy335->nSrc-1].jointype = yymsp[0].minor.yy52;
}
#line 2640 "parse.c"
        break;
      case 122:
#line 356 "parse.y"
{yygotominor.yy335 = 0;}
#line 2645 "parse.c"
        break;
      case 123:
#line 357 "parse.y"
{
  yygotominor.yy335 = sqliteSrcListAppend(yymsp[-5].minor.yy335,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210);
  if( yymsp[-2].minor.yy210.n ) sqliteSrcListAddAlias(yygotominor.yy335,&yymsp[-2].minor.yy210);
  if( yymsp[-1].minor.yy334 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pOn = yymsp[-1].minor.yy334; }
    else { sqliteExprDelete(yymsp[-1].minor.yy334); }
  }
  if( yymsp[0].minor.yy92 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pUsing = yymsp[0].minor.yy92; }
    else { sqliteIdListDelete(yymsp[0].minor.yy92); }
  }
}
#line 2661 "parse.c"
        break;
      case 124:
#line 369 "parse.y"
{
  yygotominor.yy335 = sqliteSrcListAppend(yymsp[-6].minor.yy335,0,0);
  yygotominor.yy335->a[yygotominor.yy335->nSrc-1].pSelect = yymsp[-4].minor.yy11;
  if( yymsp[-2].minor.yy210.n ) sqliteSrcListAddAlias(yygotominor.yy335,&yymsp[-2].minor.yy210);
  if( yymsp[-1].minor.yy334 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pOn = yymsp[-1].minor.yy334; }
    else { sqliteExprDelete(yymsp[-1].minor.yy334); }
  }
  if( yymsp[0].minor.yy92 ){
    if( yygotominor.yy335 && yygotominor.yy335->nSrc>1 ){ yygotominor.yy335->a[yygotominor.yy335->nSrc-2].pUsing = yymsp[0].minor.yy92; }
    else { sqliteIdListDelete(yymsp[0].minor.yy92); }
  }
}
#line 2678 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 125:
#line 384 "parse.y"
{yygotominor.yy210.z=0; yygotominor.yy210.n=0;}
#line 2685 "parse.c"
        break;
      case 126:
#line 385 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2690 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 127:
#line 389 "parse.y"
{ yygotominor.yy52 = JT_INNER; }
#line 2696 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 128:
#line 390 "parse.y"
{ yygotominor.yy52 = JT_INNER; }
#line 2702 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 129:
#line 391 "parse.y"
{ yygotominor.yy52 = sqliteJoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2708 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 130:
#line 392 "parse.y"
{ yygotominor.yy52 = sqliteJoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy210,0); }
#line 2714 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 131:
#line 394 "parse.y"
{ yygotominor.yy52 = sqliteJoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy210,&yymsp[-1].minor.yy210); }
#line 2720 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 132:
#line 398 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2726 "parse.c"
        /* No destructor defined for ON */
        break;
      case 133:
#line 399 "parse.y"
{yygotominor.yy334 = 0;}
#line 2732 "parse.c"
        break;
      case 134:
#line 403 "parse.y"
{yygotominor.yy92 = yymsp[-1].minor.yy92;}
#line 2737 "parse.c"
        /* No destructor defined for USING */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 135:
#line 404 "parse.y"
{yygotominor.yy92 = 0;}
#line 2745 "parse.c"
        break;
      case 136:
#line 414 "parse.y"
{yygotominor.yy62 = 0;}
#line 2750 "parse.c"
        break;
      case 137:
#line 415 "parse.y"
{yygotominor.yy62 = yymsp[0].minor.yy62;}
#line 2755 "parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 138:
#line 416 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-4].minor.yy62,yymsp[-2].minor.yy334,0);
  if( yygotominor.yy62 ) yygotominor.yy62->a[yygotominor.yy62->nExpr-1].sortOrder = yymsp[-1].minor.yy52+yymsp[0].minor.yy52;
}
#line 2765 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 139:
#line 420 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(0,yymsp[-2].minor.yy334,0);
  if( yygotominor.yy62 ) yygotominor.yy62->a[0].sortOrder = yymsp[-1].minor.yy52+yymsp[0].minor.yy52;
}
#line 2774 "parse.c"
        break;
      case 140:
#line 424 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2779 "parse.c"
        break;
      case 141:
#line 429 "parse.y"
{yygotominor.yy52 = SQLITE_SO_ASC;}
#line 2784 "parse.c"
        /* No destructor defined for ASC */
        break;
      case 142:
#line 430 "parse.y"
{yygotominor.yy52 = SQLITE_SO_DESC;}
#line 2790 "parse.c"
        /* No destructor defined for DESC */
        break;
      case 143:
#line 431 "parse.y"
{yygotominor.yy52 = SQLITE_SO_ASC;}
#line 2796 "parse.c"
        break;
      case 144:
#line 432 "parse.y"
{yygotominor.yy52 = SQLITE_SO_UNK;}
#line 2801 "parse.c"
        break;
      case 145:
#line 433 "parse.y"
{yygotominor.yy52 = sqliteCollateType(yymsp[0].minor.yy210.z, yymsp[0].minor.yy210.n);}
#line 2806 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 146:
#line 437 "parse.y"
{yygotominor.yy62 = 0;}
#line 2812 "parse.c"
        break;
      case 147:
#line 438 "parse.y"
{yygotominor.yy62 = yymsp[0].minor.yy62;}
#line 2817 "parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 148:
#line 442 "parse.y"
{yygotominor.yy334 = 0;}
#line 2824 "parse.c"
        break;
      case 149:
#line 443 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2829 "parse.c"
        /* No destructor defined for HAVING */
        break;
      case 150:
#line 446 "parse.y"
{yygotominor.yy280.limit = -1; yygotominor.yy280.offset = 0;}
#line 2835 "parse.c"
        break;
      case 151:
#line 447 "parse.y"
{yygotominor.yy280.limit = yymsp[0].minor.yy52; yygotominor.yy280.offset = 0;}
#line 2840 "parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 152:
#line 449 "parse.y"
{yygotominor.yy280.limit = yymsp[-2].minor.yy52; yygotominor.yy280.offset = yymsp[0].minor.yy52;}
#line 2846 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for OFFSET */
        break;
      case 153:
#line 451 "parse.y"
{yygotominor.yy280.limit = yymsp[0].minor.yy52; yygotominor.yy280.offset = yymsp[-2].minor.yy52;}
#line 2853 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for COMMA */
        break;
      case 154:
#line 455 "parse.y"
{
   sqliteDeleteFrom(pParse, sqliteSrcListAppend(0,&yymsp[-2].minor.yy210,&yymsp[-1].minor.yy210), yymsp[0].minor.yy334);
}
#line 2862 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 155:
#line 462 "parse.y"
{yygotominor.yy334 = 0;}
#line 2869 "parse.c"
        break;
      case 156:
#line 463 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 2874 "parse.c"
        /* No destructor defined for WHERE */
        break;
      case 157:
#line 471 "parse.y"
{sqliteUpdate(pParse,sqliteSrcListAppend(0,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210),yymsp[-1].minor.yy62,yymsp[0].minor.yy334,yymsp[-5].minor.yy52);}
#line 2880 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 158:
#line 474 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(yymsp[-4].minor.yy62,yymsp[0].minor.yy334,&yymsp[-2].minor.yy210);}
#line 2887 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 159:
#line 475 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(0,yymsp[0].minor.yy334,&yymsp[-2].minor.yy210);}
#line 2894 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 160:
#line 481 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-6].minor.yy210,&yymsp[-5].minor.yy210), yymsp[-1].minor.yy62, 0, yymsp[-4].minor.yy92, yymsp[-8].minor.yy52);}
#line 2900 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 161:
#line 483 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210), 0, yymsp[0].minor.yy11, yymsp[-1].minor.yy92, yymsp[-5].minor.yy52);}
#line 2909 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 162:
#line 486 "parse.y"
{yygotominor.yy52 = yymsp[0].minor.yy52;}
#line 2915 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 163:
#line 487 "parse.y"
{yygotominor.yy52 = OE_Replace;}
#line 2921 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 164:
#line 493 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(yymsp[-2].minor.yy62,yymsp[0].minor.yy334,0);}
#line 2927 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 165:
#line 494 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(0,yymsp[0].minor.yy334,0);}
#line 2933 "parse.c"
        break;
      case 166:
#line 501 "parse.y"
{yygotominor.yy92 = 0;}
#line 2938 "parse.c"
        break;
      case 167:
#line 502 "parse.y"
{yygotominor.yy92 = yymsp[-1].minor.yy92;}
#line 2943 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 168:
#line 503 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(yymsp[-2].minor.yy92,&yymsp[0].minor.yy210);}
#line 2950 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 169:
#line 504 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(0,&yymsp[0].minor.yy210);}
#line 2956 "parse.c"
        break;
      case 170:
#line 522 "parse.y"
{yygotominor.yy334 = yymsp[-1].minor.yy334; sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2961 "parse.c"
        break;
      case 171:
#line 523 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 2966 "parse.c"
        break;
      case 172:
#line 524 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2971 "parse.c"
        break;
      case 173:
#line 525 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2976 "parse.c"
        break;
      case 174:
#line 526 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  yygotominor.yy334 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 2985 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 175:
#line 531 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-4].minor.yy210);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp3 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  Expr *temp4 = sqliteExpr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy334 = sqliteExpr(TK_DOT, temp1, temp4, 0);
}
#line 2997 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for DOT */
        break;
      case 176:
#line 538 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 3004 "parse.c"
        break;
      case 177:
#line 539 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 3009 "parse.c"
        break;
      case 178:
#line 540 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 3014 "parse.c"
        break;
      case 179:
#line 541 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_VARIABLE, 0, 0, &yymsp[0].minor.yy0);
  if( yygotominor.yy334 ) yygotominor.yy334->iTable = ++pParse->nVar;
}
#line 3022 "parse.c"
        break;
      case 180:
#line 545 "parse.y"
{
  yygotominor.yy334 = sqliteExprFunction(yymsp[-1].minor.yy62, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3030 "parse.c"
        /* No destructor defined for LP */
        break;
      case 181:
#line 549 "parse.y"
{
  yygotominor.yy334 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3039 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 182:
#line 553 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_AND, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3046 "parse.c"
        /* No destructor defined for AND */
        break;
      case 183:
#line 554 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_OR, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3052 "parse.c"
        /* No destructor defined for OR */
        break;
      case 184:
#line 555 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_LT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3058 "parse.c"
        /* No destructor defined for LT */
        break;
      case 185:
#line 556 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_GT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3064 "parse.c"
        /* No destructor defined for GT */
        break;
      case 186:
#line 557 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_LE, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3070 "parse.c"
        /* No destructor defined for LE */
        break;
      case 187:
#line 558 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_GE, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3076 "parse.c"
        /* No destructor defined for GE */
        break;
      case 188:
#line 559 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_NE, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3082 "parse.c"
        /* No destructor defined for NE */
        break;
      case 189:
#line 560 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3088 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 190:
#line 561 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_BITAND, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3094 "parse.c"
        /* No destructor defined for BITAND */
        break;
      case 191:
#line 562 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_BITOR, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3100 "parse.c"
        /* No destructor defined for BITOR */
        break;
      case 192:
#line 563 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_LSHIFT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3106 "parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 193:
#line 564 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_RSHIFT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3112 "parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 194:
#line 565 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[-2].minor.yy334, 0);
  yygotominor.yy334 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->op = yymsp[-1].minor.yy52;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-2].minor.yy334->span, &yymsp[0].minor.yy334->span);
}
#line 3124 "parse.c"
        break;
      case 195:
#line 572 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[-3].minor.yy334, 0);
  yygotominor.yy334 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->op = yymsp[-1].minor.yy52;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy334->span,&yymsp[0].minor.yy334->span);
}
#line 3136 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 196:
#line 581 "parse.y"
{yygotominor.yy52 = TK_LIKE;}
#line 3142 "parse.c"
        /* No destructor defined for LIKE */
        break;
      case 197:
#line 582 "parse.y"
{yygotominor.yy52 = TK_GLOB;}
#line 3148 "parse.c"
        /* No destructor defined for GLOB */
        break;
      case 198:
#line 583 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3154 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 199:
#line 584 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3160 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 200:
#line 585 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3166 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 201:
#line 586 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3172 "parse.c"
        /* No destructor defined for SLASH */
        break;
      case 202:
#line 587 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_REM, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3178 "parse.c"
        /* No destructor defined for REM */
        break;
      case 203:
#line 588 "parse.y"
{yygotominor.yy334 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy334, yymsp[0].minor.yy334, 0);}
#line 3184 "parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 204:
#line 589 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3193 "parse.c"
        break;
      case 205:
#line 593 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3201 "parse.c"
        /* No destructor defined for IS */
        break;
      case 206:
#line 597 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3210 "parse.c"
        break;
      case 207:
#line 601 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3218 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 208:
#line 605 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOTNULL, yymsp[-3].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-3].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3227 "parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 209:
#line 609 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_NOT, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3237 "parse.c"
        break;
      case 210:
#line 613 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_BITNOT, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3245 "parse.c"
        break;
      case 211:
#line 617 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3253 "parse.c"
        break;
      case 212:
#line 621 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_UPLUS, yymsp[0].minor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy334->span);
}
#line 3261 "parse.c"
        break;
      case 213:
#line 625 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pSelect = yymsp[-1].minor.yy11;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3270 "parse.c"
        break;
      case 214:
#line 630 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy334, 0);
  yygotominor.yy334 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = pList;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-4].minor.yy334->span,&yymsp[0].minor.yy334->span);
}
#line 3281 "parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 215:
#line 637 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy334, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy334, 0);
  yygotominor.yy334 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = pList;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-5].minor.yy334->span,&yymsp[0].minor.yy334->span);
}
#line 3295 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 216:
#line 645 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-4].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = yymsp[-1].minor.yy62;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-4].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3307 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 217:
#line 650 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-4].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pSelect = yymsp[-1].minor.yy11;
  sqliteExprSpan(yygotominor.yy334,&yymsp[-4].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3318 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 218:
#line 655 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-5].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = yymsp[-1].minor.yy62;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-5].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3330 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 219:
#line 661 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_IN, yymsp[-5].minor.yy334, 0, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pSelect = yymsp[-1].minor.yy11;
  yygotominor.yy334 = sqliteExpr(TK_NOT, yygotominor.yy334, 0, 0);
  sqliteExprSpan(yygotominor.yy334,&yymsp[-5].minor.yy334->span,&yymsp[0].minor.yy0);
}
#line 3343 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 220:
#line 669 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_CASE, yymsp[-3].minor.yy334, yymsp[-1].minor.yy334, 0);
  if( yygotominor.yy334 ) yygotominor.yy334->pList = yymsp[-2].minor.yy62;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3355 "parse.c"
        break;
      case 221:
#line 676 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(yymsp[-4].minor.yy62, yymsp[-2].minor.yy334, 0);
  yygotominor.yy62 = sqliteExprListAppend(yygotominor.yy62, yymsp[0].minor.yy334, 0);
}
#line 3363 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 222:
#line 680 "parse.y"
{
  yygotominor.yy62 = sqliteExprListAppend(0, yymsp[-2].minor.yy334, 0);
  yygotominor.yy62 = sqliteExprListAppend(yygotominor.yy62, yymsp[0].minor.yy334, 0);
}
#line 3373 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 223:
#line 685 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 3380 "parse.c"
        /* No destructor defined for ELSE */
        break;
      case 224:
#line 686 "parse.y"
{yygotominor.yy334 = 0;}
#line 3386 "parse.c"
        break;
      case 225:
#line 688 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 3391 "parse.c"
        break;
      case 226:
#line 689 "parse.y"
{yygotominor.yy334 = 0;}
#line 3396 "parse.c"
        break;
      case 227:
#line 697 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(yymsp[-2].minor.yy62,yymsp[0].minor.yy334,0);}
#line 3401 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 228:
#line 698 "parse.y"
{yygotominor.yy62 = sqliteExprListAppend(0,yymsp[0].minor.yy334,0);}
#line 3407 "parse.c"
        break;
      case 229:
#line 699 "parse.y"
{yygotominor.yy334 = yymsp[0].minor.yy334;}
#line 3412 "parse.c"
        break;
      case 230:
#line 700 "parse.y"
{yygotominor.yy334 = 0;}
#line 3417 "parse.c"
        break;
      case 231:
#line 705 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-5].minor.yy210, &yymsp[-4].minor.yy210);
  if( yymsp[-9].minor.yy52!=OE_None ) yymsp[-9].minor.yy52 = yymsp[0].minor.yy52;
  if( yymsp[-9].minor.yy52==OE_Default) yymsp[-9].minor.yy52 = OE_Abort;
  sqliteCreateIndex(pParse, &yymsp[-7].minor.yy210, pSrc, yymsp[-2].minor.yy92, yymsp[-9].minor.yy52, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 3427 "parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 232:
#line 713 "parse.y"
{ yygotominor.yy52 = OE_Abort; }
#line 3435 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 233:
#line 714 "parse.y"
{ yygotominor.yy52 = OE_None; }
#line 3441 "parse.c"
        break;
      case 234:
#line 722 "parse.y"
{yygotominor.yy92 = 0;}
#line 3446 "parse.c"
        break;
      case 235:
#line 723 "parse.y"
{yygotominor.yy92 = yymsp[-1].minor.yy92;}
#line 3451 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 236:
#line 724 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(yymsp[-2].minor.yy92,&yymsp[0].minor.yy210);}
#line 3458 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 237:
#line 725 "parse.y"
{yygotominor.yy92 = sqliteIdListAppend(0,&yymsp[0].minor.yy210);}
#line 3464 "parse.c"
        break;
      case 238:
#line 726 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210;}
#line 3469 "parse.c"
        /* No destructor defined for sortorder */
        break;
      case 239:
#line 731 "parse.y"
{
  sqliteDropIndex(pParse, sqliteSrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210));
}
#line 3477 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 240:
#line 739 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-6].minor.yy210,&yymsp[-5].minor.yy210),&yymsp[-3].minor.yy210,&yymsp[0].minor.yy0,yymsp[-7].minor.yy52);}
#line 3484 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 241:
#line 741 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210),&yymsp[0].minor.yy210,0,yymsp[-4].minor.yy52);}
#line 3493 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 242:
#line 745 "parse.y"
{sqliteVacuum(pParse,0);}
#line 3500 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 243:
#line 746 "parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy210);}
#line 3506 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 244:
#line 750 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 3512 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 245:
#line 751 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy0,0);}
#line 3519 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 246:
#line 752 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 3526 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 247:
#line 753 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,1);}
#line 3533 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 248:
#line 754 "parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-1].minor.yy210,0);}
#line 3540 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 249:
#line 755 "parse.y"
{sqlitePragma(pParse,&yymsp[0].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 3548 "parse.c"
        /* No destructor defined for PRAGMA */
        break;
      case 250:
#line 756 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 3554 "parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 251:
#line 757 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 3560 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 252:
#line 758 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 3566 "parse.c"
        break;
      case 253:
#line 759 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 3571 "parse.c"
        break;
      case 254:
        /* No destructor defined for PLUS */
        break;
      case 255:
        break;
      case 256:
#line 765 "parse.y"
{
  Token all;
  all.z = yymsp[-4].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-4].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqliteFinishTrigger(pParse, yymsp[-1].minor.yy347, &all);
}
#line 3586 "parse.c"
        /* No destructor defined for trigger_decl */
        /* No destructor defined for BEGIN */
        break;
      case 257:
#line 773 "parse.y"
{
  SrcList *pTab = sqliteSrcListAppend(0, &yymsp[-3].minor.yy210, &yymsp[-2].minor.yy210);
  sqliteBeginTrigger(pParse, &yymsp[-7].minor.yy210, yymsp[-6].minor.yy52, yymsp[-5].minor.yy234.a, yymsp[-5].minor.yy234.b, pTab, yymsp[-1].minor.yy52, yymsp[0].minor.yy270, yymsp[-9].minor.yy52);
}
#line 3596 "parse.c"
        /* No destructor defined for TRIGGER */
        /* No destructor defined for ON */
        break;
      case 258:
#line 779 "parse.y"
{ yygotominor.yy52 = TK_BEFORE; }
#line 3603 "parse.c"
        /* No destructor defined for BEFORE */
        break;
      case 259:
#line 780 "parse.y"
{ yygotominor.yy52 = TK_AFTER;  }
#line 3609 "parse.c"
        /* No destructor defined for AFTER */
        break;
      case 260:
#line 781 "parse.y"
{ yygotominor.yy52 = TK_INSTEAD;}
#line 3615 "parse.c"
        /* No destructor defined for INSTEAD */
        /* No destructor defined for OF */
        break;
      case 261:
#line 782 "parse.y"
{ yygotominor.yy52 = TK_BEFORE; }
#line 3622 "parse.c"
        break;
      case 262:
#line 786 "parse.y"
{ yygotominor.yy234.a = TK_DELETE; yygotominor.yy234.b = 0; }
#line 3627 "parse.c"
        /* No destructor defined for DELETE */
        break;
      case 263:
#line 787 "parse.y"
{ yygotominor.yy234.a = TK_INSERT; yygotominor.yy234.b = 0; }
#line 3633 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 264:
#line 788 "parse.y"
{ yygotominor.yy234.a = TK_UPDATE; yygotominor.yy234.b = 0;}
#line 3639 "parse.c"
        /* No destructor defined for UPDATE */
        break;
      case 265:
#line 789 "parse.y"
{yygotominor.yy234.a = TK_UPDATE; yygotominor.yy234.b = yymsp[0].minor.yy92; }
#line 3645 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for OF */
        break;
      case 266:
#line 792 "parse.y"
{ yygotominor.yy52 = TK_ROW; }
#line 3652 "parse.c"
        break;
      case 267:
#line 793 "parse.y"
{ yygotominor.yy52 = TK_ROW; }
#line 3657 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for ROW */
        break;
      case 268:
#line 794 "parse.y"
{ yygotominor.yy52 = TK_STATEMENT; }
#line 3665 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for STATEMENT */
        break;
      case 269:
#line 797 "parse.y"
{ yygotominor.yy270 = 0; }
#line 3673 "parse.c"
        break;
      case 270:
#line 798 "parse.y"
{ yygotominor.yy270 = yymsp[0].minor.yy334; }
#line 3678 "parse.c"
        /* No destructor defined for WHEN */
        break;
      case 271:
#line 802 "parse.y"
{
  yymsp[-2].minor.yy347->pNext = yymsp[0].minor.yy347;
  yygotominor.yy347 = yymsp[-2].minor.yy347;
}
#line 3687 "parse.c"
        /* No destructor defined for SEMI */
        break;
      case 272:
#line 806 "parse.y"
{ yygotominor.yy347 = 0; }
#line 3693 "parse.c"
        break;
      case 273:
#line 812 "parse.y"
{ yygotominor.yy347 = sqliteTriggerUpdateStep(&yymsp[-3].minor.yy210, yymsp[-1].minor.yy62, yymsp[0].minor.yy334, yymsp[-4].minor.yy52); }
#line 3698 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 274:
#line 817 "parse.y"
{yygotominor.yy347 = sqliteTriggerInsertStep(&yymsp[-5].minor.yy210, yymsp[-4].minor.yy92, yymsp[-1].minor.yy62, 0, yymsp[-7].minor.yy52);}
#line 3705 "parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 275:
#line 820 "parse.y"
{yygotominor.yy347 = sqliteTriggerInsertStep(&yymsp[-2].minor.yy210, yymsp[-1].minor.yy92, 0, yymsp[0].minor.yy11, yymsp[-4].minor.yy52);}
#line 3715 "parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        break;
      case 276:
#line 824 "parse.y"
{yygotominor.yy347 = sqliteTriggerDeleteStep(&yymsp[-1].minor.yy210, yymsp[0].minor.yy334);}
#line 3722 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 277:
#line 827 "parse.y"
{yygotominor.yy347 = sqliteTriggerSelectStep(yymsp[0].minor.yy11); }
#line 3729 "parse.c"
        break;
      case 278:
#line 830 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy334->iColumn = OE_Ignore;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3738 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for IGNORE */
        break;
      case 279:
#line 835 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  yygotominor.yy334->iColumn = OE_Rollback;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3749 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for COMMA */
        break;
      case 280:
#line 840 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  yygotominor.yy334->iColumn = OE_Abort;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3761 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ABORT */
        /* No destructor defined for COMMA */
        break;
      case 281:
#line 845 "parse.y"
{
  yygotominor.yy334 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  yygotominor.yy334->iColumn = OE_Fail;
  sqliteExprSpan(yygotominor.yy334, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3773 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for FAIL */
        /* No destructor defined for COMMA */
        break;
      case 282:
#line 852 "parse.y"
{
  sqliteDropTrigger(pParse,sqliteSrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210));
}
#line 3783 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TRIGGER */
        break;
      case 283:
#line 857 "parse.y"
{
  sqliteAttach(pParse, &yymsp[-2].minor.yy210, &yymsp[0].minor.yy210);
}
#line 3792 "parse.c"
        /* No destructor defined for ATTACH */
        /* No destructor defined for database_kw_opt */
        /* No destructor defined for AS */
        break;
      case 284:
        /* No destructor defined for DATABASE */
        break;
      case 285:
        break;
      case 286:
#line 865 "parse.y"
{
  sqliteDetach(pParse, &yymsp[0].minor.yy210);
}
#line 3807 "parse.c"
        /* No destructor defined for DETACH */
        /* No destructor defined for database_kw_opt */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yypParser->yytop -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqliteParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqliteSetNString(&pParse->zErrMsg, 
          "near \"", -1, TOKEN.z, TOKEN.n, "\": syntax error", -1, 0);
    }else{
      sqliteSetString(&pParse->zErrMsg, "incomplete SQL statement", (char*)0);
    }
  }
  pParse->nErr++;

#line 3864 "parse.c"
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yytop = &yypParser->yystack[0];
    yypParser->yytop->stateno = 0;
    yypParser->yytop->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqliteParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      if( yypParser->yytop->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yypParser->yytop->major != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yypParser->yytop->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
