#define RXMMS	1
#define DIGIDECK	1

#if XMMS_VIS
#	define XMMS_VISIMPORT_HACK		0
#endif

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <X11/Xlib.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <pthread.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include <math.h>

#include <xmms/xmmsctrl.h>
#include <xmms/configfile.h>

extern GdkWindow *root_window;

/* ---------------------------------------------------------------------- */
typedef enum
{
		/* main/dock/winshade window */
	BUTTON_VOLUME, BUTTON_CLOSE, BUTTON_MINIMIZE, BUTTON_ABOUT, BUTTON_OPEN,
	BUTTON_STOP, BUTTON_PLAY, BUTTON_REWIND, BUTTON_FASTFORWARD,
	BUTTON_PREVIOUSSONG, BUTTON_NEXTSONG, BUTTON_EQUALIZER, BUTTON_PAUSE,
	BUTTON_OPTIONS, BUTTON_REPEAT, BUTTON_EQURESET, BUTTON_EQUON,
	BUTTON_EQUOFF, BUTTON_SHUFFLE, BUTTON_PLAYLIST, BUTTON_DOCKMODE,
	BUTTON_SANALYZER, BUTTON_OSCILLO, BUTTON_PITCH, BUTTON_UNDOCK,
	REGION_SEEK, REGION_MP3KBPS, REGION_MP3KHZ, REGION_MP3TIME,
	REGION_FNAME, REGION_VOLTEXT, REGION_TRACK, REGION_ANALYZER,
	REGION_EQUALIZER, REGION_PITCHTEXT, REGION_SEEKBAR, BUTTON_VOLUP,
	BUTTON_VOLDOWN,
	NUM_MAIN_AREAS,

		/* playlist window */
	PLREGION_TEXT, PLREGION_SELTRACK, PLREGION_TTLTRACK, PLBUTTON_LINK,
	PLBUTTON_CLOSE, PLBUTTON_OPEN, PLBUTTON_MINIMIZE, PLBUTTON_UP,
	PLBUTTON_DOWN, PLBUTTON_SORT, PLBUTTON_SHUFFLE, PLBUTTON_INVERSE,
	PLBUTTON_ADD, PLBUTTON_RESET, PLBUTTON_DELETE, PLBUTTON_LOAD,
	PLBUTTON_SAVE, PLBUTTON_SELUP, PLBUTTON_SELDOWN, PLBUTTON_PREVIOUS,
	PLBUTTON_PLAY, PLBUTTON_NEXT, PLBUTTON_PAUSE, PLBUTTON_STOP, PLBUTTON_ABOUT,
	PLREGION_SELTIME, PLBUTTON_PREFS, PLBUTTON_PGUP, PLBUTTON_PGDOWN,
	PLBUTTON_HOME, PLBUTTON_END, NUM_PL_AREAS,
	NUM_AREAS
} area_type;


/* ---------------------------------------------------------------------- */
typedef struct {
	char *name;
	int area;
	int type;
} k_res_area;

/* ---------------------------------------------------------------------- */
typedef struct {
	gint width, height;
	guchar *data;
	GdkPixmap *pix;
	GdkBitmap *mask;
} k_image;

/* ---------------------------------------------------------------------- */
typedef struct {
	k_image *img;
	gulong tcol;
	gint type, size[2], spacing, transparent;
} k_font;

/* ---------------------------------------------------------------------- */
typedef enum
{
	A_NONE, A_BUTTON, A_TOGGLE, A_TEXT, A_SLIDER, A_EQUALIZER, A_ANALYZER,
	A_PLIST, A_BAR
} atype;

typedef struct {
	int type, focus, pressed, active, bm;
	int x1, y1, x2, y2;
} k_area;

/* ---------------------------------------------------------------------- */
#define MAX_ABOUT_STR	10

typedef struct {
	gchar *res_name, *dck_rc_fname, *wsh_rc_fname;
	gint dock_mode;
	gchar *about_str[MAX_ABOUT_STR];
	gint about_str_pos, about_str_num;
	k_image *background;
	k_image *inactive;
	k_image *pressed[3];
	k_image *volume;
	k_image *volume_position;
	k_image *pitch;
	k_image *pitch_position;
	k_image *seek;
	GdkImage *seek_sel, *seek_unsel;
	k_image *pl_background, *pl_pressed;
	k_font Font, TimeFont, VolumeFont, PitchFont;
	gint VolumeControlImageXSize, VolumeControlImageNb, VolumeControlType;
	gint PitchControlImageXSize, PitchControlImageNb;
	gint DockPos[2];
	k_image *equalizer;
	gint equ_band_width, equ_bmp_bands, equ_num_bands, equ_band_space;
	gint pl_fontsize, pl_fontyspace;
	gchar *pl_fontname;
	GdkColor pl_colour, pl_curtrack_colour, pl_cursel_colour;
	GdkColor analyser_colour, vis_colour[25];
	k_area areas[NUM_AREAS+5];
} k_resource;


/* ---------------------------------------------------------------------- */
typedef struct {
	gchar *res_name;
	gboolean save_win_pos; 
	gint win_x, win_y;
	gboolean save_plist_pos, lock_plist;
	gint plist_x, plist_y;
	gboolean close_main_startup, quit_xmms_exit;
	gint playlist_editor_type;
	gint vis_mode, analyser_mode, analyser_type, analyser_peaks, scope_mode;
	gint refresh_rate, freq_falloff, peak_falloff;
} k_config;

/* ---------------------------------------------------------------------- */
	/* mirror of XMMS playlist entry :) */
typedef struct {
	gchar *filename;
	gchar *title;
	gint length;
	gboolean selected;
} plist_entry;

/* ---------------------------------------------------------------------- */
int inside_area(int x, int y, k_area *a);
void kj_main_move(gint x, gint y);
void kj_set_resource(void);

/* ---------------------------------------------------------------------- */
guchar *read_bmp(gchar* filename, gulong *width, gulong *height, gulong *transp);
guchar *read_png(gchar* filename, gulong *width, gulong *height, gulong *transp);
GdkBitmap *generate_mask(k_image *img, gulong trans);
void kj_mask_colour(k_image *img, gulong trans);
k_image *kj_read_image(gchar *filename, int pixmap);
gulong kj_get_pixel(k_image *img, gint x, gint y);
void kj_free_image(k_image *img);

/* ---------------------------------------------------------------------- */
void read_rc_file(gchar *path, gchar *fname, k_resource *res, k_area *areas);
void free_resource(k_resource *res);
int load_resource(char *path, char *rc_fname, k_resource *res);

/* ---------------------------------------------------------------------- */
void kj_default_config(void);
void kj_load_config(void);
void kj_save_config(void);
void kj_configure(void);
void kj_configure_cleanup(void);
void kj_about(void);

/* ---------------------------------------------------------------------- */
void kj_playlist(void);
void kj_update_playlist(void);
void kj_playlist_move(gint x, gint y);
void kj_playlist_cleanup(void);
void kj_set_pl(void);

