/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


// Heavily based on code form xmmsctrl.c and controlsocket.c
// from the XMMS package (www.xmms.org)

#include "singit/control.h"
#include "socket.h"

#include "dialogs.h"

#include "singit_debug.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <xmms/plugin.h>

extern VisPlugin singit_vp;

static gpointer remote_read_packet(gint fd, ServerPktHeader * pkt_hdr)
{
	gpointer data = NULL;

	if (read(fd, pkt_hdr, sizeof (ServerPktHeader)) == sizeof (ServerPktHeader))
	{
		if (pkt_hdr->data_length)
		{
			data = g_malloc0(pkt_hdr->data_length);
			read(fd, data, pkt_hdr->data_length);
		}
	}
	return data;
}

static void remote_read_ack(gint fd)
{
	gpointer data;
	ServerPktHeader pkt_hdr;

	data = remote_read_packet(fd, &pkt_hdr);
	if (data)
		g_free(data);

}

static void remote_send_packet(gint fd, guint32 command, gpointer data, guint32 data_length)
{
	ClientPktHeader pkt_hdr;

	pkt_hdr.version = SINGIT_PROTOCOL_VERSION;
	pkt_hdr.command = command;
	pkt_hdr.data_length = data_length;
	write(fd, &pkt_hdr, sizeof (ClientPktHeader));
	if (data_length && data)
		write(fd, data, data_length);
}

#if 0
static void remote_send_guint32(gint session, guint32 cmd, guint32 val)
{
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return;
	remote_send_packet(fd, cmd, &val, sizeof (guint32));
	remote_read_ack(fd);
	close(fd);
}

static void remote_send_boolean(gint session, guint32 cmd, gboolean val)
{
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return;
	remote_send_packet(fd, cmd, &val, sizeof (gboolean));
	remote_read_ack(fd);
	close(fd);
}

static void remote_send_gfloat(gint session, guint32 cmd, gfloat value)
{
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return;
	remote_send_packet(fd, cmd, &value, sizeof (gfloat));
	remote_read_ack(fd);
	close(fd);
}

static void remote_send_string(gint session, guint32 cmd, gchar * string)
{
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return;
	remote_send_packet(fd, cmd, string, string ? strlen(string) + 1 : 0);
	remote_read_ack(fd);
	close(fd);
}
#endif

static gboolean remote_cmd(gint session, guint32 cmd)
{
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return FALSE;
	remote_send_packet(fd, cmd, NULL, 0);
	remote_read_ack(fd);
	close(fd);

	return TRUE;
}

#if 0
static gboolean remote_get_gboolean(gint session, gint cmd)
{
	ServerPktHeader pkt_hdr;
	gboolean ret = FALSE;
	gpointer data;
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return ret;
	remote_send_packet(fd, cmd, NULL, 0);
	data = remote_read_packet(fd, &pkt_hdr);
	if (data)
	{
		ret = *((gboolean *) data);
		g_free(data);
	}
	remote_read_ack(fd);
	close(fd);

	return ret;
}
#endif

static guint32 remote_get_gint(gint session, gint cmd)
{
	ServerPktHeader pkt_hdr;
	gpointer data;
	gint fd, ret = 0;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return ret;
	remote_send_packet(fd, cmd, NULL, 0);
	data = remote_read_packet(fd, &pkt_hdr);
	if (data)
	{
		ret = *((gint *) data);
		g_free(data);
	}
	remote_read_ack(fd);
	close(fd);
	return ret;
}

#if 0
static gfloat remote_get_gfloat(gint session, gint cmd)
{
	ServerPktHeader pkt_hdr;
	gpointer data;
	gint fd;
	gfloat ret = 0.0;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return ret;
	remote_send_packet(fd, cmd, NULL, 0);
	data = remote_read_packet(fd, &pkt_hdr);
	if (data)
	{
		ret = *((gfloat *) data);
		g_free(data);
	}
	remote_read_ack(fd);
	close(fd);
	return ret;
}

static gchar *remote_get_string(gint session, gint cmd)
{
	ServerPktHeader pkt_hdr;
	gpointer data;
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return NULL;
	remote_send_packet(fd, cmd, NULL, 0);
	data = remote_read_packet(fd, &pkt_hdr);
	remote_read_ack(fd);
	close(fd);
	return data;
}

static gchar *remote_get_string_pos(gint session, gint cmd, guint32 pos)
{
	ServerPktHeader pkt_hdr;
	gpointer data;
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return NULL;
	remote_send_packet(fd, cmd, &pos, sizeof (guint32));
	data = remote_read_packet(fd, &pkt_hdr);
	remote_read_ack(fd);
	close(fd);
	return data;
}
#endif


// * * * * * * * * * * * *
// * API
// * * * * * * * *

gint singit_remote_get_xmms_session(gint session)
{
	return singit_vp.xmms_session;
}

gint singit_remote_get_version(gint session)
{
	return remote_get_gint(session, CMD_GET_VERSION);
}

void singit_remote_quit(gint session)
{
	gint fd;

	if ((fd = singit_socket_connect_to_session(session)) == -1)
		return;
	remote_send_packet(fd, CMD_QUIT, NULL, 0);
	remote_read_ack(fd);
	close(fd);
}

void singit_remote_show_prefs_dlg(gint session)
{
	remote_cmd(session, CMD_SHOW_PREFS_DLG);
	singit_config_show();
}

void singit_remote_show_about_dlg(gint session)
{
	remote_cmd(session, CMD_SHOW_ABOUT_DLG);
	singit_about_show();
}

void singit_remote_show_editor_dlg(gint session)
{
	remote_cmd(session, CMD_SHOW_EDITOR_DLG);
	singit_editor_show();
}

void singit_remote_show_about_keys_dlg(gint session)
{
	singit_about_show_page(1);
}

void singit_remote_show_tag_manager_dlg(gint session)
{
	singit_tag_manager_show();
}

// void singit_config_show_page(gint page);


// * * * * * * * * * * * *
// * Config API
// * * * * * * * *

gboolean singit_remote_cfg_toggle_yz(gint session)
{
	return GET_SCD->toggleYZ;
}

gboolean singit_remote_cfg_hide_if_not_found(gint session)
{
	return GET_SCD->hideIfNotFound;
}

gboolean singit_remote_cfg_show_empty(gint session)
{
	return GET_SCD->showEmpty;
}

gboolean singit_remote_cfg_auto_resize(gint session)
{
	return GET_SCD->autoResize;
}

gboolean singit_remote_cfg_debug_enabled(gint session)
{
	return GET_SCD->debugEnable;
}

gchar* singit_remote_cfg_lyric_font_name(gint session)
{
	return g_strdup(GET_SCD->lyricFontName);
}

gchar* singit_remote_cfg_color(gint session, gint type)
{
	switch (type) {
	case 0: return g_strdup(GET_SCD->backgroundColor);
	case 1: return g_strdup(GET_SCD->normalTextColor);
	case 2: return g_strdup(GET_SCD->normalBarColor);
	case 3: return g_strdup(GET_SCD->progressTextColor);
	case 4: return g_strdup(GET_SCD->progressBarColor);
	default: break;
	}
	return NULL;
}

gboolean singit_remote_cfg_framerate_limit_enabled(gint session)
{
	return GET_SCD->framerateLimitEnabled;
}

gint singit_remote_cfg_framerate_limit(gint session)
{
	return GET_SCD->framerateLimit;
}

gboolean singit_remote_cfg_show_time_indicator(gint session)
{
	return GET_SCD->showTimeIndicator;
}

gboolean singit_remote_cfg_guess_synced_lyrics(gint session)
{
	return GET_SCD->guessSyncLyrics;
}

gboolean singit_remote_cfg_show_jumping_ball(gint session)
{
	return GET_SCD->showJumpingBall;
}

gboolean singit_remote_cfg_find_optimal_font(gint session)
{
	return GET_SCD->findOptimalFont;
}
