/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_KARAOKE_WINDOW_STATUS_H__
#define __DISPLAYER_KARAOKE_WINDOW_STATUS_H__

#include <gtk/gtkwidget.h>

#include "singit/song.h"
#include "singit/singleton.h"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_KARAOKE_WINDOW_STATUS            (karaoke_window_status_get_type ())
#define KARAOKE_WINDOW_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_KARAOKE_WINDOW_STATUS, KaraokeWindowNewStatus))
#define KARAOKE_WINDOW_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_KARAOKE_WINDOW_STATUS, KaraokeWindowNewStatus))
#define IS_KARAOKE_WINDOW_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_KARAOKE_WINDOW_STATUS))
#define IS_KARAOKE_WINDOW_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_KARAOKE_WINDOW_STATUS))

typedef struct _KaraokeWindowNewStatus       KaraokeWindowNewStatus;
typedef struct _KaraokeWindowNewStatusClass  KaraokeWindowNewStatusClass;

struct _KaraokeWindowNewStatus {

	SingitSingleton     singleton;

	guint timestamp_context_id;
	guint song_context_id;
	gint messageCounter;
	gint jump_to_song;

	gchar *fileName;
	SingitSong *song;
	gboolean update_song;

	gboolean print_debug;
	gboolean toggle_yz;
	gboolean guess_synced_lyrics;
	gboolean show_jumping_ball;
	gboolean hide_if_not_found;
	gboolean hide_if_not_found_fullscreen;
	gboolean auto_resize;

	gboolean start_fullscreen;
	gboolean is_fullscreen;

	GtkWidget *karaoke_widget;
	gchar     *fullscreen_background_color;
};

struct _KaraokeWindowNewStatusClass {

	SingitSingletonClass  parent_class;
};

GtkType            karaoke_window_status_get_type(void);

SingitSingleton*   karaoke_window_status_ref(void);
void               karaoke_window_status_unref(SingitSingleton** single);

SingitSingleton*   karaoke_window_status_noref(void);

#define STATUS \
	KARAOKE_WINDOW_STATUS(karaoke_window_status_noref())

#define DEBUG(x)  do { if (karaoke_window_status_noref() && \
	STATUS->print_debug) debug x; } while (0)
#define PERROR(x) do { if (karaoke_window_status_noref() && \
	STATUS->print_debug) perror(x); } while (0)

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif //__DISPLAYER_KARAOKE_WINDOW_STATUS_H__
