/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "dkwn_mouse_handling.h"

#define FULL_SCREEN_HIDE_MOUSE_DELAY 1000

static guint show_mouse_timeout_id = 0;
static GtkWidget *cursor_widget = NULL;
static guint callback_id = 0;

static void clear_mouse_cursor(GtkWidget *widget, gint clear)
{
	GdkCursor *cursor = NULL;
	GdkPixmap *p;

	if (clear == TRUE) { 
		p = gdk_bitmap_create_from_data(widget->window, "\0\0\0", 1, 1);

		cursor = gdk_cursor_new_from_pixmap(p, p,
			&widget->style->fg[GTK_STATE_ACTIVE],
			&widget->style->bg[GTK_STATE_ACTIVE],
			0, 0);
		
		gdk_pixmap_unref(p);
	}

	gdk_window_set_cursor(widget->window, cursor);

	if (cursor) 
		gdk_cursor_destroy (cursor);
}

static gint fullscreen_hide_mouse_cb(gpointer data)
{
	if (show_mouse_timeout_id == 0) 
		{ return FALSE; }

	clear_mouse_cursor(cursor_widget, TRUE);

	show_mouse_timeout_id = 0;

	return FALSE;
}

static void fullscreen_mouse_moved(GtkWidget *widget, GdkEventButton *bevent, gpointer data)
{
	if (show_mouse_timeout_id != 0)
		gtk_timeout_remove(show_mouse_timeout_id);
	else
		clear_mouse_cursor(cursor_widget, FALSE);
	show_mouse_timeout_id =
		gtk_timeout_add(FULL_SCREEN_HIDE_MOUSE_DELAY, 
			fullscreen_hide_mouse_cb, NULL);
}

void fullscreen_hide_mouse_init(GtkWidget *widget)
{
	g_return_if_fail(show_mouse_timeout_id == 0);
	g_return_if_fail(callback_id == 0);

	cursor_widget = widget;
}

void fullscreen_hide_mouse_finish(void)
{
	g_return_if_fail(cursor_widget != NULL);
	
	if (show_mouse_timeout_id != 0)
		fullscreen_hide_mouse_disable();
	
	if (callback_id != 0)
		gtk_signal_disconnect(GTK_OBJECT(cursor_widget), callback_id);

	callback_id = 0;
	cursor_widget = NULL;
}

void fullscreen_hide_mouse_enable(void)
{
	g_return_if_fail(show_mouse_timeout_id == 0);
	g_return_if_fail(cursor_widget != NULL);

	if (callback_id == 0) {
		callback_id = gtk_signal_connect(GTK_OBJECT(cursor_widget), 
			"motion_notify_event",
			GTK_SIGNAL_FUNC(fullscreen_mouse_moved), NULL);
	}
	clear_mouse_cursor(cursor_widget, TRUE);
}

void fullscreen_hide_mouse_disable(void)
{
	if (show_mouse_timeout_id != 0) {
		gtk_timeout_remove(show_mouse_timeout_id);
		show_mouse_timeout_id = 0;
	}
	else { clear_mouse_cursor(cursor_widget, FALSE); }
}
