/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CFREQUENCEPARTICLEENGINE_H__
#define __CFREQUENCEPARTICLEENGINE_H__

#include <glib.h>
#include <GL/gl.h>

#include "ctexture.h"

class CFrequenceParticleEngine {
protected:
	GSList *active_particles; // Stores the active particle data
	GSList *free_particles; // Stores the unused particle data
	guint list_length, max_particles, max_create;
	GLfloat color[4];
	gdouble scaler;
	gdouble height;
	gdouble speed;
	CTexture *texture;
	gint freq_band_min, freq_band_max;
	bool draw_particles;

	static GLfloat height_scale;

public:
	CFrequenceParticleEngine(guint set_max_particles = 0);
	virtual ~CFrequenceParticleEngine();

	void calc(gint16 data[2][256]);
	void draw();
	void setTexture(CTexture texture);

	gdouble getHeight() { return height; }
	void setHeight(gdouble height) { this->height = height; }

	void setFrequenceBand(gint freq_band_min, gint freq_band_max)
	{
		this->freq_band_min = freq_band_min;
		this->freq_band_max = freq_band_max;
	}

	void setColor(GLfloat red, GLfloat green, GLfloat blue)
	{
		color[0] = red;
		color[1] = green;
		color[2] = blue;
	}

	void setDrawParticles(bool value) { draw_particles = value; }
	bool getDrawParticles() { return draw_particles; }
};

class CFrequenceParticleEngineField
{
protected:
	CFrequenceParticleEngine **bars;

	guint rows, columns;

	GLfloat y_angle, y_speed;
	GLfloat x_angle, x_speed;
	GLfloat z_angle, z_speed;

	GLfloat space;
	GLfloat scaler[3];
	GLfloat translator[3];

public:
	CFrequenceParticleEngineField(guint rows = 16, guint columns = 16, guint max_particles = 0);
	virtual ~CFrequenceParticleEngineField();

	void renderFreq(gint16 data[2][256]);
	void draw();

	void setDrawParticles(bool value);
	bool getDrawParticles();
};

#endif // __CFREQUENCEPARTICLEENGINE_H__
