
#ifndef __ABSTRACT_STR_ACCESS_H__
#define __ABSTRACT_STR_ACCESS_H__

#include "UtilStr.h"

enum XStrListOptsT {

	ASA_OrderImportant,
	ASA_OrderNotImportant,
	ASA_Sorted_Case_Sensitive,
	ASA_Sorted_Case_Insensitive
};


class AbstractStrAccess  {

public:
	AbstractStrAccess( XStrListOptsT inOrdering );

	// Returns the index of the element with a matching name.  If 0 is returned, no item was found.
	/* The running time of this fcn depends on how this array is sorted:
		Unsorted: 						O(N)
		inCaseSensitive is how strings are sorted:
			Sorted:						O(N)
		inCaseSensitive isn't how strings are sorted:
			Sorted, case insensitive:  	O(log N + D)	(where D is avg num of case insensitive dupes)
			Sorted, case sensitive:		O(N) 			(could be O(2 log N), but implementation would suck)    */
	virtual long			FindString( const char* inStr,		bool inCaseSensitive = true ) const;
	virtual long			FindString( const UtilStr* inStr,	bool inCaseSensitive = true ) const;

	// Returns direct access to the string.  Do not modify the string and use it immediately only (ie,
	//    don't keep the ptr around and use it at a later time).
	// Note:  1-based indexing is used.
	// Post:  If inIndex is an invalid index ( < 1 or > Count() ), then NULL is returned.  If the index is valid,
	// 			NULL will never be returned.
	virtual const UtilStr*		Fetch( long inIndex ) const = 0;

	// Same as above but returns a copy, and returns true if element was found and retrieved
	bool				Fetch( long inIndex, UtilStr& outStr ) const;

	//	Returns how many elements are in this Array
	virtual long			Count() const = 0;

	// Returns an index of the closest matching string to inStr.
	// Note: the running time O( N ) * O( inStr.length() * <avg element length> )
	long				FindBestMatch( const UtilStr* inStr )								{ return FindBestMatch( inStr -> getCStr(), inStr -> length() );	}
	long				FindBestMatch( const char* inStr, long inLen = -1 );

protected:
	long				BinarySearch( const char* inStr, bool inCaseSensitive ) const;

	XStrListOptsT			mStrOrdering;
};

#endif // __ABSTRACT_STR_ACCESS_H__
