#ifndef ImportedMovie_H
#define ImportedMovie_H

#include "PixPort.h"

class VFrameBuffer;
class CEgFileSpec;


#include "DictValue.h"

#if WIN_QUICKTIME_PRESENT || EG_MAC
#include <Movies.h>
#endif

class ImportedMovie : public DictValue {


	public:	
	
								ImportedMovie();
		virtual					~ImportedMovie();
								
								
		bool					OpenMovie( CEgFileSpec& inSpec, long inDepth );
								
		// Retrns the duration of this movie in MS.
		long					Duration();
		
		long					GetX()						{ return mPort.GetX();		}
		long					GetY()						{ return mPort.GetY();		}

		const VFrameBuffer*		GetFrame( long inT_MS );
		
		// Returns true if QT sees the spec as a movie.
		static bool				IsMovie( CEgFileSpec& inSpec );
		
		
	protected:
	
		Movie					mMovie;
		PixPort					mPort;
		long					mCurTimeIndex;
		bool					mQTAvailable;
};


#endif