/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SDL_WHITECAP_CONFIG_H__
#define __SDL_WHITECAP_CONFIG_H__

#include "singit/config_xmms.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _SDLWhitecapConfigData {

	gboolean  forceGlobals;

	// * have a global equivalent *
	gboolean  hideIfNotFound;
	gboolean  hideIfNotFoundFullscreen;
	gboolean  showEmpty;
	gboolean  autoResize;
	gboolean  debugEnable;
	gboolean  optimizeFontSize;

	gboolean  framerateLimitEnabled;
	guint     framerateLimit;

	// * string values *
	gchar    *lyricFontName;

	// * integer values *
	gint      winPosX;
	gint      winPosY;
	gint      lyricFontSize;
	gint      lyricFontSizeFullscreen;

	// * global values *
	gboolean  gblToggleYZ;
}
SDLWhitecapConfigData;

SingitConfigGen *displayer_sdl_whitecap_config_new(void);

#define GET_DSCD ((SDLWhitecapConfigData *) \
	singit_config_gen_get_data(STATUS->config))

#define DEBUG(x) \
	do { if (STATUS && GET_DSCD && GET_DSCD->debugEnable) debug x; } while (0);

#define GET_CFG(val) (GET_DSCD->forceGlobals == TRUE) \
	? (GET_SCD->val) : GET_DSCD->val

#ifdef __cplusplus
}
#endif // __cplusplus

#endif  // __SDL_WHITECAP_CONFIG_H__
