/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


// *
// * This implements a basic singleton class
// *
// * To create a real singleton you subclass the SingitSingleton and create a
// * new object via singit_singleton_construct.
// * Normally you should not use a a *_new funtion, since you have to check
// * for object creation in every *_ref call, so just work with *_ref and
// * *_unref calls
// *
// * Don't use gtk_type_new to create a new object!
// * All the creation work is done in singit_singleton_construct
// *

#ifndef __SINGIT_SINGLETON_H__
#define __SINGIT_SINGLETON_H__

#include <gtk/gtkobject.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_SINGIT_SINGLETON            (singit_singleton_get_type ())
#define SINGIT_SINGLETON(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_SINGLETON, SingitSingleton))
#define SINGIT_SINGLETON_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_SINGLETON, SingitSingleton))
#define IS_SINGIT_SINGLETON(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_SINGLETON))
#define IS_SINGIT_SINGLETON_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_SINGLETON))

typedef struct _SingitSingleton       SingitSingleton;
typedef struct _SingitSingletonClass  SingitSingletonClass;

struct _SingitSingleton {

	GtkObject          object;
};

struct _SingitSingletonClass {

	GtkObjectClass     parent_class;

	// Since you can't create objects, which depend on the Singleton
	// inside the init funtion a Singleton provides two funtions, which
	// run afer the initialization and before the destruction

	// For additional initialization see singit_singleton_initialize

	// The return value determinates if init was successfull
	// If FALSE the precreated Singleton will be destroyed
	gboolean         (*after_init)      (SingitSingleton*);

	void             (*before_destroy)  (SingitSingleton*);
};

GtkType           singit_singleton_get_type  (void);

// * Construct a new singleton object
// * Should be called before every attach
// * Pre:
// *	single:	(static) variable holding the singleton
// *	type:	type passed to gtk_type_new
// *		(has to be a subclass of SingitSingleton)
// *	init:	Is this the first initial call
// *		(has to be != NULL)
// * Post:
// *	return:	The created singleton or NULL if failed
SingitSingleton*  singit_singleton_construct
	(SingitSingleton **single, GtkType type, gboolean *init);

// * Returns TRUE, if the object has just been initialized
// * Can be used to do some more intialisation
gboolean        singit_singleton_initialize  (SingitSingleton  *single);

// Funtions to safely manage the reference count of a singleton
SingitSingleton*  singit_singleton_attach    (SingitSingleton  *single);
void              singit_singleton_detach    (SingitSingleton **single);

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif  // __SINGIT_SINGLETON_H__
