#ifndef SYNA_XMMS_H
#define SYNA_XMMS_H

#include <stdio.h>
#define DBRK() do{fprintf(stderr, "DBRK at line %d in "__FILE__"\n", __LINE__);}while(0)
/*#define DBRK()*/


#include <gtk/gtk.h>

typedef gint16 sampleType;

#define synx_log2numsamples 8
#define synx_numsamples (1<<synx_log2numsamples)

#define Stars 0
#define Wave 1
#define Flame 2

extern void syna_coreInit();
extern void syna_setStarSize(double size);
extern int syna_coreGo(sampleType data[2][synx_numsamples]);
extern void syna_fade();

extern void synx_configure(void);
extern void synx_read_config(void);
extern void synx_write_cfg(void);

typedef struct {
	gint req_w, req_h;
	gboolean scale;

	gdouble fgRed;
	gdouble fgGreen;
	gdouble bgRed;
	gdouble bgGreen;

	gdouble brightnessTwiddler;
	gdouble starSize;
	gint fadeMode;
	gboolean pointsAreDiamonds;
	gboolean auto_fullscreen;
} SynXConfig;

extern SynXConfig synx_cfg;

extern gboolean synx_am_fullscreen;
extern int synx_img_w, synx_img_h;


extern void synx_generate_cmap(void);
extern void synx_resize(gint new_img_w, gint new_img_h, gboolean force);

#include <pthread.h>

extern pthread_mutex_t synx_res_lock;
extern gboolean synx_have_mutex;

#define SYNX_LOCK() pthread_mutex_lock(&synx_res_lock)
#define SYNX_UNLOCK() pthread_mutex_unlock(&synx_res_lock)

#endif
