/*

    xpuyopuyo - pwindow.h     Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header file for window (graphical user interface) code.
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pwindow_h_defined
#define __pwindow_h_defined

#include <pgame.h>


/* Window dimensions */

/* Size of each tile in pixels */
#define P_WINDOW_CELL_WIDTH         20
#define P_WINDOW_CELL_HEIGHT        20
#define P_CELL_WIDTH                P_WINDOW_CELL_WIDTH
#define P_CELL_HEIGHT               P_WINDOW_CELL_HEIGHT
#define P_CELL_BORDER               2

/* Field size, in pixels (not including borders) */
#define P_WINDOW_FIELD_WIDTH(w)     ((w) * P_WINDOW_CELL_WIDTH)
#define P_WINDOW_FIELD_HEIGHT(h)    ((h) * P_WINDOW_CELL_HEIGHT)

/* Field size, including borders */
#define P_WINDOW_FIELD_WIDTH_B(w)   (P_WINDOW_FIELD_WIDTH(w) + 2 * P_WINDOW_CELL_WIDTH)
#define P_WINDOW_FIELD_HEIGHT_B(h)  (P_WINDOW_FIELD_HEIGHT(h) + 3 * P_WINDOW_CELL_HEIGHT)

/* Topleft position of field for player i */
#define P_WINDOW_FIELD_X(w, i)      (P_WINDOW_FIELD_WIDTH_B(w) * (i) + P_WINDOW_CELL_WIDTH)
#define P_WINDOW_FIELD_Y(h, i)      (P_WINDOW_CELL_HEIGHT * 3)

/* Expected size of the entire window */
#define P_WINDOW_WIDTH(w)           (P_WINDOW_FIELD_WIDTH_B(w) * P_NUM_PLAYERS)
#define P_WINDOW_HEIGHT(h)          (P_WINDOW_FIELD_HEIGHT_B(h) + 7 * P_WINDOW_CELL_HEIGHT)


/* Various available rock types */
#define P_NUM_ROCKS           4     /* Three, that's right :) */
#define P_NORMAL_ROCK         0     /* Represents one rock */
#define P_BIG_ROCK            1     /* Represents 6 rocks */
#define P_DEMON_ROCK          2     /* Represents 15 big rocks! */
#define P_BIGROCK_NUM         6     /* Number represented by a big rock */
#define P_DEMONROCK_NUM       15    /* Number represented by a really big rock */


/* The bottom tile may actually be multiple tiles */
#define P_NUM_BOTTOM_TILES    3     /* Wheee! */


/* Redraw masks */
#define P_REDRAW_NONE         0x0000            /* Nothing to do */
#define P_REDRAW_PLAYER(i)    (1 << (i))        /* Redraw player i */
#define P_REDRAW_PLAYER_0     P_REDRAW_PLAYER(0)/* Redraw player 0 */
#define P_REDRAW_PLAYER_1     P_REDRAW_PLAYER(1)/* Redraw player 1 */
#define P_REDRAW_SCREEN       0x8000            /* Redraw screen (borders, and whatnot) */
#define P_REDRAW_TIMER        0x4000            /* Update game timer */
#define P_REDRAW_NEXT         0x2000            /* Redraw both player's next pieces */
#define P_REDRAW_ALL          0xffff            /* Everything */



/* Window data */
typedef struct _pwindow {
   void *dummy;
} pwindow;


/* Interface functions */
pwindow *p_window_new(pconfig *c, int argc, char * const *argv);
void p_window_free(pwindow **w);

/* Drawing/status functions */
void p_window_paint(pconfig *c, const pwindow *w, int redraw);
void p_window_set_message(pwindow *w, const char *message);
void p_window_set_status(pwindow *w, const char *message);
void p_window_set_player_info(pwindow *w, int i, const pplayer *player);
void p_window_set_waiting(pwindow *w, int waiting);

/* Program main loop control */
void p_window_run(pwindow *w, pconfig *c);
void p_window_idle(pwindow *w);


#endif
