/*-
# X-BASED OCTAHEDRON
#
#  Oct.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Oct */

#ifndef _XtOct_h
#define _XtOct_h

/***********************************************************************
 *
 * Oct Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNfaceColor6 ((char *) "faceColor6")
#define XtNfaceColor7 ((char *) "faceColor7")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNsize ((char *) "size")
#define XtNsticky ((char *) "sticky")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCSize ((char *) "Size")
#define XtCSticky ((char *) "Sticky")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _OctClassRec *OctWidgetClass;

extern WidgetClass octWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} octCallbackStruct;
#endif

#define PUZZLE_HIDE (-9)
#define PUZZLE_PRACTICE_QUERY (-8)
#define PUZZLE_RANDOMIZE_QUERY (-7)
#define PUZZLE_SOLVE_MESSAGE (-6)
#define PUZZLE_RESTORE (-5)
#define PUZZLE_RESET (-4)
#define PUZZLE_AMBIGUOUS (-3)
#define PUZZLE_ILLEGAL (-2)
#define PUZZLE_IGNORE (-1)
#define PUZZLE_MOVED 0
#define PUZZLE_CONTROL 1
#define PUZZLE_SOLVED 2
#define PUZZLE_PRACTICE 3
#define PUZZLE_RANDOMIZE 4
#define PUZZLE_DEC 5
#define PUZZLE_ORIENTIZE 6
#define PUZZLE_INC 7
#define PUZZLE_PERIOD3 8
#define PUZZLE_PERIOD4 9
#define PUZZLE_BOTH 10
#define PUZZLE_STICKY 11
#define PUZZLE_COMPUTED 12
#define PUZZLE_UNDO 13
#define PUZZLE_REDO 14

#define MENU_GET 0
#define MENU_WRITE 1
#define MENU_EXIT 2
#define MENU_UNDO 3
#define MENU_REDO 4
#define MENU_CLEAR 5
#define MENU_RANDOMIZE 6
#define MENU_PRACTICE 7
#define MENU_SOLVE 8
#define MENU_ORIENTIZE 9
#define MENU_STICKY 10
#define MENU_INCREMENT 11
#define MENU_DECREMENT 12

#define MINFACETS 1
#define PERIOD3 3
#define PERIOD4 4
#define BOTH 5
#define MAXMODES 3
#define DEFAULTMODE PERIOD4
#define DEFAULTFACETS 3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#define DEFAULTSTICKY FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _OctRec *OctWidget;

#endif /* _XtOct_h */
/* DON'T ADD STUFF AFTER THIS #endif */
