/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * main.c
 *
 * xqbiff ᥤ롼
 *
 */

#include"xqb.h"
#include"mail.h"
#include"list.h"
#include"img.h"
#include<sys/wait.h>
#include<X11/cursorfont.h>

#include<X11/extensions/shape.h>
#ifdef HAVE_IMLIB_H
#include<Imlib.h>
#endif

/*
#define DEBUG_SEARCH
*/
Display *d = NULL;
Window m_wnd = 0;                /* Main window                  */
Window d_wnd = 0;                /* Dialog window                */
Window r_wnd = 0;                /* Root window                  */
Window l_wnd = 0;                /* Mail list window             */
Window p_wnd = 0;                /* New mail popup window        */
Window c_wnd = 0;                /* Chip window                  */
Window w_wnd = 0;                /* Warning message window       */

GC m_gc;                     /* Main window's GC             */
GC d_gc;                     /* Popup window's GC            */
GC l_gc;
GC p_gc;
GC c_gc;
GC w_gc;
XGCValues gcval;

Pixmap lpmap = 0;
Pixmap ppmap = 0;
Pixmap cpmap = 0;
Pixmap wpmap = 0;


Colormap     cmap;
int          depth;
int          screen_num;
Visual      *vis;
iFontSet     ifs;

XVisualInfo *vlist = NULL;
Pixel pixel_fg = 0, pixel_bg = 0;

MailInfo *mailinfo;             /* Mail information structure        */
Opinfo    opinfo;               /* Xqbiff's user option structure    */
iSize     display_size;         /* Display size                      */
int       font_h;               /* Fonts max height                  */
int       MAXDRAW;              /* List pixmap size                  */
int       ppid = 0;             /* Parent process ID                 */
int       cpid = 0;             /* Child process ID                  */
int       mpid = 0;             /* My process ID                     */
int       rcvsig = -1;
int       transcfg = 0;


struct {
    int red, green, blue;       /*                           */
} rgb;

struct {
    char title_light[32];
    char title_shadow[32];
    unsigned long tl, ts;
} color_info;                   /* ɲÿ                        */


#define KEEPTIME 300

extern int PopPasswdInput( Display *, Window, GC, Colormap, iFontSet*,
			   char*, char*, char*, char*, char*, int );
extern void GetWndSizePos(Display*,Window,XSizeHints*,XSizeHints*);
extern void MapWnd(Display*,Window,XSizeHints*);


/* ᡼륦ɥΥȥ */
/* 256 ʸ                   */
char *new1_message    = "᡼뤬Ϥޤ";
char *newn_message    = "᡼뤬 %d Ϥޤ";
char *titlen_message  = "%d̤Υ᡼뤬ޤ";
char *titlez_message  = "᡼Ϥޤ";

char *main_wnd_name  = "xqbiff";
char *list_wnd_name  = "xqbiff: ";
char *popup_wnd_name = "xqbiff: new mail";
char *dialog_wnd_name = "Dialog";
char *warning_wnd_name = "xqbiff: Warning!!";

MailInfo *mailinfo;      /* Mail information structure        */
MailInfo *newmailinfo;
#ifdef HAVE_IMLIB_H
ImlibData  *imlibdata;
#endif


#define XqbExit() ExitXqbiff(mcursor,lcursor,iminfo,ipmap,mpmap,lbgpmap,pbgpmap)


int dbg_mailcnt = 0;
int dbg_nmailcnt = 0;



/****************/
/* λϥɥ */
/****************/
void pExit()
{
#ifdef DEBUG
    fprintf( stderr, "pExit. ppid=%d cpid=%d mpid=%d\n",ppid,cpid,mpid );
#endif
    if( mpid == ppid ){
	/* Not create zombie process */
	kill( cpid, SIGKILL );
	waitpid( cpid, NULL, WNOHANG );
    } else if( mpid == cpid ){
	kill( ppid, SIGKILL );
	waitpid( ppid, NULL, WNOHANG );
    }
}


/*******************/
/* xqbiff λ */
/*******************/
void ExitXqbiff( Cursor mcursor, Cursor lcursor, Iminfo iminfo,
		 Pixmap **ipmap, Pixmap **mpmap,
		 Pixmap lbgpmap[], Pixmap pbgpmap[] )
{
    int i, j;

#ifdef DEBUG
    fprintf( stderr, "ExitXqbiff.\n" );
#endif

    if( mailinfo != NULL ){
	free( mailinfo );
idbgout(__func__,"Memory free mailinfo 1.");
    }
    if( newmailinfo != NULL ){
	free( newmailinfo );
idbgout(__func__,"Memory free newmailinfo 1.");
    }
    FreeBgPixmap( d, lbgpmap, TEXT_COLOR_INFO_MAX );
    FreeBgPixmap( d, pbgpmap, TEXT_COLOR_INFO_MAX );

    XUnmapWindow( d, p_wnd );
    XUnmapWindow( d, l_wnd );
    XUnmapWindow( d, m_wnd );
    XUnmapWindow( d, d_wnd );
    XUnmapWindow( d, c_wnd );
    XUnmapWindow( d, w_wnd );
    XSync( d, 0 );
    XFlush( d );
#ifdef DEBUG
    fprintf( stderr, "Memory Free.\n" );
#endif
    XFreeFont( d, ifs.ascii );
    XFreeFont( d, ifs.kanji );
    XFreeFont( d, ifs.jis );
    XFreeCursor( d, mcursor );
    XFreeCursor( d, lcursor );

    for( i=0 ; i<5 ; i++ ){
	if( iminfo.asp[i] != NULL )
	    free(iminfo.asp[i]);
    }

    for( i=0 ; i<5 ; i++ ){
	for( j=0 ; j<iminfo.pt[i] ; j++ ){
	    if( ipmap[i][j] != 0 )
		XFreePixmap( d, ipmap[i][j] );
	}
	if( ipmap[i] != NULL )
	    free(ipmap[i]);
    }

    if( mpmap[0] != NULL ){
	for( i=0 ; i<5 ; i++ ){
	    for( j=0 ; j<iminfo.pt[i] ; j++ ){
		if( mpmap[i][j] != 0 )
		    XFreePixmap( d, mpmap[i][j] );
	    }
	    if( mpmap[i] != NULL )
		free(mpmap[i]);
	}
    }

    if( lpmap != 0 ){
	XFreePixmap( d, lpmap );
#ifdef DEBUG
	fprintf( stderr, "..Free.L.Q.\n" );
#endif
    }
    if( ppmap != 0 ){
	XFreePixmap( d, ppmap );
#ifdef DEBUG
	fprintf( stderr, "..Free.P.Q.\n" );
#endif
    }
    if( cpmap != 0 ){
	XFreePixmap( d, cpmap );
#ifdef DEBUG
	fprintf( stderr, "..Free.C.Q.\n" );
#endif
    }
    if( wpmap != 0 ){
	XFreePixmap( d, wpmap );
#ifdef DEBUG
	fprintf( stderr, "..Free.W.Q.\n" );
#endif
    }
    XFreeGC( d, m_gc );
    XFreeGC( d, l_gc );
    XFreeGC( d, p_gc );
    XFreeGC( d, d_gc );
    XFreeGC( d, c_gc );
    XFreeGC( d, w_gc );

    XDestroyWindow( d, w_wnd );
    XDestroyWindow( d, c_wnd );
    XDestroyWindow( d, d_wnd );
    XDestroyWindow( d, p_wnd );
    XDestroyWindow( d, l_wnd );
    XDestroyWindow( d, m_wnd );

    XFlush(d);

    if( vlist != NULL ) XFree(vlist);

    XCloseDisplay( d );
#ifdef DEBUG
    fprintf( stderr, "..Done.\n" );
#endif
    exit(0);
}

/*********************************/
/* ޥɥ饤 '&'  */
/* դƤʤդ        */
/*********************************/
void add_and(char *comline)
{
    int i = strlen(comline);

    if( i > 0 ){
	i--;

	while( i>0 && (comline[i] == ' ' || comline[i] == '\t') ) i--;

	if( comline[i] != '&' ) strcat( comline, " &" );
    }
    return;
}


/*******************/
/* Signal ϥɥ */
/*******************/
void xqb_sighdr(int sig)
{
    rcvsig = sig;

    switch ( sig ){
    case SIGUSR1:
	SetSignalHandler( sig, xqb_sighdr );
#ifdef DEBUG_SIG
	printf("xqbiff: receive signal SIGUSR1(%d)\n",sig);
#endif
	break;
    case SIGCHLD:
#ifdef DEBUG_SIG
	printf("xqbiff: receive signal SIGCHLD(%d)\n",sig);
#endif
	if( 0 != waitpid( cpid, NULL, WNOHANG ) ){
	    printf("xqbiff: detect child process exit.\n");
	    rcvsig = sig;
	    exit(1);
	} else {
	    SetSignalHandler( sig, xqb_sighdr );
	}
	break;
    case SIGSEGV:
#ifdef DEBUG_SIG
	printf("xqbiff: receive signal SIGSEGV(%d)\n",sig);
#endif
	fprintf(stderr,"Segmentation fault\n");
	exit(1);
	break;
    default:
	printf("xqbiff: receive signal %d\n",sig);
	SetSignalHandler( sig, xqb_sighdr );
	break;
    }
}

/*************************/
/* xqbiff ǰʥ */
/*************************/
typedef struct __xqb_sig_tbl {
    int sigid;
    void (*handler)(int);
} xqbsigtbl_t;
xqbsigtbl_t XqbSigTable [] = {
    { SIGPIPE, SIG_IGN },
    { SIGCHLD, SIG_IGN },
/*    { SIGSEGV, xqb_sighdr }, */
    { SIGTERM, exit },
    { SIGUSR1, xqb_sighdr },
/*    { 16,      xqb_sighdr }, */
/*    { 30,      xqb_sighdr }, */
    { 0, 0 }          /* ơ֥ν {0,0} */
};


#define ShCmp(a,b)   ((a.x==b.x)&&(a.y==b.y)&&(a.width==b.width)&&(a.height==b.height))

void ShCpy(XSizeHints *dest,XSizeHints *src)
{
    dest->x      = src->x;
    dest->y      = src->y;
    dest->width  = src->width;
    dest->height = src->height;
}

void Sh2Sz(iSize *sz,XSizeHints *sh)
{
    sz->width  = sh->width;
    sz->height = sh->height;
}
void Sz2Sh(XSizeHints *sh,iSize *sz)
{
    sh->width  = sz->width;
    sh->height = sz->height;
}


/*********************/
/* main              */
/* xqbiff ᥤؿ */
/*********************/
int main( int argc, char *argv[] )
{
    int i;                       /*                          */

    int       pfd[2];            /* Pipe  from child to parent   */
    int       cfd[2];            /* Pipe  from parent to child   */

    int       fdmax;

    XEvent report, rep_trash;

    unsigned int acnt = 0;       /* ˥᡼󥫥       */
    double ncnt = 0.0;           /* åɽ֥   */
    int nmail = 0,               /* ᡼ο                   */
        nmail_old = 0;           /*                              */
    int state = -1;              /*  0=᡼̵ 1=᡼ */
    int next_state = -1;         /*      2=᡼ͭ 3=᡼ɲ */
    int newnmail = 0;

    Iminfo iminfo;               /*                      */
    int xst, yst;                /* λ                   */

    Pixmap *ipmap[5] = {0};      /* Υԥޥå           */
    Pixmap *mpmap[5] = {0};      /* ޥѥԥޥå         */

    char mes_title[256];         /* ᡼ꥹȥȥ         */
    char nmes_title[256];        /* ꥹȥȥ           */
    int mouse_x=0, mouse_y=0;    /* ޥưѤx,y        */

    double mouse_sp_per[5]       /* ȥޥ®   */
	= { 0.3, 0.7, 1.0, 2.0, 3.0 };


    Cursor mcursor, lcursor;     /*                      */

    char temp[1024];             /*                          */

    char defgeom[20];            /* ȥ˻       */
    int gravity;                 /* ȥ˻       */ 

    XSizeHints msh, dsh;         /* ɥΥҥ     */

    int nsbj=0;                  /* ꥹȤɽ               */


    int dfd;                     /* ǥץ쥤Υե뵭һ */
    fd_set rfds;                 /* 쥯ȤǻȤ餷         */
    struct timeval tv;           /* 쥯ȤΥॢȻ   */

    KeySym ikey;                 /* ϥ                     */
    XComposeStatus cs;

    double spl = 1.0;            /* ,ۥǤΥ®٤
				    ԥȤ                    */

    BOOL keep_flag = FALSE;      /* ³ɽ֤Υե饰           */

    BOOL Button1flag = FALSE;    /* ޥܥ֥ե饰         */
    BOOL Button2flag = FALSE;
    BOOL Button3flag = FALSE;

    int  Button1Time = 0;        /* ޥܥ󤬲줿     */
    int  Button2Time = 0;
    int  Button3Time = 0;

    char lwndname[1024];

    int  sb_flag = 0;
    int  selsts;

    /* ᡼ο       */
    TextInfo tinfo;

    /* ĶѿǼѥХåե */
    char env_buff1[32];
    char env_buff2[32];
    char env_buff3[32];
    char env_buff4[32];
    char env_buff5[256];

    BOOL chkflag = FALSE;

    /*
     * Warning message Window
     */
    XSizeHints wsh;
    BOOL     wflag  = FALSE;
    iSize    wpsize = { 0, 0 };


    /*
     * Chip Window
     */
    XSizeHints csh;
    BOOL   enterflag = FALSE;
    double entertime = -1;
    BOOL   chipflag = FALSE;
    int    cur_mouse_x, cur_mouse_y;


    /*
     * ̤ɥ᡼ꥹ
     */
    XSizeHints lsh, old_lsh;
    iSize      lwsize = { 0, 0 };     /* 륵           */
    iSize      lvsize = { 0, 0 };     /* ꥹΤΥ */
    Pixmap lbgpmap[TEXT_COLOR_INFO_MAX] = {0}; /* ط */
    BOOL lflag   = FALSE;        /* ꥹȥɥɽ
				    ޥå׻ؼФȤ TRUE */
    BOOL lmpflag = FALSE;        /* ꥹȥɥɽ
				    ºݤ˥ޥåפ줿Ȥ TRUE */
    GC     lpgc = 0;
    int y_locate = 0;            /* ꥹɽλ             */
    int y_locate_max = 0;
    BOOL lfflag    = TRUE;       /* ꥹȥɥե饰 */
    BOOL ltransflag = FALSE;


    /*
     * ᡼ꥹ
     */
    XSizeHints psh, old_psh, pdsh;
    iSize  pvsize = { 0, 0 };                  /* ꥹΤΥ */
    Pixmap pbgpmap[TEXT_COLOR_INFO_MAX] = {0}; /* ط */
    GC       ppgc = 0;
    BOOL pflag   = FALSE;        /* ݥåץåץɥΥե饰 */
    BOOL ptransflag = FALSE;



/**************************************************************************/

    ipmap[0] = NULL;
    mpmap[0] = NULL;

    /*********************************/
    /*                               */
    /* Option information Initialize */
    /*                               */
    /*********************************/
    opinfo.bd          = 3;                    /* ܡ            */
    opinfo.poll        = -1;                   /* ֳ֡á        */
    opinfo.sc_speed    = 3;                    /* ®        */
    opinfo.anim        = TRUE;                 /* ˥᡼̵ͭ  */
    opinfo.scroll      = FALSE;                /*         */
    opinfo.mmax        = 10;                   /* ֥ɽ    */
    opinfo.sort        = 0;                    /* ̵            */
    opinfo.beep        = FALSE;                /* BEEP                */
    opinfo.length      = 256;                  /* Ԥκɽʸ  */
    opinfo.mode        = 0;                    /* 0:Maildir  1:Mailbox  */
                                               /* 2:Pop                 */
    opinfo.nopopup     = FALSE;
    opinfo.shape       = FALSE;

    opinfo.retry       = 10;                   /* ԻκƻԿ */

    strcpy( opinfo.display, "" );              /* ǥץ쥤          */
    strcpy( opinfo.bg, "#CCCCCC" );
    strcpy( opinfo.fg, "black" );
    strcpy( opinfo.m_geom, "" );               /* ȥ        */
    strcpy( opinfo.p_geom, "" );               /* ȥ        */
    opinfo.p_geom_flag = FALSE;
    opinfo.nopopup = FALSE;
    opinfo.com2[0] = '\0';                     /* ޥ              */
    opinfo.com3[0] = '\0';
    strcpy( opinfo.maildir, "~/Maildir/new" ); /* ǥ쥯ȥ      */
    strcpy( opinfo.poprc, "~/.xqbiff-poprc" ); /* Popե     */
    strcpy( opinfo.image, "none" );            /* ᡼ե      */
    strcpy( opinfo.fe, "7x14" );               /* ѻե          */
    strcpy( opinfo.fk, "7x14" );               /* ̾ե          */
    strcpy( opinfo.fj, "k14" );                /* ܸե        */

    if( NULL != getenv("MAIL") ){              /* Mailbox               */
	sprintf( opinfo.mailbox, "%s", getenv("MAIL") );
    } else {
	sprintf( opinfo.mailbox, "/var/spool/mail/%s", getenv("USER") );
    }

    opinfo.nocapt = TRUE;
    strcpy( opinfo.rcfile, "" );
    opinfo.flat_face = TRUE;
    strcpy( opinfo.label, "" );
    opinfo.p_time = 10;

    /************************/
    /*                      */
    /*    ν    */
    /*                      */
    /************************/
    strcpy( tinfo.headerfg, "Black" );
    strcpy( tinfo.headerbg, "White" );
    tinfo.headerbold = FALSE;
    tinfo.hdfgc = 0;
    tinfo.hdbgc = 0;
    for( i=0 ; i<TEXT_COLOR_INFO_MAX ; i++ ){
	strcpy( tinfo.tinf[i].fromkey, "" );
	strcpy( tinfo.tinf[i].subjkey, "" );

	strcpy( tinfo.tinf[i].command, "" );
	tinfo.tinf[i].run_others = FALSE;

	strcpy( tinfo.tinf[i].bgpname, "" );
	strcpy( tinfo.tinf[i].bgcname, "" );

	strcpy( tinfo.tinf[i].fromt, "Black" );
	strcpy( tinfo.tinf[i].fromn, "Black" );
	strcpy( tinfo.tinf[i].subjt, "Black" );
	strcpy( tinfo.tinf[i].subjn, "Black" );
	strcpy( tinfo.tinf[i].daten, "Black" );
	strcpy( tinfo.tinf[i].numb, "Black" );

	tinfo.tinf[i].fromtbold = FALSE;
	tinfo.tinf[i].fromnbold = FALSE;
	tinfo.tinf[i].subjtbold = FALSE;
	tinfo.tinf[i].subjnbold = FALSE;
	tinfo.tinf[i].datenbold = FALSE;
	tinfo.tinf[i].numbbold  = FALSE;

	tinfo.tinf[i].bgp      = 0;
	tinfo.tinf[i].bgp_w    = 0;
	tinfo.tinf[i].bgp_h    = 0;
	tinfo.tinf[i].bgp_cont = 100;
	tinfo.tinf[i].bgp_brt  = 100;
	
	tinfo.tinf[i].bgc    = 0;
	tinfo.tinf[i].fromtc = 0;
	tinfo.tinf[i].fromnc = 0;
	tinfo.tinf[i].subjtc = 0;
	tinfo.tinf[i].subjnc = 0;
	tinfo.tinf[i].datenc = 0;
	tinfo.tinf[i].numbc  = 0;
    }


    /**************************/
    /*                        */
    /*    ν    */
    /*                        */
    /**************************/
    iminfo.width   = 192;
    iminfo.height  = 192;
    iminfo.pwidth  = 48;
    iminfo.pheight = 48;
    iminfo.ptn     = 4;
    iminfo.asp[0]  = NULL;
    iminfo.asp[1]  = NULL;
    iminfo.asp[2]  = NULL;
    iminfo.asp[3]  = NULL;
    iminfo.asp[4]  = NULL;
    iminfo.pt[0]   = 1;
    iminfo.pt[1]   = 4;
    iminfo.pt[2]   = 4;
    iminfo.pt[3]   = 4;
    iminfo.pt[4]   = 0;


/**************************************************************************/

    /* Get process ID */
    ppid = getpid();
    mpid = ppid;

    /* Get display option */
    for( i=1 ; i<argc ; ++i ){
	if( 0==strcmp( argv[i], "-d" ) || 0==strcmp( argv[i], "--display" ) ){
	    strcpy( opinfo.display, argv[i+1] );
	} else if( 0==strcmp( argv[i], "-h" ) 
		   || 0==strcmp( argv[i], "--help" ) ){
	    OpVerOut();
	    OpHelpOut();
	}  else if( 0==strcmp( argv[i], "-v" ) 
		    || 0==strcmp( argv[i], "--version" ) ){
	    OpVerOut();
	    exit(0);
	}  else if( 0==strcmp( argv[i], "-info" ) ){
	    OpInfoOut();
	    exit(0);
	}
    }

    /* Set locale from environment variable */
    setlocale( LC_ALL, "" );

#if 0
    {
	struct rlimit r_limit;

	r_limit.rlim_cur = 64*1024*1024;
	r_limit.rlim_max = 512*1024*1024;

	setrlimit(RLIMIT_CORE,&r_limit);
    }
#endif

    /* Connection to display for GetResource */
    if( (d = XOpenDisplay( opinfo.display )) == NULL ){
	fprintf( stderr, "Cannot connect to X server.\n" );
	return 0;
    }

    /* Get information from resource */
    GetResource( d, "xqbiff", &tinfo, NULL );

    /* Get information from command line */
    GetOpinfo( argc, argv, &tinfo );


    if( 0 != strcmp(opinfo.rcfile,"") ){
	GetResource( d, "xqbiff", &tinfo, opinfo.rcfile );
	GetOpinfo( argc, argv, &tinfo );
    }

    /* Check support locale */
    if( XSupportsLocale() == False ){
	fprintf( stderr, "XSupportsLocale() return false.\n" );
	exit(1);
    }

    /* Command is run background */
    add_and( opinfo.com2 );
    add_and( opinfo.com3 );


    /* ֳ֤桼ꤵƤʤСǥեͤȤ */
    if( opinfo.poll == -1 ){
	switch(opinfo.mode){
	case XQB_MODE_DIR:
	case XQB_MODE_BOX:
	    opinfo.poll = 5;
	    break;
	case XQB_MODE_POP:
	    opinfo.poll = 300;
	    break;
	default:
	    fprintf(stderr,"mode error.(%d)\n",opinfo.mode);
	    break;
	}
    }


    for( i=0 ; i<TEXT_COLOR_INFO_MAX ; i++ ){
	if( tinfo.tinf[i].bgpname[0]=='\0' &&
	    tinfo.tinf[i].bgcname[0]=='\0' ){
	    strcpy( tinfo.tinf[i].bgcname, "white" );
	}
    }

#ifdef HAVE_IMLIB_H
    /* Imlib бƤߤޤ礫 */
    imlibdata = Imlib_init( d );
#endif

    /* Load image */
    if( 0 != strcasecmp( opinfo.image, "none" ) ){

	/* Create image file name */
	iFilefullnameCreate( opinfo.image, opinfo.image );

#ifdef DEBUG
	fprintf( stderr, "Imagefilename: %s\n", opinfo.image );
#endif

	/* Check image file */
#ifdef DEBUG
	fprintf( stderr, "Checking image file.\n" );
#endif
	if( -1 == iAccess( opinfo.image, I_F_OK ) ){
	    fprintf( stderr, "Not find image file: '%s'\n", opinfo.image );
	    exit(1);
	}
#ifdef DEBUG
	fprintf( stderr, "..Ok.\n" );
#endif
	strcpy( iminfo.imname, opinfo.image );

	/* Get animation information */
#ifdef DEBUG
	fprintf( stderr, "Get image information.\n" );
#endif

	if( FALSE == GetIminfo( &iminfo ) ){
	    fprintf( stderr, "Can't get image information. %s\n",
		     iminfo.imname );
	    exit(1);
	}

#ifdef DEBUG
	fprintf( stderr, "PSize(%dx%d)\n", iminfo.pwidth, iminfo.pheight );
#endif
	for( i=0 ; i<iminfo.ptn ; i++ ){
	    if( iminfo.pt[i] == 1 ){
		iminfo.asp[i][0] = 0.2;
	    }
#ifdef DEBUG
	    fprintf( stderr, "Pattern%d: %d ", i, iminfo.pt[i] );
	    {
		int j;
		for( j=0 ; j<iminfo.pt[i] ; j++ ){
		    fprintf( stderr, "%4.2f ", iminfo.asp[i][j] );
		}
	    }
	    fprintf( stderr, "\n" );
#endif
	}

#ifdef DEBUG
	fprintf( stderr, "..Ok." );
#endif
    }


    /* Get depth, screen and display size */
    screen_num = DefaultScreen( d );
    DW         = DisplayWidth( d, screen_num );
    DH         = DisplayHeight( d, screen_num );
    r_wnd      = RootWindow( d, screen_num );




    /* Get geometry information of main window */
#ifdef DEBUG
    fprintf( stderr, "Get main geometry.\n" );
#endif
    msh.flags      = (PPosition | PSize | PMaxSize );
    msh.width      = iMax( MINSIZE, iminfo.pwidth );
    msh.height     = iMax( MINSIZE, iminfo.pheight );
    msh.x          = 0;
    msh.y          = 0;
    msh.max_width  = DW;
    msh.max_height = DH;
    lsh = msh;
    if( 0 != strcmp( opinfo.m_geom, "" ) ){
	msh.flags = (USPosition | USSize | PMaxSize );
	sprintf( defgeom, "%dx%d+0+0", iminfo.pwidth, iminfo.pheight );
	XWMGeometry( d, screen_num, opinfo.m_geom, defgeom, opinfo.bd,
		     &lsh, &(msh.x), &(msh.y), &(msh.width), &(msh.height),
		     &gravity );
    }

    if( opinfo.shape == FALSE ){
	msh.width      = iMax( MINSIZE, msh.width );
	msh.height     = iMax( MINSIZE, msh.height );
    } else {
	msh.width      = iminfo.pwidth;
	msh.height     = iminfo.pheight;
	opinfo.bd      = 0;
    }
#ifdef DEBUG
    fprintf( stderr, "..Ok.\n" );
#endif

    /* Get geometry information of list window */
    lsh.flags      = (PPosition | PSize | PMaxSize );
    lsh.width      = msh.width;
    lsh.height     = msh.height;
    lsh.x          = msh.x;
    lsh.y          = msh.y;
    lsh.max_width  = DW;
    lsh.max_height = DH;


    /* Get geometry information of popup window */
#ifdef DEBUG
    fprintf( stderr, "Get popup geometry.\n" );
#endif
    pdsh.flags      = (PPosition | PSize | PMaxSize );
    pdsh.width      = iMax( MINSIZE, iminfo.pwidth );
    pdsh.height     = iMax( MINSIZE, iminfo.pheight );
    pdsh.x          = 0;
    pdsh.y          = msh.y;
    pdsh.max_width   = DW;
    pdsh.max_height  = DH;
    if( 0 != strcmp( opinfo.p_geom, "" ) ){
	pdsh.flags      = (USPosition | PSize | PMaxSize );
	sprintf( defgeom, "10x10+0+0" );
	XWMGeometry( d, screen_num, opinfo.p_geom, defgeom, opinfo.bd,
		     &pdsh,&(pdsh.x),&(pdsh.y),&(pdsh.width),&(pdsh.height),
		     &gravity );
    }
    pdsh.width      = iMax( MINSIZE, pdsh.width );
    pdsh.height     = iMax( MINSIZE, pdsh.height );

    psh = pdsh;


    /* Get geometry information of dialog window */
    dsh.flags      = (PPosition | PSize | PMaxSize );
    dsh.width      = msh.width;
    dsh.height     = msh.height;
    dsh.x          = msh.x;
    dsh.y          = msh.y;
    dsh.max_width  = DW;
    dsh.max_height = DH;

#ifdef DEBUG
    fprintf( stderr, "..Ok.\n" );
#endif

#ifdef DEBUG
    fprintf( stderr, "Creating windows.\n" );
#endif
    /* Get visual info */
    /* and create main windows and set information */
    {
	XVisualInfo *vtmp;
	XVisualInfo tvinfo;
	int num_vis = 0, num_dps, r_dp;
	int *dpl = XListDepths( d, screen_num, &num_dps );
	Atom at1, at2;
	XTextProperty tp_wndname, tp_icnname;
	int dtmp = 0, nvtmp;

	char *iconname = "xqbiff";
	char *lwndtmp  = lwndname;

	XWMHints   mwmh;             /* ɥWMҥ         */
	XClassHint mch;              /* ɥClassҥ      */

	XSetWindowAttributes xsa;    /* °                   */
	unsigned long        xsa_mask;
	XWindowAttributes xwa;


	XGetWindowAttributes( d, r_wnd, &xwa );
	vis   = xwa.visual;
	depth = xwa.depth;
	cmap  = xwa.colormap;

#if 0
	r_dp = xwa.depth;

printf("root depth=%d\n",r_dp);

	for( i=0; i<num_dps ; i++ ){

	    if( dtmp < dpl[i] ){
		tvinfo.depth  = dpl[i];
		tvinfo.screen = screen_num;
    
		vtmp = XGetVisualInfo(d, VisualDepthMask | VisualScreenMask,
				      &tvinfo, &nvtmp);

#ifdef DEBUG
		fprintf( stderr, "depth: %d num: %d\n", dpl[i], nvtmp );
#endif
		if( nvtmp != 0 ){
		    if( vlist != NULL ) XFree(vlist);

		    vlist = vtmp;
		    dtmp = dpl[i];
		    num_vis = nvtmp;
		}
	    }
	}

	XFree(dpl);

	if( num_vis == 0 ){
	    fprintf( stderr, "Can't get visual info.\n" );
	    return 0;
	}

	depth = vlist[0].depth;

	if( depth <= 8 ){
            vis  = vlist[0].visual;
	    cmap = DefaultColormap( d, screen_num );
	} else {
	     vis  = vlist[0].visual;
	     cmap = XCreateColormap( d, r_wnd, vlist[0].visual, AllocNone );
	}
#endif


#ifdef DEBUG
	fprintf( stderr, "Get visual Ok. Depth=%d\n", depth );
#endif

	pixel_bg = iNametoPixel( d, cmap, opinfo.bg );
	pixel_fg = iNametoPixel( d, cmap, opinfo.fg );



	xsa.save_under        = True;
	xsa.backing_store     = Always;
	xsa.background_pixel  = pixel_bg;
	xsa.border_pixel      = pixel_bg;
	xsa.colormap          = cmap;
	xsa_mask              = CWBackingStore | CWSaveUnder
	    | CWBorderPixel | CWColormap | CWBackPixel;
/* test
   xsa.override_redirect = True;
   xsa_mask              |= CWOverrideRedirect;
*/
	m_wnd = XCreateWindow( d, r_wnd,
			       msh.x, msh.y, msh.width,msh.height,
			       opinfo.bd, depth, InputOutput,
			       vis, xsa_mask, &xsa );

	XSetWindowBorderWidth( d, m_wnd, opinfo.bd );

	xst = (msh.width/2)-(iminfo.pwidth/2);
	yst = (msh.height/2)-(iminfo.pheight/2);


	/* WM Hints  */
	mwmh.initial_state = NormalState;
	mwmh.input         = True;
	mwmh.icon_pixmap   = 0; 
	mwmh.flags = StateHint | IconPositionHint| IconPixmapHint | InputHint;

	/* Class Hint */
	mch.res_class= "XQbiff";
	mch.res_name = "xqbiff";

	XStringListToTextProperty( &main_wnd_name, 1, &tp_wndname );
	XStringListToTextProperty( &iconname, 1, &tp_icnname );

	XSetWMNormalHints( d, m_wnd, &msh );

	XSetWMProperties(d, m_wnd, &tp_wndname, &tp_icnname,
			 argv, argc, &msh, &mwmh, &mch);

	/* Get Client message */
	at1 = XInternAtom( d, "WM_PROTOCOLS", False );
	at2 = XInternAtom( d, "WM_DELETE_WINDOW", False );
	XSetWMProtocols( d, m_wnd, &at2, 1 );


	/*
	 * Create list windows and set information
	 */
	xsa.save_under        = True;
	xsa.backing_store     = Always;
	xsa.background_pixmap = ParentRelative;
	xsa.border_pixel      = pixel_bg;
	xsa.colormap          = cmap;
	xsa_mask              = CWBackingStore | CWSaveUnder
	    | CWBorderPixel | CWColormap | CWBackPixmap;
	l_wnd = XCreateWindow( d, r_wnd,
			       lsh.x, lsh.y, lsh.width, lsh.height,
			       opinfo.bd, depth, InputOutput,
			       vis, xsa_mask, &xsa );

	XSetWindowBorderWidth( d, m_wnd, opinfo.bd );

	XSetTransientForHint( d, l_wnd, m_wnd );

	sprintf( lwndname, "xqbiff" );
	XStringListToTextProperty( &lwndtmp, 1, &tp_wndname );

	mch.res_name = "xqbiff";
	mch.res_class= "XQbiff-L";
	XSetWMProperties(d, l_wnd, &tp_wndname, NULL,
			 argv, 0, &lsh, &mwmh, &mch);
	XSetWMProtocols( d, l_wnd, &at2, 1 );


	/*
	 * Create popup windows and set information
	 */
	p_wnd = XCreateWindow( d, r_wnd,
			       pdsh.x, pdsh.y, pdsh.width, pdsh.height,
			       opinfo.bd, depth, InputOutput,
			       vis, xsa_mask, &xsa );

	XSetWindowBorderWidth( d, p_wnd, opinfo.bd );

	XSetTransientForHint( d, p_wnd, m_wnd );

	XStringListToTextProperty( &popup_wnd_name, 1, &tp_wndname );

	mch.res_name = "xqbiff";
	mch.res_class= "XQbiff-P ";

	XSetWMNormalHints( d, p_wnd, &pdsh );

	XSetWMProperties(d, p_wnd, &tp_wndname, NULL, argv, 0,
			 &pdsh, &mwmh, &mch);
	XSetWMProtocols( d, p_wnd, &at2, 1 );


	/*
	 * Create dialog windows and set information
	 */
	xsa.background_pixel  = pixel_bg;
	xsa.colormap          = cmap;
	xsa_mask              = CWBackPixel | CWColormap;

	d_wnd = XCreateWindow( d, r_wnd,
			       dsh.x, dsh.y, dsh.width, dsh.height,
			       opinfo.bd, depth, InputOutput,
			       vis, xsa_mask, &xsa );

	XSetWindowBorderWidth( d, d_wnd, opinfo.bd );

	XStringListToTextProperty( &dialog_wnd_name, 1, &tp_wndname );

	mch.res_name = "xqbiff-dialog";
	mch.res_class= "XQbiff-Dilaog ";

	XSetWMNormalHints( d, d_wnd, &pdsh );

	XSetWMProperties(d, d_wnd, &tp_wndname, NULL, argv, 0,
			 &dsh, &mwmh, &mch);
	XSetWMProtocols( d, d_wnd, &at2, 1 );


	/*
	 * Create chip windows and set information
	 */

	xsa.save_under        = False;
	xsa.backing_store     = NotUseful;
	xsa.background_pixel  = pixel_bg;
	xsa.border_pixel      = pixel_bg;
	xsa.colormap          = cmap;
	xsa_mask              = CWBackingStore | CWSaveUnder
	    | CWBackPixel | CWBorderPixel | CWColormap;
	xsa.override_redirect = True;
	xsa_mask              |= CWOverrideRedirect;

	csh = msh;

	c_wnd = XCreateWindow( d, r_wnd,
			       csh.x, csh.y, csh.width, csh.height,
			       0, depth, InputOutput,
			       vis, xsa_mask, &xsa );

	XSetWindowBorderWidth( d, c_wnd, 0 );

	XSetTransientForHint( d, c_wnd, m_wnd );

	XStringListToTextProperty( &popup_wnd_name, 1, &tp_wndname );

	mch.res_name = "xqbiff";
	mch.res_class= "XQbiff-C ";

	XSetWMNormalHints( d, c_wnd, &pdsh );

	XSetWMProperties(d, c_wnd, &tp_wndname, NULL, argv, 0,
			 &csh, &mwmh, &mch);
	XSetWMProtocols( d, c_wnd, &at2, 1 );



	/*
	 * Create warning message windows and set information
	 */


	xsa.save_under        = False;
	xsa.backing_store     = NotUseful;
	xsa.background_pixel  = pixel_bg;
	xsa.border_pixel      = pixel_bg;
	xsa.colormap          = cmap;
	xsa_mask              = CWBackingStore | CWSaveUnder
	    | CWBackPixel | CWBorderPixel | CWColormap;
	xsa.override_redirect = False;
	xsa_mask              &= ~CWOverrideRedirect;

	wsh = msh;

	w_wnd = XCreateWindow( d, r_wnd,
			       wsh.x, wsh.y, wsh.width, wsh.height,
			       0, depth, InputOutput,
			       vis, xsa_mask, &xsa );

	XSetWindowBorderWidth( d, w_wnd, 0 );

	XSetTransientForHint( d, w_wnd, m_wnd );

	XStringListToTextProperty( &warning_wnd_name, 1, &tp_wndname );

	mch.res_name = "xqbiff";
	mch.res_class= "XQbiff-W ";

	XSetWMNormalHints( d, w_wnd, &pdsh );

	XSetWMProperties(d, w_wnd, &tp_wndname, NULL, argv, 0,
			 &wsh, &mwmh, &mch);
	XSetWMProtocols( d, w_wnd, &at2, 1 );


#ifdef DEBUG
	fprintf( stderr, "..Ok.\n" );
#endif

	XFlush( d );
    }

    /* Initialize mail colors */
    InitColorInfo( d, cmap, &tinfo );

    /* Create mouse pointer */
#ifdef DEBUG
    fprintf( stderr, "Creating cursors.\n" );
#endif
    if( opinfo.scroll )
	lcursor = XCreateFontCursor( d, XC_dot );
    else
	lcursor = XCreateFontCursor( d, XC_sb_v_double_arrow );

    mcursor = XCreateFontCursor( d, XC_top_left_arrow );
#ifdef DEBUG
    fprintf( stderr, "..Ok.\n" );
#endif


     /*
      *
      * Create image pixmap.
      *
      */
     CreateAnimPixmap( d, m_wnd, r_wnd, vis, cmap, depth, screen_num,
		       ipmap, mpmap, &iminfo );


     /* Create GC */
     gcval.graphics_exposures = False;
     gcval.function           = GXcopy;

     m_gc = XCreateGC( d, m_wnd, GCFunction | GCGraphicsExposures, &gcval );
     l_gc = XCreateGC( d, l_wnd, 0, 0 );
     p_gc = XCreateGC( d, p_wnd, 0, 0 );
     d_gc = XCreateGC( d, d_wnd, 0, 0 );
     c_gc = XCreateGC( d, c_wnd, 0, 0 );
     w_gc = XCreateGC( d, w_wnd, 0, 0 );

     /* Set fonts color */
     XSetForeground( d, l_gc, pixel_fg );



     /* Fonts check */
 #ifdef DEBUG
     fprintf( stderr, "Loading Fonts." );
 #endif
     XListFonts( d, opinfo.fe, 2, &i );
     if( i == 0 ){
	 fprintf( stderr, "Not found font: '%s'\n", opinfo.fe );
	 exit(1);
     }
     XListFonts( d, opinfo.fk, 2, &i );
     if( i == 0 ){
	 fprintf( stderr, "Not found font: '%s'\n", opinfo.fk );
	 exit(1);
     }
     XListFonts( d, opinfo.fj, 2, &i );
     if( i == 0 ){
	 fprintf( stderr, "Not found font: '%s'\n", opinfo.fj );
	 exit(1);
     }

     ifs.ascii = XLoadQueryFont( d, opinfo.fe );
     ifs.kanji = XLoadQueryFont( d, opinfo.fk );
     ifs.jis   = XLoadQueryFont( d, opinfo.fj );

     if( ifs.ascii == NULL || ifs.kanji == NULL || ifs.jis == NULL ){
	 fprintf( stderr, "Can't load font.\n" );
	 exit(1);
     }

 #ifdef DEBUG
     fprintf( stderr, "..Ok." );
 #endif

     /* Get font max height */
     font_h = iMax( (ifs.ascii->ascent + ifs.ascii->descent),
		    (ifs.jis->ascent + ifs.jis->descent) );
     font_h = iMax( font_h, (ifs.kanji->ascent + ifs.kanji->descent) );


     /* Set event mask */
 #ifdef DEBUG
     fprintf( stderr, "Set event mask." );
 #endif
     if( opinfo.shape == TRUE && opinfo.anim == TRUE )
	 XSelectInput( d, m_wnd, ButtonPressMask | ButtonReleaseMask |
		       StructureNotifyMask | SubstructureNotifyMask |
		       PointerMotionMask | ExposureMask |
		       KeyPressMask | EnterWindowMask | LeaveWindowMask );
     else
	 XSelectInput( d, m_wnd, ButtonPressMask | ButtonReleaseMask |
		       StructureNotifyMask | SubstructureNotifyMask | 
		       PointerMotionMask | ExposureMask |
		       ExposureMask | KeyPressMask |
		       EnterWindowMask | LeaveWindowMask );


     XSelectInput( d, l_wnd, ButtonPressMask | ButtonReleaseMask |
		   ExposureMask | StructureNotifyMask | ButtonMotionMask |
		   KeyPressMask );
     XSelectInput( d, p_wnd, ButtonPressMask | ButtonReleaseMask |
		   ExposureMask | StructureNotifyMask | PointerMotionMask |
		   KeyPressMask );

     XSelectInput( d, d_wnd, ButtonPressMask | ButtonReleaseMask |
		   ExposureMask | StructureNotifyMask | PointerMotionMask |
		   KeyPressMask | EnterWindowMask | LeaveWindowMask );

     XSelectInput( d, c_wnd, ButtonPressMask | ButtonReleaseMask |
		   ExposureMask | StructureNotifyMask | PointerMotionMask |
		   KeyPressMask | EnterWindowMask | LeaveWindowMask );

     XSelectInput( d, w_wnd, ButtonPressMask | ButtonReleaseMask |
		   ExposureMask | StructureNotifyMask | KeyPressMask );


#ifdef DEBUG
     fprintf( stderr, "..Ok." );
#endif

     /* Set list draw size */
     opinfo.mmax = iMin( opinfo.mmax, (DH-LINE_H-20)/(LINE_H*3) );


     /* Create and check path name */
     switch( opinfo.mode ){
     case XQB_MODE_DIR:

#ifdef DEBUG
	 fprintf( stderr, "Creating path name.\n" );
#endif
	 iFilefullnameCreate( opinfo.maildir, opinfo.maildir );
#ifdef DEBUG
	 fprintf( stderr, "..Ok.\n" );
	 fprintf( stderr, "Maildirname: %s\n", opinfo.maildir );
#endif
	 if( -1 == iAccess( opinfo.maildir, I_P_OK ) ){
	     fprintf( stderr, "Not found maildir: '%s'\n", opinfo.maildir );
	     return(0);
	 }
	 if( -1 == iAccess( opinfo.maildir, I_R_OK ) ){
	     fprintf( stderr, "Can't read maildir: '%s'\n", opinfo.maildir );
	     fprintf( stderr, "Permission denied.\n" );
	     return(0);
	 }
	 if( -1 == iAccess( opinfo.maildir, I_D_OK ) ){
	     fprintf( stderr, "Not found maildir: '%s'\n", opinfo.maildir );
	     return(0);
	 }
	 break;

     case XQB_MODE_BOX:
#ifdef DEBUG
	 fprintf( stderr, "Creating path name.\n" );
#endif
	 iFilefullnameCreate( opinfo.mailbox, opinfo.mailbox );
#ifdef DEBUG
	 fprintf( stderr, "..Ok.\n" );
	 fprintf( stderr, "Mailboxname: %s\n", opinfo.mailbox );
#endif
	 if( -1 == iAccess( opinfo.mailbox, I_F_OK ) ){
	     fprintf( stderr, "Not found mailbox: '%s'\n", opinfo.mailbox );
	     return(0);
	 }
	 if( -1 == iAccess( opinfo.mailbox, I_R_OK ) ){
	     fprintf( stderr, "Can't read mailbox: '%s'\n", opinfo.mailbox );
	     fprintf( stderr, "Permission denied.\n" );
	     return(0);
	 }
	 break;

     case XQB_MODE_POP:
     {
	 int ret = -100, fc = -1;

#ifdef DEBUG
	 fprintf( stderr, "Creating path name.\n" );
#endif
	 iFilefullnameCreate( opinfo.poprc, opinfo.poprc );
#ifdef DEBUG
	 fprintf( stderr, "..Ok.\n" );
	 fprintf( stderr, "Pop resource file name: %s\n", opinfo.poprc );
#endif

	 /* Get information for Connect to POP server from file. */
	 if( -1 != iAccess( opinfo.poprc, I_F_OK ) &&
	     -1 != iAccess( opinfo.poprc, I_R_OK ) ){
	     GetPopInfo();
	 }

#ifdef DEBUG
	 fprintf( stderr, "Mode: %s.\n", popinfo.mode );
	 fprintf( stderr, "Server: %s.\n", popinfo.server );
	 fprintf( stderr, "Account: %s.\n", popinfo.user );
	 fprintf( stderr, "Password: %s.\n", popinfo.passwd );
#endif

	 /* Test POP connection */
	 while( popinfo.server[0] == '\0' || popinfo.user[0] == '\0' ||
		popinfo.passwd[0] == '\0' || 0 >= (ret = CheckPopConnect()) ){
	     char label[256];

	     if( ret == -100 ){
		 strcpy( label, "POP ФξϤƲ" );
		 fc = -1;
	     } else if( ret == -2 ){
		 strcpy( label, "POP Ф˥Ǥޤ" );
		 fc = 3;
	     } else if( ret == -1 ){
		 strcpy( label, "POP Ф³Ǥޤ" );
		 fc = 0;
	     } else if( ret == 0 ){
		 strcpy( label, "POP Ф˥Ǥޤ" );
		 fc = 2;
	     }

	     if( 0 == PopPasswdInput( d, d_wnd, d_gc, cmap, &ifs,
				      popinfo.server, popinfo.user,
				      popinfo.passwd, popinfo.mode,
				      label, fc ) ){
		 XqbExit();
	     }
	     ret = -100;
	 }

	 if( 0 != strcasecmp( popinfo.mode, "POP" ) &&
	     0 != strcasecmp( popinfo.mode, "APOP" ) ){
	     if( apop == TRUE ){
		 fprintf( stderr, "xqbiff: Connect APOP mode.\n" );
	     } else {
		 fprintf( stderr, "xqbiff: Connect POP mode.\n" );
	     }
	 }
     }
     break;

     default:
	 fprintf( stderr, "xqbiff mode error! %d\n", opinfo.mode );
	 return(0);
     }
#ifdef DEBUG
     fprintf( stderr, "Create and check path name...Ok.\n" );
#endif



     /* Open pipe that data receive from child process */
     if( 0 != pipe(pfd) ){
	 fprintf( stderr, "Error: Can't create pipe.\n" );
	 exit(2);
     }
     /* Open pipe that data send to child process */
     if( 0 != pipe(cfd) ){
	 fprintf( stderr, "Error: Can't create pipe.\n" );
	 exit(2);
     }

     /*
      * Set signal handler
      */
     for( i=0 ; (XqbSigTable[i].sigid!=0 || XqbSigTable[i].handler!=0) ; i++ ){
	 SetSignalHandler( XqbSigTable[i].sigid, XqbSigTable[i].handler );
     }
     SignalBlock( SIGUSR1 );


     /* Reset signal handler for parent process */
     SetSignalHandler( SIGCHLD, xqb_sighdr );
     atexit( &pExit );


     /*
      *
      * Create child process
      *
      */
#ifdef DEBUG
     fprintf( stderr, "Create child process.\n" );
#endif
     if( 0 == (cpid = fork())){
	 /* Close unneedful file descriptor */
	 close(pfd[0]);
	 close(cfd[1]);

	 /* Get child process ID */
	 cpid = getpid();
	 mpid = cpid;

	 /* Set signal handler */
	 for( i=0 ; (XqbSigTable[i].sigid != 0 || XqbSigTable[i].handler != 0) ; i++ ){
	     SetSignalHandler( XqbSigTable[i].sigid, XqbSigTable[i].handler );
	 }
	 SignalBlock( SIGUSR1 );


	 /*
	  * Start search main 
	  */
	 SearchMail( pfd[1], cfd[0], opinfo.poll );

	 exit(3);
     }
#ifdef DEBUG
     fprintf( stderr, "..Ok.\n" );
#endif

     /* Close unneedful file descriptor */
     close(pfd[1]);
     close(cfd[0]);

#ifdef DEBUG
     fprintf( stderr, "Child process ID %d\n", cpid );
#endif


     {
#ifdef DEBUG
	 fprintf( stderr, "Get first mail info.\n" );
#endif
	 if( CP_ADDMAILS != RecvInst( pfd[0] ) ){
	     /* ᡼˼ԤƤ */
	     XqbExit();
	 }


	 /* ưΥ᡼μ */
	 nmail = RecvInt( pfd[0] );

#ifdef DEBUG
	 fprintf( stderr, "First mails: %d", nmail );
#endif

	 if( nmail == 0 ){      /* ᡼뤬̵ */
	     state = 0;
	     next_state = 0;
	     sprintf( mes_title, titlez_message );
	     changecodetojis( mes_title, mes_title, 256, CODE_EUC );
	 } else {               /* ᡼뤬 */
	     state = 2;
	     next_state = 2;

	     /* ᡼,¤Τݤ */
	     if( mailinfo != NULL ){
		 free( mailinfo ); mailinfo = NULL;
idbgout(__func__,"Memory free. mailinfo <%d>.",__LINE__);
	     }
	     if( nmail > 0 ){
		 if( NULL == (mailinfo = 
			      (MailInfo*)malloc(nmail*sizeof(MailInfo))) ){
		     fprintf( stderr, "Memory over! %d\n", nmail );
		     exit(2);
		 }
idbgout(__func__,"Memory alloc. mailinfo <%d>.",__LINE__);
	     }

	     for( i=0 ; i<nmail ; i++ ){
#ifdef DEBUG
		 fprintf( stdout, "Receive mail info %d/%d.", i+1, nmail );
#endif
		 RecvMailInfo( pfd[0], &mailinfo[i] );
		 mailinfo[i].ColorID = 0;
	     }
	     nsbj = iMin( nmail, opinfo.mmax );
	     SetMailColorInfo( mailinfo, nmail, &tinfo, &ltransflag );
	     GetMailRect( &ifs, mailinfo, nmail, &lvsize );
	     y_locate_max = lvsize.height - MH*nsbj - 10;

	     /* ᡼ʸ */
	     sprintf( mes_title, titlen_message, nmail );
	     changecodetojis( mes_title, mes_title, 256, CODE_EUC );
	 }
	 pflag = FALSE;
#ifdef DEBUG
	 fprintf( stderr, "..Ok." );
#endif
     }


     /* Set window title text */
     iFilenameCreate( argv[0], temp );

     if( strlen( opinfo.label ) > 0 ){
	 char tttxt[1024];

	 sprintf( tttxt, "%s - %s", temp, opinfo.label );
	 SetWndName( d, m_wnd, tttxt );
idbgout(__func__,"title = %s",tttxt);

	 sprintf( tttxt, "xqbiff mail list - %s", opinfo.label );
	 SetWndName( d, l_wnd, tttxt );

	 sprintf( tttxt, "New mail - %s", opinfo.label );
	 SetWndName( d, p_wnd, tttxt );
     } else {
	 char tttxt[1024];
	 sprintf( tttxt, "%s", temp );
	 SetWndName( d, m_wnd, tttxt );
idbgout(__func__,"title = %s",tttxt);

	 sprintf( tttxt, "xqbiff mail list" );
	 SetWndName( d, l_wnd, tttxt );

	 sprintf( tttxt, "New mail" );
	 SetWndName( d, p_wnd, tttxt );
     }

     {
	 /* Create chip pixmap */
	 if( strlen(opinfo.label) > 0 )
	     strcpy( temp, opinfo.label );
	 else
	     iFilenameCreate( argv[0], temp );

	 csh.width = iXmbTextWidth(&ifs,temp,strlen(temp))+10;
	 csh.height = LINE_H;
	 cpmap = XCreatePixmap( d, c_wnd, csh.width, csh.height, depth );

	 XSetForeground( d, c_gc, pixel_bg );
	 XFillRectangle( d, cpmap, c_gc, 0, 0, csh.width, csh.height );

	 XSetForeground( d, c_gc, pixel_fg );
	 XDrawRectangle( d, cpmap, c_gc, 0, 0, csh.width-1, csh.height-1 );

	 iXmbDrawString( d, cpmap, &ifs, c_gc,
			 5, font_h, temp, strlen(temp), csh.width, FALSE );
     }


     /* Mapping the main window */
#ifdef DEBUG
     fprintf( stderr, "Map main window.(%d,%d)\n", msh.x, msh.y );
#endif
     XMapRaised( d, m_wnd );
     XSync( d, 0 );
#ifdef DEBUG
     fprintf( stderr, "..Ok." );
#endif

     /* Get display descriptor */
     dfd = XConnectionNumber( d );

     fdmax = iMax( dfd, pfd[0] ) + 1;

#ifdef DEBUG
     fprintf( stderr, "FD: %d", dfd );
     fprintf( stderr, "%d", pfd[0] );
     fprintf( stderr, "%d", fdmax );
#endif

     /* Set interval time at first */
     tv.tv_sec = (int)iminfo.asp[state][acnt];
     tv.tv_usec = (iminfo.asp[state][acnt]-tv.tv_sec) * 1000000;


 /*-----------------------------------------------------------------------*/

     /********************/
     /* Start main loop! */
     /********************/
#ifdef DEBUG
     fprintf( stderr, "Start main loop!" );
#endif
     for(;;){
	 /* Set value that use select */
	 FD_ZERO( &rfds );
	 FD_SET( dfd, &rfds );
	 FD_SET( pfd[0], &rfds );

#ifdef DEBUG
	 fprintf( stderr, "+" );
#endif

	 if( SignalUnblock( SIGUSR1 ) && FALSE == chkflag ){
	     /* ֥å˥ʥäƤ */
	     /* Ƹ׵Ф                           */

#ifdef DEBUG_SEARCH
	     fprintf( stderr, "Send search request. sig1.\n" );
#endif
	     SendInst( cfd[1], PC_RESEARCH );
	     chkflag = TRUE;
	 }

	 /* select:  Wait till event or timeout */
	 selsts = select( fdmax, &rfds, NULL, NULL, &tv );

	 SignalBlock( SIGUSR1 );
	 if( selsts < 0 || rcvsig >= 0 ){
	     if( SIGUSR1 == rcvsig && FALSE == chkflag ){
#ifdef DEBUG_SEARCH
	     fprintf( stderr, "Send search request. sig2.\n" );
#endif
		 SendInst( cfd[1], PC_RESEARCH );
		 chkflag = TRUE;
	     }
	     rcvsig = -1;
	 } else if( 0 == selsts ){
	     /*****************************************/
	     /*                                       */
	     /* 쥯Ȥǥॢ:󥿡 */
	     /*                                       */
	     /*****************************************/
#ifdef DEBUG
	     fprintf( stderr, "Select Time Out. state=%d %d\n", state, next_state );
#endif

	     if( chipflag == FALSE && enterflag == TRUE && entertime >= 0 ){
		 entertime += iminfo.asp[state][acnt];
		 if( entertime > 1 ){
		     /* Chip ɥɽ */
		     csh.x = cur_mouse_x - csh.width/2;
		     csh.y = cur_mouse_y + 5;

		     GetWndSizePos( d, c_wnd, &csh, &csh );
		     MapWnd( d, c_wnd, &csh );
 /*
		     SetWndSize( d, c_wnd, csh.x, csh.y,
				 csh.width, csh.height, &csh, FALSE );
 */
		     chipflag = TRUE;
		 }
	     }

	     if( opinfo.nocapt == 1 ){
		 if( Button1flag == TRUE ){
		     int mvflag = 1;
		     switch(sb_flag){
		     case 1:  /* Pushed up button */
			 y_locate -= LINE_H;
			 break;
		     case 2:  /* Pushed down button */
			 y_locate += LINE_H;
			 break;
		     case 4:  /* Pushed up area */
			 y_locate -= LINE_H*(nsbj*3);
			 sb_flag = CheckScBarClkPos( mouse_y );
			 break;
		     case 5:  /* Pushed down area */
			 y_locate += LINE_H*(nsbj*3);
			 sb_flag = CheckScBarClkPos( mouse_y );
			 break;
		     default:
			 mvflag = 0;
			 break;
		     }
		     if( mvflag == 1 ){
			 if( y_locate < 0 )
			     y_locate = 0;
			 if( y_locate > (nmail-nsbj)*3*LINE_H ){
			     y_locate = (nmail-nsbj)*3*LINE_H;
			 }
			 Sh2Sz(&lwsize,&lsh);
			 DrawListPixmap( d, l_wnd, cmap, &lpgc, &lpmap, depth,
					 &tinfo, &ifs, mailinfo, nmail,
					 &lwsize, lbgpmap,
					 y_locate, nsbj, lfflag );

			 SetScPerc( (double)y_locate/y_locate_max );

			 CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
				   y_locate, &lsh );

			 XFlush( d );

			 /* Reset timer information for next select */
			 tv.tv_sec = 0;
			 tv.tv_usec = 50000;

			 continue;
		     }
		 }
	     }

	     /* 뤬ޥåפƤȤ */
	     if( pflag == TRUE ){
		 /* ɽ֤Υ󥿤 */

		 if( ncnt >= 0.0 )
		     ncnt += iminfo.asp[state][acnt];


		 /* ϰַв᤹ȼưŪ˾ä */
		 if( ncnt >= (double)opinfo.p_time ){
idbgout(__func__,"Window unmap request(popup)(%d)",__LINE__);
		     XUnmapWindow( d, p_wnd );
		     XFlush( d );
		     pflag = FALSE;
		 }
	     };

	     /* ᥤ󥦥ɥ򥢥˥᡼󤵤 */
	     if( opinfo.anim == TRUE ){
		 acnt = (acnt+1) % iminfo.pt[state];
		 if( acnt == 0 ){
		     if( state != 4 ){
			 state = next_state;

			 if( nmail > 0 && state != 2 ){
			     next_state = 2;
			 }
		     }
		 }
	     } else if( nmail != nmail_old ){
		 state = 0 < nmail ? 2 : 0;
	     }

	     /* ˥᡼,⤷Ͼ֤Ѳ,ɥľ */
	     if( nmail != nmail_old || opinfo.anim == TRUE ){
		 if( opinfo.shape == TRUE ){

		     /* Ĥɤ,WindowBackgroundPixmap
			ꤹ */
		     XSetWindowBackgroundPixmap(d,m_wnd,ipmap[state][acnt]);


		     /* ߤΥޤΥޥ򥳥ԡ, ޥ򤫤 */
		     XShapeCombineMask( d, m_wnd, ShapeBounding,
					0, 0,
					mpmap[state][acnt], ShapeSet );

		     XClearWindow( d, m_wnd );
 /*
		     XClearArea( d, r_wnd,
				 msh.x, msh.y, iminfo.pwidth, iminfo.pheight,
				 False );
 */
		 } else {
		     XCopyArea( d, ipmap[state][acnt], m_wnd, m_gc,
				0, 0, 
				iminfo.pwidth, iminfo.pheight,
				xst, yst );

		 }
		 XFlush(d);
	     }

	     /* Reset timer information for next select */
	     tv.tv_sec = (int)iminfo.asp[state][acnt];
	     tv.tv_usec = (iminfo.asp[state][acnt]-tv.tv_sec) * 1000000;

	 } else {
	     /******************************************/
	     /*                                        */
	     /* ᡼ƻץϤäȤ */
	     /*                                        */
	     /******************************************/

	     if( 0 != FD_ISSET( pfd[0], &rfds ) ){
		 char inst;
 #ifdef DEBUG
		 fprintf( stderr, "Mail information from child process.%d", i );
 #endif
		 inst = RecvInst( pfd[0] );
		 switch(inst){
		 case CP_ADDMAILS:
		     /*
		      *
		      * ᡼뤬Ȥ
		      *
		      */
idbgout(__func__,"Find new mail.");

		     chkflag = FALSE;
		     nmail_old = nmail;

		     /*
		      * ᡼ξ
		      */
		     newnmail = RecvInt( pfd[0] );
 #ifdef DEBUG
		     fprintf( stderr, "newnmail = %d", newnmail );
 #endif
		     /* ᡼,¤Τݤ */
		     if( newmailinfo != NULL ){
			 free( newmailinfo );
			 newmailinfo = NULL;
idbgout(__func__,"Memory free. newmailinfo <%d>.",__LINE__);
		     }
		     if( newnmail > 0 ){
			 if( NULL == (newmailinfo = 
				      (MailInfo*)malloc(newnmail*sizeof(MailInfo))) ){
			     fprintf( stderr, "Memory over!\n" );
			     exit(2);
			 }
idbgout(__func__,"Memory alloc. newmailinfo <%d>.",__LINE__);
		     }
		     for( i=0 ; i<newnmail ; i++ ){
			 RecvMailInfo( pfd[0], &newmailinfo[i] );
			 newmailinfo[i].ColorID = 0;
		     }


		     /*
		      * ̤ɥ᡼ξ
		      */
		     nmail = RecvInt( pfd[0] );
 #ifdef DEBUG
		     fprintf( stderr, "nmail = %d", nmail );
 #endif
		     /* ̤ɥ᡼,¤Τݤ */
		     if( mailinfo != NULL ){
			 free( mailinfo );mailinfo = NULL;
idbgout(__func__,"Memory free. mailinfo <%d>.",__LINE__);
		     }
		     if( nmail > 0 ){
			 if( NULL == (mailinfo = 
				      (MailInfo*)malloc(nmail*sizeof(MailInfo))) ){
			     fprintf( stderr, "Memory over!\n" );
			     exit(2);
			 }
idbgout(__func__,"Memory alloc. mailinfo <%d>.",__LINE__);
		     }
		     for( i=0 ; i<nmail ; i++ ){
			 RecvMailInfo( pfd[0], &mailinfo[i] );
			 mailinfo[i].ColorID = 0;
		     }
 #ifdef DEBUG
		     fprintf( stderr, "Receive.Ok." );
 #endif
		     nsbj = iMin( nmail, opinfo.mmax );
		     SetMailColorInfo( mailinfo, nmail, &tinfo, &ltransflag );

		     if( nsbj > 0 ){
			 GetMailRect( &ifs, mailinfo, nmail, &lvsize );
			 y_locate_max = lvsize.height - MH*nsbj - 10;
		     }

		     /*
		      * ᥤ󥦥ɥΥơ
		      */
		     if( state != 4 ){
			 if( nmail_old == 0 )
			     next_state = 1;
			 else
			     next_state = 3;
		     } else {
			 if( nmail_old == 0 ){
			     state = 1;
			     next_state = 2;
			     acnt = 0;
			 }else{
			     state = 3;
			     next_state = 2;
			     acnt = 0;
			 }
		     }


		     /*
		      * ᡼ꥹȤι
		      */
		     if( opinfo.nopopup == FALSE && newmailinfo != NULL ){
			 /* ᡼ꥹȤɽ */

			 if( pflag == TRUE ){
idbgout(__func__,"Window unmap request(popup)(%d).",__LINE__);
			     XUnmapWindow( d, p_wnd );
			     XFlush( d );
			 }

			 /* 󥿤ν */
			 ncnt = 0.0;

			 if( ppmap != 0 ){
idbgout(__func__,"Pixmap free ppmap(%d).",__LINE__);
			     XFreePixmap( d, ppmap );
			     ppmap = 0;
			 }

			 SetMailColorInfo(newmailinfo, newnmail,
					  &tinfo, &ptransflag );
			 GetMailRect(&ifs,newmailinfo,newnmail,&pvsize);

			 if( opinfo.p_geom_flag == TRUE ){
			     psh.x = old_psh.x = pdsh.x;
			 } else {
			     psh.x = old_psh.x = pdsh.x - (pvsize.width/2);
			 }
			 psh.y      = old_psh.y      = pdsh.y;
			 psh.width  = old_psh.width  =  pvsize.width;
			 psh.height = old_psh.height = LINE_H + 10 +
				         LINE_H*3*newnmail;

			 GetWndSizePos( d, p_wnd, &psh, &psh );

idbgout(__func__,"create bg(%d)",__LINE__);
			 CreateBgPixmap( d, p_wnd, r_wnd, p_gc, cmap, depth,
					 pbgpmap, TEXT_COLOR_INFO_MAX,
					 newnmail, &tinfo, &psh,
					 FALSE, ptransflag );

			 DrawListPixmap( d, p_wnd, cmap, &ppgc, &ppmap,
					 depth,
					 &tinfo, &ifs, newmailinfo,
					 newnmail, &pvsize,
					 pbgpmap, 0, newnmail, TRUE );

idbgout(__func__,"Pixmap create ppmap(%d).",__LINE__);

			 /* Recreate title message */
			 if( newnmail == 1 ){
			     strcpy( nmes_title, new1_message );
			 } else {
			     sprintf( nmes_title, newn_message, newnmail );
			 }
			 changecodetojis( nmes_title, nmes_title, 256, CODE_EUC );
			 XFlush( d );

			 MapWnd( d, p_wnd, &psh );

			 pflag = TRUE;
		     }


		     if( nsbj > 0 && opinfo.nocapt == 1 && lflag == TRUE ){
			 /*
			  * ̤ɥ᡼륦ɥɽξϡ
			  * Сƺ
			  */
			 CreateScrollBar( d, l_wnd, cmap, depth,
					  lvsize.height,
					  lsh.height-LINE_H-5,
					  nmail, nsbj );
		     }

		     /* Recreate title message */
		     sprintf( mes_title, titlen_message, nmail );
		     changecodetojis( mes_title, mes_title, 256, CODE_EUC );
		     if( lflag == TRUE ){
			 DrawListTitle( d, l_wnd, l_gc, cmap, 
					&tinfo, &ifs,
					mes_title, lsh.width, 0, depth );
			 XClearArea( d, l_wnd, 0, 0, 0, 0, True );
		     }


		     /*
		      * ᡼ư
		      */
		     if( opinfo.beep ) XBell( d, 0 );

		     /* ҥץ˥ޥɼ¹Ԥ׵ */
		     {
			 BOOL runflags[TEXT_COLOR_INFO_MAX];
			 BOOL runflag = TRUE;

			 for(i=0;i<TEXT_COLOR_INFO_MAX;i++){
			     runflags[i] = TRUE;
			 }

			 for( i=0 ; i<newnmail ; i++ ){
 /*
			     printf("%s  %d  %d  %d\n",
				    tinfo.tinf[newmailinfo[i].ColorID].command,
				    runflag,
				    runflags[newmailinfo[i].ColorID],
				    tinfo.tinf[newmailinfo[i].ColorID].run_others);
 */



			     if( strlen(tinfo.tinf[newmailinfo[i].ColorID].command) > 0
				 && TRUE == runflags[newmailinfo[i].ColorID]
				 && (TRUE == runflag ||
				     TRUE == tinfo.tinf[newmailinfo[i].ColorID].run_others)){
				 SendInst( cfd[1], PC_RUNCOMM );
				 SendStr( cfd[1],
					  tinfo.tinf[newmailinfo[i].ColorID].command );
				 runflags[newmailinfo[i].ColorID] = FALSE;
				 runflag = FALSE;
			     }
			 }
		     }

		     lfflag = TRUE;

 #ifdef DEBUG
		     fprintf( stderr, "..Done." );
 #endif
		     break;


		 case CP_DELMAILS:

idbgout(__func__,"Deleted mail.");

		     /*
		      *
		      * ᡼뤬äȤ
		      *
		      */

		     nmail_old = nmail;
		     /* ᡼μ */
		     nmail = RecvInt( pfd[0] );

		     if( opinfo.mmax > 0 && lflag == TRUE ){
			 /* ɽϥޥåפ */
			 XUndefineCursor( d, l_wnd );
			 XUngrabPointer( d, CurrentTime );
			 XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
			 lmpflag = FALSE;
			 keep_flag = FALSE;
		     } else {
			 DrawListTitle( d, l_wnd, l_gc, cmap, 
					&tinfo, &ifs,
					mes_title, lsh.width, 0, depth );
			 XClearArea( d, l_wnd, 0, 0, 0, 0, True );
		     }
		     if( pflag == TRUE ){
idbgout(__func__,"Window unmap request(popup)(%d)",__LINE__);
			 XUnmapWindow( d, p_wnd );
			 pflag = FALSE;
		     }
		     XSync( d, 0 );

		     if( nmail == 0 ){
			 /*
			  * ᡼뤬̵ʤä饢˥Ѳ
			  */
			 next_state = 0;
			 if( iminfo.ptn >= 5 ){
			     state = 0;
			     acnt = 0;
			 }
			 sprintf( mes_title, titlez_message );
			 changecodetojis( mes_title, mes_title, 256, CODE_EUC );
			 if( nmail_old > 0 &&  mailinfo != NULL ){
			     free(mailinfo);
			     mailinfo = NULL;
idbgout(__func__,"Memory free. mailinfo <%d>.",__LINE__);
			 }

		     } else {
			 /*
			  * ᡼뤬ĤäƤʤ顢ľ
			  */
			 if( mailinfo != NULL ){
			     free(mailinfo);mailinfo=NULL;
idbgout(__func__,"Memory free. mailinfo <%d>.",__LINE__);
			 }
			 if( nmail > 0 ){
			     if( NULL == (mailinfo = 
					  (MailInfo*)malloc(nmail*sizeof(MailInfo))) ){
				 fprintf( stderr, "Memory over!\n" );
				 exit(2);
			     }
idbgout(__func__,"Memory alloc. mailinfo <%d>.",__LINE__);
			 }
			 for( i=0 ; i<nmail ; i++ ){
			     RecvMailInfo( pfd[0], &mailinfo[i] );
			     mailinfo[i].ColorID = 0;
			 }
			 nsbj = iMin( nmail, opinfo.mmax );
			 if( nsbj > 0 ){
			     GetMailRect( &ifs, mailinfo, nmail, &lvsize );
			     SetMailColorInfo( mailinfo, nmail,
					   &tinfo, &ltransflag );
			 }
			 y_locate_max = lvsize.height - MH*nsbj - 10;


			 /* ᡼ʸ */
			 sprintf( mes_title, titlen_message, nmail );
			 changecodetojis( mes_title, mes_title, 256, CODE_EUC );
			 lfflag = TRUE;

			 if( iminfo.ptn >= 5 ){
			     next_state = 2;
			     state = 2;
			     acnt = 0;
			 }
		     }
		     break;


		 case CP_RESCANMAILS:
idbgout(__func__,"Rescan mail.");

		     /*
		      *
		      * ᡼ꥹȤ줿Ȥ
		      *
		      */

		     nmail_old = nmail;
		     /* ᡼μ */
		     nmail = RecvInt( pfd[0] );

		     if( opinfo.mmax > 0 && lflag == TRUE ){
			 /* ɽϥޥåפ */
			 XUndefineCursor( d, l_wnd );
			 XUngrabPointer( d, CurrentTime );
			 XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
			 lmpflag = FALSE;
			 keep_flag = FALSE;
		     } else {
			 DrawListTitle( d, l_wnd, l_gc, cmap, 
					&tinfo, &ifs,
					mes_title, lsh.width, 0, depth );
			 XClearArea( d, l_wnd, 0, 0, 0, 0, True );
		     }
		     if( pflag == TRUE ){
idbgout(__func__,"Window unmap request(popup)(%d)",__LINE__);
			 XUnmapWindow( d, p_wnd );
			 pflag = FALSE;
		     }
		     XSync( d, 0 );

		     if( nmail == 0 ){
			 /*
			  * ᡼뤬̵ʤä饢˥Ѳ
			  */
			 next_state = 0;
			 if( iminfo.ptn >= 5 ){
			     state = 0;
			     acnt = 0;
			 }
			 sprintf( mes_title, titlez_message );
			 changecodetojis( mes_title, mes_title, 256, CODE_EUC );

		     } else {
			 /*
			  * ᡼뤬ĤäƤʤ顢ľ
			  */
			 if( mailinfo != NULL ){
			     free(mailinfo);mailinfo=NULL;
idbgout(__func__,"Memory free. mailinfo <%d>.",__LINE__);
			 }
			 if( nmail > 0 ){
			     if( NULL == (mailinfo = 
					  (MailInfo*)malloc(nmail*sizeof(MailInfo))) ){
				 fprintf( stderr, "Memory over!\n" );
				 exit(2);
			     }
idbgout(__func__,"Memory alloc. mailinfo <%d>.",__LINE__);
			 }
			 for( i=0 ; i<nmail ; i++ ){
			     RecvMailInfo( pfd[0], &mailinfo[i] );
			     mailinfo[i].ColorID = 0;
			 }
			 nsbj = iMin( nmail, opinfo.mmax );
			 if( nsbj > 0 ){
			     GetMailRect( &ifs, mailinfo, nmail, &lvsize );
			     SetMailColorInfo( mailinfo, nmail,
					   &tinfo, &ltransflag );
			 }
			 y_locate_max = lvsize.height - MH*nsbj - 10;


			 /* ᡼ʸ */
			 sprintf( mes_title, titlen_message, nmail );
			 changecodetojis( mes_title, mes_title, 256, CODE_EUC );
			 lfflag = TRUE;

			 if( iminfo.ptn >= 5 ){
			     next_state = 2;
			     state = 2;
			     acnt = 0;
			 }
		     }

		     break;


		 case CP_CHKSTART:
idbgout(__func__,"Search start.");
		     /*
		      *
		      * 楢˥ᳫϡPOP⡼ɤΤߡ
		      *
		      */
		     if( opinfo.mode == 2 && iminfo.ptn >= 5 ){
			 next_state = state;
			 state = 4;
			 acnt = 0;
		     }
		     chkflag = TRUE;
		     break;


		 case CP_CHKEND:
		     /*
		      *
		      * 楢˥Ὢλ
		      * ᡼ѲȤΤƤ
		      *
		      */
idbgout(__func__,"Search finish. state=%d %d",state,next_state);

		     if( iminfo.ptn >= 5 ){ 
			 state = next_state;
			 next_state = state;
			 acnt = 0;
		     }
		     chkflag = FALSE;
		     break;


		 case CP_FINCOMM:
		     /*
		      *
		      * ᡼ƥޥɼ¹Ը塢Ƹ
		      *
		      */
		     break;


		 case CP_MESSAGE:
		     /*
		      *
		      * ҥץ, åɽ׵᤬äȤ
		      *
		      */
#ifdef DEBUG
		     fprintf( stderr,
			     "Receive string message from child process.\n" );
#endif
		     {
			 char mes[1024];


			 if( wflag == TRUE ){
			     XUnmapWindow( d, w_wnd );
			     wflag = FALSE;
idbgout(__func__,"Window unmap request(warning)(%d)",__LINE__);
			 }


			 RecvStr( pfd[0], mes );
			 changecodetojis( mes, mes, 1024, CODE_EUC );

#ifdef DEBUG
			 fprintf( stderr, "%s\n", mes );
#endif
			 if( wpmap != 0 ){
#ifdef DEBUG_PIXMAP
			     fprintf( stderr, "FreeWarningPixmap.\n" );
#endif
			     XFreePixmap( d, wpmap );
			     wpmap = 0;
			 }
			 wpmap = CreateMessagePixmap( d, w_wnd, cmap, depth,
						      mes,
						      &tinfo, &ifs, &wpsize );
		     }


		     /* åɥΥǥեɽ֤ */
		     /* ȤꤢƱˤƤ           */
		     if( opinfo.p_geom_flag == TRUE )
			 wsh.x = pdsh.x;
		     else
			 wsh.x = pdsh.x-(wpsize.width/2);
		     wsh.y = pdsh.y;
		     wsh.width  = wpsize.width;
		     wsh.height = wpsize.height;

		     if( strlen( opinfo.label ) > 0 ){
			 sprintf( temp, "xqbiff - %s : message", opinfo.label );
			 SetWndName( d, w_wnd, temp );
		     } else {
			 char tttxt[1024];
			 sprintf( temp, "xqbiff : message" );
			 SetWndName( d, w_wnd, temp );
		     }

		     GetWndSizePos( d, w_wnd, &wsh, &wsh );
		     MapWnd( d, w_wnd, &wsh );

		     wflag = TRUE;
		     break;

		 case CP_EXITCHILD:
		     /*
		      *
		      * ҥץλȤ
		      *
		      */
 #ifdef DEBUG
		     fprintf( stderr,
			     "Receive exit message from child process.\n" );
 #endif
		     XqbExit();
		     break;

		 default:
		     fprintf( stderr, "Error: ᡼ƻץ,"
			      "̵̿ޤ%d\n", i );
		     break;

		 }
	     }
	 }

 #ifdef DEBUG
	 fprintf( stderr, "X --------" );
 #endif
	 /*******************************/
	 /**                           **/
	 /* if receive a event then ... */
	 /**                           **/
	 /*******************************/
	 while( XPending( d ) > 0 ){
 #ifdef DEBUG
	     fprintf( stderr, "Received X event." );
 #endif
	     XNextEvent( d, &report );
 #ifdef DEBUG
	     fprintf( stderr, "Received X event. %d\n", report.type );
 #endif

	     switch( report.type ){
		 /********************************/
		 /*                              */
		 /* When windows are need redraw */
		 /*                              */
		 /********************************/
	     case Expose:
		 if( report.xexpose.window == m_wnd ){
		     /* Main window */
 #ifdef DEBUG
		     fprintf( stderr, "Main Window Exposure." );
		     fprintf( stderr, "W." );
 #endif
		     while( True == 
			    XCheckTypedWindowEvent(d,m_wnd,Expose,&rep_trash) );

		     if( state < 0 || 5 < state ) break;

		     if( opinfo.shape == TRUE ){
			 /* Ĥɤ,WindowBackgroundPixmap
			    ꤹ */
			 XSetWindowBackgroundPixmap(d,m_wnd,ipmap[state][acnt]);

			 /* ߤΥޤΥޥ򥳥ԡ, ޥ򤫤 */
			 XShapeCombineMask( d, m_wnd, ShapeBounding,
					    0, 0,
					    mpmap[state][acnt], ShapeSet );

			 XClearWindow( d, m_wnd );
		     } else {

			 XCopyArea( d, ipmap[state][acnt], m_wnd, m_gc,
				    0, 0, 
				    iminfo.pwidth, iminfo.pheight,
				    xst, yst );
		     }
 #ifdef DEBUG
		     fprintf( stderr, "..Ok.(%dL)", __LINE__ );
 #endif
		 }
		 /* List window */
		 else if( report.xexpose.window == l_wnd ){
idbgout(__func__,"List Window Exposure.");

		     if( True ==
			 XCheckTypedWindowEvent(d,l_wnd,ConfigureNotify,&report) ){
			 XPutBackEvent(d,&report);
			 break;
		     }

		     while( True == 
			    XCheckTypedWindowEvent(d,l_wnd,Expose,&rep_trash) );

		     if( !ShCmp(old_lsh,lsh) || lbgpmap[0]==0 ){
			 CreateBgPixmap( d, l_wnd, r_wnd, l_gc, cmap, depth,
					 lbgpmap, TEXT_COLOR_INFO_MAX,
					 nsbj, &tinfo, &lsh, TRUE, ltransflag );
			 ShCpy( &old_lsh, &lsh );
			 lfflag = TRUE;
		     }

		     Sh2Sz(&lwsize,&lsh);
		     DrawListPixmap(d, l_wnd, cmap, &lpgc, &lpmap, depth,
				    &tinfo,
				    &ifs, mailinfo, nmail, &lwsize,
				    lbgpmap, y_locate, nsbj, lfflag );
		     lfflag = FALSE;

		     /* Drawing title & list */
		     DrawListTitle( d, l_wnd, l_gc, cmap, &tinfo, &ifs,
				    mes_title, lsh.width, 0, depth );

		     CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
			       y_locate, &lsh );
 /*
		     if( opinfo.nocapt == TRUE ){
			 DrawScrollBar( d, l_wnd, l_gc,
					lsh.width, LINE_H+5,
					y_locate );
		     }
 */

 #ifdef DEBUG
		     fprintf( stderr, "..Ok.\n" );
 #endif

		 }

		 /* Popup window */
		 else if( report.xexpose.window == p_wnd &&
			  pflag == TRUE && ppmap != 0 ){
 #ifdef DEBUG
		     fprintf( stderr, "Popup Window Exposure.\n" );
 #endif
		     if( True ==
			 XCheckTypedWindowEvent(d,p_wnd,ConfigureNotify,&report) ){
			 XPutBackEvent(d,&report);
			 break;
		     }

		     while( True == 
			    XCheckTypedWindowEvent(d,p_wnd,Expose,&rep_trash) );

#ifdef HAVE_IMLIB_H
		     if( ptransflag != 0 ){
			 if( !ShCmp( old_psh, psh ) || pbgpmap[0] == 0 ){
idbgout(__func__,"create bg(%d)",__LINE__);
			     CreateBgPixmap( d, p_wnd, r_wnd, p_gc, cmap, depth,
					     pbgpmap, TEXT_COLOR_INFO_MAX,
					     newnmail, &tinfo, &psh,
					     FALSE, ptransflag );
			     ShCpy( &old_psh, &psh );

idbgout(__func__,"Pixmap free ppmap(%d).",__LINE__);
			     XFreePixmap( d, ppmap );
			     ppmap = 0;
			     DrawListPixmap(d,p_wnd,cmap,&ppgc,&ppmap,
					    depth,&tinfo,
					    &ifs, newmailinfo, newnmail, &pvsize,
					    pbgpmap, 0, newnmail, TRUE );
idbgout(__func__,"Pixmap create ppmap(%d).",__LINE__);
			 }
		     }
#endif

		     /* Drawing title & list */
		     DrawListTitle( d, p_wnd, p_gc, cmap, &tinfo, &ifs,
				    nmes_title, psh.width, psh.height,
				    depth );
		     XCopyArea( d, ppmap, p_wnd, p_gc, 0, (LINE_H*3),
				psh.width, psh.height-LINE_H-5, 0, LINE_H+5 );
 #ifdef DEBUG
		     fprintf( stderr, "..Ok." );
 #endif
		 }
		 /* Chip window */
		 else if( report.xexpose.window == c_wnd &&
			  chipflag == TRUE && cpmap != 0 ){
 #ifdef DEBUG
		     fprintf( stderr, "Chip Window Exposure." );
		     fprintf( stderr, "P." );
 #endif

		     XCopyArea( d, cpmap, c_wnd, c_gc, 0, 0,
				csh.width, csh.height, 0, 0 );
 #ifdef DEBUG
		     fprintf( stderr, "..Ok." );
 #endif
		 }
		 /* Warning message window */
		 else if( report.xexpose.window == w_wnd &&
			  wflag == TRUE && wpmap != 0 ){
		     XCopyArea( d, wpmap, w_wnd, w_gc, 0, 0,
				wsh.width, wsh.height, 0, 0 );
		 }
		 XFlush( d );
		 break;



		 /************************/
		 /*                      */
		 /* Case of Button press */
		 /*                      */
		 /************************/
	     case ButtonPress:
		 if( enterflag == TRUE ){
		     entertime = -1;
		     if( chipflag == TRUE ){
			 XUnmapWindow( d, c_wnd );
			 XFlush( d );
			 chipflag = FALSE;
		     }
		 }

		 while( True == 
			XCheckMaskEvent(d, ButtonPressMask, &rep_trash) );

		 switch( report.xbutton.button ){
		 case Button1:       /* Press left button */
		     Button1flag = TRUE;
		     Button1Time = report.xbutton.time;
		     mouse_x = report.xbutton.x;
		     mouse_y = report.xbutton.y;
 #ifdef DEBUG
		     fprintf( stderr, "Button1 Press." );
 #endif

		     /* If already mapped list window or popup window */
		     if( report.xbutton.window == l_wnd ){
			 if( opinfo.nocapt == 1 ){
			     if( mouse_x > lsh.width - SCBAR_SIZE ){
				 sb_flag = CheckScBarClkPos( mouse_y );
				 if( sb_flag > 0 && sb_flag != 3 ) {
				     switch(sb_flag){
				     case 1:
					 ScBtnPush( d, cmap, 0, TRUE );
					 y_locate -= LINE_H;
					 break;
				     case 2:
					 ScBtnPush( d, cmap, 1, TRUE );
					 y_locate += LINE_H;
					 break;
				     case 4:
					 y_locate -= LINE_H*(nsbj*3);
					 break;
				     case 5:
					 y_locate += LINE_H*(nsbj*3);
					 break;
				     }
				     if( y_locate < 0 )
					 y_locate = 0;
				     if( y_locate > (nmail-nsbj)*3*LINE_H ){
					 y_locate = (nmail-nsbj)*3*LINE_H;
				     }

				     Sh2Sz(&lwsize,&lsh);
				     DrawListPixmap( d, l_wnd, cmap, &lpgc,
						     &lpmap, depth,
						     &tinfo, &ifs,
						     mailinfo, nmail, &lwsize,
						     lbgpmap,
						     y_locate, nsbj, lfflag );

				     SetScPerc( (double)y_locate/y_locate_max );

				     CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
					       y_locate, &lsh );

				     XFlush( d );

				     /* Reset timer information for next select */
				     tv.tv_sec = 0;
				     tv.tv_usec = 500000;
				 } else if( sb_flag == 3 ){
				     ResetScrollBar();
				 }
			     } else if( sb_flag == 0 ){
				 XDefineCursor( d, l_wnd, lcursor );
			     }
			 }
			 break;
		     }

		     if( report.xbutton.window != m_wnd ){
			 break;
		     }

		     /* If already mapped popup window, it unmap */
		     if( pflag == TRUE ){
idbgout(__func__,"Window unmap request(popup)(%d)",__LINE__);
			 XUnmapWindow( d, p_wnd );
			 XFlush( d );
			 pflag = FALSE;
		     }

		     /* If find mails, see to draw list */
		     if( lflag == FALSE ){
			 y_locate = 0;

			 /* Drawn mails */
			 nsbj = iMin( nmail, opinfo.mmax );

			 /* Create title message */
			 if( nmail > 0 ){
			     sprintf( mes_title, titlen_message, nmail );
			 } else {
			     sprintf( mes_title, titlez_message );
			 }
			 changecodetojis( mes_title, mes_title, 256, CODE_EUC );

			 if( nsbj > 0 ){
			     GetMailRect( &ifs, mailinfo, nmail, &lvsize );
			     y_locate_max = lvsize.height - MH*nsbj - 10;
			     lsh.height = LINE_H*3*nsbj + LINE_H+10;
			 } else {
			     lvsize.width = iXmbTextWidth(&ifs,mes_title,
							  strlen(mes_title))
				 + 10;
			     lvsize.height = 0;
			     lsh.height = LINE_H+5;
			 }

			 if( opinfo.nocapt == 1 ){
			     lsh.width = lvsize.width + SCBAR_SIZE;
			 } else {
			     lsh.width = lvsize.width;
			 }

			 lsh.x = report.xbutton.x_root-(lsh.width/2);
			 lsh.y = report.xbutton.y_root-(LINE_H+15);

			 GetWndSizePos( d, l_wnd, &lsh, &lsh );
			 Sh2Sz(&lwsize,&lsh);

			 if( nsbj > 0 ){
			     DrawListPixmap(d, l_wnd, cmap, &lpgc, &lpmap,
					    depth,
					    &tinfo,
					    &ifs, mailinfo, nmail, &lwsize,
					    lbgpmap, y_locate, nsbj, lfflag );
			 }

			 lfflag = FALSE;
 /*
			 mouse_x = report.xbutton.x_root;
			 mouse_y = report.xbutton.y_root;
 */
			 if( nsbj > 0 ){
			     if( opinfo.nocapt == 1 ){
				 CreateScrollBar( d, l_wnd, cmap, depth,
						  lvsize.height,
						  lsh.height-LINE_H-5,
						  nmail, nsbj );
				 SetScPerc(0);
			     } else {
				 if( nmail > opinfo.mmax ){
				     XDefineCursor( d, l_wnd, lcursor );
				 }
			     }
			 }

			 MapWnd( d, l_wnd, &lsh );
			 lmpflag = TRUE;

			 XFlush( d );
		     }


 #ifdef DEBUG
		     fprintf( stderr, "Button1 Press...Ok." );
 #endif
		     break;

		     /* If press button of 2 or 3, execute a command */
		 case Button2:
		     Button2flag = TRUE;
		     Button2Time = report.xbutton.time;
 #ifdef DEBUG
		     fprintf( stderr, "Button2 Press. %s", opinfo.com2 );
 #endif

		     if( strlen(opinfo.com2) > 0 &&
			 report.xbutton.window == m_wnd ){
			 if( Button1flag == FALSE && Button3flag == FALSE ){
			     sprintf(env_buff1,"%s=%d",_MAIL_ENV_,nmail);
			     putenv(env_buff1);
			     sprintf(env_buff2,"%s=%d",_NMAIL_ENV_,newnmail);
			     putenv(env_buff2);
			     sprintf(env_buff3,"%s=%d",_PPID_ENV_,ppid);
			     putenv(env_buff3);
			     sprintf(env_buff4,"%s=%d",_CPID_ENV_,cpid);
			     putenv(env_buff4);
			     sprintf(env_buff5,"%s=%s",_LABEL_ENV_,opinfo.label);
			     putenv(env_buff5);
			     system( opinfo.com2 );
			 }
		     }
		     break;

		 case Button3:
		     Button3flag = TRUE;
		     Button3Time = report.xbutton.time;
		     if( strlen(opinfo.com3) > 0 &&
			 report.xbutton.window == m_wnd ){
			 if( Button1flag == FALSE && Button2flag == FALSE ){
			     sprintf(env_buff1,"%s=%d",_MAIL_ENV_,nmail);
			     putenv(env_buff1);
			     sprintf(env_buff2,"%s=%d",_NMAIL_ENV_,newnmail);
			     putenv(env_buff2);
			     sprintf(env_buff3,"%s=%d",_PPID_ENV_,ppid);
			     putenv(env_buff3);
			     sprintf(env_buff4,"%s=%d",_CPID_ENV_,cpid);
			     putenv(env_buff4);
			     sprintf(env_buff5,"%s=%s",_LABEL_ENV_,opinfo.label);
			     putenv(env_buff5);
			     system( opinfo.com3 );
			 }
		     }

		     break;


		     /* If press button of 4 or 5 (moved wheel),
			scroll list */
		 case Button4:
		     if( report.xbutton.window != l_wnd 
			 || nmail <= nsbj ) break;

		     y_locate = ScrollList( y_locate, 
					    LINE_H*spl, TRUE, nsbj, &lvsize );

		     Sh2Sz(&lwsize,&lsh);
		     DrawListPixmap( d, l_wnd, cmap, &lpgc, &lpmap, depth,
				     &tinfo,
				     &ifs, mailinfo, nmail, &lwsize, lbgpmap,
				     y_locate, nsbj, lfflag );

		     lfflag = FALSE;

		     SetScPerc( (double)y_locate/y_locate_max );


		     CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
			       y_locate, &lsh );
		     break;


		 case Button5:
		     if( report.xbutton.window != l_wnd 
			 || nmail <= nsbj ) break;

		     y_locate = ScrollList( y_locate, 
					    LINE_H*spl, FALSE, nsbj, &lvsize );

		     Sh2Sz(&lwsize,&lsh);
		     DrawListPixmap( d, l_wnd, cmap, &lpgc, &lpmap, depth,
				     &tinfo,
				     &ifs, mailinfo, nmail, &lwsize, lbgpmap,
				     y_locate, nsbj, lfflag );
		     lfflag = FALSE;

		     SetScPerc( (double)y_locate/y_locate_max );

		     CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
			       y_locate, &lsh );
		     break;

		 default:
		     break;
		 };
		 break;


		 /**************************/
		 /*                        */
		 /* Case of Button release */
		 /*                        */
		 /**************************/
	     case ButtonRelease:
 #ifdef DEBUG
		 fprintf( stderr, "ButtonRelease" );
 #endif
		 if( enterflag == TRUE ){
		     entertime = -1;
		     if( chipflag == TRUE ){
			 XUnmapWindow( d, c_wnd );
			 XFlush( d );
			 chipflag = FALSE;
		     }
		 }

		 switch( report.xbutton.button ){
		 case Button1:
			 Button1flag = FALSE;

			 if( sb_flag == 1 || sb_flag == 2 ){
			     ScBtnPush( d, cmap, 0, FALSE );
			     ScBtnPush( d, cmap, 1, FALSE );
			     Sh2Sz(&lwsize,&lsh);
			     DrawListPixmap( d, l_wnd, cmap, &lpgc, &lpmap,
					     depth, &tinfo,
					     &ifs, mailinfo, nmail, &lwsize,
					     lbgpmap, y_locate, nsbj, lfflag );
			     CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
				       y_locate, &lsh );
			 }
			 sb_flag = 0;

			 if( report.xbutton.window == m_wnd
			     || report.xbutton.window == l_wnd ){
				 XUndefineCursor( d, l_wnd );
			     if( keep_flag == FALSE && 
				 report.xbutton.time - Button1Time < KEEPTIME ){
				 keep_flag = TRUE;
			     } else {
				 if( opinfo.nocapt == 0 ||
				     ((mouse_x!=report.xbutton.x ||
				       mouse_y!=report.xbutton.y) &&
					 keep_flag == FALSE ) ){
				     XUndefineCursor( d, l_wnd );
				     XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
				     XFlush( d );
				     lmpflag = FALSE;
				     keep_flag = FALSE;
				 } else {
				     if( mouse_x < lsh.width - SCBAR_SIZE ){
					 if( report.xbutton.time-Button1Time < KEEPTIME ){
					     XUndefineCursor( d, l_wnd );
					     XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
					     XFlush( d );
					     lmpflag = FALSE;
					     keep_flag = FALSE;
					 }
				     }
				 }
			     }
			 } else if( report.xbutton.window == w_wnd ) {
			     XUnmapWindow( d, w_wnd );
idbgout(__func__,"Window unmap request(warning)(%d)",__LINE__);
			     XFlush( d );
			     wflag = FALSE;
			 }
			 break;

		     case Button2:
			 Button2flag = FALSE;

		     case Button3:
			 Button3flag = FALSE;

			 XUndefineCursor( d, l_wnd );
			 XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
			 XFlush( d );
			 lmpflag = FALSE;
			 keep_flag = FALSE;

			 break;
		     }
		 if( report.xbutton.window == p_wnd ){
idbgout(__func__,"Window unmap request(popup)(%d)",__LINE__);
		     XUnmapWindow( d, p_wnd );
		     pflag = FALSE;
		 }
		 break;

		 /***************************/
		 /*                         */
		 /* When move mouse pointer */
		 /*                         */
		 /***************************/
	     case MotionNotify:

		 if( report.xmotion.window == m_wnd ){

		    cur_mouse_x = report.xmotion.x_root;
		    cur_mouse_y = report.xmotion.y_root;

		} else if( report.xmotion.window == l_wnd ){

		    while( True == 
			   XCheckTypedWindowEvent( d, l_wnd, MotionNotify,
						   &report ) ){
		    }


		    cur_mouse_x = report.xmotion.x_root;
		    cur_mouse_y = report.xmotion.y_root;

		    if( lflag == TRUE ){

			if( opinfo.nocapt == 0 ){
			    /*
			     * ޥͭ
			     */
			    if( report.xmotion.y < LINE_H+5 ){
				/* Pointer over top area */
				y_locate = ScrollList( y_locate,
						       mouse_sp_per[opinfo.sc_speed-1]
						       *(LINE_H+5-report.xmotion.y),
						       !opinfo.scroll, nsbj, &lvsize );

				XWarpPointer( d, l_wnd, l_wnd, 0, 0, 
					      lsh.width,
					      lsh.height,
					      report.xbutton.x,
					      LINE_H+5 );
				XMaskEvent( d, PointerMotionMask, &report );
			    } else if( report.xmotion.y > lsh.height-LINE_H ){
				/* Pointer over under area */
				y_locate = ScrollList( y_locate,
						       mouse_sp_per[opinfo.sc_speed-1]
						       *(lsh.height - LINE_H
							 - report.xmotion.y),
						       !opinfo.scroll, nsbj, &lvsize );

				XWarpPointer( d, l_wnd, l_wnd, 0, 0, 
					      lsh.width,
					      lsh.height,
					      report.xbutton.x,
					      lsh.height-LINE_H );
				XMaskEvent( d, PointerMotionMask, &report );
			    } else {
				y_locate = ScrollList( y_locate,
						       (mouse_sp_per[opinfo.sc_speed-1]
							*(report.xmotion.y-mouse_y)),
						       opinfo.scroll, nsbj, &lvsize );

				mouse_y = report.xmotion.y;
			    }

			    SetScPerc( (double)y_locate/y_locate_max );

			} else {
			    /*
			     * ޥͭʤ
			     */
			    if( Button1flag == TRUE ){
				if( sb_flag == 0 ) {
                                /*
				 * ꤹȤΤɤä
				 */
				    y_locate = ScrollList( y_locate,
							   (mouse_sp_per[opinfo.sc_speed-1]
							    *(report.xmotion.y-mouse_y)),
							   opinfo.scroll, nsbj,
							   &lvsize );
				    SetScPerc( (double)y_locate/y_locate_max );
				    mouse_y = report.xmotion.y;
				} else if( sb_flag == 3 ) {
                                /*
				 * СΤɤä
				 */

				    MoveScrollBar( report.xmotion.y - mouse_y );

				    y_locate = (lvsize.height-nsbj*MH-10)*GetScPerc();

				    if( y_locate < 0 )
					y_locate = 0;
				    if( y_locate > (nmail-nsbj)*3*LINE_H ){
					y_locate = (nmail-nsbj)*3*LINE_H;
				    }
				    mouse_y = report.xmotion.y;
				}
			    }
			}
			Sh2Sz(&lwsize,&lsh);
			DrawListPixmap( d, l_wnd, cmap, &lpgc, &lpmap, depth,
					&tinfo,
					&ifs, mailinfo, nmail, &lwsize, lbgpmap,
					y_locate, nsbj, lfflag );
			lfflag = FALSE;

			CopyList( d, l_wnd, l_gc, lpmap, nsbj, lsh.width,
				  y_locate, &lsh );

			XFlush( d );
		    }
		}
		break;


		/********************/
		/*                  */
		/* When pressed key */
		/*                  */
		/********************/
	    case KeyPress:
		if( enterflag == TRUE ){
		    entertime = -1;
		    if( chipflag == TRUE ){
			XUnmapWindow( d, c_wnd );
			XFlush( d );
			chipflag = FALSE;
		    }
		}

		while( True == 
		       XCheckMaskEvent( d, KeyPressMask, &rep_trash ) );

		XLookupString((XKeyEvent*)&report,temp,1,&ikey,&cs);

		/*********************************/
		/*   Ctrl + 'q' or               */
		/*   Ctrl + 'Q' then quit xqbiff */
		/* Free all memories             */
		/*********************************/
		if( report.xkey.state == ControlMask &&
		    (ikey == XK_Q || ikey == XK_q) ){

		    XqbExit();

		}

		/********************************/
		/*   Ctrl + 'p' or              */
		/*   Ctrl + 'P' then turn over  */
		/* behavior of Popup window.    */
		/********************************/
		else if( report.xkey.state == ControlMask &&
			 (ikey == XK_P || ikey == XK_p) ){

		    opinfo.nopopup = !opinfo.nopopup;
		    XBell( d, 0 );
		}

		/**********************************/
		/*   Ctrl + 'b' or                */
		/*   Ctrl + 'B' then turn over    */
		/* rings the bell or not.         */
		/**********************************/
		else if( report.xkey.state == ControlMask &&
			 (ikey == XK_B || ikey == XK_b) ){

		    opinfo.beep = !opinfo.beep;
		    XBell( d, 0 );
		}

		/**********************************/
		/*   Ctrl + 'r' or                */
		/*   Ctrl + 'R' then reget mail   */
		/* information.                   */
		/**********************************/
		else if( report.xkey.state == ControlMask &&
			 (ikey == XK_R || ikey == XK_r) ){
		    if( FALSE == chkflag ){
#ifdef DEBUG_SEARCH
			fprintf( stderr, "Send search request. Ctrl+R.\n" );
#endif
			SendInst( cfd[1], PC_RESEARCH );
			chkflag = TRUE;

#ifdef DEBUG_SEARCH
		    } else {
			fprintf( stderr, "Pushed key Ctrl+R ignored.\n" );
#endif
		    }
		}

		/**********************************/
		/* For debug.                     */
		/**********************************/
/*
		else if( report.xkey.state == ControlMask &&
			 (ikey == XK_Z || ikey == XK_z) ){
		    XUngrabPointer( d, CurrentTime );
		}
		else if( report.xkey.state == ControlMask &&
			 (ikey == XK_S || ikey == XK_s) ){
		    printf( "--print status--\n" );
		    __scbar_print_params();
		    printf( "  nmail = %d\n", nmail );
		    printf( "  nsbj = %d\n", nsbj );
		    printf( "\n" );

		}
*/

		/*********************************/
		/* When mapped list window,      */
		/* '' or '' then scroll list */
		/*********************************/
		else if(  lflag == TRUE ){
		    if( ikey == XK_Escape ){
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
			XUnmapWindow( d, l_wnd );
			keep_flag = FALSE;
			lmpflag = FALSE;
		    } else if( ikey == XK_Up ){
			y_locate = ScrollList( y_locate,
					       (LINE_H * spl),
					       TRUE, nsbj, &lvsize );
		    } else if( ikey == XK_Down ){
			y_locate = ScrollList( y_locate,
					       (LINE_H * spl),
					       FALSE, nsbj, &lvsize );
		    } else if( ikey == XK_Prior ){
			y_locate -= LINE_H*(nsbj*3);
			if( y_locate < 0 ) y_locate = 0;
		    } else if( ikey == XK_Next ){
			y_locate += LINE_H*(nsbj*3);
			if( lvsize.height - y_locate < LINE_H*(nsbj*3)+10 ){
			    y_locate = lvsize.height - LINE_H*(nsbj*3) - 10;
			}
		    } else if( ikey == XK_End ){
			y_locate = lvsize.height - LINE_H*(nsbj*3) - 10;
		    } else if( ikey==XK_Begin || ikey==XK_Home ){
			y_locate = 0;
		    }

		    Sh2Sz(&lwsize,&lsh);
		    DrawListPixmap( d, l_wnd, cmap, &lpgc, &lpmap, depth,
				    &tinfo,
				    &ifs, mailinfo, nmail, &lwsize, lbgpmap,
				    y_locate, nsbj, lfflag );

		    lfflag = FALSE;

		    SetScPerc( (double)y_locate/y_locate_max );

		    CopyList( d, l_wnd, l_gc, lpmap,
			      nsbj, lsh.width, y_locate, &lsh );
		}

		if( pflag == TRUE && (ikey == XK_Q || ikey == XK_q) ){
idbgout(__func__,"Window unmap request(popup)(%d)",__LINE__);
		    XUnmapWindow( d, p_wnd );
		    pflag = FALSE;
		}

		XFlush( d );
		XSync(d,0);
		break;



		/*****************************************************/
		/*                                                   */
		/* ɥΰ,Ѥä򹹿 */
		/*                                                   */
		/*****************************************************/
	    case ConfigureNotify:
		if( report.xconfigure.window == m_wnd ){
		    msh.x = report.xconfigure.x;
		    msh.y = report.xconfigure.y;
		    msh.width = report.xconfigure.width;
		    msh.height = report.xconfigure.height;
		    xst = (msh.width-iminfo.pwidth)/2;
		    yst = (msh.height-iminfo.pheight)/2;

		    XClearArea( d, m_wnd, 0, 0, 0, 0, True );
		    XFlush( d );
		} else
		if( report.xconfigure.window == l_wnd && lflag == TRUE ){

		    while( True == 
			   XCheckTypedWindowEvent( d, l_wnd, ConfigureNotify,
						   &rep_trash ) ){
			report = rep_trash;
		    }

		    if( lsh.x == report.xconfigure.x &&
			lsh.y == report.xconfigure.y &&
			lsh.width == report.xconfigure.width &&
			lsh.height == report.xconfigure.height )
			break;

		    lsh.x = report.xconfigure.x;
		    lsh.y = report.xconfigure.y;
		    lsh.width = report.xconfigure.width;
		    lsh.height = report.xconfigure.height;

		    lfflag = TRUE;
		    XClearArea( d, l_wnd, 0, 0, 0, 0, True );

		} else
		if( report.xconfigure.window == p_wnd && pflag == TRUE ){

		    while( True == 
			   XCheckTypedWindowEvent( d, p_wnd, ConfigureNotify,
						   &rep_trash ) ){
			report = rep_trash;
		    }

		    if( psh.x == report.xconfigure.x &&
			psh.y == report.xconfigure.y &&
			psh.width == report.xconfigure.width &&
			psh.height == report.xconfigure.height )
			break;

		    psh.x = report.xconfigure.x;
		    psh.y = report.xconfigure.y;
		    psh.width = report.xconfigure.width;
		    psh.height = report.xconfigure.height;

		    XClearArea( d, p_wnd, 0, 0, 0, 0, True );
		    XFlush( d );
		}


		if( opinfo.p_geom_flag == FALSE ){
		    pdsh.x = msh.x + (msh.width/2);
		    pdsh.y = msh.y + msh.height;
		}
		break;

		/***********************/
		/*                     */
		/* When map any window */
		/*                     */
		/***********************/
	    case MapNotify:
#ifdef DEBUG
		fprintf( stderr, "lMap.\n" );
#endif
		/* Main window */
		if( report.xmap.window == m_wnd ){

		    /* to occur Expose event. */
		    XClearArea( d, m_wnd, 0, 0, 0, 0, True );

		} else if( report.xmap.window == l_wnd && lmpflag == TRUE ){
		    /* List window */

		    lflag = TRUE;

		    if( opinfo.nocapt == 0 ){
			/* ꥹϥޥݥ󥿤ͭ */
			XGrabPointer( d, r_wnd, 
				      True, 
				      PointerMotionMask, GrabModeAsync,
				      GrabModeAsync, l_wnd,
				      None, CurrentTime );

			mouse_y = iMax( mouse_y, (lsh.y + LINE_H + 10) );

			XWarpPointer( d, r_wnd,
				      r_wnd, 0, 0, 
				      DisplayWidth( d, screen_num ),
				      DisplayHeight( d, screen_num ),
				      mouse_x, mouse_y );
		    }
		    XSync( d, 0 );
		    while( True == 
			   XCheckWindowEvent( d, l_wnd, 
					      PointerMotionMask,
					      &rep_trash ) );

		    XRaiseWindow( d, l_wnd );

		    /* to occur Expose event. */
		    XClearArea( d, l_wnd, 0, 0, 0, 0, True );

#ifdef DEBUG
		    fprintf( stderr, "List Window Mapped." );
#endif
		    XFlush( d );

		} else if( report.xmap.window == p_wnd ){
		    /****************/
		    /* Popup Window */
		    /****************/
		    if( pflag == TRUE && ppmap != 0 ){
			XFlush( d );
			/* Popup window first draw */
#ifdef DEBUG
			fprintf( stderr, "Popup Window First Draw." );
#endif
			/* Drawing title & list */
			DrawListTitle( d, p_wnd, p_gc, cmap, &tinfo, 
				       &ifs, nmes_title,
				       pvsize.width, pvsize.height, depth );

			XCopyArea( d, ppmap, p_wnd, p_gc, 0, 0,
				   psh.width, psh.height-LINE_H, 
				   0, LINE_H+5 );
			XFlush( d );
#ifdef DEBUG
			fprintf( stderr, "..Ok." );
#endif
		    }
		}
		break;
		
		/******************************************/
		/*                                        */
		/* ɥޥåפ줿Ȥν */
		/*                                        */
		/******************************************/
	    case UnmapNotify:

		if( report.xmap.window == l_wnd ){
idbgout(__func__,"Window unmap complete(list)");

		    XUndefineCursor( d, l_wnd );
		    if( opinfo.nocapt == 0 ){
			XUngrabPointer( d, CurrentTime );
		    }
		    lflag = FALSE;

		    if( lpmap != 0 ){
#ifdef DEBUG_PIXMAP
			fprintf( stderr, "FreeListPixmap.\n" );
#endif
			XFreePixmap( d, lpmap );
			lpmap = 0;
			FreeBgPixmap( d, lbgpmap, TEXT_COLOR_INFO_MAX );
		    }
		    lfflag = TRUE;

		} else if( report.xmap.window == p_wnd && pflag == FALSE ){
idbgout(__func__,"Window unmap complete(popup)");
#if 0
		    ncnt = 0.0;
		    if( ppmap != 0 ){
#ifdef DEBUG_PIXMAP
			fprintf( stderr, "FreePopupPixmap.\n" );
#endif
fprintf( stderr, "free ppmap3.\n" );
			XFreePixmap( d, ppmap );
			ppmap = 0;
			FreeBgPixmap( d, pbgpmap, TEXT_COLOR_INFO_MAX );
		    }

		    if( newmailinfo != NULL ){
			free( newmailinfo );
			newmailinfo = NULL;
idbgout(__func__,"Memory free. newmailinfo <%d>.",__LINE__);
		    }
#endif
		}
		XFlush(d);
		break;

	    case EnterNotify:
		if( report.xcrossing.window == m_wnd ){
		    enterflag = TRUE;
		    entertime = 0;
		}
		break;

	    case LeaveNotify:
		if( report.xcrossing.window == m_wnd ){
		    enterflag = FALSE;
		    entertime = -1;
		    if( chipflag == TRUE ){
			XUnmapWindow( d, c_wnd );
			XFlush( d );
			chipflag = FALSE;
		    }
		}
		break;

	    case ClientMessage:
		if( report.xclient.window == m_wnd )
		    XqbExit();
		else if( report.xclient.window == l_wnd ){
		    XUndefineCursor( d, l_wnd );
		    XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
		    XFlush( d );
		    lmpflag = FALSE;
		    keep_flag = FALSE;
		}
		else if( report.xclient.window == w_wnd ){
		    XUnmapWindow( d, w_wnd );
idbgout(__func__,"Window unmap request(warning)(%d)",__LINE__);
		    XFlush( d );
		    wflag = FALSE;
		}

		break;


	    default:
		break;
	    }
	} /* end while */

	/* Unmap a list window. */
	if( lflag == TRUE && lmpflag == FALSE ){
	    XUnmapWindow( d, l_wnd );
idbgout(__func__,"Window unmap request(list)(%d)",__LINE__);
	    XFlush( d );
	    keep_flag = FALSE;
	    lmpflag = FALSE;
	}
    }
}


/**************************************/
/* GetWndSizePos                      */
/* ɥΰ֤ȥĴ᤹ */
/**************************************/
void GetWndSizePos( Display *d, Window wnd, XSizeHints *ssh, XSizeHints *rsh )
{
#define BH 16
#define AJ 16
    int wx = ssh->x;
    int wy = ssh->y;
    int ww = iMin( ssh->width, DW-AJ );
    int wh = iMin( ssh->height, DH-AJ );

#ifdef DEBUG
    fprintf(stderr,"GetWndSizePos.(%dx%d+%d+%d)",ssh->width,ssh->height,ssh->x,ssh->y);
#endif

    if( wx < 0 ) wx = 0;
    if( wy < 0 ) wy = 0;
    if( wx + ww > DW - BH ) wx = DW - (ww + BH);
    if( wy + wh > DH - BH ) wy = DH - (wh + BH);

    rsh->flags = (PPosition | PSize | PMaxSize | PMinSize);
    rsh->width = rsh->max_width = rsh->min_width = ww;
    rsh->height = rsh->max_height = rsh->min_height = wh;
    rsh->x = wx;
    rsh->y = wy;

#ifdef DEBUG
    fprintf(stderr,"..Ok.(%dx%d+%d+%d)\n",rsh->width,rsh->height,rsh->x,rsh->y);
#endif

    return;
}

/************************/
/* MapWnd               */
/* ɥɽ */
/************************/
void MapWnd( Display *d, Window wnd, XSizeHints *sh )
{
#ifdef DEBUG
    fprintf(stderr,"MapWnd.(%dx%d+%d+%d)\n",sh->width,sh->height,sh->x,sh->y);
#endif
    XSetWMSizeHints( d, wnd, sh, XA_WM_SIZE_HINTS );
    XSetWMNormalHints( d, wnd, sh );

    XMoveResizeWindow( d, wnd, sh->x, sh->y, sh->width, sh->height );
    XMapWindow( d, wnd );

    XRaiseWindow( d, wnd );

    XFlush( d );
    XSync( d, 0 );

/*
    if(wnd==l_wnd){
	fprintf(stderr,"Mapping list window.\n");
    }else if(wnd==p_wnd){
	fprintf(stderr,"Mapping popup window.\n");
    }else if(wnd==w_wnd){
	fprintf(stderr,"Mapping warning window.\n");
    }else if(wnd==c_wnd){
	fprintf(stderr,"Mapping chip window.\n");
    }else{
	fprintf(stderr,"Mapping other window(0x%x).\n",wnd);
    }
*/

#ifdef DEBUG
    fprintf(stderr,"%s: .Ok.(%dx%d+%d+%d)\n",__func__,sh->width,sh->height,sh->x,sh->y);
#endif

    return;
}


/*****************************/
/* SetWndName                */
/* Set window title string.  */
/*****************************/
void SetWndName( Display *d, Window wnd, char *str )
{
    XTextProperty tp_wndname;

    XStringListToTextProperty( &str, 1, &tp_wndname );

    XSetWMName( d, wnd, &tp_wndname );

    return;
}


