/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * scbar.c
 *
 * ԥޥå׺ؿ
 *
 */

#include "scbar.h"


#define __BAR_DESIGN_MOZILLA_
/*
#define _DEBUG_SB_
*/
extern Pixel pixel_bg;
extern Pixel pixel_fg;

Pixmap p_btn[2] = { 0, 0 }; /* 0:Up  1:Dwn */
Pixmap p_scbar = 0;
Pixmap p_scbtn = 0;
Pixmap p_sctmp = 0;
GC scgc = NULL;
int list_height = 0;
int ara_height = 0;
int bar_height = 0;
int btn_height = 0;
int btn_y = 0;
int btn_y_max = 0;
int btn_y_as = 0;
#define MIN_SCSZ  8

Pixel lpix = 0;
Pixel spix = 0;
Pixel dpix = 0;
Pixel l2pix = 0;
Pixel s2pix = 0;
Pixel bgpix = 0;

void CreateScrollBar( Display *d, Window wnd, Colormap cmap, int depth,
		      int l_height, int a_height, int nmail, int nsbj )
{
    BOOL flag = FALSE;

    if( depth >= 16 ) flag = TRUE;

    if( bgpix == 0 ){
	bgpix = pixel_bg;
	dpix = iGetColorPixelRate( d, cmap, bgpix, 50, FALSE );
	spix = iGetColorPixelRate( d, cmap, bgpix, 75, FALSE );
	lpix = iGetColorPixelRate( d, cmap, bgpix, 50, TRUE );

	if( flag == TRUE ){
	    l2pix = iGetColorPixelRate( d, cmap, bgpix, 25, TRUE );
	    s2pix = iGetColorPixelRate( d, cmap, bgpix, 88, FALSE );
	}
    }
    ClearScrollBar( d );


    /* Create a pixmap and a gc */
    p_btn[0] = XCreatePixmap( d, wnd, SCBAR_SIZE, SCBAR_SIZE, depth );
    p_btn[1] = XCreatePixmap( d, wnd, SCBAR_SIZE, SCBAR_SIZE, depth );

    scgc = XCreateGC( d, p_btn[0], 0, 0 );

    list_height = l_height;
    ara_height  = a_height;
    bar_height  = ara_height-(2*SCBAR_SIZE);
    btn_height  = bar_height - bar_height
	* ((double)(list_height-MH*nsbj-10)/list_height);


    if( btn_height < MIN_SCSZ ){
	/* BarΥܥ󤬾ʤ᤮Ĵ */
	btn_height = MIN_SCSZ;
	list_height = bar_height*(list_height-LINE_H*3*nsbj-10)
	    /(bar_height-MIN_SCSZ);
    }


    btn_y_max = bar_height - btn_height;

    p_scbar = XCreatePixmap( d, wnd, SCBAR_SIZE+2, ara_height, depth );
    p_sctmp = XCreatePixmap( d, wnd, SCBAR_SIZE+2, ara_height, depth );
    p_scbtn = XCreatePixmap( d, wnd, SCBAR_SIZE, btn_height, depth );

    /* Draw bar */
    XSetForeground( d, scgc, bgpix );
    XFillRectangle( d, p_scbtn, scgc, 0, 0, SCBAR_SIZE, btn_height );
    XFillRectangle( d, p_scbar, scgc, 0, 0, SCBAR_SIZE+2, ara_height );

    XSetForeground( d, scgc, lpix );
    XFillRectangle( d, p_scbtn, scgc, 0, 0, WD, btn_height );
    XFillRectangle( d, p_scbtn, scgc, 0, 0, SCBAR_SIZE, WD );

    XSetForeground( d, scgc, dpix );
    XFillRectangle( d, p_scbar, scgc, 0, 0, SCBAR_SIZE+1, ara_height );
    XFillRectangle(d,p_scbtn,scgc,SCBAR_SIZE-WD,WD, SCBAR_SIZE,btn_height);
    XFillRectangle(d,p_scbtn,scgc,0,btn_height-WD,SCBAR_SIZE,btn_height);

    XSetForeground( d, scgc, spix );
    XFillRectangle( d, p_scbar, scgc, 1, 1, SCBAR_SIZE, ara_height-2 );

#ifdef __SMOOTH_COLOR__
    if( flag == TRUE && opinfo.flat_face == FALSE ){
	XSetForeground( d, scgc, l2pix );
	XFillRectangle( d, p_scbtn, scgc, WD, WD, WD, btn_height-WD-WD );
	XSetForeground( d, scgc, s2pix );
	XFillRectangle( d, p_scbtn, scgc, SCBAR_SIZE-WD-WD, WD, WD, btn_height-WD-WD );
    }
#endif

#ifdef __BAR_DESIGN_MOZILLA_
    if( btn_height >= 16 && opinfo.flat_face == FALSE ){
	XSetForeground( d, scgc, lpix );
	XFillRectangle( d, p_scbtn, scgc, WD+1, (btn_height/2)-4,
			SCBAR_SIZE-WD-WD-4, 1 );
	XFillRectangle( d, p_scbtn, scgc, WD+1, (btn_height/2),
			SCBAR_SIZE-WD-WD-4, 1 );
	XFillRectangle( d, p_scbtn, scgc, WD+1, (btn_height/2)+4,
			SCBAR_SIZE-WD-WD-4, 1 );

	XSetForeground( d, scgc, spix );
	XFillRectangle( d, p_scbtn, scgc, WD+1, (btn_height/2)-5,
			SCBAR_SIZE-WD-WD-4, 1 );
	XFillRectangle( d, p_scbtn, scgc, WD+1, (btn_height/2)-1,
			SCBAR_SIZE-WD-WD-4, 1 );
	XFillRectangle( d, p_scbtn, scgc, WD+1, (btn_height/2)+3,
			SCBAR_SIZE-WD-WD-4, 1 );
    }
#endif


    /* Draw Buttons */
    ScBtnPush( d, cmap, 0, FALSE );
    ScBtnPush( d, cmap, 1, FALSE );


    return;
}

void ScBtnPush( Display *d, Colormap cmap, int btn, BOOL flag )
{
/*
    static int lpix;
    static int spix;
    static int dpix;
    int l2pix = 0;
    int s2pix = 0;
    int bgpix;
*/
    int aj = (flag==TRUE)?1:0;

/*
    bgpix = pixel_bg;
    dpix = iGetColorPixelRate( d, cmap, bgpix, 50, FALSE );
    spix = iGetColorPixelRate( d, cmap, bgpix, 75, FALSE );
    lpix = iGetColorPixelRate( d, cmap, bgpix, 50, TRUE );

    if( flag == TRUE ){
	l2pix = iGetColorPixelRate( d, cmap, bgpix, 25, TRUE );
	s2pix = iGetColorPixelRate( d, cmap, bgpix, 83, FALSE );
    }
*/

    XSetForeground( d, scgc, bgpix );
    XFillRectangle( d, p_btn[btn], scgc, 0, 0, SCBAR_SIZE, SCBAR_SIZE );

    if( flag == TRUE )
	XSetForeground( d, scgc, bgpix );
    else
	XSetForeground( d, scgc, lpix );
	
    XFillRectangle( d, p_btn[btn], scgc, 0, 0, WD, SCBAR_SIZE );
    XFillRectangle( d, p_btn[btn], scgc, 0, 0, SCBAR_SIZE, WD );
    
    if( flag == TRUE )
	XSetForeground( d, scgc, bgpix );
    else
	XSetForeground( d, scgc, dpix );
    XFillRectangle(d,p_btn[btn],scgc,SCBAR_SIZE-WD,WD,SCBAR_SIZE,SCBAR_SIZE);
    XFillRectangle(d,p_btn[btn],scgc,0,SCBAR_SIZE-WD,SCBAR_SIZE,SCBAR_SIZE);


    if( btn == 0 ){
	if( opinfo.flat_face == TRUE ){
	    XSetForeground( d, scgc,iNametoPixel( d, cmap, "black" ) );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-1+aj, WD+3+aj,
		       SCBAR_SIZE/2-1+aj, WD+3+aj );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-2+aj, WD+4+aj,
		       SCBAR_SIZE/2+aj, WD+4+aj );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-3+aj, WD+5+aj,
		       SCBAR_SIZE/2+1+aj, WD+5+aj );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-4+aj, WD+6+aj,
		       SCBAR_SIZE/2+2+aj, WD+6+aj );
	} else {
	    XSetForeground( d, scgc, lpix );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2+aj,
		       WD+2+aj,WD+2+aj,SCBAR_SIZE-WD-2+aj);

	    XSetForeground( d, scgc, spix );
	    XDrawLine( d, p_btn[btn], scgc,
		       SCBAR_SIZE/2+1+aj,WD+2+aj,
		       SCBAR_SIZE-WD-2+aj,SCBAR_SIZE-WD-2+aj);
	    XDrawLine( d, p_btn[btn], scgc,
		       WD+3+aj,SCBAR_SIZE-WD-2+aj,
		       SCBAR_SIZE-WD-2+aj,SCBAR_SIZE-WD-2+aj);
	}
    } else {
	if( opinfo.flat_face == TRUE ){
	    XSetForeground( d, scgc,iNametoPixel( d, cmap, "black" ) );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-1+aj, WD+6+aj,
		       SCBAR_SIZE/2-1+aj, WD+6+aj );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-2+aj, WD+5+aj,
		       SCBAR_SIZE/2+aj, WD+5+aj );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-3+aj, WD+4+aj,
		       SCBAR_SIZE/2+1+aj, WD+4+aj );
	    XDrawLine( d, p_btn[btn], scgc, SCBAR_SIZE/2-4+aj, WD+3+aj,
		       SCBAR_SIZE/2+2+aj, WD+3+aj );
	} else {
	    XSetForeground( d, scgc, lpix );
	    XDrawLine( d, p_btn[btn], scgc,
		       SCBAR_SIZE/2+aj, SCBAR_SIZE-WD-2+aj,WD+2+aj,WD+2+aj);
	    XDrawLine( d, p_btn[btn], scgc,
		       WD+2+aj,WD+2+aj,SCBAR_SIZE-WD-2+aj,WD+2+aj);

	    XSetForeground( d, scgc, spix );
	    XDrawLine( d, p_btn[btn], scgc,
		       SCBAR_SIZE/2+1+aj,SCBAR_SIZE-WD-2+aj,SCBAR_SIZE-WD-2+aj,WD+2+aj);
	}
    }
    return;
}


void ClearScrollBar( Display *d )
{
    if( p_btn[0] != 0 ){ XFreePixmap( d, p_btn[0] ); p_btn[0] = 0; }
    if( p_btn[1] != 0 ){ XFreePixmap( d, p_btn[1] ); p_btn[1] = 0; }
    if( p_scbar != 0 ){ XFreePixmap( d, p_scbar ); p_scbar = 0; }
    if( p_scbtn != 0 ){ XFreePixmap( d, p_scbtn ); p_scbtn = 0; }
    if( p_sctmp != 0 ){ XFreePixmap( d, p_sctmp ); p_sctmp = 0; }
    if( scgc != NULL ){ XFreeGC( d, scgc ); scgc = NULL; }

    return;
}

void DrawScrollBar( Display *d, Window wnd, GC gc, int x, int y )
{
    XCopyArea( d, p_scbar, p_sctmp, gc, 0, 0, SCBAR_SIZE, ara_height,
	       0, 0 );
    XCopyArea( d, p_scbtn, p_sctmp, gc, 0, 0, SCBAR_SIZE, btn_height,
	       1, btn_y + SCBAR_SIZE + 1 );

    XCopyArea( d, p_btn[0], p_sctmp, gc,
	       0, 0, SCBAR_SIZE, SCBAR_SIZE, 1, 1 );

    XCopyArea( d, p_btn[1], p_sctmp, gc,
	       0, 0, SCBAR_SIZE, SCBAR_SIZE, 1, ara_height-SCBAR_SIZE+1 );

    XCopyArea( d, p_sctmp, wnd, gc, 0, 0, SCBAR_SIZE, ara_height, x, y );
    
    return;
}


void ResetScrollBar()
{
    btn_y_as = btn_y;
}

int MoveScrollBar( int mov )
{
    btn_y_as += mov;

    btn_y = iMax( btn_y_as, 0 );
    btn_y = iMin( btn_y, btn_y_max );

    return btn_y;
}


void SetScPerc( double p )
{
    btn_y_as = p * btn_y_max;

    btn_y = iMax( btn_y_as, 0 );
    btn_y = iMin( btn_y, btn_y_max );

    return;
}


int CheckScBarClkPos( int y )
{
    y = y - (LINE_H+10) + 3;
#ifdef _DEBUG_SB_
    printf( "y=%d\n", y );
    printf( "btn_h=%d\n", btn_height );
#endif

    if( y < 0 ) return 0;

    if( y < SCBAR_SIZE + 1 ){
#ifdef _DEBUG_SB_
	printf( "Push up button\n" );
#endif
	return 1;
    }

    if( y >= ara_height - SCBAR_SIZE + 1 ){
#ifdef _DEBUG_SB_
	printf( "Push down button\n" );
#endif
	return 2;
    }

    if( y >= btn_y + SCBAR_SIZE + 1 &&
	y <= btn_y + SCBAR_SIZE + 1 + btn_height ){
#ifdef _DEBUG_SB_
	printf( "Push bar button\n" );    
#endif
	return 3;
    }


    if( y < btn_y + SCBAR_SIZE + 1 ){
#ifdef _DEBUG_SB_
	printf( "Push up area\n" );
#endif
	return 4;
    }
    if( y > btn_y + SCBAR_SIZE + 1 ){
#ifdef _DEBUG_SB_
	printf( "Push down area\n" );
#endif
	return 5;
    }
    return -1;
}


double GetScPerc()
{
    return (double)btn_y/btn_y_max;
}


void __scbar_print_params()
{
    printf( "  list_height = %d\n", list_height );
    printf( "  ara_height = %d\n", ara_height );
    printf( "  bar_height = %d\n", bar_height );
    printf( "  btn_height = %d\n", btn_height );
    printf( "  btn_y = %d\n", btn_y );
    return;
}
