/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-craft.h,v 1.5 2000/01/18 23:24:21 rich Exp $
 */

#ifndef __xracer_craft_h__
#define __xracer_craft_h__

#include <GL/gl.h>

/* This structure contains the parameters of each craft. */
struct xrCraft
{
  /* Craft are stored internally on linked lists. */
  struct xrCraft *next;

  /* This is used internally to store a pointer to the shared library. */
  void *lib;

  /* Name and vital statistics. */
  const char *name, *model, *manufacturer;

  /* Level number defines how ``technologically well developed'' this
   * craft is. It's a number from 0 (beginners) to 3 (advanced).
   */
  int level;

  /* Acceleration and brake parameters. */
  GLfloat accel, brake;

  /* Maximum thrust - this governs the maximum speed. */
  GLfloat max_thrust;

  /* When the craft goes over a faster spot, this is the multiple used. */
  GLfloat faster_mult;

  /* These parameters change the manoueverability of the craft. */
  GLfloat roll_mult, yaw_mult, pitch_mult;

  /* Function which is called to display this craft. */
  void (*display) (void);
};

/* Initialize the craft code. */
extern void xrCraftInit (void);

/* Load a particular craft from a file. */
extern int xrCraftLoadByName (const char *name);

/* Get the default craft - usually the craft with the lowest level. */
extern const struct xrCraft *xrCraftGetDefault (void);

/* Get next craft in sequence. */
extern const struct xrCraft *xrCraftGetNext (const struct xrCraft *);

/* Call display function for craft. */
extern void xrCraftDisplay (const struct xrCraft *craft);

extern inline void
xrCraftDisplay (const struct xrCraft *craft)
{
  craft->display ();
}

#endif /* __xracer_craft_h__ */
