/*
 * Copyright 2004-2006 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_MODE_H_
#define _VIA_MODE_H_ 1

/*
 * In case this isn't in xf86str.h.
 */
#ifndef M_T_PREFERRED
#define M_T_PREFERRED 0x08
#endif
#ifndef M_T_DRIVER
#define M_T_DRIVER 0x40
#endif

/*
 * Define a set of own mode errors.
 */
#define VIA_MODE_STATUS 0x51A00
#ifndef MONREC_HAS_REDUCED
#define MODE_NO_REDUCED     0x01 + VIA_MODE_STATUS
#endif
#define MODE_MEM_BW         0x02 + VIA_MODE_STATUS
#define MODE_OUTPUT_UNDEF   0x03 + VIA_MODE_STATUS
#define MODE_NOT_PAL        0x04 + VIA_MODE_STATUS
#define MODE_NOT_NTSC       0x05 + VIA_MODE_STATUS
#define MODE_HTOTAL_WIDE    0x06 + VIA_MODE_STATUS
#define MODE_HDISPLAY_WIDE  0x07 + VIA_MODE_STATUS
#define MODE_HSYNC_RANGE    0x08 + VIA_MODE_STATUS
#define MODE_HBLANK_RANGE   0x09 + VIA_MODE_STATUS
#define MODE_VTOTAL_WIDE    0x0A + VIA_MODE_STATUS
#define MODE_VDISPLAY_WIDE  0x0B + VIA_MODE_STATUS
#define MODE_VSYNC_RANGE    0x0C + VIA_MODE_STATUS
#define MODE_VBLANK_RANGE   0x0D + VIA_MODE_STATUS
#define MODE_PITCH          0x0E + VIA_MODE_STATUS
#define MODE_OFFSET         0x0F + VIA_MODE_STATUS
#define MODE_MINHEIGHT      0x10 + VIA_MODE_STATUS

/* Function prototypes */
/* via_mode.c */
void ViaVgaPrintRegs(ScrnInfoPtr pScrn, const char *function);
void ViaModeSet(ScrnInfoPtr pScrn, DisplayModePtr mode);
DisplayModePtr ViaCVTMode(int HDisplay, int VDisplay, float VRefresh, Bool Reduced, Bool Interlaced);
DisplayModePtr ViaModesAdd(DisplayModePtr Modes, DisplayModePtr Additions);
DisplayModePtr ViaModeCopy(DisplayModePtr Mode);
void ViaPrintModeline(int scrnIndex, DisplayModePtr mode);
void ViaModesDestroy(DisplayModePtr Modes);
void ViaVirtualGetFromConfig(ScrnInfoPtr pScrn);
void ViaVirtualGetFromModes(ScrnInfoPtr pScrn);
void ViaVirtualGet(ScrnInfoPtr pScrn);
DisplayModePtr ViaModesPoolCreate(ScrnInfoPtr pScrn, Bool Silent);
void ViaModesAttach(ScrnInfoPtr pScrn, DisplayModePtr Modes);

#endif /* _VIA_MODE_H_ */
