/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FILTERDIALOG_H
#define FILTERDIALOG_H

class QPaintEvent;

#include "wrapper/emucfg.h"

#include "FilterDialogData.h"

class FilterDialog : public FilterDialogData
{
    Q_OBJECT

public:
    FilterDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );

    void setConfig(const emuConfig&);
    void setConfigDefault(const emuConfig&);
    
    void paintFilterFunc();
    
 public slots:

    void receiveConfig(const emuConfig&);

 protected:

    emuConfig config;
    emuConfig configDefault;

    void paintEvent(QPaintEvent *);

 private:
    
    void setButtons();
    void setSliderValues();

    bool changedSignalEnabled;
    void enableChangedSignal(bool);
    void emitChangedIfEnabled();

 protected slots:

    void updatePara1(int);
    void updatePara2(int);
    void updatePara3(int);
    void setFilterFlag(bool);
    void setDefaults();
 
 signals:

    void changed(const emuConfig&);
        
};

#endif  /* FILTERDIALOG_H */
