#include "debug.h"
#include "string_utils.h"

Format::PrintF<std::ostream> out( std::cout );
Format::PrintF<std::ostream> vout( std::cout );
Format::PrintF<std::ostream> eout( std::cerr );

DModule string2module( std::string m )
{
  m = toupper( m );

  if( m == "ALL" )
    return MODULE_ALL;

  if( m == "MAIN" )
    return  MODULE_MAIN;

  if( m == "ARG" )
    return MODULE_ARG;       

  if( m == "TREE" )
    return MODULE_TREE;

  if( m == "CPPDIR" )
    return MODULE_CPPDIR;
  
  if( m == "SETUP" )
    return MODULE_SETUP;

  if( m == "NIGNORE" )
    return MODULE_NIGNORE;

  out[0]( "unkown module name \"%s\". Using default value ALL\n", m );

  return MODULE_ALL;
}

std::string x2s( DModule module )
{
  switch( module )
    {
    case MODULE_ALL:    return "ALL";
    case MODULE_ARG:    return "ARG";
    case MODULE_MAIN:   return "MAIN";
    case MODULE_TREE:   return "TREE";
    case MODULE_CPPDIR: return "CPPDIR";
    case MODULE_SETUP:  return "SETUP";
    case MODULE_NIGNORE:  return "NIGNORE";
    }

  return "UNKNOWN";
}
