/*******************************************************************
 * EAP PEAP Function header
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 * 
 * File: eappeap.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAPPEAP_H_
#define _EAPPEAP_H_

#include <netinet/in.h>

#define PEAP_VERSION0    0
#define PEAP_VERSION1    1

#define PEAP_SESSION_KEY_CONST         "client EAP encryption"
#define PEAP_SESSION_KEY_CONST_SIZE    21

#define PEAPv1_SESSION_KEY_CONST       "client PEAP encryption"
#define PEAPv1_SESSION_KEY_CONST_SIZE  22

int eappeap_setup(struct generic_eap_data *);
int eappeap_process(struct generic_eap_data *, u_char *, int, u_char *, int *);
int eappeap_get_keys(struct interface_data *);
int eappeap_cleanup(struct generic_eap_data *);
int eappeap_failed(struct generic_eap_data *);

#endif
