/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: wpa.h
 *
 *******************************************************************/

#ifndef __WPA_H__
#define __WPA_H__

#define WPA_EID        0xdd


struct wpa_ie_struct {
  unsigned char wpaid;
  unsigned char wpalen;
  unsigned char oui[4];
  uint16_t wpa_ver;
  unsigned char group_cipher[4];
  uint16_t pk_suite_cnt;

  // The rest of the IE is variable, and can be structured here.
} __attribute__((__packed__));

int wpa_parse_ie(char *);
void wpa_gen_ie(struct interface_data *, char *);
void wpa_gen_ie_caps(struct interface_data *, char *);
char *wpa_minmax(char *, char *, int, char);

#endif
