/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/


#ifndef TIDELIST_H
#define TIDELIST_H

/* RWL the following ifdef removes a templates error when compiling with MSVC (Known bug) */

#ifdef WIN32
#include <math.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <qapplication.h>
#include <qevent.h>
#include <qpainter.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qrect.h>
#include <qpoint.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <qcursor.h>
#include <qimage.h>
#include <qstrlist.h>
#include <qintdict.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmainwindow.h>
#include <qrangecontrol.h>
#include <qpen.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpointarray.h>
#include <qtabdialog.h>
#include <qcombobox.h>
#include <qtextedit.h>
#include <qtable.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qtabwidget.h> 

#include "tcd.h"
#include "tideEditor.h"

#define STATIONS_PER_PAGE   2000

class TideList:public QTabDialog
{
    Q_OBJECT 


  public:

    TideList (QWidget *parent, const char *name);
    ~TideList ();


    void updateTideList ();


  protected:

    DB_HEADER_PUBLIC db;
    TIDE_RECORD rec;

    QTabWidget *tideList;

    TideEditor *tideEditor;

    QListBox **stationList;

    int numtabs, *page_displayed, page, lastrec;
    

  protected slots:

    void slotCurrentChanged ();
    void slotSelected ();
    void slotHighlighted ();


  private:
};

#endif
