/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

static void sigfunc __P((int));
char *probe_internal __P((char *, int));

__END_DECLS

char sigsrv[BUFSIZE];
int signum;

static void
sigfunc(int signo)
{
  sprintf(text_buffer[signum], "Connection to %s timed out.", sigsrv);
  set_text_list(text_buffer[signum]);
  return;
}

/* warper for normal non-threaded queries */
int
probe_internal_warper(void)
{
  set_text_list(probe_internal(server, 0));
  return 0;
}

char *
probe_internal(wsrv, bnum)
     char *wsrv; /* whois server to query */
     int bnum; /* buffer number (0 if non-threaded query) */
{
#ifdef IPV6
  struct sockaddr_in6 serv_addr;
#else /* !IPV6 */
  struct sockaddr_in serv_addr;
#endif /* IPV6 */
  struct hostent *hptr;
#if !IPV6
  struct in_addr outgoing;
#endif
  struct timeval tv;
  fd_set fd;
  char c_domain[BUFSIZE], in_buffer[12288];
  int sockfd, retval=0;

  if (HELP_FLAG == 1)
    {
      sprintf(c_domain,"%s","HELP");
      HELP_FLAG = 0;
    }
  else
    {
      sprintf(c_domain, "%s",
	      gtk_entry_get_text(GTK_ENTRY(history_combo->entry)));
      write_history(c_domain);
      navigator_add(c_domain);
    }

#ifdef DEBUG
  fprintf(stderr, "*** probe_internal() *** (char [%d]) c_domain: \"%s\" (%d bytes)\n",
	 sizeof(c_domain), c_domain, strlen(c_domain));
#endif /* DEBUG */

  memset (&serv_addr, 0, sizeof(serv_addr));
#ifdef IPV6
  if ((hptr = gethostbyname2(wsrv, AF_INET6)) == NULL)
    {
      sprintf(text_buffer[bnum], "Could not resolve host %s", wsrv);
      return text_buffer[bnum];
    }
  sockfd = socket(AF_INET6, SOCK_STREAM, 0);
  serv_addr.sin6_family = AF_INET6;
  serv_addr.sin6_port = htons(PORT);
  inet_pton(AF_INET6, hptr->h_addr_list[0], &serv_addr.sin6_addr);
#else /* !IPV6 */
  if ((hptr = gethostbyname(wsrv)) == NULL)
    {
      sprintf(text_buffer[bnum], "Could not resolve host %s", wsrv);
      return text_buffer[bnum];
    }
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(PORT);
  (void *) memcpy (&outgoing.s_addr, hptr->h_addr_list[0],
		   sizeof(outgoing.s_addr));
  serv_addr.sin_addr.s_addr = inet_addr(inet_ntoa(outgoing));
#endif /* IPV6 */

  sprintf(sigsrv, "%s", wsrv);
  signum = bnum;
  signal(SIGALRM, sigfunc);
  alarm(TIMEOUT);
  if ((connect(sockfd,(struct sockaddr *) &serv_addr,sizeof(serv_addr)))!= 0)
    {
      sprintf(text_buffer[bnum], "Could not connect to host %s", wsrv);
      return text_buffer[bnum];
    }
  alarm(0);

  strcat(c_domain, "\r\n");
  memset(text_buffer[bnum], 0, sizeof(text_buffer[bnum]));

  write(sockfd, c_domain, strlen(c_domain));

  while (1)
    {
      FD_ZERO(&fd);
      FD_SET(sockfd, &fd);
      tv.tv_sec = TIMEOUT;
      tv.tv_usec = 0;
      retval = select(sockfd + 1, &fd, NULL, NULL, &tv);
      if (retval == 0)
	{
	  sprintf(text_buffer[bnum], "Read from %s timed out.", wsrv);
	  break;
	}
      memset(in_buffer, 0, sizeof(in_buffer));
      retval = read(sockfd, in_buffer, 2048);
      strcat(text_buffer[bnum], in_buffer);
      if (retval == 0)
	{
	  break;
	}
      /*      memset(in_buffer, 0, sizeof(in_buffer)); */ /* XXX */
    }

  close(sockfd);
  return text_buffer[bnum];
}
