/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void cb_combolist __P((GtkWidget *, gpointer));
void gui_set_text __P((GtkWidget *, char *));
void set_text_list __P((char *));
void probe_help __P((GtkWidget *, GtkWidget *));
void enter_callback __P((GtkWidget *, GtkWidget *));
void list_selection __P((GtkWidget *, gpointer));
void new_text_selection __P((GtkWidget *, gpointer));
void destroy __P((GtkWidget *));

__END_DECLS

/* int Call(int signo) { FLAG=0; return 0; } */

/* GtkWidget *e_domain; */
const gchar *list_item_data_key="list_item_data";
int cursrvpos; /* current list selection server pos */

void
sbprintf(const char *fmt, ...)
{
  char buf[BUFSIZE];
  char str[BUFSIZE];
  va_list ap;

  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  va_end(ap);

  sprintf(str, " %s", buf);
  gtk_statusbar_push(GTK_STATUSBAR (statusbar), 1, str);
}

void
cb_combolist(GtkWidget *widget, gpointer func_data)
{
  char object[BUFSIZE];
  char *srv;
  gint pos;

  sprintf(object, "%s", gtk_entry_get_text(GTK_ENTRY(history_combo->entry)));

  srv = getsrvbyobj(object);

  if (srv != NULL) /* only do pos lookup if srv does exist */
    {
      pos = getsrvpos(srv);
    }
  else
    {
      pos = cursrvpos;
    }

  if (server_list != NULL) /* do only if server_list has been initialized */
    {
      gtk_list_select_item(GTK_LIST(server_list), pos);
    }

  if (srv == NULL)
    {
      srv = "";
    }

#ifdef DEBUG
  fprintf(stderr, "*** cb_combolist() *** (char [%d]) object: \"%s\" (char *) srv: \"%s\"\n",
	  sizeof(object), object, srv);
#endif /* DEBUG */
}

void
set_text_list(new_text)
     char *new_text;
{
  GtkWidget *list_item;
  char *next_line, *EOL;
  static char *current_text = NULL;
  GList *old;

  if (new_text == NULL)
    {
      return;
    }

  /* delete old text in the list widget */
  old = gtk_container_children(GTK_CONTAINER(text_field_list));
  while (old != NULL)
    {
      gtk_container_remove(GTK_CONTAINER(text_field_list), old->data);
      old = old->next;
    }

  if (current_text)
    {
      free(current_text);
    }

  /* add new text */
  current_text = strdup(new_text);
  new_text = current_text;

  while (*new_text != '\0')
    {
      /* find the end of the line */
      EOL = new_text;
      while (*EOL != '\0' && *EOL != '\n' && *EOL != '\r')
	{
	  EOL++;
	}

      /* find the beginning of next line, if any */
      next_line = EOL;
      if (*next_line != '\0')
	{
	  next_line++;
	  while ((*next_line == '\n' || *next_line == '\r') &&
		 *next_line != *(next_line-1))
	    {
	      next_line++;
	    }
	}

      /* terminate this line and add it */
      *EOL = '\0';
      list_item = gtk_list_item_new_with_label(new_text);
      gtk_object_set_data(GTK_OBJECT(list_item), list_item_data_key, new_text);
      gtk_container_add(GTK_CONTAINER(text_field_list), list_item);
      gtk_widget_show(list_item);

      /* go to next line */
      new_text = next_line;
    }
}

void probe_help(GtkWidget *widget, GtkWidget *entry)
{
  HELP_FLAG=1;
  sprintf(server,"%s","whois.internic.net");
  probe_internal_warper();
}

void enter_callback(GtkWidget *widget, GtkWidget *entry)
{
  probe_internal_warper();
}

void list_selection(GtkWidget *server_list,gpointer func_data)
{
  GList *dlist;
  int pos = 0;
  dlist=GTK_LIST(server_list)->selection;
  while (dlist)
    {
      GtkObject *list_item;
      gchar *item_data_string;
      list_item=GTK_OBJECT(dlist->data);
      item_data_string=gtk_object_get_data(list_item,list_item_data_key);
      sprintf(server,"%s",item_data_string);
      cursrvpos = getsrvpos(server);

      pos = getsrvpos(server);
      sbprintf("%s - %s", servers[pos].name, servers[pos].comment);
#ifdef DEBUG
      fprintf(stderr, "*** list_selection() *** (char [%d]) server: \"%s\" (%d bytes)\n",
	      sizeof(server), server, strlen(server));
#endif /* DEBUG */
      dlist=dlist->next;
    }
}

void new_text_selection(text_list, func_data)
     GtkWidget *text_list;
     gpointer func_data;
{
  GList *dlist;
  dlist=GTK_LIST(text_list)->selection;

  if (dlist)
    {
      GtkObject *list_item;
      gchar *item_data_string, *start, *end;

      /* retrieve the selected text */
      list_item=GTK_OBJECT(dlist->data);
      item_data_string=gtk_object_get_data(list_item,list_item_data_key);

      /* try and find something in parenthesis */
      for (start = item_data_string; *start && *start != '('; start++);

      /* end if no left paren */
      if (!*start)
        return;

      /* find right paren */
      for (end = start + 1; *end && *end != ')'; end++)
        ;

      /* end if no right paren */
      if (!*end)
        return;

      /* change "(FOO)" to "!FOO" */
      *start = '!';
      *end = '\0';
      
      /* Make sure it isn't someone's FAX number... */
      if (!strcmp(start, "!FAX"))
        return;

      /* probe it */
      gtk_entry_set_text (GTK_ENTRY(history_combo->entry),start);
      gtk_signal_emit_by_name(GTK_OBJECT(b_submit), "clicked");
    }
}

void destroy(GtkWidget *widget)
{
  gtk_main_quit();
}

int main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *menu_bar;
  GtkWidget *root_menu;
  GtkWidget *menu;
  GtkWidget *sub_menu;
  GtkWidget *sub_menu_item;
  GtkWidget *menu_item_quit;
  GtkWidget *menu_item_about;
  GtkWidget *menu_item_fwhois;
  GtkWidget *menu_item_whois;
  GtkWidget *menu_item_clear;
  GtkWidget *menu_item_modify;
  GtkWidget *h_box_top;
  GtkWidget *box;
  GtkWidget *h_box_low;
  GtkWidget *h_box;
  GtkWidget *label;
  GtkWidget *b_back;
  GtkWidget *b_forward;
  GtkWidget *b_help;
  GtkWidget *b_scan;
  GtkWidget *b_quit;
  /*  GtkWidget *v_scrollbar; */
  GtkWidget *scrolled_window;
  /*  GtkWidget *server_list; */
  GtkWidget *list_item;
  GtkTooltips *tooltips;
  int i=0;

  ne = malloc(256 * sizeof(struct navent *)); /* i dont know how many i need but i guess 256 will do */

  get_history();

  get_servers();
  sprintf(server,"%s",servers[0].name);

  gtk_init (&argc, &argv);

  /* the statusbar mush be initialized before the server list is created */
  statusbar = gtk_statusbar_new();

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window),"xwhois "VERSION"");
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_widget_show (window);

  main_box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), main_box);
  gtk_widget_show (main_box);

  menu_bar = gtk_menu_bar_new ();
  gtk_box_pack_start (GTK_BOX (main_box), menu_bar, FALSE, FALSE, 0);
  gtk_widget_show (menu_bar);

  root_menu = gtk_menu_item_new_with_label ("Main");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), root_menu);
  gtk_widget_show (root_menu);

  menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);

  sub_menu_item = gtk_menu_item_new_with_label ("External");
  gtk_menu_append (GTK_MENU (menu), sub_menu_item);
  gtk_widget_show (sub_menu_item);

  sub_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (sub_menu_item), sub_menu);

  menu_item_fwhois = gtk_menu_item_new_with_label ("Fwhois");
  gtk_menu_append (GTK_MENU (sub_menu), menu_item_fwhois);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_fwhois), "activate",
			     GTK_SIGNAL_FUNC (probe_external_fwhois), NULL);
  gtk_widget_show (menu_item_fwhois);

  menu_item_whois = gtk_menu_item_new_with_label ("Whois");
  gtk_menu_append (GTK_MENU (sub_menu), menu_item_whois);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_whois), "activate",
			     GTK_SIGNAL_FUNC (probe_external_whois), NULL);
  gtk_widget_show (menu_item_whois);

  menu_item_clear = gtk_menu_item_new_with_label ("Clear history");
  gtk_menu_append (GTK_MENU (menu), menu_item_clear);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_clear),"activate",
                             GTK_SIGNAL_FUNC (clear_history), NULL);
  gtk_widget_show (menu_item_clear);

  menu_item_modify = gtk_menu_item_new_with_label ("Modify server");
  gtk_menu_append (GTK_MENU (menu), menu_item_modify);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_modify), "activate",
			     GTK_SIGNAL_FUNC (whois_dialog), NULL);
  gtk_widget_show (menu_item_modify);

  menu_item_about = gtk_menu_item_new_with_label ("About");
  gtk_menu_append (GTK_MENU (menu), menu_item_about);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_about),"activate",
			     GTK_SIGNAL_FUNC (about_window), NULL);
  gtk_widget_show (menu_item_about);

  menu_item_quit = gtk_menu_item_new_with_label ("Quit");
  gtk_menu_append (GTK_MENU (menu), menu_item_quit);
  gtk_signal_connect_object (GTK_OBJECT (menu_item_quit),"activate",
			     GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_widget_show (menu_item_quit);

  h_box_top = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), h_box_top, FALSE, FALSE, 5);
  gtk_widget_show (h_box_top);

  label = gtk_label_new ("Object");
  gtk_box_pack_start (GTK_BOX (h_box_top), label, FALSE, TRUE, 5);
  gtk_widget_show (label);

  /*
  e_domain = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (e_domain), "activate",
		      GTK_SIGNAL_FUNC (enter_callback), e_domain);
  gtk_box_pack_start (GTK_BOX (h_box_top), e_domain, TRUE, TRUE, 0);
  gtk_widget_show (e_domain);
  */

  history_combo = GTK_COMBO(gtk_combo_new());

  /* enter callback in gtk_combo entry field does not work ok */
  /*
  gtk_signal_connect (GTK_OBJECT (history_combo->entry), "activate",
                      GTK_SIGNAL_FUNC (enter_callback), NULL);
  */

  gtk_signal_connect(GTK_OBJECT (history_combo->list), "selection_changed",
		     GTK_SIGNAL_FUNC (cb_combolist), NULL);

  gtk_box_pack_start (GTK_BOX (h_box_top), GTK_WIDGET(history_combo),
		      TRUE, TRUE, 5);
  if (HIST_FLAG == 0)
    {
      gtk_combo_set_popdown_strings (history_combo, history_list);
    }

  gtk_widget_show (GTK_WIDGET(history_combo));
  gtk_entry_set_text (GTK_ENTRY(history_combo->entry),"");

  b_submit = gtk_button_new_with_label (" Submit ");
  gtk_signal_connect (GTK_OBJECT (b_submit), "clicked",
		      GTK_SIGNAL_FUNC (probe_internal_warper), NULL);
  gtk_box_pack_start (GTK_BOX (h_box_top), b_submit, FALSE, TRUE, 0);
  gtk_widget_show (b_submit);

  b_back = gtk_button_new_with_label(" < ");
  gtk_signal_connect(GTK_OBJECT (b_back), "clicked",
		     GTK_SIGNAL_FUNC (navigator_back), NULL);
  gtk_box_pack_start(GTK_BOX (h_box_top), b_back, FALSE, TRUE, 5);
  gtk_widget_show(b_back);

  b_forward = gtk_button_new_with_label(" > ");
  gtk_signal_connect(GTK_OBJECT (b_forward), "clicked",
		     GTK_SIGNAL_FUNC (navigator_forward), NULL);
  gtk_box_pack_start(GTK_BOX (h_box_top), b_forward, FALSE, TRUE, 0);
  gtk_widget_show(b_forward);

  b_help = gtk_button_new_with_label (" ? ");
  gtk_signal_connect (GTK_OBJECT (b_help), "clicked",
		      GTK_SIGNAL_FUNC (probe_help), NULL);
  gtk_box_pack_start (GTK_BOX (h_box_top), b_help, FALSE, TRUE, 5);
  gtk_widget_show (b_help);

  b_scan = gtk_button_new_with_label(" Scan ");
  gtk_signal_connect(GTK_OBJECT (b_scan), "clicked",
		     GTK_SIGNAL_FUNC (scan_servers), NULL);
  gtk_box_pack_start(GTK_BOX (h_box_top), b_scan, FALSE, TRUE, 0);
  gtk_widget_show(b_scan);

  b_quit = gtk_button_new_with_label (" Quit ");
  gtk_signal_connect (GTK_OBJECT (b_quit), "clicked",
		      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_box_pack_start (GTK_BOX (h_box_top), b_quit, FALSE, TRUE, 5);
  gtk_widget_show (b_quit);

  box = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (main_box), box, TRUE, TRUE, 0);
  gtk_widget_show (box);

  h_box_low = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), h_box_low, TRUE, TRUE, 5);
  gtk_widget_show (h_box_low);

  text_field = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (text_field),
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gtk_box_pack_start(GTK_BOX (h_box_low), text_field, TRUE, TRUE, 0);
  gtk_widget_show(text_field);
  gtk_widget_set_usize(text_field, 350, 200);

  text_field_list = gtk_list_new();
#ifdef GTK_STABLE
  gtk_container_add(GTK_CONTAINER (text_field), text_field_list);
#else /* !GTK_STABLE */
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW (text_field),
					text_field_list);
#endif /* GTK_STABLE */
  gtk_widget_show(text_field_list);
  gtk_signal_connect (GTK_OBJECT (text_field_list),"selection_changed",
                      GTK_SIGNAL_FUNC (new_text_selection),NULL);

  /*
  text_field = gtk_text_new (NULL,NULL);
  gtk_box_pack_start (GTK_BOX (h_box_low), text_field, TRUE, TRUE, 0);
  gtk_widget_show (text_field);
  gtk_widget_set_usize (text_field,350,200);

  v_scrollbar = gtk_vscrollbar_new (GTK_TEXT(text_field)->vadj);
  gtk_box_pack_start (GTK_BOX (h_box_low), v_scrollbar, FALSE, FALSE, 0);
  gtk_widget_show (v_scrollbar);
  */

  scrolled_window = gtk_scrolled_window_new (NULL,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
  gtk_box_pack_start (GTK_BOX (h_box_low), scrolled_window, FALSE, TRUE, 0);
  gtk_widget_show (scrolled_window);
  gtk_widget_set_usize (scrolled_window,190,0);

  server_list = gtk_list_new ();
#ifdef GTK_STABLE
  gtk_container_add (GTK_CONTAINER (scrolled_window),server_list);
#else
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window),
					server_list);
#endif /* GTK_STABLE */
  gtk_widget_show (server_list);
  gtk_signal_connect (GTK_OBJECT (server_list), "selection_changed",
		      GTK_SIGNAL_FUNC (list_selection), NULL);

  tooltips = gtk_tooltips_new();

  while (servers[i].name != 0)
    {
      GtkWidget *label;
      gchar *string;
      list_item = gtk_list_item_new_with_label (servers[i].name);
      label = gtk_label_new (servers[i].name);

      if (servers[i].comment)
	{
	  gtk_tooltips_set_tip (tooltips, list_item, servers[i].comment, NULL);
	}

      gtk_container_add (GTK_CONTAINER (server_list),list_item);
      gtk_widget_show (list_item);
      gtk_label_get (GTK_LABEL (label),&string);
      gtk_object_set_data (GTK_OBJECT(list_item),list_item_data_key,string);
      i++;
    }

  gtk_list_select_item(GTK_LIST(server_list), 0); /* default server selection */

  h_box = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX (main_box), h_box, FALSE, FALSE, 5);
  gtk_widget_show(h_box);

  gtk_box_pack_start(GTK_BOX (h_box), statusbar, TRUE, TRUE, 5);
  gtk_widget_show(statusbar);

  gtk_main ();
  return 0;
}
